/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.estoque.almoxarifado;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.relatorio.gerador.Relatorio;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;

public class RelatorioMovimentoEstoque
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String FILTRO_FILIAL = "filtroFilial";
    private static final String FILTRO_CELULA = "filtroCelula";
    private static final String FILTRO_MATERIAL = "filtroMaterial";
    private static final String FILTRO_TIPO_MATERIAL = "filtroTipoMaterial";
    private static final String FILTRO_ORDENACAO = "filtroOrdenacao";
    private static final String FILTRO_SOMENTE_ESTOQUE = "filtroSomenteEstoque";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_SOMENTE_COM_MOVIMENTO = "filtroSomenteComMovimento";
    private static final String FILTRO_MATERIAL_INATIVO = "filtroMaterialInativo";
    private static final String[] camposOrdenacao = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "C\u00f3d. Tipo", "Desc. Tipo"};
    private static final String[] camposOrdenacaoBanco = new String[]{"a.mat_codigo", "a.mat_descricao", "tpm.tpm_codigo", "tpm.tpm_descricao"};
    private static final String[] camposEstoque = new String[]{"saldoEstoqueInicial", "saldoEstoqueInicialNaoConciliado", "dataSaldoEstoqueInicial", "saldoEstoqueFinal", "dataSaldoEstoqueFinal", "saldoEstoqueFinalNaoConciliado", "entradasEstoque", "saidasEstoque", "valorPepsFinal", "valorUepsFinal", "valorCmcFinal", "valorUnitarioCmc"};
    private static final String[] camposMaterial = new String[]{"materialInativo", "codigoMaterial", "descricaoMaterial", "valorUnitarioMaterial", "valorUltimaCompraMaterial", "dataUltimaCompraMaterial", "quantidadeUltimaCompraMaterial", "pontoReposicaoMaterial", "dataUltimaEntregaMaterial", "marcaMaterial", "modeloMaterial", "reposicaoAutomaticaMaterial", "codigoUsuarioMaterial", "imobilizadoMaterial", "solicitarPatrimonioMaterial", "fichaTecnicaMaterial", "ipiUltimaCompraMaterial", "freteUltimaCompraMaterial", "calculoRateioFreteUltimaCompra"};
    private static final String[] camposUnidadeMedida = new String[]{"codigoUnidadeMedida", "descricaoUnidadeMedida"};
    private static final String[] camposTipoMaterial = new String[]{"codigoTipoMaterial", "descricaoTipoMaterial"};
    private String[] camposRelatorio = null;

    public RelatorioMovimentoEstoque() {
        this.montaBarraDescricao("Relat\u00f3rio de Movimenta\u00e7\u00e3o de Estoque", "Movimenta\u00e7\u00e3o de estoque dos materiais no per\u00edodo", "relatorios/rel_estoque_almoxarifado_movimentacao.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_CELULA, "C\u00e9lula Estoque", "celulaestoque", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cel_codigo", "cel_descricao", "cel_inativa", "cel_padrao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Inativa?", "Padr\u00e3o?"}, new int[]{60, 0, 60, 60});
        this.adicionaItemFiltro(FILTRO_MATERIAL, "Material", "material", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"mat_codigo", "mat_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_TIPO_MATERIAL, "Tipo Material", "tipomaterial", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"tpm_codigo", "tpm_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data Inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data Final:");
        this.adicionaFiltroCombo(FILTRO_ORDENACAO, "Ordem:", camposOrdenacao, 0);
        this.adicionaFiltroCheck(FILTRO_SOMENTE_ESTOQUE, "Somente em estoque", false);
        this.adicionaFiltroCheck(FILTRO_SOMENTE_COM_MOVIMENTO, "Somente com movimento", false);
        this.adicionaFiltroCheck(FILTRO_MATERIAL_INATIVO, "Mostrar material inativo", false);
        this.setModuloConfigurar(RelatorioMovimentoEstoque.getModuloConfigurar());
        this.setModuloAcesso(RelatorioMovimentoEstoque.getModuloAcesso());
        this.camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, camposEstoque);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposMaterial);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposUnidadeMedida);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposTipoMaterial);
        this.setCamposConfigurador(this.camposRelatorio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void imprimirPressionado() {
        Statement st;
        block46: {
            if (this.getFiltroData(FILTRO_DATA_INICIAL) == null || Funcoes.textoVazio(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                Funcoes.mensagem(this, "\u00c9 necess\u00e1rio informar uma data inicial.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            st = Conexao.getStatement();
            Statement st2 = null;
            String[] celula = this.getSelecionadosFiltro(FILTRO_CELULA, 0);
            this.setModuloConfigurar(RelatorioMovimentoEstoque.getModuloConfigurar());
            this.setModuloAcesso(RelatorioMovimentoEstoque.getModuloAcesso());
            try {
                ResultSet rs;
                String[] tipoMaterial;
                StringBuilder buf = new StringBuilder();
                if (celula == null || celula.length == 0) {
                    if (!this.getFiltroData(FILTRO_DATA_INICIAL).isEmpty()) {
                        buf.append(" select COALESCE(sdeini.sde_saldo, 0) as saldoEstoqueInicial, ");
                        buf.append("        0 as saldoEstoqueInicialNaoConciliado, ");
                        buf.append("        sdeini.sde_data as dataSaldoEstoqueInicial, ");
                    } else {
                        buf.append(" select 0 as saldoEstoqueInicial, ");
                        buf.append("        0 as saldoEstoqueInicialNaoConciliado, ");
                        buf.append("        cast(sdeini.sde_data as date) - interval '1 day' as dataSaldoEstoqueInicial, ");
                    }
                    buf.append("        COALESCE(sdefin.sde_saldo, sdeini.sde_saldo, 0) as saldoEstoqueFinal, ");
                    buf.append("        0 as saldoEstoqueFinalNaoConciliado, ");
                    buf.append("        COALESCE(sdefin.sde_data, cast(sdeini.sde_data as date) - interval '1 day') as dataSaldoEstoqueFinal, ");
                } else {
                    buf.append(" select ");
                }
                buf.append("        a.fil_codigo, ");
                buf.append("        a.mat_codigo as codigoMaterial, ");
                buf.append("        a.mat_descricao as descricaoMaterial, ");
                buf.append("        a.mat_valorunit as valorUnitarioMaterial, ");
                buf.append("        a.mat_valorultcompra as valorUltimaCompraMaterial, ");
                buf.append("        a.mat_dataultcompra as dataUltimaCompraMaterial, ");
                buf.append("        a.mat_qtdeultcompra as quantidadeUltimaCompraMaterial, ");
                buf.append("        a.mat_ptoreposicao as pontoReposicaoMaterial, ");
                buf.append("        a.mat_dataultentrega as dataUltimaEntregaMaterial, ");
                buf.append("        a.mat_marca as marcaMaterial, ");
                buf.append("        a.mat_modelo as modeloMaterial, ");
                buf.append("        a.mat_reposicaoautomatica as reposicaoAutomaticaMaterial, ");
                buf.append("\t\t\t\ta.usr_codigo as codigoUsuarioMaterial, ");
                buf.append("\t\t\t\ta.mat_imobilizado as imobilizadoMaterial, ");
                buf.append("\t\t\t\ta.mat_solicitarpatrimonio as solicitarPatrimonioMaterial, ");
                buf.append("\t\t\t\ta.mat_fichatecnica as fichaTecnicaMaterial, ");
                buf.append("\t\t\t\ta.mat_inativo  as materialInativo, ");
                buf.append("\t\t\t\ta.mat_freteultcompra  as freteUltimaCompraMaterial, ");
                buf.append("\t\t\t\ta.mat_ipiultcompra  as ipiUltimaCompraMaterial, ");
                buf.append("        COALESCE(a.mat_calcrateiofreteultcompra, 0) as calculoRateioFreteUltimaCompra, ");
                buf.append("\t\t\t\tunm.unm_codigo as codigoUnidadeMedida, ");
                buf.append("\t\t\t\tunm.unm_descricao as descricaoUnidadeMedida, ");
                buf.append("\t\t\t\ttpm.tpm_codigo as codigoTipoMaterial, ");
                buf.append("\t\t\t\ttpm.tpm_descricao as descricaoTipoMaterial ");
                buf.append(", ");
                buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                buf.append("  from material a ");
                if (celula == null || celula.length == 0) {
                    buf.append("  left join saldoestoque sdefin on (a.fil_codigo = sdefin.fil_codigo and a.mat_codigo = sdefin.mat_codigo ");
                    if (celula == null || celula.length == 0) {
                        buf.append(" and (sdefin.sde_data = (select MAX(sde_data) ");
                        buf.append("                           from saldoestoque ");
                        buf.append("                          where fil_codigo = a.fil_codigo ");
                        buf.append("                            and mat_codigo = a.mat_codigo ");
                        if (!this.getFiltroData(FILTRO_DATA_INICIAL).isEmpty()) {
                            buf.append("                            and sde_data >= '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_INICIAL))).append("' ");
                        }
                        if (!this.getFiltroData(FILTRO_DATA_FINAL).isEmpty()) {
                            buf.append("                            and sde_data <= '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_FINAL))).append("' ");
                        }
                        buf.append("                        ) ");
                        buf.append("      or sdefin.sde_data IS NULL) ");
                        buf.append(" and (sdefin.sde_data = (select MAX(sde_data) ");
                        buf.append("                           from saldoestoque ");
                        buf.append("                          where fil_codigo = a.fil_codigo ");
                        buf.append("                            and mat_codigo = a.mat_codigo ");
                        if (!this.getFiltroData(FILTRO_DATA_FINAL).isEmpty()) {
                            buf.append("                            and sde_data <= '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_FINAL))).append("' ");
                        }
                        buf.append("                        ) ");
                        buf.append("      or sdefin.sde_data IS NULL) ");
                    }
                    buf.append(") ");
                    buf.append("  left join saldoestoque sdeini on (a.fil_codigo = sdeini.fil_codigo and a.mat_codigo = sdeini.mat_codigo ");
                    buf.append(" and (sdeini.sde_data = (select MAX(sde_data) ");
                    buf.append("                           from saldoestoque ");
                    buf.append("                          where fil_codigo = a.fil_codigo ");
                    buf.append("                            and mat_codigo = a.mat_codigo ");
                    if (!this.getFiltroData(FILTRO_DATA_INICIAL).isEmpty()) {
                        buf.append("                            and sde_data < '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_INICIAL))).append("' ");
                    }
                    buf.append("                        )");
                    buf.append("      or sdeini.sde_data IS NULL) ");
                    buf.append(") ");
                }
                buf.append("  left join unidademedida unm on (a.fil_codigo = unm.fil_codigo and a.unm_codigo = unm.unm_codigo)");
                buf.append("  join tipomaterial tpm on (tpm.fil_codigo = a.fil_codigo and tpm.tpm_codigo = a.tpm_codigo)");
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                buf.append(" where a.fil_codigo ");
                String[] filiais = this.getSelecionadosFiltro(FILTRO_FILIAL, 0);
                if (filiais == null || filiais.length == 0) {
                    buf.append(" = ").append(Variaveis.filialPadrao);
                } else {
                    buf.append(" in (");
                    for (int i = 0; i < filiais.length; ++i) {
                        buf.append(filiais[i]);
                        if (i >= filiais.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                String[] material = this.getSelecionadosFiltro(FILTRO_MATERIAL, 0);
                if (material != null) {
                    buf.append(" and a.mat_codigo in (");
                    for (int i = 0; i < material.length; ++i) {
                        buf.append(material[i]);
                        if (i >= material.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if ((tipoMaterial = this.getSelecionadosFiltro(FILTRO_TIPO_MATERIAL, 0)) != null) {
                    buf.append(" and tpm.tpm_codigo in (");
                    for (int i = 0; i < tipoMaterial.length; ++i) {
                        buf.append("'");
                        buf.append(tipoMaterial[i]);
                        buf.append("'");
                        if (i >= tipoMaterial.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if (!this.getFiltroCheck(FILTRO_MATERIAL_INATIVO)) {
                    buf.append(" and a.mat_inativo = false ");
                }
                buf.append(" order by a.fil_codigo, ");
                buf.append(camposOrdenacaoBanco[this.getFiltroComboIndice(FILTRO_ORDENACAO)]);
                if (celula != null) {
                    buf = new StringBuilder(buf.toString().replaceAll("sde", "ces"));
                    buf = new StringBuilder(buf.toString().replaceAll("saldoestoque", "saldoestoquecelula"));
                }
                if (!(rs = Conexao.executeQuery(st, buf.toString())).next()) {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                    this.habilitaBotaoImprimir(true);
                    break block46;
                }
                ModeloGridTable modelo = new ModeloGridTable(this.camposRelatorio);
                do {
                    Object[] o = new Object[this.camposRelatorio.length];
                    for (int i = 0; i < this.camposRelatorio.length; ++i) {
                        if (this.camposRelatorio[i].equalsIgnoreCase("entradasEstoque") || this.camposRelatorio[i].equalsIgnoreCase("saidasEstoque") || this.camposRelatorio[i].equalsIgnoreCase("valorPepsFinal") || this.camposRelatorio[i].equalsIgnoreCase("valorUepsFinal") || this.camposRelatorio[i].equalsIgnoreCase("valorCmcFinal") || this.camposRelatorio[i].equalsIgnoreCase("valorUnitarioCmc") || celula != null && (this.camposRelatorio[i].equalsIgnoreCase("saldoEstoqueInicial") || this.camposRelatorio[i].equalsIgnoreCase("saldoEstoqueInicialNaoConciliado") || this.camposRelatorio[i].equalsIgnoreCase("saldoEstoqueFinal") || this.camposRelatorio[i].equalsIgnoreCase("saldoEstoqueFinalNaoConciliado") || this.camposRelatorio[i].equalsIgnoreCase("dataSaldoEstoqueInicial") || this.camposRelatorio[i].equalsIgnoreCase("dataSaldoEstoqueFinal"))) continue;
                        o[modelo.findColumn((String)this.camposRelatorio[i])] = this.camposRelatorio[i].equalsIgnoreCase("materialInativo") ? (rs.getBoolean(this.camposRelatorio[i]) ? "Sim" : "N\u00e3o") : rs.getObject(this.camposRelatorio[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                st2 = Conexao.getStatement();
                for (int i = 0; i < modelo.getRowCount(); ++i) {
                    Integer filial = (Integer)modelo.getValueAt(i, modelo.findColumn("codigoFilial"));
                    Integer codigoMaterial = (Integer)modelo.getValueAt(i, modelo.findColumn("codigoMaterial"));
                    Date dataInicial = (Date)modelo.getValueAt(i, modelo.findColumn("dataSaldoEstoqueInicial"));
                    Date dataFinal = (Date)modelo.getValueAt(i, modelo.findColumn("dataSaldoEstoqueFinal"));
                    try {
                        SaldoFinal saldoFinal = this.getSaldoFinal(filial, codigoMaterial, this.getFiltroData(FILTRO_DATA_FINAL).isEmpty() ? null : Funcoes.stringToDate("dd/MM/yyyy", this.getFiltroData(FILTRO_DATA_FINAL)), celula, st2);
                        if (this.getFiltroCheck(FILTRO_SOMENTE_ESTOQUE) && saldoFinal.quantidadeFinal.doubleValue() == 0.0) {
                            modelo.removeLine(i);
                            --i;
                            continue;
                        }
                        if (celula != null) {
                            modelo.setValueAt(saldoFinal.quantidadeFinal, i, modelo.findColumn("saldoEstoqueFinal"));
                            BigDecimal saldoFinalNaoConciliado = this.getSaldoFinalNaoConciliado(filial, codigoMaterial, Funcoes.stringToDate("dd/MM/yyyy", this.getFiltroData(FILTRO_DATA_INICIAL)), this.getFiltroData(FILTRO_DATA_FINAL).isEmpty() ? new Date() : Funcoes.stringToDate("dd/MM/yyyy", this.getFiltroData(FILTRO_DATA_FINAL)), celula, st2);
                            modelo.setValueAt(saldoFinalNaoConciliado == null ? BigDecimal.ZERO : saldoFinalNaoConciliado, i, modelo.findColumn("saldoEstoqueFinalNaoConciliado"));
                            if (!this.getFiltroData(FILTRO_DATA_INICIAL).isEmpty()) {
                                BigDecimal saldoInicial = this.getSaldoAnterior(filial, codigoMaterial, Funcoes.stringToDate("dd/MM/yyyy", this.getFiltroData(FILTRO_DATA_INICIAL)), celula, st2);
                                modelo.setValueAt(saldoInicial == null ? BigDecimal.ZERO : saldoInicial, i, modelo.findColumn("saldoEstoqueInicial"));
                                BigDecimal saldoInicialNaoConciliado = this.getSaldoAnteriorNaoConciliado(filial, codigoMaterial, Funcoes.stringToDate("dd/MM/yyyy", this.getFiltroData(FILTRO_DATA_INICIAL)), celula, st2);
                                modelo.setValueAt(saldoInicialNaoConciliado == null ? BigDecimal.ZERO : saldoInicialNaoConciliado, i, modelo.findColumn("saldoEstoqueInicialNaoConciliado"));
                            } else {
                                modelo.setValueAt(BigDecimal.ZERO, i, modelo.findColumn("saldoEstoqueInicial"));
                                modelo.setValueAt(BigDecimal.ZERO, i, modelo.findColumn("saldoEstoqueInicialNaoConciliado"));
                            }
                        }
                        if (saldoFinal.quantidadeFinal.compareTo(BigDecimal.ZERO) > 0) {
                            modelo.setValueAt(saldoFinal.valorCmc.divide(saldoFinal.quantidadeFinal, ParametrosGerais.getArredondamentoPrecoExame()), i, modelo.findColumn("valorUnitarioCmc"));
                        } else {
                            modelo.setValueAt(BigDecimal.ZERO, i, modelo.findColumn("valorUnitarioCmc"));
                        }
                        modelo.setValueAt(saldoFinal.valorPeps, i, modelo.findColumn("valorPepsFinal"));
                        modelo.setValueAt(saldoFinal.valorUeps, i, modelo.findColumn("valorUepsFinal"));
                        modelo.setValueAt(saldoFinal.valorCmc, i, modelo.findColumn("valorCmcFinal"));
                        BigDecimal[] valores = null;
                        valores = celula == null ? this.getValorMovimento(filial, codigoMaterial, this.getFiltroData(FILTRO_DATA_INICIAL).isEmpty() ? null : Funcoes.getData("dd/MM/yyyy", this.getFiltroData(FILTRO_DATA_INICIAL)), this.getFiltroData(FILTRO_DATA_FINAL).isEmpty() ? null : Funcoes.getData("dd/MM/yyyy", this.getFiltroData(FILTRO_DATA_FINAL)), st2) : this.getValorMovimentoCelula(filial, codigoMaterial, this.getFiltroData(FILTRO_DATA_INICIAL).isEmpty() ? null : Funcoes.getData("dd/MM/yyyy", this.getFiltroData(FILTRO_DATA_INICIAL)), this.getFiltroData(FILTRO_DATA_FINAL).isEmpty() ? null : Funcoes.getData("dd/MM/yyyy", this.getFiltroData(FILTRO_DATA_FINAL)), celula, st2);
                        modelo.setValueAt(valores[0], i, modelo.findColumn("entradasEstoque"));
                        modelo.setValueAt(valores[1], i, modelo.findColumn("saidasEstoque"));
                        if (!this.getFiltroCheck(FILTRO_SOMENTE_COM_MOVIMENTO) || valores[0].doubleValue() != 0.0 || valores[1].doubleValue() != 0.0) continue;
                        modelo.removeLine(i);
                        --i;
                        continue;
                    }
                    catch (Exception e) {
                        modelo.setValueAt(BigDecimal.ZERO, i, modelo.findColumn("entradasEstoque"));
                        modelo.setValueAt(BigDecimal.ZERO, i, modelo.findColumn("saidasEstoque"));
                        modelo.setValueAt(BigDecimal.ZERO, i, modelo.findColumn("saldoEstoqueInicial"));
                        modelo.setValueAt(BigDecimal.ZERO, i, modelo.findColumn("saldoEstoqueInicialNaoConciliado"));
                        modelo.setValueAt(BigDecimal.ZERO, i, modelo.findColumn("saldoEstoqueFinal"));
                        modelo.setValueAt(BigDecimal.ZERO, i, modelo.findColumn("saldoEstoqueFinalNaoConciliado"));
                        modelo.setValueAt(BigDecimal.ZERO, i, modelo.findColumn("valorPepsFinal"));
                        modelo.setValueAt(BigDecimal.ZERO, i, modelo.findColumn("valorUepsFinal"));
                        modelo.setValueAt(BigDecimal.ZERO, i, modelo.findColumn("valorCmcFinal"));
                        modelo.setValueAt(BigDecimal.ZERO, i, modelo.findColumn("valorUnitarioCmc"));
                    }
                }
                if (modelo.getRowCount() == 0) {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                    this.habilitaBotaoImprimir(true);
                    this.setCursor(Cursor.getDefaultCursor());
                    Conexao.fecharStatement(st);
                    return;
                }
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioMovimentoEstoque.getModuloAcesso());
                rs.close();
                rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) break block46;
                Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                gerador.setPai(this.panelCentro);
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(1.0f);
                gerador.setAcaoFechar(new Runnable(){

                    @Override
                    public void run() {
                        RelatorioMovimentoEstoque.this.panelCentro.removeAll();
                        RelatorioMovimentoEstoque.this.panelCentro.repaint();
                        RelatorioMovimentoEstoque.this.habilitaBotaoImprimir(true);
                    }
                });
                HashMap<String, Object> var = new HashMap<String, Object>();
                var.put(FILTRO_SOMENTE_ESTOQUE, this.getFiltroCheck(FILTRO_SOMENTE_ESTOQUE) ? "Sim" : "N\u00e3o");
                var.put(FILTRO_ORDENACAO, this.getFiltroCombo(FILTRO_ORDENACAO));
                var.put(FILTRO_DATA_INICIAL, this.getFiltroData(FILTRO_DATA_INICIAL));
                var.put(FILTRO_DATA_FINAL, this.getFiltroData(FILTRO_DATA_FINAL));
                var.put(FILTRO_SOMENTE_COM_MOVIMENTO, this.getFiltroCheck(FILTRO_SOMENTE_COM_MOVIMENTO) ? "Sim" : "N\u00e3o");
                var.put(FILTRO_MATERIAL_INATIVO, this.getFiltroCheck(FILTRO_MATERIAL_INATIVO) ? "Sim" : "N\u00e3o");
                buf.delete(0, buf.length());
                if (filiais != null) {
                    for (int i = 0; i < filiais.length; ++i) {
                        buf.append(filiais[i]);
                        if (i >= filiais.length - 1) continue;
                        buf.append(", ");
                    }
                }
                var.put(FILTRO_FILIAL, buf.toString());
                buf.delete(0, buf.length());
                if (material != null) {
                    for (int i = 0; i < material.length; ++i) {
                        buf.append(material[i]);
                        if (i >= material.length - 1) continue;
                        buf.append(", ");
                    }
                }
                var.put(FILTRO_MATERIAL, buf.toString());
                buf.delete(0, buf.length());
                if (celula != null) {
                    for (int i = 0; i < celula.length; ++i) {
                        buf.append(celula[i]);
                        if (i >= celula.length - 1) continue;
                        buf.append(", ");
                    }
                }
                var.put(FILTRO_CELULA, buf.toString());
                buf.delete(0, buf.length());
                if (tipoMaterial != null) {
                    for (int i = 0; i < tipoMaterial.length; ++i) {
                        buf.append(tipoMaterial[i]);
                        if (i >= tipoMaterial.length - 1) continue;
                        buf.append(", ");
                    }
                }
                var.put(FILTRO_TIPO_MATERIAL, buf.toString());
                Relatorio rel = new Relatorio(modelo, var, ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                rel.setConfiguracao(rs.getString("rel_xml"));
                gerador.executar(rel);
                this.panelCentro.revalidate();
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0801000600");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0801000601");
    }

    private BigDecimal[] getValorMovimento(Integer filial, Integer codigoMaterial, Date dataInicial, Date dataFinal, Statement st) throws SQLException {
        ResultSet rs;
        StringBuilder buf = new StringBuilder();
        buf.append(" select COALESCE(SUM(CASE WHEN lce.lce_tipo = '").append("E").append("' THEN lce.lce_quantidade ELSE 0 END), 0) as entradas, ");
        buf.append("        COALESCE(SUM(CASE WHEN lce.lce_tipo = '").append("S").append("' THEN lce.lce_quantidade ELSE 0 END), 0) as saidas ");
        buf.append("   from lanctoestoque lce ");
        buf.append("  where lce.fil_codigo = ").append(filial);
        buf.append("    and lce.mat_codigo = ").append(codigoMaterial);
        buf.append("    and lce.lce_situacao = '").append("O").append("' ");
        buf.append("    and lce.lce_datahoracancelamento is null ");
        if (dataInicial != null) {
            buf.append("    and date_trunc('day', lce.lce_datahora) >= '").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append("' ");
        }
        if (dataFinal != null) {
            buf.append("    and date_trunc('day', lce.lce_datahora) <= '").append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append("' ");
        }
        if ((rs = Conexao.executeQuery(st, buf.toString())).next()) {
            return new BigDecimal[]{rs.getBigDecimal("entradas"), rs.getBigDecimal("saidas")};
        }
        return null;
    }

    private BigDecimal[] getValorMovimentoCelula(Integer filial, Integer codigoMaterial, Date dataInicial, Date dataFinal, String[] celulas, Statement st) throws SQLException {
        ResultSet rs;
        StringBuilder buf = new StringBuilder();
        buf.append(" select COALESCE(SUM(CASE WHEN lce.lce_tipo = '").append("E").append("' THEN lce.lce_quantidade ELSE 0 END), 0) as entradas, ");
        buf.append("        COALESCE(SUM(CASE WHEN lce.lce_tipo = '").append("S").append("' THEN lce.lce_quantidade ELSE 0 END), 0) as saidas ");
        buf.append("   from lanctoestoque lce ");
        buf.append("  where lce.fil_codigo = ").append(filial);
        buf.append("    and lce.mat_codigo = ").append(codigoMaterial);
        buf.append("    and lce.lce_situacao = '").append("O").append("' ");
        buf.append("    and lce.lce_datahoracancelamento is null ");
        if (celulas != null) {
            buf.append(" and lce.cel_codigo in (");
            for (int i = 0; i < celulas.length; ++i) {
                buf.append(celulas[i]);
                if (i >= celulas.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (dataInicial != null) {
            buf.append("    and date_trunc('day', lce.lce_datahora) >= '").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append("' ");
        }
        if (dataFinal != null) {
            buf.append("    and date_trunc('day', lce.lce_datahora) <= '").append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append("' ");
        }
        if ((rs = Conexao.executeQuery(st, buf.toString())).next()) {
            return new BigDecimal[]{rs.getBigDecimal("entradas"), rs.getBigDecimal("saidas")};
        }
        return null;
    }

    private BigDecimal getSaldoAnteriorNaoConciliado(Integer filial, Integer codigoMaterial, Date dataInicial, String[] celulas, Statement st) throws SQLException {
        if (celulas == null || celulas.length == 0) {
            return BigDecimal.ZERO;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" select SUM(COALESCE(lce_quantidade, 0)) as saldoAnteriorNaoConciliado ");
        buf.append("   from lanctoestoque lce ");
        buf.append("  where lce.fil_codigo = ").append(filial);
        buf.append("    and lce.mat_codigo = ").append(codigoMaterial);
        buf.append("    and lce.lce_tipo = '").append("E").append("' ");
        buf.append("    and (lce.lce_conciliacao IS NULL OR cast(lce.lce_conciliacao as date) > '").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append("') ");
        buf.append("    and cast(lce.lce_datahora as date) < '").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append("' ");
        buf.append("    and lce.lce_datahoracancelamento is null ");
        buf.append(" and lce.cel_codigo in (");
        for (int i = 0; i < celulas.length; ++i) {
            buf.append(celulas[i]);
            if (i >= celulas.length - 1) continue;
            buf.append(", ");
        }
        buf.append(")");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getBigDecimal("saldoAnteriorNaoConciliado");
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getSaldoFinalNaoConciliado(Integer filial, Integer codigoMaterial, Date dataInicial, Date dataFinal, String[] celulas, Statement st) throws SQLException {
        if (celulas == null || celulas.length == 0) {
            return BigDecimal.ZERO;
        }
        dataInicial = Funcoes.somaDias(dataInicial, 1);
        StringBuilder buf = new StringBuilder();
        buf.append(" select SUM(COALESCE(lce_quantidade, 0)) as saldoFinalNaoConciliado ");
        buf.append("   from lanctoestoque lce ");
        buf.append("  where lce.fil_codigo = ").append(filial);
        buf.append("    and lce.mat_codigo = ").append(codigoMaterial);
        buf.append("    and lce.lce_tipo = '").append("E").append("' ");
        buf.append("    and cast(lce.lce_datahora as date) between '").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append("' and '").append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append("' ");
        buf.append("    and (lce.lce_conciliacao IS NULL OR cast(lce.lce_conciliacao as date) > '").append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append("') ");
        buf.append("    and lce.lce_datahoracancelamento is null ");
        buf.append(" and lce.cel_codigo in (");
        for (int i = 0; i < celulas.length; ++i) {
            buf.append(celulas[i]);
            if (i >= celulas.length - 1) continue;
            buf.append(", ");
        }
        buf.append(")");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getBigDecimal("saldoFinalNaoConciliado");
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getSaldoAnterior(Integer filial, Integer codigoMaterial, Date dataInicial, String[] celulas, Statement st) throws SQLException {
        ResultSet rs;
        StringBuilder buf = new StringBuilder();
        buf.append(" select SUM(COALESCE(ces_saldo, 0)) as saldoAnterior ");
        buf.append("   from saldoestoquecelula ces ");
        buf.append("  where ces.fil_codigo = ").append(filial);
        buf.append("    and ces.mat_codigo = ").append(codigoMaterial);
        buf.append("    and ces.ces_data = (select MAX(ces_data) ");
        buf.append("                          from saldoestoquecelula ");
        buf.append("                         where fil_codigo = ces.fil_codigo ");
        buf.append("                           and mat_codigo = ces.mat_codigo ");
        buf.append("                           and cel_codigo = ces.cel_codigo ");
        buf.append("                           and ces_data < '").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append("' ");
        buf.append("                       ) ");
        if (celulas != null) {
            buf.append(" and ces.cel_codigo in (");
            for (int i = 0; i < celulas.length; ++i) {
                buf.append(celulas[i]);
                if (i >= celulas.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if ((rs = Conexao.executeQuery(st, buf.toString())).next()) {
            return rs.getBigDecimal("saldoAnterior");
        }
        return BigDecimal.ZERO;
    }

    private SaldoFinal getSaldoFinal(Integer filial, Integer codigoMaterial, Date dataFinal, String[] celulas, Statement st) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select SUM(COALESCE(ces_saldo, 0)) as saldoFinal");
        buf.append("       ,SUM(COALESCE(ces_totalpeps, 0)) as valorPeps ");
        buf.append("       ,SUM(COALESCE(ces_totalueps, 0)) as valorUeps ");
        buf.append("       ,SUM(COALESCE(ces_totalcmc, 0)) as valorCmc ");
        buf.append("   from saldoestoquecelula ces ");
        buf.append("  where ces.fil_codigo = ").append(filial);
        buf.append("    and ces.mat_codigo = ").append(codigoMaterial);
        buf.append("    and ces.ces_data = (select MAX(ces_data) ");
        buf.append("                          from saldoestoquecelula ");
        buf.append("                         where fil_codigo = ").append(filial);
        buf.append("                           and mat_codigo = ").append(codigoMaterial);
        buf.append("                           and cel_codigo = ces.cel_codigo ");
        if (dataFinal != null) {
            buf.append("                           and ces_data <= '").append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append("' ");
        }
        if (celulas != null) {
            buf.append(" and ces.cel_codigo in (");
            for (int i = 0; i < celulas.length; ++i) {
                buf.append(celulas[i]);
                if (i >= celulas.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        buf.append("                       ) ");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            SaldoFinal saldo = new SaldoFinal();
            saldo.quantidadeFinal = rs.getBigDecimal("saldoFinal") == null ? BigDecimal.ZERO : rs.getBigDecimal("saldoFinal");
            saldo.valorPeps = rs.getBigDecimal("valorPeps") == null ? BigDecimal.ZERO : rs.getBigDecimal("valorPeps");
            saldo.valorUeps = rs.getBigDecimal("valorUeps") == null ? BigDecimal.ZERO : rs.getBigDecimal("valorUeps");
            saldo.valorCmc = rs.getBigDecimal("valorCmc") == null ? BigDecimal.ZERO : rs.getBigDecimal("valorCmc");
            return saldo;
        }
        return new SaldoFinal();
    }

    class SaldoFinal {
        BigDecimal quantidadeFinal = BigDecimal.ZERO;
        BigDecimal valorPeps = BigDecimal.ZERO;
        BigDecimal valorUeps = BigDecimal.ZERO;
        BigDecimal valorCmc = BigDecimal.ZERO;

        SaldoFinal() {
        }
    }
}

