/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.estoque.almoxarifado;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioMediaTransferencia
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final int DIAS_QUINZENAL = 15;
    private static final int DIAS_TRIMESTRAL = 30;
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_CELULA_ESTOQUE = "filtroCelulaEstoque";
    private final String FILTRO_MATERIAL = "filtroMaterial";
    private final String FILTRO_INATIVOS = "filtroInativo";
    public static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    public static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"quantidadeAnterior", "quantidadeMensal", "quantidadeQuinzenal", "codigoCelulaDestino", "quantidadeTransferencia", "descricaoCelulaDestino", "codigoMaterial", "descricaoMaterial", "codigoUnidadeMedida", "descricaoUnidadeMedida", "dataHoraTransferencia1", "dataHoraTransferencia2", "dataHoraTransferencia3", "dataHoraTransferencia4", "dataHoraTransferencia5", "quantidadeTransferencia1", "quantidadeTransferencia2", "quantidadeTransferencia3", "quantidadeTransferencia4", "quantidadeTransferencia5", "mediaQtdeTransferencia", "totalPeps", "totalUeps", "totalCmc"});

    public RelatorioMediaTransferencia() {
        this.montaBarraDescricao("Relat\u00f3rio de M\u00e9dia de Transfer\u00eancia entre Estoques", "Listagem da m\u00e9dia de transfer\u00eancia entre estoques", "relatorios/rel_estoque_almoxarifado_media_transf_estoque_material.jpg");
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroCelulaEstoque", "C\u00e9lula Estoque", "celulaestoque", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cel_codigo", "cel_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroMaterial", "Material", "material", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"mat_codigo", "mat_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data Inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data Final:");
        this.adicionaFiltroCheck("filtroInativo", "Apresentar inativos", false);
        this.adicionaRelatorioListener(this);
        this.setModuloConfigurar(RelatorioMediaTransferencia.getModuloConfigurar());
        this.setModuloAcesso(RelatorioMediaTransferencia.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0801001000");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0801001001");
    }

    @Override
    public void imprimirPressionado() {
        String[] material;
        if (!Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL))) {
            Funcoes.mensagem(this, "A data inicial deve ser preenchida.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        if (!Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL))) {
            Funcoes.mensagem(this, "A data final deve ser preenchida.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("Select distinct ");
        buf.append("\t\t    0 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t as mediaQtdeTransferencia ");
        buf.append("\t\t   ,0 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t as quantidadeQuinzenal \t ");
        buf.append("\t\t   ,0 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t as quantidadeMensal \t\t\t ");
        buf.append("\t\t   ,0 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t quantidadeAnterior        ");
        buf.append("       ,a.cel_coddestino                 as codigoCelulaDestino    ");
        buf.append("  \t\t ,upper(celdestino.cel_descricao)  as descricaoCelulaDestino ");
        buf.append("  \t\t ,mat.mat_codigo \t\t\t\t\t\t\t     as codigoMaterial         ");
        buf.append("  \t\t ,upper(mat.mat_descricao) \t\t\t   as descricaoMaterial      ");
        buf.append("  \t\t ,unm.unm_codigo \t\t\t\t\t\t\t     as codigoUnidadeMedida    ");
        buf.append("  \t\t ,unm.unm_descricao \t\t\t\t\t\t   as descricaoUnidadeMedida,");
        buf.append("  \t\t saldoest.sde_totalpeps as totalpeps,                        ");
        buf.append("  \t\t saldoest.sde_totalueps as totalueps,                        ");
        buf.append("  \t\t saldoest.sde_totalcmc as totalcmc,                          ");
        buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        buf.append(" from transfestoque a \t\t\t\t\t\t\t\t\t\t  \t\t\t\t\t\t\t\t\t\t\t ");
        buf.append(" join transfestoquematerial trm  on a.fil_codigo = trm.fil_codigo and a.tra_codigo = trm.tra_codigo ");
        buf.append(" join celulaestoque celorigem  \ton a.fil_codigo = celorigem.fil_codigo and a.cel_codorigem = celorigem.cel_codigo ");
        buf.append(" join celulaestoque celdestino   on a.fil_codigo = celdestino.fil_codigo and a.cel_coddestino = celdestino.cel_codigo ");
        buf.append(" join material mat on trm.fil_codigo = mat.fil_codigo and trm.mat_codigo = mat.mat_codigo ");
        buf.append(" join tipomaterial tpm on mat.fil_codigo = tpm.fil_codigo and mat.tpm_codigo = tpm.tpm_codigo ");
        buf.append(" join unidademedida unm on mat.fil_codigo = unm.fil_codigo and mat.unm_codigo = unm.unm_codigo ");
        buf.append(" left join saldoestoque saldoest on (mat.fil_codigo = saldoest.fil_codigo and mat.mat_codigo = saldoest.mat_codigo) ");
        buf.append(" and (saldoest.sde_data = (select MAX(sde_data) from saldoestoque se where mat.fil_codigo = se.fil_codigo and mat.mat_codigo = se.mat_codigo)) ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
        if (filiais == null) {
            filiais = new String[]{Variaveis.filialPadrao};
        }
        buf.append(" where filial.fil_codigo in (");
        for (int i = 0; i < filiais.length; ++i) {
            buf.append(filiais[i]);
            if (i >= filiais.length - 1) continue;
            buf.append(",");
        }
        buf.append(")");
        String[] celula = this.getSelecionadosFiltro("filtroCelulaEstoque", 0);
        if (celula != null) {
            buf.append(" and a.cel_coddestino in (");
            for (int i = 0; i < celula.length; ++i) {
                buf.append(celula[i]);
                if (i >= celula.length - 1) continue;
                buf.append(",");
            }
            buf.append(")");
        }
        if ((material = this.getSelecionadosFiltro("filtroMaterial", 0)) != null) {
            buf.append(" and mat.mat_codigo in (");
            for (int i = 0; i < material.length; ++i) {
                buf.append(material[i]);
                if (i >= material.length - 1) continue;
                buf.append(",");
            }
            buf.append(")");
        }
        if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL))) {
            buf.append("  and cast(a.tra_datahora as date) between  (cast('").append(Funcoes.formataData("yyyy/MM/dd", this.getFiltroData(FILTRO_DATA_FINAL))).append("' as date) - ").append(30).append(") AND cast('").append(Funcoes.formataData("yyyy/MM/dd", this.getFiltroData(FILTRO_DATA_FINAL))).append("' as date)");
        }
        if (!this.getFiltroCheck("filtroInativo")) {
            buf.append(" and not mat.mat_inativo ");
        }
        buf.append(" and trm.trm_datacancelamento IS NULL ");
        buf.append(" and a.tra_datacancelamento IS NULL ");
        buf.append(" order by filial.fil_codigo, a.cel_coddestino, mat.mat_codigo ");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        if (campos[i].startsWith("dataHoraTransferencia") || campos[i].startsWith("quantidadeTransferencia")) continue;
                        o[modelo.findColumn((String)RelatorioMediaTransferencia.campos[i])] = rs.getObject(campos[i]);
                    }
                    this.getQuantidadeTransferencia(rs.getString("codigoMaterial"), Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_FINAL)), rs.getString("codigoCelulaDestino"), 30, o, modelo);
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioMediaTransferencia.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(1.0f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioMediaTransferencia.this.panelCentro.removeAll();
                            RelatorioMediaTransferencia.this.panelCentro.repaint();
                            RelatorioMediaTransferencia.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put(FILTRO_DATA_FINAL, this.getFiltroData(FILTRO_DATA_FINAL));
                    var.put("filtroInativo", this.getFiltroCheck("filtroInativo") ? "Sim" : "N\u00e3o");
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        for (i = 0; i < filiais.length; ++i) {
                            buf.append(filiais[i]);
                            if (i >= filiais.length - 1) continue;
                            buf.append(",");
                        }
                    }
                    var.put("filtroFilial", buf.toString());
                    buf.delete(0, buf.length());
                    if (celula != null) {
                        for (i = 0; i < celula.length; ++i) {
                            buf.append(celula[i]);
                            if (i >= celula.length - 1) continue;
                            buf.append(",");
                        }
                    }
                    var.put("filtroCelulaEstoque", buf.toString());
                    buf.delete(0, buf.length());
                    if (material != null) {
                        for (i = 0; i < material.length; ++i) {
                            buf.append(material[i]);
                            if (i >= material.length - 1) continue;
                            buf.append(",");
                        }
                    }
                    var.put("filtroMaterial", buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void getQuantidadeTransferencia(String material, String data, String celularDestino, int diaPassado, Object[] o, ModeloGridTable modelo) {
        ResultSet rs2;
        Statement st = Conexao.getStatement();
        StringBuilder buf = this.gerarSqlQuantidadePeriodo(material, data, celularDestino, diaPassado, 0);
        int pos = 0;
        BigDecimal totalQuantidade = BigDecimal.ZERO;
        try {
            int contador;
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            for (contador = 1; rs.next() && contador <= 5; ++contador) {
                Timestamp dataHora = rs.getTimestamp("tra_datahora");
                BigDecimal qtde = rs.getBigDecimal("trm_quantidade");
                pos = modelo.findColumn("dataHoraTransferencia" + String.valueOf(contador));
                o[pos] = dataHora;
                pos = modelo.findColumn("quantidadeTransferencia" + String.valueOf(contador));
                qtde.setScale(2, ParametrosGerais.getArredondamentoPrecoExame());
                o[pos] = qtde;
                totalQuantidade = totalQuantidade.add(qtde);
            }
            pos = modelo.findColumn("mediaQtdeTransferencia");
            if (contador - 1 > 0) {
                totalQuantidade = totalQuantidade.divide(new BigDecimal("" + (contador - 1)), 4, ParametrosGerais.getArredondamentoPrecoExame());
            }
            o[pos] = totalQuantidade;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        buf.delete(0, buf.length());
        buf = this.gerarSqlQuantidadePeriodo(material, data, celularDestino, 30, 1);
        try {
            ResultSet rs1 = Conexao.executeQuery(st, buf.toString());
            while (rs1.next()) {
                BigDecimal qtdeMensal = rs1.getBigDecimal("trm_quantidade");
                pos = modelo.findColumn("quantidadeMensal");
                o[pos] = qtdeMensal;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        buf.delete(0, buf.length());
        buf = this.gerarSqlQuantidadePeriodo(material, data, celularDestino, 15, 1);
        try {
            rs2 = Conexao.executeQuery(st, buf.toString());
            while (rs2.next()) {
                BigDecimal qtdeQuinzenal = rs2.getBigDecimal("trm_quantidade");
                pos = modelo.findColumn("quantidadeQuinzenal");
                o[pos] = qtdeQuinzenal;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        buf.delete(0, buf.length());
        buf = this.gerarSqlQuantidadePeriodo(material, data, celularDestino, 0, 2);
        try {
            rs2 = Conexao.executeQuery(st, buf.toString());
            while (rs2.next()) {
                BigDecimal qtdeAnterior = rs2.getBigDecimal("trm_quantidade");
                pos = modelo.findColumn("quantidadeAnterior");
                o[pos] = qtdeAnterior;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    private StringBuilder gerarSqlQuantidadePeriodo(String material, String data, String celularDestino, int diaPassado, int contabilizaQtde) {
        StringBuilder buf = new StringBuilder();
        buf.append("select ");
        if (contabilizaQtde == 0) {
            buf.append(" cast(a1.tra_datahora as date)as tra_datahora, ");
        }
        buf.append("  sum(trm1.trm_quantidade) as trm_quantidade ");
        buf.append("from transfestoque a1 ");
        buf.append(" left join transfestoquematerial trm1 ON a1.fil_codigo = trm1.fil_codigo AND a1.tra_codigo = trm1.tra_codigo ");
        buf.append("where trm1.mat_codigo =  ").append(material);
        buf.append("  and a1.cel_coddestino =  ").append(celularDestino);
        buf.append(" and trm1.trm_datacancelamento IS NULL ");
        buf.append(" and a1.tra_datacancelamento IS NULL ");
        if (contabilizaQtde == 0) {
            buf.append(" and cast(a1.tra_datahora as date) >=  cast('").append(data).append("' as date) - ").append(diaPassado);
            buf.append(" group by cast(a1.tra_datahora as date)  ");
            buf.append(" order by cast(a1.tra_datahora as date) desc limit 5");
        } else if (contabilizaQtde == 1) {
            buf.append(" and cast(a1.tra_datahora as date) between  (cast('").append(data).append("' as date) - ").append(diaPassado).append(") AND cast(current_date as date)");
        } else if (contabilizaQtde == 2) {
            buf.append(" and cast(a1.tra_datahora as date) between  cast('").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_INICIAL))).append("' as date) and cast('").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_FINAL))).append("' as date) ");
        }
        return buf;
    }
}

