/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.estoque.almoxarifado;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableModel;

public class RelatorioMediaAnualTransferenciaEstoque
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_CELULA_ESTOQUE = "filtroCelulaEstoque";
    private final String FILTRO_MATERIAL = "filtroMaterial";
    private final String FILTRO_TIPO_MATERIAL = "filtroTipoMaterial";
    private final String FILTRO_INATIVOS = "filtroInativo";
    private final String FILTRO_AGRUPAR = "agrupaCelula";
    private final String FILTRO_AVISO_REPOSICAO = "apenasPontoReposicao";
    public static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoCelulaDestino", "mediaQtdeTransferencia", "descricaoCelulaDestino", "codigoMaterial", "descricaoMaterial", "codigoUnidadeMedida", "descricaoUnidadeMedida", "descricaoTipoMaterial", "pontoReposicaoMaterial", "totalPeps", "totalUeps", "totalCmc"});
    private Calendar calendar = Calendar.getInstance();
    private static final String[] campos_totais = new String[]{"mes1", "mes2", "mes3", "mes4", "mes5", "mes6", "mes7", "mes8", "mes9", "mes10", "mes11", "mes12", "totalMes1", "totalMes2", "totalMes3", "totalMes4", "totalMes5", "totalMes6", "totalMes7", "totalMes8", "totalMes9", "totalMes10", "totalMes11", "totalMes12"};

    public RelatorioMediaAnualTransferenciaEstoque() {
        this.montaBarraDescricao("<html>Relat\u00f3rio de M\u00e9dia anual de transfer\u00eancia <br>entre estoques</html>", "Listagem da m\u00e9dia de transfer\u00eancia entre estoques anual", "relatorios/rel_estoque_almoxarifado_media_anual_transf_estoque_material.jpg");
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", null, 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroCelulaEstoque", "C\u00e9lula Estoque", "celulaestoque", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cel_codigo", "cel_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroMaterial", "Material", "material", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"mat_codigo", "mat_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroTipoMaterial", "Tipo Material", "tipomaterial", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"tpm_codigo", "tpm_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroCombo(FILTRO_DATA_FINAL, "M\u00eas anterior:", new Object[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, this.calendar.get(2));
        this.adicionaFiltroCheck("filtroInativo", "Apresentar inativos", false);
        this.adicionaFiltroCheck("agrupaCelula", "Agrupar C\u00e9lula", false);
        this.adicionaFiltroCheck("apenasPontoReposicao", "<html>Apresentar apenas <br>com aviso de reposi\u00e7\u00e3o</html>", false);
        this.adicionaRelatorioListener(this);
        this.setModuloConfigurar(RelatorioMediaAnualTransferenciaEstoque.getModuloConfigurar());
        this.setModuloAcesso(RelatorioMediaAnualTransferenciaEstoque.getModuloAcesso());
        this.setCamposConfigurador(ArraysUtil.concatenar(campos, campos_totais));
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0801001100");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0801001101");
    }

    @Override
    public void imprimirPressionado() {
        ResultSet rs;
        String mesSelecionadoReferencia = String.valueOf(this.getFiltroCombo(FILTRO_DATA_FINAL).toString());
        if (mesSelecionadoReferencia.length() == 1) {
            mesSelecionadoReferencia = "0" + mesSelecionadoReferencia;
        }
        Calendar dtAtual = Calendar.getInstance();
        String dataFinal = Funcoes.formataData("yyyy", dtAtual.getTime()) + "-" + mesSelecionadoReferencia + "-" + Funcoes.formataData("dd", dtAtual.getTime());
        dtAtual.add(2, -Integer.parseInt(mesSelecionadoReferencia));
        Date dataFiltro = Funcoes.getData("yyyy-MM-dd", dataFinal);
        Calendar car = Calendar.getInstance();
        car.setTime(dataFiltro);
        car.add(2, -10);
        Date dataInicio = car.getTime();
        int mes = car.get(2);
        int ano = car.get(1);
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        String dataBase = "01/" + mes + "/" + ano;
        buf.append(" select date_trunc('month', to_timestamp('" + dataBase + "', 'DD/MM/YYYY')) as mes1 ");
        buf.append("       ,date_trunc('month', to_timestamp('" + dataBase + "', 'DD/MM/YYYY')) + interval '1 month' as mes2 ");
        buf.append("       ,date_trunc('month', to_timestamp('" + dataBase + "', 'DD/MM/YYYY')) + interval '2 month' as mes3 ");
        buf.append("       ,date_trunc('month', to_timestamp('" + dataBase + "', 'DD/MM/YYYY')) + interval '3 month' as mes4 ");
        buf.append("       ,date_trunc('month', to_timestamp('" + dataBase + "', 'DD/MM/YYYY')) + interval '4 month' as mes5 ");
        buf.append("       ,date_trunc('month', to_timestamp('" + dataBase + "', 'DD/MM/YYYY')) + interval '5 month' as mes6 ");
        buf.append("       ,date_trunc('month', to_timestamp('" + dataBase + "', 'DD/MM/YYYY')) + interval '6 month' as mes7 ");
        buf.append("       ,date_trunc('month', to_timestamp('" + dataBase + "', 'DD/MM/YYYY')) + interval '7 month' as mes8 ");
        buf.append("       ,date_trunc('month', to_timestamp('" + dataBase + "', 'DD/MM/YYYY')) + interval '8 month' as mes9 ");
        buf.append("       ,date_trunc('month', to_timestamp('" + dataBase + "', 'DD/MM/YYYY')) + interval '9 month' as mes10 ");
        buf.append("       ,date_trunc('month', to_timestamp('" + dataBase + "', 'DD/MM/YYYY')) + interval '10 month' as mes11 ");
        buf.append("       ,date_trunc('month', to_timestamp('" + dataBase + "', 'DD/MM/YYYY')) + interval '11 month' as mes12 ");
        String[] arrayMeses = new String[12];
        try {
            rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                for (int j = 1; j <= arrayMeses.length; ++j) {
                    arrayMeses[j - 1] = rs.getString("mes" + j);
                }
            }
        }
        catch (SQLException e1) {
            ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace());
        }
        buf.delete(0, buf.length());
        buf.append("Select distinct ");
        buf.append("\t\t\t 0 mediaQtdeTransferencia ");
        if (this.getFiltroCheck("agrupaCelula")) {
            buf.append("       ,a.cel_coddestino                 as codigoCelulaDestino    ");
            buf.append("  \t\t ,upper(celdestino.cel_descricao)  as descricaoCelulaDestino ");
        }
        buf.append("       ,tpm.tpm_descricao                as descricaoTipoMaterial      ");
        buf.append("  \t\t ,mat.mat_codigo \t\t\t\t\t\t\t     as codigoMaterial         ");
        buf.append("  \t\t ,upper(mat.mat_descricao) \t\t\t   as descricaoMaterial      ");
        buf.append("  \t\t ,unm.unm_codigo \t\t\t\t\t\t\t     as codigoUnidadeMedida    ");
        buf.append("  \t\t ,unm.unm_descricao \t\t\t\t\t\t   as descricaoUnidadeMedida ");
        buf.append("\t\t\t ,mat.mat_ptoreposicao             as pontoReposicaoMaterial, ");
        buf.append("  \t\t saldoest.sde_totalpeps as totalpeps,                        ");
        buf.append("  \t\t saldoest.sde_totalueps as totalueps,                        ");
        buf.append("  \t\t saldoest.sde_totalcmc as totalcmc,                          ");
        buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        buf.append(" from transfestoque a \t\t\t\t\t\t\t\t\t\t  \t\t\t\t\t\t\t\t\t\t\t ");
        buf.append(" join transfestoquematerial trm  on a.fil_codigo = trm.fil_codigo and a.tra_codigo = trm.tra_codigo ");
        buf.append(" join celulaestoque celorigem  \ton a.fil_codigo = celorigem.fil_codigo and a.cel_codorigem = celorigem.cel_codigo ");
        if (this.getFiltroCheck("agrupaCelula")) {
            buf.append(" join celulaestoque celdestino   on a.fil_codigo = celdestino.fil_codigo and a.cel_coddestino = celdestino.cel_codigo ");
        }
        buf.append(" join material mat on trm.fil_codigo = mat.fil_codigo and trm.mat_codigo = mat.mat_codigo ");
        buf.append(" join tipomaterial tpm on mat.fil_codigo = tpm.fil_codigo and mat.tpm_codigo = tpm.tpm_codigo ");
        buf.append(" join unidademedida unm on mat.fil_codigo = unm.fil_codigo and mat.unm_codigo = unm.unm_codigo ");
        buf.append(" left join saldoestoque saldoest on (mat.fil_codigo = saldoest.fil_codigo and mat.mat_codigo = saldoest.mat_codigo) ");
        buf.append(" and (saldoest.sde_data = (select MAX(sde_data) from saldoestoque se where mat.fil_codigo = se.fil_codigo and mat.mat_codigo = se.mat_codigo)) ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
        if (filiais == null) {
            filiais = new String[]{Variaveis.filialPadrao};
        }
        this.concatenaFiltroSql(buf, "where", "filial.fil_codigo", filiais, false);
        String[] celula = this.getSelecionadosFiltro("filtroCelulaEstoque", 0);
        this.concatenaFiltroSql(buf, "and", "a.cel_coddestino", celula, false);
        String[] material = this.getSelecionadosFiltro("filtroMaterial", 0);
        this.concatenaFiltroSql(buf, "and", "mat.mat_codigo", material, false);
        String[] tipoMaterial = this.getSelecionadosFiltro("filtroTipoMaterial", 0);
        this.concatenaFiltroSql(buf, "and", "tpm.tpm_codigo", tipoMaterial, false);
        buf.append(" and trm.trm_datacancelamento IS NULL ");
        buf.append(" and a.tra_datacancelamento IS NULL ");
        if (Funcoes.verificaData(dataFinal)) {
            buf.append("  and cast(a.tra_datahora as date) between cast('").append(Funcoes.formataData("yyyy/MM/dd", dataInicio)).append("' as date ) ").append(" AND cast('").append(Funcoes.formataData("yyyy/MM/dd", dataFinal)).append("' as date)");
        }
        if (!this.getFiltroCheck("filtroInativo")) {
            buf.append(" and not mat.mat_inativo ");
        }
        if (this.getFiltroCheck("apenasPontoReposicao")) {
            buf.append(" and mat.mat_reposicaoautomatica = true ");
        }
        buf.append(" order by filial.fil_codigo,  ");
        if (this.getFiltroCheck("agrupaCelula")) {
            buf.append("\t\t\t\t\tcodigoCelulaDestino, ");
        }
        buf.append("\t\t\t\t\tcodigoMaterial ");
        try {
            rs = Conexao.executeQuery(st, buf.toString());
            String[] camposGeral = ArraysUtil.concatenar(campos, campos_totais);
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(camposGeral);
                do {
                    int i;
                    Object[] o = new Object[camposGeral.length];
                    int contador = 1;
                    for (i = 0; i < campos_totais.length; ++i) {
                        if (!campos_totais[i].equalsIgnoreCase("mes" + contador)) continue;
                        o[modelo.findColumn((String)RelatorioMediaAnualTransferenciaEstoque.campos_totais[i])] = arrayMeses[i];
                        ++contador;
                    }
                    for (i = 0; i < campos.length; ++i) {
                        if (!this.getFiltroCheck("agrupaCelula")) {
                            if (campos[i].equalsIgnoreCase("codigoCelulaDestino") || campos[i].equalsIgnoreCase("descricaoCelulaDestino")) continue;
                            o[modelo.findColumn((String)RelatorioMediaAnualTransferenciaEstoque.campos[i])] = rs.getObject(campos[i]);
                            continue;
                        }
                        o[modelo.findColumn((String)RelatorioMediaAnualTransferenciaEstoque.campos[i])] = rs.getObject(campos[i]);
                    }
                    this.preencheTotais(modelo, o, arrayMeses, rs);
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioMediaAnualTransferenciaEstoque.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(1.0f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioMediaAnualTransferenciaEstoque.this.panelCentro.removeAll();
                            RelatorioMediaAnualTransferenciaEstoque.this.panelCentro.repaint();
                            RelatorioMediaAnualTransferenciaEstoque.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put(FILTRO_DATA_FINAL, Funcoes.formataData("dd", dtAtual.getTime()) + "-" + mesSelecionadoReferencia + "-" + Funcoes.formataData("yyyy", dtAtual.getTime()));
                    var.put("filtroInativo", this.getFiltroCheck("filtroInativo") ? "Sim" : "N\u00e3o");
                    var.put("apenasPontoReposicao", this.getFiltroCheck("apenasPontoReposicao") ? "Sim" : "N\u00e3o");
                    var.put("agrupaCelula", this.getFiltroCheck("agrupaCelula") ? "Sim" : "N\u00e3o");
                    this.concatenarFiltro(buf, filiais, var, "filtroFilial");
                    this.concatenarFiltro(buf, celula, var, "filtroCelulaEstoque");
                    this.concatenarFiltro(buf, material, var, "filtroMaterial");
                    this.concatenarFiltro(buf, tipoMaterial, var, "filtroTipoMaterial");
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void concatenarFiltro(StringBuilder buf, String[] filtro, Map<String, Object> var, String descFiltro) {
        buf.delete(0, buf.length());
        if (filtro != null) {
            for (int i = 0; i < filtro.length; ++i) {
                buf.append(filtro[i]);
                if (i >= filtro.length - 1) continue;
                buf.append(",");
            }
        }
        var.put(descFiltro, buf.toString());
    }

    public void concatenaFiltroSql(StringBuilder buf, String inicio, String coluna, String[] filtro, boolean temAspas) {
        if (filtro != null) {
            buf.append(" ").append(inicio).append(" ").append(coluna).append(" in (");
            for (int i = 0; i < filtro.length; ++i) {
                if (temAspas) {
                    buf.append("' ");
                }
                buf.append(filtro[i]);
                if (temAspas) {
                    buf.append("' ");
                }
                if (i >= filtro.length - 1) continue;
                buf.append(",");
            }
            buf.append(")");
        }
    }

    private void preencheTotais(ModeloGridTable modelo, Object[] o, String[] arrayMeses, ResultSet rsMaterial) {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        int contador = 1;
        BigDecimal totalQuantidade = BigDecimal.ZERO;
        BigDecimal qtde = BigDecimal.ZERO;
        String mesano = "";
        try {
            for (int i = 0; i < arrayMeses.length; ++i) {
                buf.delete(0, buf.length());
                buf.append("select ");
                buf.append("\tsum(b.trm_quantidade) as totalMes ");
                buf.append(" from transfestoque a ");
                buf.append("\tleft join transfestoquematerial b ON a.fil_codigo = b.fil_codigo AND a.tra_codigo = b.tra_codigo ");
                buf.append(" where a.fil_codigo = ").append(rsMaterial.getObject("codigoFilial"));
                buf.append("\t\t\tand b.mat_codigo = ").append(rsMaterial.getObject("codigoMaterial"));
                if (this.getFiltroCheck("agrupaCelula")) {
                    buf.append("\t\t\tand a.cel_coddestino = ").append(rsMaterial.getObject("codigoCelulaDestino"));
                }
                buf.append("\t\t\tand a.tra_datahora >= cast('" + arrayMeses[i] + "' as date)");
                buf.append("\t\t\tand a.tra_datahora <= (cast('" + arrayMeses[i] + "' as date) + interval '1 month' - interval '1 day')");
                buf.append(" and b.trm_datacancelamento IS NULL ");
                buf.append(" and a.tra_datacancelamento IS NULL ");
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    for (int j = 0; j < campos_totais.length; ++j) {
                        if (!campos_totais[j].equals("totalMes" + contador)) continue;
                        qtde = rs.getBigDecimal("totalMes") != null ? rs.getBigDecimal("totalMes") : BigDecimal.ZERO;
                        o[modelo.findColumn((String)RelatorioMediaAnualTransferenciaEstoque.campos_totais[j])] = qtde;
                        totalQuantidade = totalQuantidade.add(qtde);
                    }
                }
                ++contador;
            }
            if (contador - 1 == arrayMeses.length) {
                totalQuantidade = totalQuantidade.divide(new BigDecimal("" + (contador - 1)), 4, ParametrosGerais.getArredondamentoPrecoExame());
                o[modelo.findColumn((String)"mediaQtdeTransferencia")] = totalQuantidade;
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }
}

