/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.estoque.almoxarifado;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.relatorio.gerador.Relatorio;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;

public class RelatorioInventario
extends FrmRelPadrao {
    private static final String FILTRO_FILIAL = "filtroFilial";
    private static final String FILTRO_CELULA = "filtroCelula";
    private static final String FILTRO_MATERIAL = "filtroMaterial";
    private static final String FILTRO_TIPO_MATERIAL = "filtroTipoMaterial";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_ORDENACAO = "filtroOrdenacao";
    private static final String[] camposOrdenacao = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"};
    private static final String[] camposOrdenacaoBanco = new String[]{"mat.mat_codigo", "mat.mat_descricao"};
    private static final String[] camposMaterial = new String[]{"materialInativo", "codigoMaterial", "descricaoMaterial", "valorUnitarioMaterial", "valorUltimaCompraMaterial", "dataUltimaCompraMaterial", "quantidadeUltimaCompraMaterial", "pontoReposicaoMaterial", "dataUltimaEntregaMaterial", "marcaMaterial", "modeloMaterial", "reposicaoAutomaticaMaterial", "codigoUsuarioMaterial", "imobilizadoMaterial", "solicitarPatrimonioMaterial", "fichaTecnicaMaterial"};
    private static final String[] camposUnidadeMedida = new String[]{"codigoUnidadeMedida", "descricaoUnidadeMedida"};
    private static final String[] camposTipoMaterial = new String[]{"codigoTipoMaterial", "descricaoTipoMaterial"};
    private static final String[] camposCelulaEstoque = new String[]{"codigoCelula", "descricaoCelula"};
    private static final String[] camposLancamento = new String[]{"quantidadeLancamento", "tipoLancamento", "codigoLancamento", "analiseCritica"};
    private static final String[] camposSaldo = new String[]{"saldoAnterior", "saldoAtual"};
    private String[] camposRelatorio = null;

    public RelatorioInventario() {
        this.montaBarraDescricao("Relat\u00f3rio de Invent\u00e1rio", "Invent\u00e1rio de materiais", "relatorios/rel_estoque_almoxarifado_inventario.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_MATERIAL, "Material", "material", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"mat_codigo", "mat_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_CELULA, "C\u00e9lula Estoque", "celulaestoque", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cel_codigo", "cel_descricao", "cel_inativa", "cel_padrao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Inativa?", "Padr\u00e3o?"}, new int[]{60, 0, 60, 60});
        this.adicionaItemFiltro(FILTRO_TIPO_MATERIAL, "Tipo Material", "tipomaterial", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"tpm_codigo", "tpm_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data Inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data Final:");
        this.adicionaFiltroCombo(FILTRO_ORDENACAO, "Ordem:", camposOrdenacao, 0);
        this.setModuloConfigurar(RelatorioInventario.getModuloConfigurar());
        this.setModuloAcesso(RelatorioInventario.getModuloAcesso());
        this.camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, camposMaterial);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposUnidadeMedida);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposTipoMaterial);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposCelulaEstoque);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposLancamento);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposSaldo);
        this.setCamposConfigurador(this.camposRelatorio);
        this.setModuloConfigurar(RelatorioInventario.getModuloConfigurar());
        this.setModuloAcesso(RelatorioInventario.getModuloAcesso());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void imprimirPressionado() {
        Statement st;
        block29: {
            if (this.getFiltroData(FILTRO_DATA_INICIAL) == null || Funcoes.textoVazio(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                Funcoes.mensagem(this, "\u00c9 necess\u00e1rio informar uma data inicial.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            st = Conexao.getStatement();
            Object st2 = null;
            String[] celula = this.getSelecionadosFiltro(FILTRO_CELULA, 0);
            try {
                int i;
                String dataFinal;
                String dataInicial;
                String[] celulasEstoque;
                String[] tipoMaterial;
                StringBuilder buf = new StringBuilder();
                buf.append(" select mat.fil_codigo ");
                buf.append("       ,mat.mat_codigo as codigoMaterial ");
                buf.append("       ,mat.mat_descricao as descricaoMaterial ");
                buf.append("       ,mat.mat_valorunit as valorUnitarioMaterial ");
                buf.append("       ,mat.mat_valorultcompra as valorUltimaCompraMaterial ");
                buf.append("       ,mat.mat_dataultcompra as dataUltimaCompraMaterial ");
                buf.append("       ,mat.mat_qtdeultcompra as quantidadeUltimaCompraMaterial ");
                buf.append("       ,mat.mat_ptoreposicao as pontoReposicaoMaterial ");
                buf.append("       ,mat.mat_dataultentrega as dataUltimaEntregaMaterial ");
                buf.append("       ,mat.mat_marca as marcaMaterial ");
                buf.append("       ,mat.mat_modelo as modeloMaterial ");
                buf.append("       ,mat.mat_reposicaoautomatica as reposicaoAutomaticaMaterial ");
                buf.append("\t\t\t ,mat.usr_codigo as codigoUsuarioMaterial ");
                buf.append("\t\t\t ,mat.mat_imobilizado as imobilizadoMaterial ");
                buf.append("\t\t\t ,mat.mat_solicitarpatrimonio as solicitarPatrimonioMaterial ");
                buf.append("\t\t\t ,mat.mat_fichatecnica as fichaTecnicaMaterial ");
                buf.append("\t\t\t ,mat.mat_inativo  as materialInativo ");
                buf.append("\t\t\t ,unm.unm_codigo as codigoUnidadeMedida ");
                buf.append("\t\t\t ,unm.unm_descricao as descricaoUnidadeMedida ");
                buf.append("\t\t\t ,tpm.tpm_codigo as codigoTipoMaterial ");
                buf.append("\t\t\t ,tpm.tpm_descricao as descricaoTipoMaterial ");
                buf.append("\t\t\t ,cel.cel_codigo as codigoCelula ");
                buf.append("\t\t\t ,cel.cel_descricao as descricaoCelula ");
                buf.append("\t\t\t ,a.lce_codigo as codigoLancamento ");
                buf.append("\t\t\t ,a.lce_quantidade as quantidadeLancamento ");
                buf.append("\t\t\t ,a.lce_tipo as tipoLancamento ");
                buf.append("\t\t\t ,a.lce_analisecritica as analiseCritica ");
                buf.append("\t\t\t ,cma.cma_quantidadeatual as saldoAnterior ");
                buf.append("\t\t\t ,cma.cma_quantidadenova as saldoAtual ");
                buf.append(" , ");
                buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                buf.append("  from lanctoestoque a ");
                buf.append("  join conferenciaestoquelanctoestoque cle on a.fil_codigo = cle.fil_codigo and a.lce_codigo = cle.lce_codigo ");
                buf.append("  join conferenciaestoquematerial cma on cle.fil_codigo = cma.fil_codigo and cle.ces_codigo = cma.ces_codigo and a.mat_codigo = cma.mat_codigo ");
                buf.append("  join material mat on a.fil_codigo = mat.fil_codigo and a.mat_codigo = mat.mat_codigo ");
                buf.append("  join tipomaterial tpm on mat.fil_codigo = tpm.fil_codigo and mat.tpm_codigo = tpm.tpm_codigo ");
                buf.append("  left join unidademedida unm on mat.fil_codigo = unm.fil_codigo and mat.unm_codigo = unm.unm_codigo ");
                buf.append("  join celulaestoque cel on a.fil_codigo = cel.fil_codigo and a.cel_codigo = cel.cel_codigo ");
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                buf.append(" where a.lce_tipoorigem = '").append("O").append("' ");
                buf.append("   and a.lce_datahoracancelamento IS NULL and a.usr_codcancelamento IS NULL ");
                buf.append(" and a.fil_codigo ");
                String[] filiais = this.getSelecionadosFiltro(FILTRO_FILIAL, 0);
                if (filiais == null || filiais.length == 0) {
                    buf.append(" = ").append(Variaveis.filialPadrao);
                } else {
                    buf.append(" in (");
                    for (int i2 = 0; i2 < filiais.length; ++i2) {
                        buf.append(filiais[i2]);
                        if (i2 >= filiais.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                String[] material = this.getSelecionadosFiltro(FILTRO_MATERIAL, 0);
                if (material != null) {
                    buf.append(" and mat.mat_codigo in (");
                    for (int i3 = 0; i3 < material.length; ++i3) {
                        buf.append(material[i3]);
                        if (i3 >= material.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if ((tipoMaterial = this.getSelecionadosFiltro(FILTRO_TIPO_MATERIAL, 0)) != null) {
                    buf.append(" and tpm.tpm_codigo in (");
                    for (int i4 = 0; i4 < tipoMaterial.length; ++i4) {
                        buf.append("'");
                        buf.append(tipoMaterial[i4]);
                        buf.append("'");
                        if (i4 >= tipoMaterial.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if ((celulasEstoque = this.getSelecionadosFiltro(FILTRO_CELULA, 0)) != null) {
                    buf.append(" and cel.cel_codigo in (");
                    for (int i5 = 0; i5 < celulasEstoque.length; ++i5) {
                        buf.append("'");
                        buf.append(celulasEstoque[i5]);
                        buf.append("'");
                        if (i5 >= celulasEstoque.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if (!Funcoes.textoVazio(dataInicial = this.getFiltroData(FILTRO_DATA_INICIAL))) {
                    buf.append(" and cast(a.lce_datahora as date) >= '").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append("' ");
                }
                if (!Funcoes.textoVazio(dataFinal = this.getFiltroData(FILTRO_DATA_FINAL))) {
                    buf.append(" and cast(a.lce_datahora as date) <= '").append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append("' ");
                }
                buf.append(" order by a.fil_codigo, ");
                buf.append(camposOrdenacaoBanco[this.getFiltroComboIndice(FILTRO_ORDENACAO)]);
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                    this.habilitaBotaoImprimir(true);
                    break block29;
                }
                ModeloGridTable modelo = new ModeloGridTable(this.camposRelatorio);
                do {
                    Object[] o = new Object[this.camposRelatorio.length];
                    for (int i6 = 0; i6 < this.camposRelatorio.length; ++i6) {
                        o[modelo.findColumn((String)this.camposRelatorio[i6])] = rs.getObject(this.camposRelatorio[i6]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                if (modelo.getRowCount() == 0) {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                    this.habilitaBotaoImprimir(true);
                    this.setCursor(Cursor.getDefaultCursor());
                    Conexao.fecharStatement(st);
                    return;
                }
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioInventario.getModuloAcesso());
                rs.close();
                rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) break block29;
                Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                gerador.setPai(this.panelCentro);
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(1.0f);
                gerador.setAcaoFechar(new Runnable(){

                    @Override
                    public void run() {
                        RelatorioInventario.this.panelCentro.removeAll();
                        RelatorioInventario.this.panelCentro.repaint();
                        RelatorioInventario.this.habilitaBotaoImprimir(true);
                    }
                });
                HashMap<String, Object> var = new HashMap<String, Object>();
                var.put(FILTRO_ORDENACAO, this.getFiltroCombo(FILTRO_ORDENACAO));
                var.put(FILTRO_DATA_INICIAL, this.getFiltroData(FILTRO_DATA_INICIAL));
                var.put(FILTRO_DATA_FINAL, this.getFiltroData(FILTRO_DATA_FINAL));
                buf.delete(0, buf.length());
                if (filiais != null) {
                    for (i = 0; i < filiais.length; ++i) {
                        buf.append(filiais[i]);
                        if (i >= filiais.length - 1) continue;
                        buf.append(", ");
                    }
                }
                var.put(FILTRO_FILIAL, buf.toString());
                buf.delete(0, buf.length());
                if (material != null) {
                    for (i = 0; i < material.length; ++i) {
                        buf.append(material[i]);
                        if (i >= material.length - 1) continue;
                        buf.append(", ");
                    }
                }
                var.put(FILTRO_MATERIAL, buf.toString());
                buf.delete(0, buf.length());
                if (celula != null) {
                    for (i = 0; i < celula.length; ++i) {
                        buf.append(celula[i]);
                        if (i >= celula.length - 1) continue;
                        buf.append(", ");
                    }
                }
                var.put(FILTRO_CELULA, buf.toString());
                buf.delete(0, buf.length());
                if (tipoMaterial != null) {
                    for (i = 0; i < tipoMaterial.length; ++i) {
                        buf.append(tipoMaterial[i]);
                        if (i >= tipoMaterial.length - 1) continue;
                        buf.append(", ");
                    }
                }
                var.put(FILTRO_TIPO_MATERIAL, buf.toString());
                Relatorio rel = new Relatorio(modelo, var, ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                rel.setConfiguracao(rs.getString("rel_xml"));
                gerador.executar(rel);
                this.panelCentro.revalidate();
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0801001500");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0801001501");
    }
}

