/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.estoque.almoxarifado;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioEstoqueManual
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_USUARIO = "filtroUsuario";
    private final String FILTRO_CELULA_ESTOQUE = "filtroCelulaEstoque";
    private final String FILTRO_OPERACAO = "filtroOperacao";
    private final String[] OPERACOES = new String[]{"Todas", Tipos.getTipoOperacaoEstoque("I"), Tipos.getTipoOperacaoEstoque("B"), Tipos.getTipoOperacaoEstoque("A"), Tipos.getTipoOperacaoEstoque("N")};
    private static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoManutencao", "dataHoraManutencao", "observacaoManutencao", "codigoRequisicaoEstoque", "codigoUsuarioManutencao", "descricaoUsuarioManutencao", "codigoMaterial", "descricaoMaterial", "valorUnitarioMaterial", "codigoCelulaEstoque", "descricaoCelulaEstoque", "tipoOperacaoManutencao", "quantidadeOperacaoManutencao", "codigoUnidadeMedida", "descricaoUnidadeMedida"});

    public RelatorioEstoqueManual() {
        this.montaBarraDescricao("Relat\u00f3rio de Manuten\u00e7\u00e3o de estoque", "Manuten\u00e7\u00e3o de estoque por per\u00edodo", "relatorios/rel_estoque_almoxarifado_manutencao.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroUsuario", "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroCelulaEstoque", "C\u00e9lula Estoque", "celulaestoque", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cel_codigo", "cel_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data Inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data Final:");
        this.adicionaFiltroCombo("filtroOperacao", "Opera\u00e7\u00e3o:", this.OPERACOES, 0);
        this.setModuloConfigurar(RelatorioEstoqueManual.getModuloConfigurar());
        this.setModuloAcesso(RelatorioEstoqueManual.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st2;
        Statement st;
        block30: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            st = Conexao.getStatement();
            st2 = Conexao.getStatement();
            try {
                String[] celulas;
                StringBuilder buf = new StringBuilder();
                buf.append("select ");
                buf.append("a.etm_codigo as codigoManutencao, ");
                buf.append("a.etm_datahora as dataHoraManutencao, ");
                buf.append("a.etm_observacao as observacaoManutencao, ");
                buf.append("a.ree_codigo as codigoRequisicaoEstoque, ");
                buf.append("usr.usr_codigo as codigoUsuarioManutencao, ");
                buf.append("usr.usr_nome as descricaoUsuarioManutencao, ");
                buf.append("b.mat_codigo as codigoMaterial, ");
                buf.append("b.mat_descricao as descricaoMaterial, ");
                buf.append("b.mat_valorunit as valorUnitarioMaterial, ");
                buf.append("d.cel_codigo as codigoCelulaEstoque, ");
                buf.append("d.cel_descricao as descricaoCelulaEstoque, ");
                buf.append("c.emo_tipooperacao as tipoOperacaoManutencao, ");
                buf.append("c.emo_quantidade as quantidadeOperacaoManutencao, ");
                buf.append("e.unm_codigo as codigoUnidadeMedida, ");
                buf.append("e.unm_descricao as descricaoUnidadeMedida, ");
                buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                buf.append("  from estoquemanual a ");
                buf.append("  left join estoquemanualmaterial c on a.fil_codigo = c.fil_codigo and a.etm_codigo = c.etm_codigo ");
                buf.append("  left join material b on c.fil_codigo = b.fil_codigo and c.mat_codigo = b.mat_codigo ");
                buf.append("  left join celulaestoque d on c.fil_codigo = d.fil_codigo and c.cel_codigo = d.cel_codigo ");
                buf.append("  left join unidademedida e on b.fil_codigo = e.fil_codigo and b.unm_codigo = e.unm_codigo ");
                buf.append("  left join usuario usr on a.usr_codigo = usr.usr_codigo ");
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                buf.append(" where a.fil_codigo ");
                String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
                if (filiais == null || filiais.length == 0) {
                    buf.append(" = ").append(Variaveis.filialPadrao);
                } else {
                    buf.append(" in (");
                    for (int i = 0; i < filiais.length; ++i) {
                        buf.append(filiais[i]);
                        if (i >= filiais.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                String[] usuario = this.getSelecionadosFiltro("filtroUsuario", 0);
                if (usuario != null) {
                    buf.append(" and a.usr_codigo in (");
                    for (int i = 0; i < usuario.length; ++i) {
                        buf.append("'");
                        buf.append(usuario[i]);
                        buf.append("'");
                        if (i >= usuario.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if ((celulas = this.getSelecionadosFiltro("filtroCelulaEstoque", 0)) != null) {
                    buf.append(" and c.cel_codigo in (");
                    for (int i = 0; i < celulas.length; ++i) {
                        buf.append(celulas[i]);
                        if (i >= celulas.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                    buf.append(" and cast(a.etm_datahora as date) >= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial")));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                    buf.append(" and cast(a.etm_datahora as date) <= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal")));
                    buf.append("'");
                }
                if (this.getFiltroCombo("filtroOperacao").equals(this.OPERACOES[1])) {
                    buf.append(" and c.emo_tipooperacao = '").append("I").append("' ");
                }
                if (this.getFiltroCombo("filtroOperacao").equals(this.OPERACOES[2])) {
                    buf.append(" and c.emo_tipooperacao = '").append("B").append("' ");
                } else if (this.getFiltroCombo("filtroOperacao").equals(this.OPERACOES[3])) {
                    buf.append(" and c.emo_tipooperacao = '").append("A").append("' ");
                } else if (this.getFiltroCombo("filtroOperacao").equals(this.OPERACOES[4])) {
                    buf.append(" and c.emo_tipooperacao = '").append("N").append("' ");
                }
                buf.append(" order by a.fil_codigo, a.etm_codigo, b.mat_descricao ");
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    ModeloGridTable modelo = new ModeloGridTable(campos);
                    do {
                        Object[] o = new Object[campos.length];
                        for (int i = 0; i < campos.length; ++i) {
                            if (campos[i].equals("tipoOperacaoManutencao")) {
                                if (rs.getString("tipoOperacaoManutencao") == null) continue;
                                o[modelo.findColumn((String)RelatorioEstoqueManual.campos[i])] = Tipos.getTipoOperacaoEstoque(rs.getString("tipoOperacaoManutencao"));
                                continue;
                            }
                            o[modelo.findColumn((String)RelatorioEstoqueManual.campos[i])] = rs.getObject(campos[i]);
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioEstoqueManual.getModuloAcesso());
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        int i;
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(1.0f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioEstoqueManual.this.panelCentro.removeAll();
                                RelatorioEstoqueManual.this.panelCentro.repaint();
                                RelatorioEstoqueManual.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put("filtroOperacao", this.getFiltroCombo("filtroOperacao"));
                        var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                        var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                        buf.delete(0, buf.length());
                        if (filiais != null) {
                            for (i = 0; i < filiais.length; ++i) {
                                buf.append(filiais[i]);
                                if (i >= filiais.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroFilial", buf.toString());
                        buf.delete(0, buf.length());
                        if (usuario != null) {
                            for (i = 0; i < usuario.length; ++i) {
                                buf.append(usuario[i]);
                                if (i >= usuario.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroUsuario", buf.toString());
                        buf.delete(0, buf.length());
                        if (celulas != null) {
                            for (i = 0; i < celulas.length; ++i) {
                                buf.append(celulas[i]);
                                if (i >= celulas.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroCelulaEstoque", buf.toString());
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block30;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
        }
        Conexao.fecharStatement(st, st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0801001601");
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0801001600");
    }
}

