/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.estoque.almoxarifado;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.relatorio.gerador.Relatorio;
import jalis.util.ArraysUtil;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RelatorioEstoque
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String FILTRO_FILIAL = "filtroFilial";
    private static final String FILTRO_CELULA = "filtroCelula";
    private static final String FILTRO_MATERIAL = "filtroMaterial";
    private static final String FILTRO_TIPO_MATERIAL = "filtroTipoMaterial";
    private static final String FILTRO_ORDENACAO = "filtroOrdenacao";
    private static final String FILTRO_SOMENTE_ESTOQUE = "filtroSomenteEstoque";
    private static final String FILTRO_AGRUPAR_POR_CELULA = "filtroAgruparPorCelula";
    private static final String FILTRO_ABAIXO_REPOSICAO = "filtroAbaixoReposicao";
    private static final String FILTRO_MATERIAL_INATIVO = "filtroMaterialInativo";
    private static final String FILTRO_AVISO_REPOSICAO = "apenasPontoReposicao";
    private static final String FILTRO_PONTO_REPOSICAO = "filtroPontoReposicao";
    private static final String[] camposOrdenacao = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "C\u00f3d. Tipo", "Desc. Tipo", "Qtde cresc.", "Qtde desc."};
    private static final String[] camposOrdenacaoBanco = new String[]{"a.mat_codigo", "a.mat_descricao", "tpm.tpm_codigo", "tpm.tpm_descricao", "saldoestoque", "saldoestoque desc"};
    private static final String[] camposEstoque = new String[]{"saldoEstoque", "dataSaldoEstoque", "saldoEstoqueNaoConciliado"};
    private static final String[] camposCelulaEstoque = new String[]{"codigoCelulaEstoque", "descricaoCelulaEstoque", "inativaCelulaEstoque", "padraoCelulaEstoque"};
    private static final String[] camposMaterial = new String[]{"codigoMaterial", "descricaoMaterial", "valorUnitarioMaterial", "valorUltimaCompraMaterial", "dataUltimaCompraMaterial", "quantidadeUltimaCompraMaterial", "pontoReposicaoMaterial", "dataUltimaEntregaMaterial", "marcaMaterial", "modeloMaterial", "reposicaoAutomaticaMaterial", "codigoUsuarioMaterial", "imobilizadoMaterial", "solicitarPatrimonioMaterial", "fichaTecnicaMaterial", "materialInativo"};
    private static final String[] camposUnidadeMedida = new String[]{"codigoUnidadeMedida", "descricaoUnidadeMedida"};
    private static final String[] camposTipoMaterial = new String[]{"codigoTipoMaterial", "descricaoTipoMaterial"};
    private static final String[] camposFornecedor = new String[]{"fornecedorNotaFiscal"};
    private String[] camposRelatorio = null;

    public RelatorioEstoque() {
        this.montaBarraDescricao("Relat\u00f3rio de estoque", "Listagem do saldo de estoque atual dos materiais", "relatorios/rel_estoque_almoxarifado_rel_estoque.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        final CheckItemFiltro itemCelula = this.adicionaRetornaItemFiltro(FILTRO_CELULA, "C\u00e9lula Estoque", "celulaestoque", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cel_codigo", "cel_descricao", "cel_inativa", "cel_padrao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Inativa?", "Padr\u00e3o?"}, new int[]{60, 0, 60, 60});
        this.adicionaItemFiltro(FILTRO_MATERIAL, "Material", "material", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"mat_codigo", "mat_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_TIPO_MATERIAL, "Tipo Material", "tipomaterial", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"tpm_codigo", "tpm_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroCombo(FILTRO_ORDENACAO, "Ordem", camposOrdenacao, 0);
        this.adicionaFiltroCheck(FILTRO_SOMENTE_ESTOQUE, "Somente em estoque", false);
        final JCheckBox checkPontoReposicao = this.adicionaRetornaFiltroCheck(FILTRO_PONTO_REPOSICAO, "Atingiu ponto de reposi\u00e7\u00e3o", false);
        final JCheckBox checkAgrupar = this.adicionaRetornaFiltroCheck(FILTRO_AGRUPAR_POR_CELULA, "Agrupar por C\u00e9lula", false);
        this.adicionaFiltroCheck(FILTRO_MATERIAL_INATIVO, "Mostrar material inativo", false);
        this.adicionaFiltroCheck(FILTRO_AVISO_REPOSICAO, "<html>Apresentar apenas <br>com aviso de reposi\u00e7\u00e3o</html>", false);
        final JCheckBox checkAbaixoReposicao = this.adicionaRetornaFiltroCheck(FILTRO_ABAIXO_REPOSICAO, "Abaixo do ponto de reposi\u00e7\u00e3o", false);
        checkAgrupar.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                itemCelula.setEnabled(checkAgrupar.isSelected());
            }
        });
        checkAbaixoReposicao.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (checkAbaixoReposicao.isSelected()) {
                    checkPontoReposicao.setSelected(false);
                }
            }
        });
        checkPontoReposicao.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (checkPontoReposicao.isSelected()) {
                    checkAbaixoReposicao.setSelected(false);
                }
            }
        });
        itemCelula.setEnabled(false);
        this.setModuloConfigurar(RelatorioEstoque.getModuloConfigurar());
        this.setModuloAcesso(RelatorioEstoque.getModuloAcesso());
        this.camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, camposEstoque);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposCelulaEstoque);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposMaterial);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposUnidadeMedida);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposTipoMaterial);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposFornecedor);
        this.setCamposConfigurador(this.camposRelatorio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st2;
        Statement st;
        block46: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            st = Conexao.getStatement();
            st2 = Conexao.getStatement();
            try {
                String[] tipoMaterial;
                String[] material;
                StringBuilder buf = new StringBuilder();
                if (this.getFiltroCheck(FILTRO_AGRUPAR_POR_CELULA)) {
                    buf.append(" select distinct COALESCE(ces.ces_saldo, 0) as saldoEstoque, ");
                    buf.append("        ces.ces_data as dataSaldoEstoque, ");
                    buf.append("        cel.cel_codigo as codigoCelulaEstoque, ");
                    buf.append("        cel.cel_descricao as descricaoCelulaEstoque, ");
                    buf.append("        cel.cel_inativa as inativaCelulaEstoque, ");
                    buf.append("        cel.cel_padrao as padraoCelulaEstoque, ");
                } else {
                    buf.append(" select COALESCE(sde.sde_saldo, 0) as saldoEstoque, ");
                    buf.append("        sde.sde_data as dataSaldoEstoque, ");
                }
                buf.append("        a.fil_codigo, ");
                buf.append("        a.mat_codigo as codigoMaterial, ");
                buf.append("        a.mat_descricao as descricaoMaterial, ");
                buf.append("        a.mat_valorunit as valorUnitarioMaterial, ");
                buf.append("        a.mat_valorultcompra as valorUltimaCompraMaterial, ");
                buf.append("        a.mat_dataultcompra as dataUltimaCompraMaterial, ");
                buf.append("        a.mat_qtdeultcompra as quantidadeUltimaCompraMaterial, ");
                buf.append("        a.mat_ptoreposicao as pontoReposicaoMaterial, ");
                buf.append("        a.mat_dataultentrega as dataUltimaEntregaMaterial, ");
                buf.append("        a.mat_marca as marcaMaterial, ");
                buf.append("        a.mat_modelo as modeloMaterial, ");
                buf.append("        a.mat_reposicaoautomatica as reposicaoAutomaticaMaterial, ");
                buf.append("\t\t\t\ta.usr_codigo as codigoUsuarioMaterial, ");
                buf.append("\t\t\t\ta.mat_imobilizado as imobilizadoMaterial, ");
                buf.append("\t\t\t\ta.mat_solicitarpatrimonio as solicitarPatrimonioMaterial, ");
                buf.append("\t\t\t\ta.mat_fichatecnica as fichaTecnicaMaterial, ");
                buf.append("\t\t\t\ta.mat_inativo  as materialInativo, ");
                buf.append("\t\t\t\tunm.unm_codigo as codigoUnidadeMedida, ");
                buf.append("\t\t\t\tunm.unm_descricao as descricaoUnidadeMedida, ");
                buf.append("\t\t\t\ttpm.tpm_codigo as codigoTipoMaterial, ");
                buf.append("\t\t\t\ttpm.tpm_descricao as descricaoTipoMaterial, ");
                buf.append("\t\t\t\tentidade.ent_razaosocial as fornecedorNotaFiscal");
                buf.append(", ");
                buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                buf.append("  from material a ");
                if (this.getFiltroCheck(FILTRO_AGRUPAR_POR_CELULA)) {
                    buf.append("  cross join celulaestoque cel ");
                    buf.append("  left join saldoestoquecelula ces on (a.fil_codigo = ces.fil_codigo and cel.cel_codigo = ces.cel_codigo and a.mat_codigo = ces.mat_codigo) ");
                } else {
                    buf.append("  left join saldoestoque sde on (a.fil_codigo = sde.fil_codigo and a.mat_codigo = sde.mat_codigo)");
                }
                buf.append("  left join unidademedida unm on (a.fil_codigo = unm.fil_codigo and a.unm_codigo = unm.unm_codigo)");
                buf.append("  join tipomaterial tpm on (tpm.fil_codigo = a.fil_codigo and tpm.tpm_codigo = a.tpm_codigo)");
                buf.append("  left join (select max(nf.nfi_codigo) as nfi_codigo, nfMaterial.mat_codigo, nf.fil_codigo from notafiscal nf");
                buf.append("\tleft join notafiscalMaterial nfMaterial on (nf.fil_codigo = nfMaterial.fil_codigo and nf.nfi_codigo = nfMaterial.nfi_codigo)");
                buf.append("\twhere nf.nfi_tipo = 'E'");
                buf.append("  and nf.nfi_situacao not in ('E', 'C') group by nfMaterial.mat_codigo, nf.fil_codigo order by nfMaterial.mat_codigo) ");
                buf.append("  as nota on (a.fil_codigo = nota.fil_codigo and a.mat_codigo = nota.mat_codigo)");
                buf.append("  left join notafiscal nf2 on (nota.fil_codigo = nf2.fil_codigo and nota.nfi_codigo = nf2.nfi_codigo)");
                buf.append("\tleft join entidade entidade on (nf2.ent_codigo = entidade.ent_codigo and nf2.fil_codigo = entidade.fil_codigo)");
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                buf.append(" where a.fil_codigo ");
                String[] filiais = this.getSelecionadosFiltro(FILTRO_FILIAL, 0);
                StringBuilder bufFilial = new StringBuilder();
                if (filiais == null || filiais.length == 0) {
                    bufFilial.append(" = ").append(Variaveis.filialPadrao);
                } else {
                    bufFilial.append(" in (");
                    for (int i = 0; i < filiais.length; ++i) {
                        bufFilial.append(filiais[i]);
                        if (i >= filiais.length - 1) continue;
                        bufFilial.append(", ");
                    }
                    bufFilial.append(")");
                }
                buf.append(bufFilial.toString());
                String[] celula = this.getSelecionadosFiltro(FILTRO_CELULA, 0);
                if (this.getFiltroCheck(FILTRO_AGRUPAR_POR_CELULA)) {
                    buf.append(" and cel.fil_codigo ").append(bufFilial.toString());
                    if (celula != null) {
                        buf.append(" and cel.cel_codigo in (");
                        for (int i = 0; i < celula.length; ++i) {
                            buf.append("'");
                            buf.append(celula[i]);
                            buf.append("'");
                            if (i >= celula.length - 1) continue;
                            buf.append(", ");
                        }
                        buf.append(")");
                    }
                } else {
                    celula = null;
                }
                if ((material = this.getSelecionadosFiltro(FILTRO_MATERIAL, 0)) != null) {
                    buf.append(" and a.mat_codigo in (");
                    for (int i = 0; i < material.length; ++i) {
                        buf.append("'");
                        buf.append(material[i]);
                        buf.append("'");
                        if (i >= material.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if ((tipoMaterial = this.getSelecionadosFiltro(FILTRO_TIPO_MATERIAL, 0)) != null) {
                    buf.append(" and tpm.tpm_codigo in (");
                    for (int i = 0; i < tipoMaterial.length; ++i) {
                        buf.append("'");
                        buf.append(tipoMaterial[i]);
                        buf.append("'");
                        if (i >= tipoMaterial.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if (this.getFiltroCheck(FILTRO_SOMENTE_ESTOQUE)) {
                    if (this.getFiltroCheck(FILTRO_AGRUPAR_POR_CELULA)) {
                        buf.append(" and ces.ces_saldo > 0 ");
                    } else {
                        buf.append(" and sde.sde_saldo > 0 ");
                    }
                }
                if (this.getFiltroCheck(FILTRO_ABAIXO_REPOSICAO)) {
                    if (this.getFiltroCheck(FILTRO_AGRUPAR_POR_CELULA)) {
                        buf.append(" and COALESCE(ces.ces_saldo, 0) < COALESCE(a.mat_ptoreposicao, 0) ");
                    } else {
                        buf.append(" and COALESCE(sde.sde_saldo, 0) < COALESCE(a.mat_ptoreposicao, 0) ");
                    }
                }
                if (this.getFiltroCheck(FILTRO_PONTO_REPOSICAO)) {
                    if (this.getFiltroCheck(FILTRO_AGRUPAR_POR_CELULA)) {
                        buf.append(" and COALESCE(ces.ces_saldo, 0) = COALESCE(a.mat_ptoreposicao, 0) ");
                    } else {
                        buf.append(" and COALESCE(sde.sde_saldo, 0) = COALESCE(a.mat_ptoreposicao, 0) ");
                    }
                }
                if (this.getFiltroCheck(FILTRO_AGRUPAR_POR_CELULA)) {
                    buf.append(" and (ces.ces_data = (select MAX(ces_data) ");
                    buf.append("                        from saldoestoquecelula ");
                    buf.append("                       where fil_codigo = a.fil_codigo ");
                    buf.append("                         and cel_codigo = ces.cel_codigo ");
                    buf.append("                         and mat_codigo = a.mat_codigo) ");
                    buf.append("      or ces.ces_data IS NULL) ");
                } else {
                    buf.append(" and (sde.sde_data = (select MAX(sde_data) ");
                    buf.append("                        from saldoestoque ");
                    buf.append("                       where fil_codigo = a.fil_codigo ");
                    buf.append("                         and mat_codigo = a.mat_codigo) ");
                    buf.append("      or sde.sde_data IS NULL) ");
                }
                if (!this.getFiltroCheck(FILTRO_MATERIAL_INATIVO)) {
                    buf.append(" and a.mat_inativo = false ");
                }
                if (this.getFiltroCheck(FILTRO_AVISO_REPOSICAO)) {
                    buf.append(" and a.mat_reposicaoautomatica = true ");
                }
                buf.append(" order by a.fil_codigo, ");
                if (this.getFiltroCheck(FILTRO_AGRUPAR_POR_CELULA)) {
                    buf.append(" cel.cel_codigo, ");
                }
                buf.append(camposOrdenacaoBanco[this.getFiltroComboIndice(FILTRO_ORDENACAO)]);
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i;
                    ModeloGridTable modelo = new ModeloGridTable(this.camposRelatorio);
                    do {
                        BigDecimal saldoNaoConciliado = BigDecimal.ZERO;
                        saldoNaoConciliado = this.getSaldoFinalNaoConciliado(bufFilial.toString(), rs.getInt("codigoMaterial"), this.getFiltroCheck(FILTRO_AGRUPAR_POR_CELULA) ? Integer.valueOf(rs.getInt("codigoCelulaEstoque")) : null);
                        Object[] o = new Object[this.camposRelatorio.length];
                        for (i = 0; i < this.camposRelatorio.length; ++i) {
                            if (!this.getFiltroCheck(FILTRO_AGRUPAR_POR_CELULA) && ArraysUtil.contem(camposCelulaEstoque, this.camposRelatorio[i])) continue;
                            o[modelo.findColumn((String)this.camposRelatorio[i])] = this.camposRelatorio[i].equalsIgnoreCase("inativaCelulaEstoque") || this.camposRelatorio[i].equalsIgnoreCase("padraoCelulaEstoque") ? (rs.getBoolean(this.camposRelatorio[i]) ? "Sim" : "N\u00e3o") : (this.camposRelatorio[i].equalsIgnoreCase("saldoEstoqueNaoConciliado") ? (saldoNaoConciliado == null ? BigDecimal.ZERO : saldoNaoConciliado) : (this.camposRelatorio[i].equalsIgnoreCase("materialInativo") ? (rs.getBoolean(this.camposRelatorio[i]) ? "Sim" : "N\u00e3o") : rs.getObject(this.camposRelatorio[i])));
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioEstoque.getModuloAcesso());
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(1.0f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioEstoque.this.panelCentro.removeAll();
                                RelatorioEstoque.this.panelCentro.repaint();
                                RelatorioEstoque.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put(FILTRO_AGRUPAR_POR_CELULA, this.getFiltroCheck(FILTRO_AGRUPAR_POR_CELULA) ? "Sim" : "N\u00e3o");
                        var.put(FILTRO_SOMENTE_ESTOQUE, this.getFiltroCheck(FILTRO_SOMENTE_ESTOQUE) ? "Sim" : "N\u00e3o");
                        var.put(FILTRO_ABAIXO_REPOSICAO, this.getFiltroCheck(FILTRO_ABAIXO_REPOSICAO) ? "Sim" : "N\u00e3o");
                        var.put(FILTRO_MATERIAL_INATIVO, this.getFiltroCheck(FILTRO_MATERIAL_INATIVO) ? "Sim" : "N\u00e3o");
                        var.put(FILTRO_ORDENACAO, this.getFiltroCombo(FILTRO_ORDENACAO));
                        var.put(FILTRO_AVISO_REPOSICAO, this.getFiltroCheck(FILTRO_AVISO_REPOSICAO) ? "Sim" : "N\u00e3o");
                        buf.delete(0, buf.length());
                        if (filiais != null) {
                            for (i = 0; i < filiais.length; ++i) {
                                buf.append(filiais[i]);
                                if (i >= filiais.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_FILIAL, buf.toString());
                        buf.delete(0, buf.length());
                        if (celula != null) {
                            for (i = 0; i < celula.length; ++i) {
                                buf.append(celula[i]);
                                if (i >= celula.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_CELULA, buf.toString());
                        buf.delete(0, buf.length());
                        if (material != null) {
                            for (i = 0; i < material.length; ++i) {
                                buf.append(material[i]);
                                if (i >= material.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_MATERIAL, buf.toString());
                        buf.delete(0, buf.length());
                        if (tipoMaterial != null) {
                            for (i = 0; i < tipoMaterial.length; ++i) {
                                buf.append(tipoMaterial[i]);
                                if (i >= tipoMaterial.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_TIPO_MATERIAL, buf.toString());
                        Relatorio rel = new Relatorio(modelo, var, ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        rel.setConfiguracao(rs.getString("rel_xml"));
                        if (!this.getFiltroCheck(FILTRO_AGRUPAR_POR_CELULA)) {
                            rel.removerBandaCabecalhoGrupo("bandaCelula");
                        }
                        gerador.executar(rel);
                        this.panelCentro.revalidate();
                    }
                    break block46;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
        }
        Conexao.fecharStatement(st, st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0801000200");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0801000201");
    }

    private BigDecimal getSaldoFinalNaoConciliado(String filiais, Integer material, Integer celula) throws SQLException {
        ResultSet rs;
        StringBuilder buf = new StringBuilder();
        buf.append(" select SUM(COALESCE(lce_quantidade, 0)) as saldoAnteriorNaoConciliado ");
        buf.append("   from lanctoestoque lce ");
        buf.append("  where lce.fil_codigo ").append(filiais);
        buf.append("    and lce.lce_tipo = '").append("E").append("' ");
        buf.append("    and (lce.lce_conciliacao IS NULL OR cast(lce.lce_conciliacao as date) > '").append(Funcoes.formataData("yyyy-MM-dd", new Date())).append("') ");
        buf.append("    and cast(lce.lce_datahora as date) <= '").append(Funcoes.formataData("yyyy-MM-dd", new Date())).append("' ");
        if (celula != null) {
            buf.append("    and lce.cel_codigo = ").append(celula);
        }
        if (material != null) {
            buf.append(" and lce.mat_codigo = ").append(material);
        }
        if ((rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString())).next()) {
            return rs.getBigDecimal("saldoAnteriorNaoConciliado") == null ? BigDecimal.ZERO : rs.getBigDecimal("saldoAnteriorNaoConciliado");
        }
        return BigDecimal.ZERO;
    }
}

