/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.estoque.almoxarifado;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.estoque.almoxarifado.aberturalotesmaterial.AberturaLotesMaterial;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.service.estoque.MaterialLoteService;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.table.TableModel;

public class RelatorioAberturaLotesMaterial
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String FILTRO_MATERIAL = "filtromaterial";
    private static final String FILTRO_TIPO_MATERIAL = "filtrotipo";
    private static final String FILTRO_ORDENACAO = "filtroOrdenacao";
    private static final String FILTRO_ORDENACAO_LOTE = "filtroOrdenacaoLote";
    private static final String FILTRO_CAMPO_DATA = "filtroCampoData";
    private static final String FILTRO_VALIDADE_INICIAL = "filtroValidadeInicial";
    private static final String FILTRO_VALIDADE_FINAL = "filtroValidadeFim";
    private static final String FILTRO_MATERIAL_INATIVO = "filtroinativo";
    private static final String FILTRO_MATERIAL_SEM_LOTE = "filtroLoteZerado";
    private static final String FILTRO_LOTE_CONSUMIDO = "filtroLoteConsumido";
    private static final String[] camposOrdenacao = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"};
    private static final String[] camposOrdenacaoBanco = new String[]{"a.mat_codigo", "a.mat_descricao"};
    private static final String[] camposOrdenacaoLote = new String[]{"Data cresc.", "Data decresc."};
    private static final String[] camposOrdenacaoCampoData = new String[]{"Validade", "Lote"};
    private static final String[] camposMaterial = new String[]{"materialInativo", "codigomaterial", "descricaoMaterial", "valorUnitarioMaterial", "valorUltimaCompraMaterial", "dataUltimaCompraMaterial", "quantidadeUltimaCompraMaterial", "pontoReposicaoMaterial", "dataUltimaEntregaMaterial", "marcaMaterial", "modeloMaterial", "reposicaoAutomaticaMaterial", "codigoUsuarioCadastroMaterial", "imobilizadoMaterial", "solicitarPatrimonioMaterial", "fichaTecnicaMaterial", "criarLoteKitMaterial", "usuarioAberturaLote", "dataAberturaLote", "usuarioFechamentoLote", "dataFechamentoLote", "materialLote", "quantDiasAbertoLoteEntreDatas", "quantidadeTotalDiasAbertoLote"};
    private static final String[] camposUnidadeMedida = new String[]{"codigoUnidadeMedida", "descricaoUnidadeMedida"};
    private static final String[] camposTipoMaterial = new String[]{"codigoTipoMaterial", "descricaoTipoMaterial"};
    private static final String[] camposMaterialLote = new String[]{"codigoLote", "dataLote", "validadeLote", "quantidadeLote", "quantidadeConsumidaLote", "codigoUsuarioCadastroLote", "dataCadastroLote", "observacaoLote", "quantidadeRestanteLote"};
    private static final String[] camposEstoqueManual = new String[]{"dataHoraEstoqueManual", "observacaoEstoqueManual", "codigoUsuarioEstoqueManual"};
    private static final String[] camposConferenciaEntrada = new String[]{"dataHoraConferenciaEntrada", "codigoUsuarioConferenciaEntrada", "observacaoConferenciaEntrada"};
    private static final String[] camposConferenciaEstoque = new String[]{"dataHoraConferenciaEstoque", "observacaoConferenciaEstoque", "codigoUsuarioConferenciaEstoque"};
    private static final String[] camposNotaFiscal = new String[]{"codigoNotaFiscal", "serieNotaFiscal", "numeroNotaFiscal", "tipoCadastroNotaFiscal", "codigoUsuarioNotaFiscal", "dataHoraNotaFiscal", "dataEmissaoNotaFiscal", "situacaoNotaFiscal", "observacaoNotaFiscal", "valorBrutoNotaFiscal", "valorLiquidoNotaFiscal"};
    private static final String[] camposPedidoCompra = new String[]{"codigoPedidoCompra", "dataHoraPedidoCompra", "observacaoPedidoCompra", "valorTotalPedidoCompra", "codigoUsuarioPedidoCompra"};
    private static final String[] camposSaldoEstoque = new String[]{"saldoAtualEstoque"};
    private String[] camposRelatorio = null;

    public RelatorioAberturaLotesMaterial() {
        this.montaBarraDescricao("Relat\u00f3rio de abertura de lotes de material", "Hist\u00f3rico de abertura e fechamento dos lotes de materiais", "relatorios/rel_estoque_almoxarifado_abertura.jpg");
        this.adicionaItemFiltro(FILTRO_MATERIAL, "Material", "material", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"mat_codigo", "mat_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_TIPO_MATERIAL, "Tipo Material", "tipomaterial", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"tpm_codigo", "tpm_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroCombo(FILTRO_CAMPO_DATA, "Campo Data:", camposOrdenacaoCampoData, 0);
        this.adicionaFiltroData(FILTRO_VALIDADE_INICIAL, "Data Inicial:");
        this.adicionaFiltroData(FILTRO_VALIDADE_FINAL, "Data Final:");
        this.adicionaFiltroCombo(FILTRO_ORDENACAO, "Ordem Mat.:", camposOrdenacao, 0);
        this.adicionaFiltroCombo(FILTRO_ORDENACAO_LOTE, "Ordem Lotes:", camposOrdenacaoLote, 0);
        this.adicionaFiltroCheck(FILTRO_MATERIAL_INATIVO, "Mostrar material inativo", false);
        this.adicionaFiltroCheck(FILTRO_MATERIAL_SEM_LOTE, "Mostrar material sem lote", false);
        this.adicionaFiltroCheck(FILTRO_LOTE_CONSUMIDO, "Mostrar lotes consumidos", false);
        this.adicionaRelatorioListener(this);
        this.setModuloAcesso(RelatorioAberturaLotesMaterial.getModuloAcesso());
        this.setModuloConfigurar(RelatorioAberturaLotesMaterial.getModuloConfigurar());
        this.camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, camposMaterial);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposUnidadeMedida);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposTipoMaterial);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposMaterialLote);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposEstoqueManual);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposConferenciaEntrada);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposConferenciaEstoque);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposNotaFiscal);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposPedidoCompra);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposSaldoEstoque);
        this.setCamposConfigurador(this.camposRelatorio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st;
        block39: {
            String campo;
            boolean isDataValidade;
            int i;
            String dataInicial = this.getFiltroData(FILTRO_VALIDADE_INICIAL);
            String dataFinal = this.getFiltroData(FILTRO_VALIDADE_FINAL);
            if (Funcoes.textoVazio(dataFinal) || Funcoes.textoVazio(dataInicial)) {
                Funcoes.mensagem(this, "Os campos \"Data Inicial\" e \"Data Final\" devem ser informados.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            StringBuilder buf = new StringBuilder();
            buf.append("\tSELECT a.mat_codigo AS codigomaterial ,\t");
            buf.append("\t       a.mat_descricao AS descricaoMaterial ,\t");
            buf.append("\t       a.mat_valorunit AS valorUnitarioMaterial ,\t");
            buf.append("\t       a.mat_valorultcompra AS valorUltimaCompraMaterial ,\t");
            buf.append("\t       a.mat_dataultcompra AS dataUltimaCompraMaterial ,\t");
            buf.append("\t       a.mat_qtdeultcompra AS quantidadeUltimaCompraMaterial ,\t");
            buf.append("\t       a.mat_ptoreposicao AS pontoReposicaoMaterial ,\t");
            buf.append("\t       a.mat_dataultentrega AS dataUltimaEntregaMaterial ,\t");
            buf.append("\t       a.mat_marca AS marcaMaterial ,\t");
            buf.append("\t       a.mat_modelo AS modeloMaterial ,\t");
            buf.append("\t       a.mat_reposicaoautomatica AS reposicaoAutomaticaMaterial ,\t");
            buf.append("\t       a.usr_codigo AS codigoUsuarioCadastroMaterial ,\t");
            buf.append("\t       a.mat_imobilizado AS imobilizadoMaterial ,\t");
            buf.append("\t       a.mat_solicitarpatrimonio AS solicitarPatrimonioMaterial ,\t");
            buf.append("\t       a.mat_fichatecnica AS fichaTecnicaMaterial ,\t");
            buf.append("\t       a.mat_criarlotekit AS criarLoteKitMaterial ,\t");
            buf.append("\t       a.mat_inativo AS materialInativo ,\t");
            buf.append("\t       unm.unm_codigo AS codigoUnidadeMedida ,\t");
            buf.append("\t       unm.unm_descricao AS descricaoUnidadeMedida ,\t");
            buf.append("\t       tpm.tpm_codigo AS codigoTipoMaterial ,\t");
            buf.append("\t       tpm.tpm_descricao AS descricaoTipoMaterial ,\t");
            buf.append("\t       mll.mll_lote AS codigoLote ,\t");
            buf.append("\t       mll.mll_datalote AS dataLote ,\t");
            buf.append("\t       mll.mll_validadelote AS validadeLote ,\t");
            buf.append("\t       mll.mll_quantidade AS quantidadeLote ,\t");
            buf.append("\t       mll.mll_quantidadeconsumida AS quantidadeConsumidaLote ,\t");
            buf.append("\t       mll.mll_quantidade - mll.mll_quantidadeconsumida AS quantidadeRestanteLote ,\t");
            buf.append("\t       mll.usr_codigo AS codigoUsuarioCadastroLote ,\t");
            buf.append("\t       mll.mll_datahora AS dataCadastroLote ,\t");
            buf.append("\t       mll.mll_observacao AS observacaoLote ,\t");
            buf.append("\t       mll.mll_codigo AS materialLote ,\t");
            buf.append("\t       etm.etm_datahora AS dataHoraEstoqueManual ,\t");
            buf.append("\t       etm.etm_observacao AS observacaoEstoqueManual ,\t");
            buf.append("\t       etm.usr_codigo AS codigoUsuarioEstoqueManual ,\t");
            buf.append("\t       cen.cen_datahora AS dataHoraConferenciaEntrada ,\t");
            buf.append("\t       cen.usr_codigo AS codigoUsuarioConferenciaEntrada ,\t");
            buf.append("\t       cen.cen_observacao AS observacaoConferenciaEntrada ,\t");
            buf.append("\t       ces.ces_datahora AS dataHoraConferenciaEstoque ,\t");
            buf.append("\t       ces.ces_observacao AS observacaoConferenciaEstoque ,\t");
            buf.append("\t       ces.usr_codigo AS codigoUsuarioConferenciaEstoque ,\t");
            buf.append("\t       nfi.nfi_codigo AS codigoNotaFiscal ,\t");
            buf.append("\t       nfi.ser_codigo AS serieNotaFiscal ,\t");
            buf.append("\t       nfi.nfi_numero AS numeroNotaFiscal ,\t");
            buf.append("\t       nfi.nfi_tipocadastro AS tipoCadastroNotaFiscal ,\t");
            buf.append("\t       nfi.usr_codigo AS codigoUsuarioNotaFiscal ,\t");
            buf.append("\t       nfi.nfi_datahora AS dataHoraNotaFiscal ,\t");
            buf.append("\t       nfi.nfi_dataemissao AS dataEmissaoNotaFiscal ,\t");
            buf.append("\t       nfi.nfi_situacao AS situacaoNotaFiscal ,\t");
            buf.append("\t       nfi.nfi_observacao AS observacaoNotaFiscal ,\t");
            buf.append("\t       nfi.nfi_subtotal AS valorBrutoNotaFiscal ,\t");
            buf.append("\t       nfi.nfi_valortotal AS valorLiquidoNotaFiscal ,\t");
            buf.append("\t       nfi.nfi_numerorps AS numeroRpsNotaFiscal ,\t");
            buf.append("\t       ped.ped_codigo AS codigoPedidoCompra ,\t");
            buf.append("\t       ped.ped_datahora AS dataHoraPedidoCompra ,\t");
            buf.append("\t       ped.ped_observacao AS observacaoPedidoCompra ,\t");
            buf.append("\t       ped.ped_total AS valorTotalPedidoCompra ,\t");
            buf.append("\t       ped.usr_codigo AS codigoUsuarioPedidoCompra ,\t");
            buf.append("\t       COALESCE(sde.sde_saldo, 0) AS saldoAtualEstoque ,\t");
            buf.append("\t       '' AS usuarioAberturaLote ,\t");
            buf.append("\t       '' AS dataAberturaLote ,\t");
            buf.append("\t       '' AS usuarioFechamentoLote ,\t");
            buf.append("\t       '' AS dataFechamentoLote ,\t");
            buf.append("\t       '' AS quantDiasAbertoLoteEntreDatas ,\t");
            buf.append("\t       '' AS quantidadeTotalDiasAbertoLote ,\t");
            buf.append("\t       ent.ent_codigo AS codigoFornecedor ,\t");
            buf.append("\t       ent.ent_fantasia AS fantasiaFornecedor ,\t");
            buf.append("\t       ent.ent_razaosocial AS razaoSocialFornecedor,\t");
            buf.append("\t       filial.fil_codigo AS codigoFilial,\t");
            buf.append("\t       filial.fil_descricao AS descricaoFilial,\t");
            buf.append("\t       filial.fil_cnpj AS cnpjFilial,\t");
            buf.append("\t       filial.fil_endereco AS enderecoFilial,\t");
            buf.append("\t       filial.fil_complemento AS complementoFilial,\t");
            buf.append("\t       filial.fil_cep AS cepFilial,\t");
            buf.append("\t       filial.fil_fone AS foneFilial,\t");
            buf.append("\t       filial.fil_fax AS faxFilial,\t");
            buf.append("\t       filial.fil_razaosocial AS razaoSocialFilial,\t");
            buf.append("\t       filial.fil_cnes AS CNESFilial,\t");
            buf.append("\t       cidadefilial.cid_codigo AS codigoCidadeFilial,\t");
            buf.append("\t       cidadefilial.cid_nome AS descricaoCidadeFilial,\t");
            buf.append("\t       cidadefilial.cid_uf AS estadoCidadeFilial,\t");
            buf.append("\t       bairrofilial.bai_codigo AS codigoBairroFilial,\t");
            buf.append("\t       bairrofilial.bai_descricao AS descricaoBairroFilial\t");
            buf.append("\tFROM material a\t");
            buf.append("\tLEFT JOIN unidademedida unm ON a.fil_codigo = unm.fil_codigo\t");
            buf.append("\tAND a.unm_codigo = unm.unm_codigo\t");
            buf.append("\tLEFT JOIN tipomaterial tpm ON a.fil_codigo = tpm.fil_codigo\t");
            buf.append("\tAND a.tpm_codigo = tpm.tpm_codigo\t");
            buf.append("\tLEFT JOIN materiallote mll ON a.fil_codigo = mll.fil_codigo\t");
            buf.append("\tAND a.mat_codigo = mll.mat_codigo\t");
            buf.append("\tAND NOT mll.mll_removido\t");
            buf.append("\tLEFT JOIN materiallotelanctoestoque mle ON mll.fil_codigo = mle.fil_codigo\t");
            buf.append("\tAND mll.mll_codigo = mle.mll_codigo\t");
            buf.append("\tAND mle.mll_quantidade > 0\t");
            buf.append("\tLEFT JOIN lanctoestoque lce ON mle.fil_codigo = lce.fil_codigo\t");
            buf.append("\tAND mle.lce_codigo = lce.lce_codigo\t");
            buf.append("\tAND lce.lce_datahoracancelamento IS NULL\t");
            buf.append("\tLEFT JOIN celulaestoque cel ON lce.fil_codigo = cel.fil_codigo\t");
            buf.append("\tAND lce.cel_codigo = cel.cel_codigo\t");
            buf.append("\tLEFT JOIN estoquemanuallanctoestoque aux1 ON lce.fil_codigo = aux1.fil_codigo\t");
            buf.append("\tAND lce.lce_codigo = aux1.lce_codigo\t");
            buf.append("\tLEFT JOIN conferenciaentradalanctoestoque aux2 ON lce.fil_codigo = aux2.fil_codigo\t");
            buf.append("\tAND lce.lce_codigo = aux2.lce_codigo\t");
            buf.append("\tLEFT JOIN conferenciaestoquelanctoestoque aux3 ON lce.fil_codigo = aux3.fil_codigo\t");
            buf.append("\tAND lce.lce_codigo = aux3.lce_codigo\t");
            buf.append("\tLEFT JOIN estoquemanual etm ON aux1.fil_codigo = etm.fil_codigo\t");
            buf.append("\tAND aux1.etm_codigo = etm.etm_codigo\t");
            buf.append("\tLEFT JOIN conferenciaentrada cen ON aux2.fil_codigo = cen.fil_codigo\t");
            buf.append("\tAND aux2.cen_codigo = cen.cen_codigo\t");
            buf.append("\tAND cen.cen_datahoracancelamento IS NULL\t");
            buf.append("\tLEFT JOIN conferenciaestoque ces ON aux3.fil_codigo = ces.fil_codigo\t");
            buf.append("\tAND aux3.ces_codigo = ces.ces_codigo\t");
            buf.append("\tLEFT JOIN pedido ped ON cen.fil_codigo = ped.fil_codigo\t");
            buf.append("\tAND cen.ped_codigo = ped.ped_codigo\t");
            buf.append("\tAND ped.usr_codexclusao IS NULL\t");
            buf.append("\tLEFT JOIN saldoestoque sde ON a.fil_codigo = sde.fil_codigo\t");
            buf.append("\tAND a.mat_codigo = sde.mat_codigo\t");
            buf.append("\tAND sde.sde_data =\t");
            buf.append("\t  (SELECT max(aux.sde_data)\t");
            buf.append("\t   FROM saldoestoque aux\t");
            buf.append("\t   WHERE aux.fil_codigo = sde.fil_codigo\t");
            buf.append("\t     AND aux.mat_codigo = sde.mat_codigo)\t");
            buf.append("\tLEFT JOIN notafiscallanctoestoque nle ON lce.fil_codigo = nle.fil_codigo\t");
            buf.append("\tAND lce.lce_codigo = nle.lce_codigo\t");
            buf.append("\tLEFT JOIN notafiscal nfi ON ((cen.fil_codigo = nfi.fil_codigo\t");
            buf.append("\t                              AND cen.nfi_codigo = nfi.nfi_codigo)\t");
            buf.append("\t                             OR (nle.fil_codigo = nfi.fil_codigo\t");
            buf.append("\t                                 AND nle.nfi_codigo = nfi.nfi_codigo))\t");
            buf.append("\tAND nfi.usr_codcancelada IS NULL\t");
            buf.append("\tLEFT JOIN entidade ent ON ent.fil_codigo = nfi.fil_codigo\t");
            buf.append("\tAND ent.ent_codigo = nfi.ent_codigo\t");
            buf.append("\tLEFT JOIN filiais_postocoleta filial ON a.fil_codigo = filial.fil_codigo\t");
            buf.append("\tLEFT JOIN cidades cidadefilial ON filial.fil_codigo = cidadefilial.fil_codigo\t");
            buf.append("\tAND filial.cid_codigo = cidadefilial.cid_codigo\t");
            buf.append("\tLEFT JOIN bairro bairrofilial ON filial.fil_codigo = bairrofilial.fil_codigo\t");
            buf.append("\tAND filial.bai_codigo = bairrofilial.bai_codigo\t");
            buf.append("\tWHERE a.fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("\t  AND a.mat_solicitarlote\t");
            buf.append("\t  AND mll.mll_lote IS NOT NULL\t");
            if (!this.getFiltroCheck(FILTRO_MATERIAL_SEM_LOTE)) {
                buf.append(" and mll.mll_lote is not null ");
            }
            String[] materiais = this.getSelecionadosFiltro(FILTRO_MATERIAL, 0);
            String[] tiposMateriais = this.getSelecionadosFiltro(FILTRO_TIPO_MATERIAL, 0);
            if (materiais != null) {
                buf.append("  and a.mat_codigo IN (");
                for (i = 0; i < materiais.length; ++i) {
                    buf.append(materiais[i]);
                    if (i >= materiais.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if (tiposMateriais != null) {
                buf.append("  and a.tpm_codigo IN (");
                for (i = 0; i < tiposMateriais.length; ++i) {
                    buf.append(tiposMateriais[i]);
                    if (i >= tiposMateriais.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            boolean bl = isDataValidade = this.getFiltroComboIndice(FILTRO_CAMPO_DATA) == 0;
            if (dataInicial != null && !Funcoes.textoVazio(dataInicial)) {
                campo = "mll.mll_datalote";
                if (isDataValidade) {
                    campo = "mll.mll_validadelote";
                }
                buf.append(" and (").append(campo).append(" >= '").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append("' ");
                if (this.getFiltroCheck(FILTRO_MATERIAL_SEM_LOTE)) {
                    buf.append(" or mll.mll_lote is null ");
                }
                buf.append(") ");
            }
            if (dataFinal != null && !Funcoes.textoVazio(dataFinal)) {
                campo = "mll.mll_datalote";
                if (isDataValidade) {
                    campo = "mll.mll_validadelote";
                }
                buf.append(" and (").append(campo).append(" <= '").append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append("' ");
                if (this.getFiltroCheck(FILTRO_MATERIAL_SEM_LOTE)) {
                    buf.append(" or mll.mll_lote is null ");
                }
                buf.append(") ");
            }
            if (!this.getFiltroCheck(FILTRO_MATERIAL_INATIVO)) {
                buf.append(" and a.mat_inativo = false ");
            }
            if (!this.getFiltroCheck(FILTRO_LOTE_CONSUMIDO)) {
                buf.append(" and (COALESCE(mll.mll_quantidadeconsumida, 0) < COALESCE(mll.mll_quantidade, 0) ");
                if (this.getFiltroCheck(FILTRO_MATERIAL_SEM_LOTE)) {
                    buf.append(" or mll.mll_lote is null ");
                }
                buf.append(") ");
            }
            int ordem = this.getFiltroComboIndice(FILTRO_ORDENACAO);
            buf.append(" order by ").append(camposOrdenacaoBanco[ordem]);
            String ordenacao = "mll.mll_datalote";
            if (isDataValidade) {
                ordenacao = "mll.mll_validadelote";
            }
            buf.append(", ").append(ordenacao);
            int ordemLote = this.getFiltroComboIndice(FILTRO_ORDENACAO_LOTE);
            if (ordemLote == 0) {
                buf.append(" asc ");
            } else {
                buf.append(" desc ");
            }
            buf.append(" , mll.mll_lote, mle.lce_codigo ");
            st = Conexao.getStatement();
            try {
                MaterialLoteService materialLoteService = new MaterialLoteService();
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                ModeloGridTable modelo = new ModeloGridTable(this.camposRelatorio);
                if (rs.next()) {
                    int i2;
                    do {
                        Object[] o = new Object[this.camposRelatorio.length];
                        List<AberturaLotesMaterial> listaAbertura = materialLoteService.dadosLote(rs.getString("codigoFilial"), rs.getString("materialLote"), rs.getString("codigoMaterial"), rs.getString("codigoLote"));
                        for (i2 = 0; i2 < this.camposRelatorio.length; ++i2) {
                            if (this.camposRelatorio[i2].equalsIgnoreCase("usuarioAberturaLote") || this.camposRelatorio[i2].equalsIgnoreCase("dataAberturaLote") || this.camposRelatorio[i2].equalsIgnoreCase("usuarioFechamentoLote") || this.camposRelatorio[i2].equalsIgnoreCase("dataFechamentoLote")) {
                                for (AberturaLotesMaterial aberturaLotesMaterial : listaAbertura) {
                                    if (rs.getObject(this.camposRelatorio[i2]) == null) continue;
                                    if (this.camposRelatorio[i2].equalsIgnoreCase("usuarioAberturaLote")) {
                                        o[modelo.findColumn((String)this.camposRelatorio[i2])] = aberturaLotesMaterial.getUsuarioAbertura();
                                        continue;
                                    }
                                    if (this.camposRelatorio[i2].equalsIgnoreCase("dataAberturaLote")) {
                                        o[modelo.findColumn((String)this.camposRelatorio[i2])] = Funcoes.formataData("dd/MM/yyyy HH:mm:ss", aberturaLotesMaterial.getDataAbertura());
                                        continue;
                                    }
                                    if (this.camposRelatorio[i2].equalsIgnoreCase("usuarioFechamentoLote")) {
                                        o[modelo.findColumn((String)this.camposRelatorio[i2])] = aberturaLotesMaterial.getUsuarioFechamento();
                                        continue;
                                    }
                                    if (!this.camposRelatorio[i2].equalsIgnoreCase("dataFechamentoLote")) continue;
                                    o[modelo.findColumn((String)this.camposRelatorio[i2])] = Funcoes.formataData("dd/MM/yyyy HH:mm:ss", aberturaLotesMaterial.getDataFechamento());
                                }
                                continue;
                            }
                            o[modelo.findColumn((String)this.camposRelatorio[i2])] = rs.getObject(this.camposRelatorio[i2]);
                        }
                        if (modelo.findColumn("quantDiasAbertoLoteEntreDatas") > 0) {
                            String dataAbertura;
                            String dataFechamento = (String)o[modelo.findColumn("dataFechamentoLote")];
                            if (!Funcoes.textoVazio(dataFechamento)) {
                                dataFechamento = Funcoes.formataData("dd/MM/yyyy", dataFechamento);
                            }
                            if (!Funcoes.textoVazio((String)o[modelo.findColumn("dataAberturaLote")]) && !Funcoes.textoVazio(dataAbertura = Funcoes.formataData("dd/MM/yyyy", (String)o[modelo.findColumn("dataAberturaLote")]))) {
                                if (Funcoes.textoVazio(dataFechamento)) {
                                    dataFechamento = Funcoes.formataData("dd/MM/yyyy", new Date());
                                }
                                Integer dias = Funcoes.diasPorPeriodo(dataAbertura, dataFechamento);
                                o[modelo.findColumn((String)"quantDiasAbertoLoteEntreDatas")] = dias;
                            }
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioAberturaLotesMaterial.getModuloAcesso());
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioAberturaLotesMaterial.this.panelCentro.removeAll();
                                RelatorioAberturaLotesMaterial.this.panelCentro.repaint();
                                RelatorioAberturaLotesMaterial.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put(FILTRO_ORDENACAO, this.getFiltroCombo(FILTRO_ORDENACAO));
                        var.put(FILTRO_ORDENACAO_LOTE, this.getFiltroCombo(FILTRO_ORDENACAO_LOTE));
                        var.put(FILTRO_CAMPO_DATA, this.getFiltroCombo(FILTRO_CAMPO_DATA));
                        var.put(FILTRO_MATERIAL_INATIVO, this.getFiltroCheck(FILTRO_MATERIAL_INATIVO) ? "Sim" : "N\u00e3o");
                        var.put(FILTRO_MATERIAL_SEM_LOTE, this.getFiltroCheck(FILTRO_MATERIAL_SEM_LOTE) ? "Sim" : "N\u00e3o");
                        var.put(FILTRO_LOTE_CONSUMIDO, this.getFiltroCheck(FILTRO_LOTE_CONSUMIDO) ? "Sim" : "N\u00e3o");
                        var.put(FILTRO_VALIDADE_FINAL, this.getFiltroData(FILTRO_VALIDADE_FINAL));
                        var.put(FILTRO_VALIDADE_INICIAL, this.getFiltroData(FILTRO_VALIDADE_INICIAL));
                        buf.delete(0, buf.length());
                        if (materiais != null) {
                            for (i2 = 0; i2 < materiais.length; ++i2) {
                                buf.append(materiais[i2]);
                                if (i2 >= materiais.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_MATERIAL, buf.toString());
                        buf.delete(0, buf.length());
                        if (tiposMateriais != null) {
                            for (i2 = 0; i2 < tiposMateriais.length; ++i2) {
                                buf.append(tiposMateriais[i2]);
                                if (i2 >= tiposMateriais.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_TIPO_MATERIAL, buf.toString());
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block39;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0801001700");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0801001701");
    }
}

