/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.estoque;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.service.estoque.MaterialLoteService;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;

public class RelatorioLotesMaterialDetalhado
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String FILTRO_MATERIAL = "filtroMaterial";
    private static final String FILTRO_TIPO_MATERIAL = "filtroTipoMaterial";
    private static final String FILTRO_ORDENACAO = "filtroOrdenacao";
    private static final String FILTRO_ORDENACAO_LOTE = "filtroOrdenacaoLote";
    private static final String FILTRO_CAMPO_DATA = "filtroCampoData";
    private static final String FILTRO_VALIDADE_INICIAL = "filtroValidadeInicial";
    private static final String FILTRO_VALIDADE_FINAL = "filtroValidadeFinal";
    private static final String FILTRO_MATERIAL_INATIVO = "filtroMaterialInativo";
    private static final String FILTRO_MATERIAL_SEM_LOTE = "filtroLoteZerado";
    private static final String FILTRO_LOTE_CONSUMIDO = "filtroLoteConsumido";
    private static final String[] camposOrdenacao = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"};
    private static final String[] camposOrdenacaoBanco = new String[]{"a.mat_codigo", "a.mat_descricao"};
    private static final String[] camposOrdenacaoLote = new String[]{"Data cresc.", "Data decresc."};
    private static final String[] camposOrdenacaoCampoData = new String[]{"Validade", "Lote"};
    private static final String[] camposMaterial = new String[]{"materialInativo", "codigoMaterial", "descricaoMaterial", "valorUnitarioMaterial", "valorUltimaCompraMaterial", "dataUltimaCompraMaterial", "quantidadeUltimaCompraMaterial", "pontoReposicaoMaterial", "dataUltimaEntregaMaterial", "marcaMaterial", "modeloMaterial", "reposicaoAutomaticaMaterial", "codigoUsuarioCadastroMaterial", "imobilizadoMaterial", "solicitarPatrimonioMaterial", "fichaTecnicaMaterial", "criarLoteKitMaterial", "usuarioAberturaLote", "dataAberturaLote", "usuarioFechamentoLote", "dataFechamentoLote", "materialLote"};
    private static final String[] camposUnidadeMedida = new String[]{"codigoUnidadeMedida", "descricaoUnidadeMedida"};
    private static final String[] camposTipoMaterial = new String[]{"codigoTipoMaterial", "descricaoTipoMaterial"};
    private static final String[] camposMaterialLote = new String[]{"codigoLote", "dataLote", "validadeLote", "quantidadeLote", "quantidadeConsumidaLote", "codigoUsuarioCadastroLote", "dataCadastroLote", "observacaoLote", "quantidadeRestanteLote"};
    private static final String[] camposLanctoEstoque = new String[]{"dataHoraLanctoEstoque", "tipoLanctoEstoque", "tipoOrigemLanctoEstoque", "quantidadeLanctoEstoque", "codigoUsuarioLanctoEstoque", "codigoUsuarioConciliacaoLanctoEstoque", "situacaoLanctoEstoque", "dataHoraConciliacaoLanctoEstoque"};
    private static final String[] camposEstoqueManual = new String[]{"dataHoraEstoqueManual", "observacaoEstoqueManual", "codigoUsuarioEstoqueManual"};
    private static final String[] camposConferenciaEntrada = new String[]{"dataHoraConferenciaEntrada", "codigoUsuarioConferenciaEntrada", "observacaoConferenciaEntrada"};
    private static final String[] camposConferenciaEstoque = new String[]{"dataHoraConferenciaEstoque", "observacaoConferenciaEstoque", "codigoUsuarioConferenciaEstoque"};
    private static final String[] camposNotaFiscal = new String[]{"codigoNotaFiscal", "serieNotaFiscal", "numeroNotaFiscal", "tipoCadastroNotaFiscal", "codigoUsuarioNotaFiscal", "dataHoraNotaFiscal", "dataEmissaoNotaFiscal", "situacaoNotaFiscal", "observacaoNotaFiscal", "valorBrutoNotaFiscal", "valorLiquidoNotaFiscal"};
    private static final String[] camposPedidoCompra = new String[]{"codigoPedidoCompra", "dataHoraPedidoCompra", "observacaoPedidoCompra", "valorTotalPedidoCompra", "codigoUsuarioPedidoCompra"};
    private static final String[] camposSaldoEstoque = new String[]{"saldoAtualEstoque"};
    private static final String[] camposCelulaEstoque = new String[]{"codigoCelulaEstoque", "descricaoCelulaEstoque"};
    private static final String[] camposFornecedor = new String[]{"codigoFornecedor", "fantasiaFornecedor", "razaoSocialFornecedor"};
    private String[] camposRelatorio = null;

    public RelatorioLotesMaterialDetalhado() {
        this.montaBarraDescricao("Relat\u00f3rio de lotes de material detalhado", "Listagem dos lotes dos materiais detalhado", "relatorios/rel_estoque_almoxarifado_lotes_material_detalhado.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_MATERIAL, "Material", "material", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"mat_codigo", "mat_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_TIPO_MATERIAL, "Tipo Material", "tipomaterial", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"tpm_codigo", "tpm_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroCombo(FILTRO_CAMPO_DATA, "Campo Data:", camposOrdenacaoCampoData, 0);
        this.adicionaFiltroData(FILTRO_VALIDADE_INICIAL, "Data Inicial:");
        this.adicionaFiltroData(FILTRO_VALIDADE_FINAL, "Data Final:");
        this.adicionaFiltroCombo(FILTRO_ORDENACAO, "Ordem Mat.:", camposOrdenacao, 0);
        this.adicionaFiltroCombo(FILTRO_ORDENACAO_LOTE, "Ordem Lotes:", camposOrdenacaoLote, 0);
        this.adicionaFiltroCheck(FILTRO_MATERIAL_INATIVO, "Mostrar material inativo", false);
        this.adicionaFiltroCheck(FILTRO_MATERIAL_SEM_LOTE, "Mostrar material sem lote", false);
        this.adicionaFiltroCheck(FILTRO_LOTE_CONSUMIDO, "Mostrar lotes consumidos", false);
        this.setModuloConfigurar(RelatorioLotesMaterialDetalhado.getModuloConfigurar());
        this.setModuloAcesso(RelatorioLotesMaterialDetalhado.getModuloAcesso());
        this.camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, camposMaterial);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposUnidadeMedida);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposTipoMaterial);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposMaterialLote);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposLanctoEstoque);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposEstoqueManual);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposConferenciaEntrada);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposConferenciaEstoque);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposNotaFiscal);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposPedidoCompra);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposSaldoEstoque);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposCelulaEstoque);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposFornecedor);
        this.setCamposConfigurador(this.camposRelatorio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        String[] materiais = this.getSelecionadosFiltro(FILTRO_MATERIAL, 0);
        String[] tiposMateriais = this.getSelecionadosFiltro(FILTRO_TIPO_MATERIAL, 0);
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        try {
            int i;
            StringBuilder buf = new StringBuilder();
            buf.append(" select a.mat_codigo \t\t\t\t\t\t\tas codigoMaterial ");
            buf.append("       ,a.mat_descricao \t\t\t\t\tas descricaoMaterial ");
            buf.append("       ,a.mat_valorunit \t\t\t\t\tas valorUnitarioMaterial ");
            buf.append("       ,a.mat_valorultcompra \t\t\tas valorUltimaCompraMaterial ");
            buf.append("       ,a.mat_dataultcompra \t\t\tas dataUltimaCompraMaterial ");
            buf.append("       ,a.mat_qtdeultcompra \t\t\tas quantidadeUltimaCompraMaterial ");
            buf.append("       ,a.mat_ptoreposicao \t\t\t\tas pontoReposicaoMaterial ");
            buf.append("       ,a.mat_dataultentrega \t\t\tas dataUltimaEntregaMaterial ");
            buf.append("       ,a.mat_marca \t\t\t\t\t\t\tas marcaMaterial ");
            buf.append("       ,a.mat_modelo \t\t\t\t\t\t\tas modeloMaterial ");
            buf.append("       ,a.mat_reposicaoautomatica as reposicaoAutomaticaMaterial ");
            buf.append("       ,a.usr_codigo \t\t\t\t\t\t\tas codigoUsuarioCadastroMaterial ");
            buf.append("       ,a.mat_imobilizado \t\t\t\tas imobilizadoMaterial ");
            buf.append("       ,a.mat_solicitarpatrimonio as solicitarPatrimonioMaterial ");
            buf.append("       ,a.mat_fichatecnica \t\t\t\tas fichaTecnicaMaterial ");
            buf.append("       ,a.mat_criarlotekit \t\t\t\tas criarLoteKitMaterial ");
            buf.append("\t\t\t ,a.mat_inativo \t\t\t\t\t\tas materialInativo ");
            buf.append("       ,unm.unm_codigo \t\t\t\t\t\tas codigoUnidadeMedida ");
            buf.append("       ,unm.unm_descricao \t\t\t\tas descricaoUnidadeMedida ");
            buf.append("       ,tpm.tpm_codigo \t\t\t\t\t\tas codigoTipoMaterial ");
            buf.append("       ,tpm.tpm_descricao \t\t\t\tas descricaoTipoMaterial ");
            buf.append("       ,mll.mll_lote\t\t\t\t\t\t\tas codigoLote ");
            buf.append("       ,mll.mll_datalote\t\t\t\t\tas dataLote ");
            buf.append("       ,mll.mll_validadelote\t\t\tas validadeLote ");
            buf.append("       ,mll.mll_quantidade\t\t\t\tas quantidadeLote ");
            buf.append("       ,mll.mll_quantidadeconsumida as quantidadeConsumidaLote ");
            buf.append("       ,mll.mll_quantidade - mll.mll_quantidadeconsumida as quantidadeRestanteLote ");
            buf.append("       ,mll.usr_codigo            as codigoUsuarioCadastroLote ");
            buf.append("       ,mll.mll_datahora          as dataCadastroLote ");
            buf.append("       ,mll.mll_observacao        as observacaoLote ");
            buf.append("       ,mll.mll_codigo            as materialLote ");
            buf.append("       ,lce.lce_datahora\t\t\t\t\tas dataHoraLanctoEstoque ");
            buf.append("       ,lce.lce_tipo\t\t\t\t\t\t\tas tipoLanctoEstoque ");
            buf.append("       ,lce.lce_tipoorigem\t\t\t\tas tipoOrigemLanctoEstoque ");
            buf.append("       ,lce.lce_quantidade\t\t\t\tas quantidadeLanctoEstoque ");
            buf.append("       ,lce.usr_codigo\t\t\t\t\t\tas codigoUsuarioLanctoEstoque ");
            buf.append("       ,lce.usr_codconciliacao\t\tas codigoUsuarioConciliacaoLanctoEstoque ");
            buf.append("       ,lce.lce_situacao\t\t\t\t\tas situacaoLanctoEstoque ");
            buf.append("       ,lce.lce_conciliacao\t\t\t\tas dataHoraConciliacaoLanctoEstoque ");
            buf.append("       ,etm.etm_datahora \t\t\t\t\tas dataHoraEstoqueManual ");
            buf.append("       ,etm.etm_observacao \t\t\t\tas observacaoEstoqueManual ");
            buf.append("       ,etm.usr_codigo\t\t\t\t\t\tas codigoUsuarioEstoqueManual ");
            buf.append("       ,cen.cen_datahora\t\t\t\t\tas dataHoraConferenciaEntrada ");
            buf.append("       ,cen.usr_codigo\t\t\t\t\t\tas codigoUsuarioConferenciaEntrada ");
            buf.append("       ,cen.cen_observacao\t\t\t\tas observacaoConferenciaEntrada ");
            buf.append("       ,ces.ces_datahora\t\t\t\t\tas dataHoraConferenciaEstoque ");
            buf.append("       ,ces.ces_observacao\t\t\t\tas observacaoConferenciaEstoque ");
            buf.append("       ,ces.usr_codigo\t\t\t\t\t\tas codigoUsuarioConferenciaEstoque ");
            buf.append("       ,nfi.nfi_codigo\t\t\t\t\t\tas codigoNotaFiscal ");
            buf.append("       ,nfi.ser_codigo\t\t\t\t\t\tas serieNotaFiscal ");
            buf.append("       ,nfi.nfi_numero \t\t\t\t\t\tas numeroNotaFiscal ");
            buf.append("       ,nfi.nfi_tipocadastro\t\t\tas tipoCadastroNotaFiscal ");
            buf.append("       ,nfi.usr_codigo            as codigoUsuarioNotaFiscal ");
            buf.append("       ,nfi.nfi_datahora          as dataHoraNotaFiscal ");
            buf.append("       ,nfi.nfi_dataemissao\t\t\t\tas dataEmissaoNotaFiscal ");
            buf.append("       ,nfi.nfi_situacao\t\t\t\t\tas situacaoNotaFiscal ");
            buf.append("       ,nfi.nfi_observacao\t\t\t\tas observacaoNotaFiscal ");
            buf.append("       ,nfi.nfi_subtotal\t\t\t\t\tas valorBrutoNotaFiscal ");
            buf.append("       ,nfi.nfi_valortotal \t\t\t\tas valorLiquidoNotaFiscal ");
            buf.append("       ,nfi.nfi_numerorps         as numeroRpsNotaFiscal ");
            buf.append("\t\t\t ,ped.ped_codigo\t\t\t\t\t\tas codigoPedidoCompra ");
            buf.append("       ,ped.ped_datahora\t\t\t\t\tas dataHoraPedidoCompra ");
            buf.append("       ,ped.ped_observacao\t\t\t\tas observacaoPedidoCompra ");
            buf.append("       ,ped.ped_total\t\t\t\t\t\t\tas valorTotalPedidoCompra ");
            buf.append("       ,ped.usr_codigo\t\t\t\t\t\tas codigoUsuarioPedidoCompra ");
            buf.append("       ,COALESCE(sde.sde_saldo, 0) as saldoAtualEstoque ");
            buf.append("       , '' as usuarioAberturaLote ");
            buf.append("       , '' as dataAberturaLote ");
            buf.append("       , '' as usuarioFechamentoLote ");
            buf.append("       , '' as dataFechamentoLote ");
            buf.append("       ,cel.cel_codigo\t\t\t\t\t\tas codigoCelulaEstoque ");
            buf.append("       ,cel.cel_descricao         as descricaoCelulaEstoque ");
            buf.append("       ,ent.ent_codigo      as codigoFornecedor");
            buf.append("       ,ent.ent_fantasia    as fantasiaFornecedor");
            buf.append("       ,ent.ent_razaosocial as razaoSocialFornecedor");
            buf.append(", ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("   from material a ");
            buf.append("   left join unidademedida unm on a.fil_codigo = unm.fil_codigo and a.unm_codigo = unm.unm_codigo ");
            buf.append("   left join tipomaterial tpm on a.fil_codigo = tpm.fil_codigo and a.tpm_codigo = tpm.tpm_codigo ");
            buf.append("   left join materiallote mll on a.fil_codigo = mll.fil_codigo and a.mat_codigo = mll.mat_codigo and not mll.mll_removido ");
            buf.append("   left join materiallotelanctoestoque mle on mll.fil_codigo = mle.fil_codigo and mll.mll_codigo = mle.mll_codigo and mle.mll_quantidade > 0 ");
            buf.append("   left join lanctoestoque lce on mle.fil_codigo = lce.fil_codigo and mle.lce_codigo = lce.lce_codigo and lce.lce_datahoracancelamento IS NULL ");
            buf.append("   left join celulaestoque cel on lce.fil_codigo = cel.fil_codigo and lce.cel_codigo = cel.cel_codigo ");
            buf.append("   left join estoquemanuallanctoestoque aux1 on lce.fil_codigo = aux1.fil_codigo and lce.lce_codigo = aux1.lce_codigo ");
            buf.append("   left join conferenciaentradalanctoestoque aux2 on lce.fil_codigo = aux2.fil_codigo and lce.lce_codigo = aux2.lce_codigo ");
            buf.append("   left join conferenciaestoquelanctoestoque aux3 on lce.fil_codigo = aux3.fil_codigo and lce.lce_codigo = aux3.lce_codigo ");
            buf.append("   left join estoquemanual etm on aux1.fil_codigo = etm.fil_codigo and aux1.etm_codigo = etm.etm_codigo ");
            buf.append("   left join conferenciaentrada cen on aux2.fil_codigo = cen.fil_codigo and aux2.cen_codigo = cen.cen_codigo and cen.cen_datahoracancelamento IS NULL ");
            buf.append("   left join conferenciaestoque ces on aux3.fil_codigo = ces.fil_codigo and aux3.ces_codigo = ces.ces_codigo ");
            buf.append("   left join pedido ped on cen.fil_codigo = ped.fil_codigo and cen.ped_codigo = ped.ped_codigo and ped.usr_codexclusao IS NULL ");
            buf.append("   left join saldoestoque sde on a.fil_codigo = sde.fil_codigo and a.mat_codigo = sde.mat_codigo and sde.sde_data = (select max(aux.sde_data) from saldoestoque aux where aux.fil_codigo = sde.fil_codigo and aux.mat_codigo = sde.mat_codigo) ");
            buf.append("   left join notafiscallanctoestoque nle on lce.fil_codigo = nle.fil_codigo and lce.lce_codigo = nle.lce_codigo ");
            buf.append("   left join notafiscal nfi on ((cen.fil_codigo = nfi.fil_codigo and cen.nfi_codigo = nfi.nfi_codigo) or (nle.fil_codigo = nfi.fil_codigo and nle.nfi_codigo = nfi.nfi_codigo)) and nfi.usr_codcancelada IS NULL ");
            buf.append("   left join entidade ent on ent.fil_codigo = nfi.fil_codigo and ent.ent_codigo = nfi.ent_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append("  where a.fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("    and a.mat_solicitarlote ");
            if (!this.getFiltroCheck(FILTRO_MATERIAL_SEM_LOTE)) {
                buf.append(" and mll.mll_lote is not null ");
            }
            if (materiais != null) {
                buf.append("  and a.mat_codigo IN (");
                for (i = 0; i < materiais.length; ++i) {
                    buf.append(materiais[i]);
                    if (i >= materiais.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if (tiposMateriais != null) {
                buf.append("  and a.tpm_codigo IN (");
                for (i = 0; i < tiposMateriais.length; ++i) {
                    buf.append(tiposMateriais[i]);
                    if (i >= tiposMateriais.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            boolean isDataValidade = this.getFiltroComboIndice(FILTRO_CAMPO_DATA) == 0;
            String dataInicial = this.getFiltroData(FILTRO_VALIDADE_INICIAL);
            String dataFinal = this.getFiltroData(FILTRO_VALIDADE_FINAL);
            if (dataInicial != null && !Funcoes.textoVazio(dataInicial)) {
                if (isDataValidade) {
                    buf.append(" and (mll.mll_validadelote >= '").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append("' ");
                } else {
                    buf.append(" and (mll.mll_datalote >= '").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append("' ");
                }
                if (this.getFiltroCheck(FILTRO_MATERIAL_SEM_LOTE)) {
                    buf.append(" or mll.mll_lote is null ");
                }
                buf.append(") ");
            }
            if (dataFinal != null && !Funcoes.textoVazio(dataFinal)) {
                if (isDataValidade) {
                    buf.append(" and (mll.mll_validadelote <= '").append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append("' ");
                } else {
                    buf.append(" and (mll.mll_datalote <= '").append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append("' ");
                }
                if (this.getFiltroCheck(FILTRO_MATERIAL_SEM_LOTE)) {
                    buf.append(" or mll.mll_lote is null ");
                }
                buf.append(") ");
            }
            if (!this.getFiltroCheck(FILTRO_MATERIAL_INATIVO)) {
                buf.append(" and a.mat_inativo = false ");
            }
            if (!this.getFiltroCheck(FILTRO_LOTE_CONSUMIDO)) {
                buf.append(" and (COALESCE(mll.mll_quantidadeconsumida, 0) < COALESCE(mll.mll_quantidade, 0) ");
                if (this.getFiltroCheck(FILTRO_MATERIAL_SEM_LOTE)) {
                    buf.append(" or mll.mll_lote is null ");
                }
                buf.append(") ");
            }
            int ordem = this.getFiltroComboIndice(FILTRO_ORDENACAO);
            buf.append(" order by ").append(camposOrdenacaoBanco[ordem]);
            if (isDataValidade) {
                buf.append(", mll.mll_validadelote ");
            } else {
                buf.append(", mll.mll_datalote ");
            }
            int ordemLote = this.getFiltroComboIndice(FILTRO_ORDENACAO_LOTE);
            if (ordemLote == 0) {
                buf.append(" asc ");
            } else {
                buf.append(" desc ");
            }
            buf.append(" , mll.mll_lote, mle.lce_codigo ");
            MaterialLoteService materialLoteService = new MaterialLoteService();
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                int i2;
                ModeloGridTable modelo = new ModeloGridTable(this.camposRelatorio);
                do {
                    Object[] o = new Object[this.camposRelatorio.length];
                    List<Map<String, Object>> lista = materialLoteService.aberturaFechamentoLote(rs.getString("codigoFilial"), rs.getString("materialLote"));
                    for (i2 = 0; i2 < this.camposRelatorio.length; ++i2) {
                        if (rs.getObject(this.camposRelatorio[i2]) == null) continue;
                        o[modelo.findColumn((String)this.camposRelatorio[i2])] = this.camposRelatorio[i2].equalsIgnoreCase("tipoLanctoEstoque") ? Tipos.tipoLancamentoEstoque(rs.getObject(this.camposRelatorio[i2]).toString()) : (this.camposRelatorio[i2].equalsIgnoreCase("tipoOrigemLanctoEstoque") ? Tipos.tipoOrigemLancamentoEstoque(rs.getObject(this.camposRelatorio[i2]).toString()) : (this.camposRelatorio[i2].equalsIgnoreCase("situacaoLanctoEstoque") ? Tipos.tipoSituacaoLancamentoEstoque(rs.getObject(this.camposRelatorio[i2]).toString()) : (this.camposRelatorio[i2].equalsIgnoreCase("tipoCadastroNotaFiscal") ? Tipos.tipoCadastro(rs.getObject(this.camposRelatorio[i2]).toString()) : (this.camposRelatorio[i2].equalsIgnoreCase("situacaoNotaFiscal") ? Tipos.tipoSituacaoNotaFiscal(rs.getObject(this.camposRelatorio[i2]).toString(), rs.getObject("numeroRpsNotaFiscal") != null) : (this.camposRelatorio[i2].equalsIgnoreCase("materialInativo") ? (rs.getBoolean(this.camposRelatorio[i2]) ? "Sim" : "N\u00e3o") : (this.camposRelatorio[i2].equalsIgnoreCase("usuarioAberturaLote") ? materialLoteService.processaValorDataFechamentoLote("usuarioAberturaLote", lista) : (this.camposRelatorio[i2].equalsIgnoreCase("dataAberturaLote") ? materialLoteService.processaValorDataFechamentoLote("dataAberturaLote", lista) : (this.camposRelatorio[i2].equalsIgnoreCase("usuarioFechamentoLote") ? materialLoteService.processaValorDataFechamentoLote("usuarioFechamentoLote", lista) : (this.camposRelatorio[i2].equalsIgnoreCase("dataFechamentoLote") ? materialLoteService.processaValorDataFechamentoLote("dataFechamentoLote", lista) : rs.getObject(this.camposRelatorio[i2]))))))))));
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioLotesMaterialDetalhado.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioLotesMaterialDetalhado.this.panelCentro.removeAll();
                            RelatorioLotesMaterialDetalhado.this.panelCentro.repaint();
                            RelatorioLotesMaterialDetalhado.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put(FILTRO_ORDENACAO, this.getFiltroCombo(FILTRO_ORDENACAO));
                    var.put(FILTRO_ORDENACAO_LOTE, this.getFiltroCombo(FILTRO_ORDENACAO_LOTE));
                    var.put(FILTRO_CAMPO_DATA, this.getFiltroCombo(FILTRO_CAMPO_DATA));
                    var.put(FILTRO_VALIDADE_INICIAL, this.getFiltroData(FILTRO_VALIDADE_INICIAL));
                    var.put(FILTRO_VALIDADE_FINAL, this.getFiltroData(FILTRO_VALIDADE_FINAL));
                    var.put(FILTRO_MATERIAL_INATIVO, this.getFiltroCheck(FILTRO_MATERIAL_INATIVO) ? "Sim" : "N\u00e3o");
                    var.put(FILTRO_MATERIAL_SEM_LOTE, this.getFiltroCheck(FILTRO_MATERIAL_SEM_LOTE) ? "Sim" : "N\u00e3o");
                    buf.delete(0, buf.length());
                    if (materiais != null) {
                        for (i2 = 0; i2 < materiais.length; ++i2) {
                            buf.append(materiais[i2]);
                            if (i2 >= materiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_MATERIAL, buf.toString());
                    buf.delete(0, buf.length());
                    if (tiposMateriais != null) {
                        for (i2 = 0; i2 < tiposMateriais.length; ++i2) {
                            buf.append(tiposMateriais[i2]);
                            if (i2 >= tiposMateriais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_TIPO_MATERIAL, buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            try {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0801001400");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0801001401");
    }
}

