/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.cadastros;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.relatorio.Gerador;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioUsuario
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_SITUACAO = "filtroSituacao";
    private final String FILTRO_TIPO = "filtroTipo";
    private final String[] ordem = new String[]{"C\u00f3digo", "Nome"};
    private final String[] situacao = new String[]{"Todos", "Ativos", "Inativos"};
    public final String[] campos = new String[]{"codigoTipoUsuario", "codigoUsuario", "descricaoTipoUsuario", "nomeUsuario", "estadoUsuario", "dataInativoUsuario", "dataHoraUltimoLoginUsuario", "dataHoraUltimoLogoutUsuario", "alterarSenhaNoLoginUsuario", "dataHoraUltimaAtualizacaoSenhaUsuario"};

    public RelatorioUsuario() {
        this.setName("RelatorioUsuario");
        this.montaBarraDescricao("Relat\u00f3rio de usu\u00e1rios", "Listagem dos usu\u00e1rios cadastrados", "relatorios/cad_usuario.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroTipo", "Tipo de usu\u00e1rios", "tipousuario", "", 1, new String[]{"tpu_codigo", "tpu_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroCombo("filtroSituacao", "Situa\u00e7\u00e3o", this.situacao, 0);
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem", this.ordem, 0);
        this.setModuloAcesso(RelatorioUsuario.getModuloAcesso());
        this.setModuloConfigurar(RelatorioUsuario.getModuloConfigurar());
        this.setCamposConfigurador(this.campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void imprimirPressionado() {
        block28: {
            ResultSet resultSetDados;
            Statement statement;
            block27: {
                boolean where;
                this.setCursor(Cursor.getPredefinedCursor(3));
                statement = Conexao.getStatement();
                resultSetDados = null;
                boolean existeDados = false;
                ModeloGridTable modelo = new ModeloGridTable(this.campos);
                StringBuilder sql = new StringBuilder("select ");
                sql.append(" b.tpu_codigo as codigoTipoUsuario, ");
                sql.append(" b.tpu_descricao as descricaoTipoUsuario, ");
                sql.append(" a.usr_codigo as codigoUsuario, ");
                sql.append(" a.usr_nome as nomeUsuario, ");
                sql.append(" a.usr_inativo as estadoUsuario, ");
                sql.append(" a.usr_datainativo as dataInativoUsuario, ");
                sql.append(" (select ulo_datahoralogin from usuariologin where usr_codigo = a.usr_codigo and ulo_datahoralogin is not null order by ulo_codigo desc limit 1) as dataHoraUltimoLoginUsuario, ");
                sql.append(" (select ulo_datahoralogout  from usuariologin where usr_codigo = a.usr_codigo and ulo_datahoralogout is not null order by ulo_codigo desc limit 1) as dataHoraUltimoLogoutUsuario, ");
                sql.append(" a.usr_alterasenha as alterarSenhaNoLoginUsuario, ");
                sql.append(" a.usr_dataultimasenha as dataHoraUltimaAtualizacaoSenhaUsuario ");
                sql.append(" from usuario a ");
                sql.append(" left join tipousuario b on a.tpu_codigo = b.tpu_codigo");
                String[] tipos = this.getSelecionadosFiltro("filtroTipo", 0);
                boolean bl = where = tipos != null && tipos.length > 0;
                if (where) {
                    sql.append(" where a.tpu_codigo in (");
                    for (int i = 0; i < tipos.length; ++i) {
                        sql.append(tipos[i]);
                        if (i >= tipos.length - 1) continue;
                        sql.append(", ");
                    }
                    sql.append(") ");
                }
                if (this.getFiltroComboIndice("filtroSituacao") > 0) {
                    if (where) {
                        sql.append(" and ");
                    } else {
                        sql.append(" where ");
                    }
                }
                if (this.getFiltroComboIndice("filtroSituacao") == 1) {
                    sql.append("not a.usr_inativo");
                } else if (this.getFiltroComboIndice("filtroSituacao") == 2) {
                    sql.append(" a.usr_inativo");
                }
                sql.append(" order by a.usr_inativo, a.tpu_codigo, upper(").append(this.getCampoOrdernar(this.getFiltroComboIndice("ordemRelatorio"))).append(") ");
                resultSetDados = Conexao.executeQuery(statement, sql.toString());
                existeDados = resultSetDados.next();
                if (existeDados) {
                    do {
                        Object[] o = new Object[this.campos.length];
                        for (int i = 0; i < this.campos.length; ++i) {
                            o[i] = resultSetDados.getObject(this.campos[i]);
                        }
                        modelo.addLine(o);
                    } while (resultSetDados.next());
                }
                if (existeDados) {
                    sql.delete(0, sql.length());
                    sql.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    sql.append(RelatorioUsuario.getModuloAcesso());
                    ResultSet resultSetRelatorio = Conexao.executeQuery(statement, sql.toString());
                    if (resultSetRelatorio.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(1.0f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioUsuario.this.panelCentro.removeAll();
                                RelatorioUsuario.this.panelCentro.repaint();
                                RelatorioUsuario.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio").toString());
                        var.put("filtroSituacao", this.getFiltroCombo("filtroSituacao").toString());
                        var.put("filtroTipo", this.getSelecionadosFiltro("filtroTipo", 0));
                        gerador.executar(resultSetRelatorio.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                        resultSetRelatorio.close();
                    } else {
                        Funcoes.mensagem(this, "Relat\u00f3rio n\u00e3o possui layout.", 2);
                        this.habilitaBotaoImprimir(true);
                    }
                    break block27;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            Conexao.fecharStatement(statement);
            try {
                if (resultSetDados != null) {
                    resultSetDados.close();
                }
                break block28;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            break block28;
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(statement);
                    try {
                        if (resultSetDados != null) {
                            resultSetDados.close();
                        }
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                    throw throwable;
                }
                Conexao.fecharStatement(statement);
                try {
                    if (resultSetDados != null) {
                        resultSetDados.close();
                    }
                }
                catch (SQLException e3) {
                    e3.printStackTrace();
                }
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private String getCampoOrdernar(int filtroComboIndice) {
        if (filtroComboIndice == 0) {
            return "a.usr_codigo";
        }
        return "a.usr_nome";
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0812501001");
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0812501000");
    }
}

