/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.cadastros;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioTaxa
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String[] ordem = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Valor"};
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigo", "descricao", "valor"});

    public RelatorioTaxa() {
        this.setName("RelatorioTaxa");
        this.montaBarraDescricao("Relat\u00f3rio de Taxas", "Listagem de taxas cobradas", "relatorios/rel_taxa.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem", this.ordem, 0);
        this.setModuloAcesso(RelatorioTaxa.getModuloAcesso());
        this.setModuloConfigurar(RelatorioTaxa.getModuloConfigurar());
        this.setCamposConfigurador(campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void imprimirPressionado() {
        block22: {
            ResultSet resultSetDados;
            Statement statement;
            block21: {
                this.setCursor(Cursor.getPredefinedCursor(3));
                statement = Conexao.getStatement();
                resultSetDados = null;
                boolean existeDados = false;
                ModeloGridTable modelo = new ModeloGridTable(campos);
                StringBuilder sql = new StringBuilder();
                sql.append(" select a.tax_valor as valor , a.tax_codigo as codigo, a.tax_descricao as descricao, ");
                sql.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                sql.append(" from taxa a ");
                sql.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
                if (filiais == null) {
                    filiais = new String[]{Variaveis.filialPadrao};
                }
                sql.append(" where a.fil_codigo in (");
                for (int i = 0; i < filiais.length; ++i) {
                    sql.append(filiais[i]);
                    if (i >= filiais.length - 1) continue;
                    sql.append(", ");
                }
                sql.append(") ");
                sql.append(" order by a.fil_codigo, ").append(this.getCampoOrdernar(this.getFiltroComboIndice("ordemRelatorio")));
                resultSetDados = Conexao.executeQuery(statement, sql.toString());
                existeDados = resultSetDados.next();
                if (existeDados) {
                    do {
                        Object[] o = new Object[campos.length];
                        for (int i = 0; i < campos.length; ++i) {
                            o[i] = resultSetDados.getObject(campos[i]);
                        }
                        modelo.addLine(o);
                    } while (resultSetDados.next());
                }
                if (existeDados) {
                    sql.delete(0, sql.length());
                    sql.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    sql.append(RelatorioTaxa.getModuloAcesso());
                    ResultSet resultSetRelatorio = Conexao.executeQuery(statement, sql.toString());
                    if (resultSetRelatorio.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(1.0f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioTaxa.this.panelCentro.removeAll();
                                RelatorioTaxa.this.panelCentro.repaint();
                                RelatorioTaxa.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio").toString());
                        var.put("filtroFilial", this.getSelecionadosFiltro("filtroFilial", 0));
                        gerador.executar(resultSetRelatorio.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                        resultSetRelatorio.close();
                    } else {
                        Funcoes.mensagem(this, "Relat\u00f3rio n\u00e3o possui layout.", 2);
                        this.habilitaBotaoImprimir(true);
                    }
                    break block21;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            Conexao.fecharStatement(statement);
            try {
                if (resultSetDados != null) {
                    resultSetDados.close();
                }
                break block22;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            break block22;
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(statement);
                    try {
                        if (resultSetDados != null) {
                            resultSetDados.close();
                        }
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                    throw throwable;
                }
                Conexao.fecharStatement(statement);
                try {
                    if (resultSetDados != null) {
                        resultSetDados.close();
                    }
                }
                catch (SQLException e3) {
                    e3.printStackTrace();
                }
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private String getCampoOrdernar(int filtroComboIndice) {
        if (filtroComboIndice == 0) {
            return "codigo";
        }
        if (filtroComboIndice == 1) {
            return "descricao";
        }
        if (filtroComboIndice == 2) {
            return "valor";
        }
        return null;
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0812500901");
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0812500900");
    }
}

