/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.cadastros;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioPatrimonio
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_TIPO = "filtroTipo";
    private final String FILTRO_SETOR = "filtroSetor";
    private final String FILTRO_INUTILIZADO = "filtroInutilizado";
    private final String FILTRO_MATERIAL = "filtroMaterial";
    private final String FILTRO_MATERIAL_INATIVO = "filtroMaterialInativo";
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoMaterial", "descricaoMaterial", "codigoSetorPatrimonio", "numeroPatrimonio", "numeroNotaFiscal", "numeroSeriePatrimonio", "descricaoSetor", "situacaoPatrimonio", "materialInativo"});

    public RelatorioPatrimonio() {
        this.setName("RelatorioPatrimonio");
        this.montaBarraDescricao("Relat\u00f3rio de Patrim\u00f4nio", "Listagem dos patrim\u00f4nios dos materiais", "relatorios/rel_patrimonio.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSetor", "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroMaterial", "Material", "material", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"mat_codigo", "mat_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroTipo", "Tipo", "tipomaterial", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"tpm_codigo", "tpm_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroCheck("filtroInutilizado", "Mostrar inutilizados", false);
        this.adicionaFiltroCheck("filtroMaterialInativo", "Mostrar material inativo", false);
        this.setModuloConfigurar(RelatorioPatrimonio.getModuloConfigurar());
        this.setModuloAcesso(RelatorioPatrimonio.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String[] material;
            String[] setor;
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.append("select a.mat_codigo \t AS codigoMaterial, ");
            buf.append("a.mtp_patrimonio  \t\t AS numeroPatrimonio, ");
            buf.append("a.set_codigo \t\t  \t\t AS codigoSetorPatrimonio, ");
            buf.append("a.mtp_inutilizado \t\t AS situacaoPatrimonio, ");
            buf.append("a.mtp_numeronotafiscal AS numeroNotaFiscal, ");
            buf.append("a.mtp_numeroserie \t\t AS numeroSeriePatrimonio, ");
            buf.append("set.set_descricao \t\t AS descricaoSetor, ");
            buf.append("mat.mat_descricao \t\t AS descricaoMaterial, ");
            buf.append("mat.mat_inativo \t\t\t AS materialInativo, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from materialpatrimonio a ");
            buf.append("left join setores  set on a.fil_codigo = set.fil_codigo and a.set_codigo = set.set_codigo ");
            buf.append("left join material mat on a.fil_codigo = mat.fil_codigo and a.mat_codigo = mat.mat_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            String[] filiais = this.getSelecionadosFiltro(FILTRO_FILIAL, 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            buf.append("where a.fil_codigo in (");
            for (int i = 0; i < filiais.length; ++i) {
                buf.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
            String[] tipos = this.getSelecionadosFiltro("filtroTipo", 0);
            if (tipos != null) {
                buf.append(" and mat.tpm_codigo in (");
                for (int i = 0; i < tipos.length; ++i) {
                    buf.append(tipos[i]);
                    if (i >= tipos.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((setor = this.getSelecionadosFiltro("filtroSetor", 0)) != null) {
                buf.append(" and a.set_codigo in (");
                for (int i = 0; i < setor.length; ++i) {
                    buf.append(setor[i]);
                    if (i >= setor.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((material = this.getSelecionadosFiltro("filtroMaterial", 0)) != null) {
                buf.append(" and mat.mat_codigo in (");
                for (int i = 0; i < material.length; ++i) {
                    buf.append("'");
                    buf.append(material[i]);
                    buf.append("'");
                    if (i >= material.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if (!this.getFiltroCheck("filtroInutilizado")) {
                buf.append(" and a.mtp_inutilizado = false ");
            }
            if (!this.getFiltroCheck("filtroMaterialInativo")) {
                buf.append(" and mat.mat_inativo = false ");
            }
            buf.append("order by a.fil_codigo ");
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        if (campos[i].equals("situacaoPatrimonio")) {
                            o[modelo.findColumn((String)RelatorioPatrimonio.campos[i])] = !rs.getBoolean(campos[i]) ? "Utilizado" : "Inutilizado";
                            continue;
                        }
                        if (campos[i].endsWith("materialInativo")) {
                            o[modelo.findColumn((String)RelatorioPatrimonio.campos[i])] = rs.getBoolean(campos[i]) ? "Sim" : "N\u00e3o";
                            continue;
                        }
                        o[i] = this.colunaExiste(rs, campos[i]) ? rs.getObject(campos[i]) : null;
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioPatrimonio.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioPatrimonio.this.panelCentro.removeAll();
                            RelatorioPatrimonio.this.panelCentro.repaint();
                            RelatorioPatrimonio.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    buf.delete(0, buf.length());
                    if (tipos != null) {
                        for (int i = 0; i < tipos.length; ++i) {
                            buf.append(tipos[i]);
                            if (i >= tipos.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroInutilizado", this.getFiltroCheck("filtroInutilizado") ? "Sim" : "N\u00e3o");
                    var.put("filtroMaterialInativo", this.getFiltroCheck("filtroMaterialInativo") ? "Sim" : "N\u00e3o");
                    var.put(FILTRO_FILIAL, filiais);
                    var.put("filtroTipo", tipos);
                    var.put("filtroMaterial", material);
                    var.put("filtroSetor", setor);
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private boolean colunaExiste(ResultSet rs, String campo) {
        try {
            return rs.findColumn(campo) > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101300700");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0101300701");
    }
}

