/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.cadastros;

import jalis.comum.CBOS;
import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableModel;

public class RelatorioMedicos
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    public static int TIPO_CADASTRO = 1;
    public static int TIPO_MALADIRETA = 2;
    private int tipoRelatorio = TIPO_CADASTRO;
    private final String[] ordem = new String[]{"Crm", "Nome"};
    private final long ACESSO_CONFIGURAR_CADASTRO = Long.parseLong("0811500201");
    private final long ACESSO_CONFIGURAR_MALADIRETA = Long.parseLong("0890400101");
    private final String FILTRO_ESTADO = "filtroEstado";
    private final String FILTRO_CIDADE = "filtroCidade";
    private final String FILTRO_MEDICO = "filtroMedico";
    private final String FILTRO_DIANASCIMENTO = "filtroDiaNascimento";
    private final String FILTRO_MESNASCIMENTO = "filtroMesNascimento";
    private final String FILTRO_ANONASCIMENTO = "filtroAnoNascimento";
    private final String FILTRO_ESPECIALIDADE = "filtroEspecialidade";
    private final String FILTRO_EMAIL = "filtroEmail";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String TITULO_RELATORIO = "tituloRelatorio";
    private final String FILTRO_CONSELHO = "filtroConselho";
    private final String FILTRO_REMOVERINATIVO = "filtroRemoverInativo";
    private final String FILTRO_SOMENTEINATIVO = "filtroSomenteInativo";
    private final String[] estados = ArraysUtil.concatenar(new String[]{"Todos"}, ConstantesGerais.ESTADOS);
    private JCheckBox checkRemoverInativos = new JCheckBox();
    private JCheckBox checkSomenteInativos = new JCheckBox();
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"conselhoMedico", "crmMedico", "ufMedico", "nomeMedico", "abreviaturaMedico", "observacaoMedico", "tipoMedico", "comissaoMedico", "cepMedico", "complementoMedico", "enderecoMedico", "celularMedico", "faxMedico", "dataNascimentoMedico", "medicoInativo", "cpfMedico", "codigoCBOSMedico", "descricaoCBOSMedico", "foneMedico", "emailMedico", "siteMedico", "senhaWebMedico", "codigoCidadeMedico", "descricaoCidadeMedico", "estadoCidadeMedico", "codigoBairroMedico", "descricaoBairroMedico", "codigoEspecialidade", "descricaoEspecialidade", "numeroEnderecoMedico", "tipoLogradouroMedico", "tituloRelatorio"});

    public RelatorioMedicos(int tipo) {
        String imagemMala;
        this.setName("RelatorioMedicos");
        this.tipoRelatorio = tipo;
        String descricao = this.isAlimentos() ? "Coletadores" : "M\u00e9dicos";
        String imagemCadastro = this.isAlimentos() ? "relatorios/rel_coletador.jpg" : "relatorios/rel_medico.jpg";
        String string = imagemMala = this.isAlimentos() ? "relatorios/mala_direta_medico.jpg" : "relatorios/mala_direta_coletador.jpg";
        if (tipo == TIPO_CADASTRO) {
            this.montaBarraDescricao("Relat\u00f3rio de " + descricao.toLowerCase(), "Listagem dos " + descricao.toLowerCase() + " cadastrados", imagemCadastro);
        } else {
            this.montaBarraDescricao("Mala-direta de " + descricao.toLowerCase(), "Listagem dos " + descricao.toLowerCase() + " cadastrados para mala-direta", "relatorios/mala_direta_medico.jpg");
        }
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltroAvancado("filtroMedico", descricao, "medico", "fil_codigo = " + Variaveis.filialPadrao, 4, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "N\u00famero", "UF", "Nome"}, new int[]{30, 70, 30, 0}, false, new int[]{0, 1, 2});
        this.adicionaItemFiltro("filtroEspecialidade", "Especialidade", "especialidades", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"esp_codigo", "esp_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroCidade", "Cidade", "cidades", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cid_codigo", "cid_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConselho", "Conselho", ConstantesGerais.CONSELHOS, new String[]{"Conselho"});
        this.adicionaFiltroNumero("filtroDiaNascimento", "Dia anivers.:", 2);
        this.adicionaFiltroCombo("filtroMesNascimento", "M\u00eas anivers.:", ArraysUtil.concatenar(new String[]{" "}, ConstantesGerais.MESES_ANO), 0);
        this.adicionaFiltroNumero("filtroAnoNascimento", "Ano anivers.:", 4);
        this.adicionaFiltroCombo("filtroEstado", "Estado:", this.estados, 0);
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.adicionaFiltroCheck("filtroEmail", "M\u00e9dico com e-mail", false);
        this.checkRemoverInativos = this.adicionaRetornaFiltroCheck("filtroRemoverInativo", "Remover inativos", false);
        this.checkSomenteInativos = this.adicionaRetornaFiltroCheck("filtroSomenteInativo", "Somente inativos", false);
        this.checkRemoverInativos.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (RelatorioMedicos.this.checkRemoverInativos.isSelected()) {
                    RelatorioMedicos.this.checkSomenteInativos.setSelected(false);
                }
            }
        });
        this.checkSomenteInativos.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (RelatorioMedicos.this.checkSomenteInativos.isSelected()) {
                    RelatorioMedicos.this.checkRemoverInativos.setSelected(false);
                }
            }
        });
        if (tipo == TIPO_CADASTRO) {
            this.setModuloConfigurar(this.ACESSO_CONFIGURAR_CADASTRO);
        } else {
            this.setModuloConfigurar(this.ACESSO_CONFIGURAR_MALADIRETA);
        }
        this.setModuloAcesso(RelatorioMedicos.getModuloAcesso(this.tipoRelatorio));
        this.setCamposConfigurador(campos);
    }

    private boolean isAlimentos() {
        return Variaveis.tipoFilialPadrao.equals("A");
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String[] cidade;
            String[] conselhos;
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("select a.med_conselho as conselhoMedico, a.med_crm as crmMedico, a.med_uf as ufMedico, a.med_nome as nomeMedico, ");
            buf.append("a.med_abrev as abreviaturaMedico, a.med_observ as observacaoMedico, a.med_tipo as tipoMedico, ");
            buf.append("a.med_comissao as comissaoMedico, a.med_cep as cepMedico, a.med_complemento as complementoMedico, ");
            buf.append("a.med_endereco as enderecoMedico, a.med_celular as celularMedico, a.med_fax as faxMedico, ");
            buf.append("a.med_numeroendereco as numeroEnderecoMedico, a.med_tipologradouroendereco as tipoLogradouroMedico, ");
            buf.append("a.med_cpf as cpfMedico, a.med_cbo as codigoCBOSMedico, a.med_cbo as descricaoCBOSMedico, ");
            buf.append("a.med_fone as foneMedico, a.med_email as emailMedico, a.med_site as siteMedico, a.med_senhaweb as senhaWebMedico, ");
            buf.append("a.med_datanascimento as dataNascimentoMedico, a.med_inativo as medicoInativo, ");
            buf.append("es.esp_codigo as codigoEspecialidade, es.esp_descricao as descricaoEspecialidade, ");
            buf.append("u.cid_codigo as codigoCidadeMedico, u.cid_nome as descricaoCidadeMedico, u.cid_uf as estadoCidadeMedico, ");
            buf.append("t.bai_codigo as codigoBairroMedico, t.bai_descricao as descricaoBairroMedico, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from medico a ");
            buf.append("left join medicoespecialidades me on a.fil_codigo = me.fil_codigo and a.med_conselho = me.med_conselho and a.med_crm = me.med_crm and a.med_uf = me.med_uf ");
            buf.append("left join especialidades es on me.fil_codigo = es.fil_codigo and me.esp_codigo = es.esp_codigo ");
            buf.append("left join cidades u on a.fil_codigo = u.fil_codigo and a.cid_codigo = u.cid_codigo ");
            buf.append("left join bairro t on a.fil_codigo = t.fil_codigo and a.bai_codigo = t.bai_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            String[] especialidade = this.getSelecionadosFiltro("filtroEspecialidade", 0);
            if (especialidade != null) {
                buf.append(" and me.esp_codigo in (");
                for (int i = 0; i < especialidade.length; ++i) {
                    buf.append(especialidade[i]);
                    if (i >= especialidade.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((conselhos = this.getSelecionadosFiltroArray("filtroConselho")) != null) {
                buf.append(" and a.med_conselho in (");
                for (int i = 0; i < conselhos.length; ++i) {
                    buf.append("'");
                    buf.append(conselhos[i]);
                    buf.append("'");
                    if (i >= conselhos.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            String[] conselho = this.getSelecionadosFiltroAvancado("filtroMedico", 0);
            String[] medico = this.getSelecionadosFiltroAvancado("filtroMedico", 1);
            String[] uf = this.getSelecionadosFiltroAvancado("filtroMedico", 2);
            if (medico != null) {
                buf.append(" and (");
                for (int i = 0; i < medico.length; ++i) {
                    buf.append("(a.med_conselho = '");
                    buf.append(conselho[i]);
                    buf.append("' and a.med_crm = '");
                    buf.append(medico[i]);
                    buf.append("' and a.med_uf = '");
                    buf.append(uf[i]);
                    buf.append("')");
                    if (i >= medico.length - 1) continue;
                    buf.append("  or ");
                }
                buf.append(")");
            }
            if ((cidade = this.getSelecionadosFiltro("filtroCidade", 0)) != null) {
                buf.append(" and a.cid_codigo in (");
                for (int i = 0; i < cidade.length; ++i) {
                    buf.append(cidade[i]);
                    if (i >= cidade.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if (!this.getFiltroCombo("filtroEstado").equals(this.estados[0])) {
                buf.append(" and a.med_uf = '");
                buf.append(this.getFiltroCombo("filtroEstado"));
                buf.append("'");
            }
            if (Funcoes.isNumeric(this.getFiltroNumero("filtroDiaNascimento"))) {
                buf.append(" and extract(day from a.med_datanascimento) = ").append(this.getFiltroNumero("filtroDiaNascimento"));
            }
            if (Funcoes.isNumeric(this.getFiltroNumero("filtroAnoNascimento"))) {
                buf.append(" and extract(year from a.med_datanascimento) = ").append(this.getFiltroNumero("filtroAnoNascimento"));
            }
            if (this.getFiltroComboIndice("filtroMesNascimento") > 0) {
                buf.append(" and extract(month from a.med_datanascimento) = ").append(this.getFiltroComboIndice("filtroMesNascimento"));
            }
            if (this.getFiltroCheck("filtroEmail")) {
                buf.append(" and (a.med_email is not null and trim(a.med_email) <> '') ");
            }
            if (this.checkRemoverInativos.isSelected()) {
                buf.append(" and not a.med_inativo ");
            }
            if (this.checkSomenteInativos.isSelected()) {
                buf.append(" and a.med_inativo ");
            }
            buf.append(" order by me.esp_codigo, ");
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                buf.append("a.med_nome");
            } else {
                buf.append("a.med_conselho, a.med_crm, a.med_uf");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        if (campos[i].equalsIgnoreCase("tipoLogradouroMedico")) {
                            o[i] = Tipos.tipoLogradouroDescricao(rs.getString(campos[i]));
                            continue;
                        }
                        if (campos[i].equals("tipoMedico")) {
                            o[i] = Tipos.tipoMedico(rs.getString("tipoMedico"));
                            continue;
                        }
                        if (campos[i].equals("descricaoCBOSMedico") && !Funcoes.textoVazio(rs.getString("codigoCBOSMedico"))) {
                            o[i] = CBOS.getCBO(rs.getString("codigoCBOSMedico"));
                            continue;
                        }
                        if (campos[i].equals("tituloRelatorio")) {
                            String titulo = "Relat\u00f3rio de M\u00e9dicos";
                            if (this.isAlimentos()) {
                                titulo = "Relat\u00f3rio de Coletadores";
                            }
                            o[i] = titulo;
                            continue;
                        }
                        o[i] = rs.getObject(campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioMedicos.getModuloAcesso(this.tipoRelatorio));
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioMedicos.this.panelCentro.removeAll();
                            RelatorioMedicos.this.panelCentro.repaint();
                            RelatorioMedicos.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    var.put("filtroEstado", this.getFiltroCombo("filtroEstado"));
                    buf.delete(0, buf.length());
                    if (especialidade != null) {
                        for (int i = 0; i < especialidade.length; ++i) {
                            buf.append(especialidade[i]);
                            if (i >= especialidade.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroEspecialidade", buf.toString());
                    buf.delete(0, buf.length());
                    if (cidade != null) {
                        for (int i = 0; i < cidade.length; ++i) {
                            buf.append(cidade[i]);
                            if (i >= cidade.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroCidade", buf.toString());
                    buf.delete(0, buf.length());
                    if (medico != null) {
                        for (int i = 0; i < medico.length; ++i) {
                            buf.append(conselho[i]).append(": ");
                            buf.append(medico[i]);
                            buf.append(" [");
                            buf.append(uf[i]);
                            buf.append("]");
                            if (i >= medico.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroMedico", buf.toString());
                    var.put("tituloRelatorio", "Relat\u00f3rio de M\u00e9dicos");
                    if (this.isAlimentos()) {
                        var.put("tituloRelatorio", "Relat\u00f3rio de Coletadores");
                    }
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso(int tipo) {
        if (tipo == TIPO_CADASTRO) {
            return Long.parseLong("0811500200");
        }
        return Long.parseLong("0890400100");
    }
}

