/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.cadastros;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioMateriais
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String[] ordem = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"};
    private final long ACESSO_CONFIGURAR = Long.parseLong("0811300301");
    private final String FILTRO_TIPO = "filtroTipo";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoUnidadeMedida", "descricaoUnidadeMedida", "codigoTipoMaterial", "descricaoTipoMaterial", "codigoMaterial", "descricaoMaterial", "valorUnitarioMaterial", "valorUltimaCompraMaterial", "dataUltimaCompraMaterial", "quantidadeUltimaCompraMaterial", "pontoReposicaoMaterial", "dataUltimaEntregaMaterial"});

    public RelatorioMateriais() {
        this.setName("RelatorioMateriais");
        this.montaBarraDescricao("Relat\u00f3rio de materiais", "Listagem dos materiais cadastrados", "relatorios/rel_material.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroTipo", "Tipo", "tipomaterial", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"tpm_codigo", "tpm_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.setModuloConfigurar(this.ACESSO_CONFIGURAR);
        this.setModuloAcesso(RelatorioMateriais.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("select a.mat_codigo as codigoMaterial, a.mat_descricao as descricaoMaterial, ");
            buf.append("a.mat_valorunit as valorUnitarioMaterial, a.mat_valorultcompra as valorUltimaCompraMaterial, ");
            buf.append("a.mat_dataultcompra as dataUltimaCompraMaterial, a.mat_qtdeultcompra as quantidadeUltimaCompraMaterial, ");
            buf.append("a.mat_ptoreposicao as pontoReposicaoMaterial, a.mat_dataultentrega as dataUltimaEntregaMaterial, ");
            buf.append("u.unm_codigo as codigoUnidadeMedida, u.unm_descricao as descricaoUnidadeMedida, ");
            buf.append("t.tpm_codigo as codigoTipoMaterial, t.tpm_descricao as descricaoTipoMaterial, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from material a ");
            buf.append("left join unidademedida u on a.fil_codigo = u.fil_codigo and a.unm_codigo = u.unm_codigo ");
            buf.append("left join tipomaterial t on a.fil_codigo = t.fil_codigo and a.tpm_codigo = t.tpm_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            String[] tipos = this.getSelecionadosFiltro("filtroTipo", 0);
            if (tipos != null) {
                buf.append(" and a.tpm_codigo in (");
                for (int i = 0; i < tipos.length; ++i) {
                    buf.append(tipos[i]);
                    if (i >= tipos.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            buf.append("order by t.tpm_codigo, ");
            if (this.getFiltroCombo("ordemRelatorio").equals("Descri\u00e7\u00e3o")) {
                buf.append("a.mat_descricao");
            } else {
                buf.append("a.mat_codigo");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        o[i] = rs.getObject(campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioMateriais.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioMateriais.this.panelCentro.removeAll();
                            RelatorioMateriais.this.panelCentro.repaint();
                            RelatorioMateriais.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    buf.delete(0, buf.length());
                    if (tipos != null) {
                        for (int i = 0; i < tipos.length; ++i) {
                            buf.append(tipos[i]);
                            if (i >= tipos.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroTipo", buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0811300300");
    }
}

