/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.cadastros;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioHistoricos
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_SETOR = "filtroSetor";
    private final String FILTRO_EXAME = "filtroExame";
    private final String[] ordem = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"};
    private final long ACESSO_CONFIGURAR = Long.parseLong("0811900701");
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoHistorico", "descricaoHistorico"});

    public RelatorioHistoricos() {
        this.setName("RelatorioHistoricos");
        this.montaBarraDescricao("Relat\u00f3rio de hist\u00f3ricos", "Listagem dos hist\u00f3ricos cadastrados", "relatorios/rel_historico.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroSetor", "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroExame", "Exame", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.setModuloConfigurar(this.ACESSO_CONFIGURAR);
        this.setModuloAcesso(RelatorioHistoricos.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            int i;
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            String[] setor = this.getSelecionadosFiltro("filtroSetor", 0);
            String[] exame = this.getSelecionadosFiltro("filtroExame", 0);
            buf.append("select ");
            if (setor != null && setor.length > 0) {
                buf.append(" distinct ");
            }
            buf.append("a.his_codigo as codigoHistorico, ");
            buf.append("a.his_descricao as descricaoHistorico, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            if (setor != null && setor.length > 0 && (exame == null || exame.length == 0)) {
                buf.append("from examesetor b ");
                buf.append("left join examehistorico c on b.fil_codigo = c.fil_codigo and b.exa_codigo = c.exa_codigo ");
                buf.append("left join historicos a on c.fil_codigo = a.fil_codigo and c.his_codigo = a.his_codigo ");
            } else if (exame != null && exame.length > 0) {
                buf.append("from examehistorico c ");
                buf.append("left join historicos a on c.fil_codigo = a.fil_codigo and c.his_codigo = a.his_codigo ");
            } else {
                buf.append("from historicos a ");
            }
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append(" where a.fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            if (setor != null && exame == null) {
                buf.append(" and b.set_codigo in (");
                for (i = 0; i < setor.length; ++i) {
                    buf.append(setor[i]);
                    if (i >= setor.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            } else if (exame != null) {
                buf.append(" and c.exa_codigo in (");
                for (i = 0; i < exame.length; ++i) {
                    buf.append("'").append(exame[i]).append("' ");
                    if (i >= exame.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            buf.append(" order by ");
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                buf.append("a.his_descricao");
            } else {
                buf.append("a.his_codigo");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i2 = 0; i2 < campos.length; ++i2) {
                        o[i2] = rs.getObject(campos[i2]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioHistoricos.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i3;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioHistoricos.this.panelCentro.removeAll();
                            RelatorioHistoricos.this.panelCentro.repaint();
                            RelatorioHistoricos.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    buf.delete(0, buf.length());
                    if (setor != null) {
                        for (i3 = 0; i3 < setor.length; ++i3) {
                            buf.append(setor[i3]);
                            if (i3 >= setor.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroSetor", buf.toString());
                    buf.delete(0, buf.length());
                    if (exame != null) {
                        for (i3 = 0; i3 < exame.length; ++i3) {
                            buf.append(exame[i3]);
                            if (i3 >= exame.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroExame", buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0811900700");
    }
}

