/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.cadastros;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioFiliais
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String[] ordem = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Raz\u00e3o social"};
    private final long ACESSO_CONFIGURAR = Long.parseLong("0810900001");
    private final String FILTRO_ORDEM = "ordemRelatorio";
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoFiliais", "descricaoFiliais", "cnpjFiliais", "enderecoFiliais", "complementoFiliais", "cepFiliais", "CNESFiliais", "foneFiliais", "faxFiliais", "razaoSocialFiliais", "responsavelFiliais", "codigoCidadeFiliais", "descricaoCidadeFiliais", "estadoCidadeFiliais", "codigoBairroFiliais", "descricaoBairroFiliais"});

    public RelatorioFiliais() {
        this.setName("RelatorioFiliais");
        this.montaBarraDescricao("Relat\u00f3rio de Filiais", "Listagem das filiais cadastradas", "relatorios/rel_filial.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.setModuloConfigurar(this.ACESSO_CONFIGURAR);
        this.setModuloAcesso(RelatorioFiliais.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("select a.fil_codigo as codigoFiliais, a.fil_descricao as descricaoFiliais, a.fil_cnpj as cnpjFiliais, a.fil_endereco as enderecoFiliais, ");
            buf.append("a.fil_complemento as complementoFiliais, a.fil_cep as cepFiliais, a.fil_fone as foneFiliais, a.fil_fax as faxFiliais, ");
            buf.append("a.fil_razaosocial as razaoSocialFiliais, a.fil_responsavel as responsavelFiliais, a.fil_cnes as CNESFiliais, ");
            buf.append("f.cid_codigo as codigoCidadefiliais, f.cid_nome as descricaoCidadefiliais, f.cid_uf as estadoCidadefiliais,");
            buf.append("e.bai_codigo as codigoBairrofiliais, e.bai_descricao as descricaoBairrofiliais, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from filiais_postocoleta a ");
            buf.append("left join cidades f on a.fil_codigo = f.fil_codigo and a.cid_codigo = f.cid_codigo ");
            buf.append("left join bairro e on a.fil_codigo = e.fil_codigo and a.bai_codigo = e.bai_codigo ");
            buf.append("left join filiais_postocoleta filial on filial.fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            buf.append("left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo ");
            buf.append("left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append("order by ");
            if (this.getFiltroCombo("ordemRelatorio").equals("Descri\u00e7\u00e3o")) {
                buf.append("a.fil_descricao");
            } else if (this.getFiltroCombo("ordemRelatorio").equals("C\u00f3digo")) {
                buf.append("a.fil_codigo");
            } else {
                buf.append("a.fil_razaosocial");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        o[i] = rs.getObject(campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioFiliais.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioFiliais.this.panelCentro.removeAll();
                            RelatorioFiliais.this.panelCentro.repaint();
                            RelatorioFiliais.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0810900000");
    }
}

