/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.cadastros;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioFichaTecnica
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_MATERIAL = "filtroMaterial";
    private final String FILTRO_MATERIAL_INATIVO = "filtroMaterialInativo";
    public static final String[] camposUnidadeMedida = new String[]{"codigoUnidadeMedida", "descricaoUnidadeMedida"};
    public static final String[] camposTipoMaterial = new String[]{"codigoTipoMaterial", "descricaoTipoMaterial"};
    public static final String[] camposUnidadeMedidaFilho = new String[]{"codigoUnidadeMedidaFilho", "descricaoUnidadeMedidaFilho"};
    public static final String[] camposTipoMaterialFilho = new String[]{"codigoTipoMaterialFilho", "descricaoTipoMaterialFilho"};
    public static final String[] camposFichaTecnicaMaterial = new String[]{"codigoMaterialFilho", "quantidadeFichaTecnica"};
    public static final String[] camposMaterial = new String[]{"codigoMaterial", "descricaoMaterial", "valorUnitarioMaterial", "materialInativo", "valorUltimaCompraMaterial", "dataUltimaCompraMaterial", "quantidadeUltimaCompraMaterial", "pontoReposicaoMaterial", "dataUltimaEntregaMaterial"};
    public static final String[] camposMaterialFilho = new String[]{"descricaoMaterialFilho", "valorUnitarioMaterialFilho", "valorUltimaCompraMaterialFilho", "dataUltimaCompraMaterialFilho", "quantidadeUltimaCompraMaterialFilho", "pontoReposicaoMaterialFilho", "dataUltimaEntregaMaterialFilho"};
    public static final String[] camposRelatorio = ArraysUtil.concatenar(ArraysUtil.concatenar(ArraysUtil.concatenar(ArraysUtil.concatenar(ArraysUtil.concatenar(ArraysUtil.concatenar(ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, camposMaterial), camposFichaTecnicaMaterial), camposTipoMaterial), camposUnidadeMedida), camposMaterialFilho), camposUnidadeMedidaFilho), camposTipoMaterialFilho);

    public RelatorioFichaTecnica() {
        this.setName("RelatorioFichaTecnica");
        this.montaBarraDescricao("Relat\u00f3rio de Ficha T\u00e9cnica", "Listagem da ficha t\u00e9nica de materiais", "relatorios/rel_cad_materiais_ficha_tecnica.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroMaterial", "Material", "material", "fil_codigo = " + Variaveis.filialPadrao + " and mat_fichatecnica = true ", 1, new String[]{"mat_codigo", "mat_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroCheck("filtroMaterialInativo", "Mostrar material inativo", false);
        this.setModuloConfigurar(RelatorioFichaTecnica.getModuloConfigurar());
        this.setModuloAcesso(RelatorioFichaTecnica.getModuloAcesso());
        this.setCamposConfigurador(camposRelatorio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st;
        block19: {
            st = Conexao.getStatement();
            String[] material = this.getSelecionadosFiltro("filtroMaterial", 0);
            if (material == null || material.length == 0) {
                Funcoes.mensagem(this, "Um material deve ser selecionado para o relat\u00f3rio", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            try {
                int i;
                StringBuilder buf = new StringBuilder();
                buf.append(" select a.mat_codigo \t\t   \tas codigoMaterial, ");
                buf.append("        a.mat_codigofilho \tas codigoMaterialFilho, ");
                buf.append("        a.fch_quantidade \t  as quantidadeFichaTecnica, ");
                buf.append("        matf.mat_descricao\tas descricaoMaterialFilho, ");
                buf.append("        matf.mat_valorunit\tas valorUnitarioMaterialFilho, ");
                buf.append("\t\tmatf.mat_valorultcompra as valorUltimaCompraMaterialFilho, ");
                buf.append("\t\tmatf.mat_dataultcompra\tas dataUltimaCompraMaterialFilho, ");
                buf.append("\t\tmatf.mat_qtdeultcompra\tas quantidadeUltimaCompraMaterialFilho, ");
                buf.append("\t\tmatf.mat_ptoreposicao\t  as pontoReposicaoMaterialFilho, ");
                buf.append("\t\tmatf.mat_dataultentrega\tas dataUltimaEntregaMaterialFilho, ");
                buf.append("        mat.mat_descricao \tas descricaoMaterial, ");
                buf.append("        mat.mat_valorunit\t\tas valorUnitarioMaterial, ");
                buf.append("\t\tmat.mat_valorultcompra \tas valorUltimaCompraMaterial, ");
                buf.append("\t\tmat.mat_dataultcompra\t  as dataUltimaCompraMaterial, ");
                buf.append("\t\tmat.mat_qtdeultcompra\t  as quantidadeUltimaCompraMaterial, ");
                buf.append("\t\tmat.mat_ptoreposicao\t  as pontoReposicaoMaterial, ");
                buf.append("\t\tmat.mat_dataultentrega\tas dataUltimaEntregaMaterial, ");
                buf.append("    mat.mat_inativo \t\t\t\tas materialInativo, ");
                buf.append("\t\tunm.unm_codigo\t\t\t\t\tas codigoUnidadeMedida, ");
                buf.append("\t\tunm.unm_descricao\t\t\t\tas descricaoUnidadeMedida, ");
                buf.append("\t\ttpm.tpm_codigo\t\t\t\t\tas codigoTipoMaterial, ");
                buf.append("\t\ttpm.tpm_descricao\t\t\t\tas descricaoTipoMaterial, ");
                buf.append("\t\tunmf.unm_codigo\t\t\t\t\tas codigoUnidadeMedidaFilho, ");
                buf.append("\t\tunmf.unm_descricao\t\t\tas descricaoUnidadeMedidaFilho, ");
                buf.append("\t\ttpmf.tpm_codigo\t\t\t\t\tas codigoTipoMaterialFilho, ");
                buf.append("\t\ttpmf.tpm_descricao\t\t\tas descricaoTipoMaterialFilho, ");
                buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                buf.append("   from fichatecnicamaterial a ");
                buf.append("   left join material mat on (a.fil_codigo = mat.fil_codigo and a.mat_codigo = mat.mat_codigo) ");
                buf.append("   left join material matf on (a.fil_codigo = matf.fil_codigo and a.mat_codigofilho = matf.mat_codigo) ");
                buf.append("   left join unidademedida unm on (mat.fil_codigo = unm.fil_codigo and mat.unm_codigo = unm.unm_codigo) ");
                buf.append("   left join tipomaterial tpm on (mat.fil_codigo = tpm.fil_codigo and mat.tpm_codigo = tpm.tpm_codigo) ");
                buf.append("   left join unidademedida unmf on (matf.fil_codigo = unmf.fil_codigo and matf.unm_codigo = unmf.unm_codigo) ");
                buf.append("   left join tipomaterial tpmf on (matf.fil_codigo = tpmf.fil_codigo and matf.tpm_codigo = tpmf.tpm_codigo) ");
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                buf.append("  where a.fil_codigo ");
                String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
                if (filiais == null || filiais.length == 0) {
                    buf.append(" = ").append(Variaveis.filialPadrao);
                } else {
                    buf.append(" in (");
                    for (i = 0; i < filiais.length; ++i) {
                        buf.append(filiais[i]);
                        if (i >= filiais.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if (material != null) {
                    buf.append(" and a.mat_codigo in (");
                    for (i = 0; i < material.length; ++i) {
                        buf.append("'");
                        buf.append(material[i]);
                        buf.append("'");
                        if (i >= material.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if (!this.getFiltroCheck("filtroMaterialInativo")) {
                    buf.append(" and mat.mat_inativo = false ");
                }
                buf.append(" order by a.fil_codigo, a.mat_codigo ");
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    ModeloGridTable modelo = new ModeloGridTable(camposRelatorio);
                    do {
                        Object[] o = new Object[camposRelatorio.length];
                        for (int i2 = 0; i2 < camposRelatorio.length; ++i2) {
                            o[modelo.findColumn((String)RelatorioFichaTecnica.camposRelatorio[i2])] = camposRelatorio[i2].equalsIgnoreCase("materialInativo") ? (rs.getBoolean(camposRelatorio[i2]) ? "Sim" : "N\u00e3o") : rs.getObject(camposRelatorio[i2]);
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioFichaTecnica.getModuloAcesso());
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        int i3;
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(1.0f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioFichaTecnica.this.panelCentro.removeAll();
                                RelatorioFichaTecnica.this.panelCentro.repaint();
                                RelatorioFichaTecnica.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        buf.delete(0, buf.length());
                        if (filiais != null) {
                            for (i3 = 0; i3 < filiais.length; ++i3) {
                                buf.append(filiais[i3]);
                                if (i3 >= filiais.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroFilial", buf.toString().isEmpty() ? Variaveis.filialPadrao : buf.toString());
                        buf.delete(0, buf.length());
                        if (material != null) {
                            for (i3 = 0; i3 < material.length; ++i3) {
                                buf.append(material[i3]);
                                if (i3 >= material.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroMaterial", buf.toString());
                        var.put("filtroMaterialInativo", this.getFiltroCheck("filtroMaterialInativo") ? " Sim " : " N\u00e3o ");
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block19;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0811300400");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0811300401");
    }
}

