/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.cadastros;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioExamesRecipientes
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_MATERIAL = "filtroMaterial";
    private final String FILTRO_PRAZO = "filtroPrazo";
    private final String FILTRO_METODOLOGIA = "filtroMetodologia";
    private final String FILTRO_TIPO = "filtroTipo";
    private final String FILTRO_SETOR = "filtroSetor";
    private final String FILTRO_RECIPIENTE = "filtroRecipiente";
    private final String FILTRO_SITUACAO_MATERIAL = "filtroSituacaoMaterial";
    private final String[] ordem = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"};
    private final String[] tipo = new String[]{"Coleta", "Triagem"};
    private final String[] material = new String[]{"Todas", "Liberados", "Proibidos"};
    private final long ACESSO_CONFIGURAR = Long.parseLong("0811901121");
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoExame", "descricaoExame", "sexoExame", "materialPadraoExame", "horaEntradaExame", "horaSaidaExame", "filtroExame", "proibidoExame", "diagnosticoExame", "interferenciaExame", "sinonimoExame", "salvaParcialExame", "idadeMaximaExame", "idadeMinimaExame", "tipoIdadeMaximaExame", "tipoIdadeMinimaExame", "proibidoWebExame", "quantidadeAmostrasExame", "materialPadraoExame", "preaparoExame", "preparoAmostraExame", "inadequadaExame", "codigoPrazoEntrega", "codigoMetodologia", "ordemExame", "paginaExame", "cbhpmExame", "ambExame", "conservacaoExame", "diasConservacaoExame", "temperaturaInicialExame", "temperaturaFinalExame", "referenciaExame", "procedimentoExame", "solicitarJejumExame", "solicitarMedicamentoExame", "solicitarDUMExame", "codigoMaterialColetado", "solicitarTempoDiureseExame", "instrucaoColetaExame", "marcarExternoExame", "descricaoPrazoEntrega", "rotinaPrazoEntrega", "diasPrazoEntrega", "horaEntradaPrazoEntrega", "horaSaidaPrazoEntrega", "descricaoMetodologia", "descricaoMaterialColetado", "solicitarMaterialMaterialColetado", "abreviaturaMaterialColetado", "codigoSetor", "descricaoSetor", "responsavelSetor", "corSetor", "siglaSetor", "codigoUsuario", "nomeUsuario", "codigoRecipiente", "descricaoRecipiente", "tipoRecipiente", "capacidadeRecipiente", "volumeUtilizadoExame", "codigoUnidadeMedida", "descricaoUnidadeMedida", "proibidoExameMaterial"});

    public RelatorioExamesRecipientes() {
        this.setName("RelatorioExamesRecipientes");
        this.montaBarraDescricao("Relat\u00f3rio de recipientes por exame", "Listagem dos recipientes utilizados por exame", "relatorios/rel_recip_exames.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroMaterial", "Material", "materialcoleta", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"mco_codigo", "mco_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroPrazo", "Prazo", "prazoentrega", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"prz_codigo", "prz_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroMetodologia", "Metodologia", "metodologia", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"met_codigo", "met_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSetor", "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroRecipiente", "Recipiente", "recipientes", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"rec_codigo", "rec_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroCombo("filtroTipo", "Tipo", this.tipo, 0);
        this.adicionaFiltroCombo("filtroSituacaoMaterial", "Situa\u00e7\u00e3o:", this.material, 0);
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.setModuloConfigurar(this.ACESSO_CONFIGURAR);
        this.setModuloAcesso(RelatorioExamesRecipientes.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String[] recipiente;
            String[] setor;
            String[] metodologia;
            String[] prazos;
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("select a.exa_codigo as codigoExame, ");
            buf.append("a.exa_descricao as descricaoExame, ");
            buf.append("a.exa_sexo as sexoExame, ");
            buf.append("a.exa_horaentrada as horaEntradaExame, ");
            buf.append("a.exa_horasaida as horaSaidaExame, ");
            buf.append("a.exa_filtro as filtroExame, ");
            buf.append("a.exa_proibido as proibidoExame, ");
            buf.append("a.exa_diagnostico as diagnosticoExame, ");
            buf.append("a.exa_interferencia as interferenciaExame, ");
            buf.append("a.exa_sinonimo as sinonimoExame, ");
            buf.append("a.exa_salvaparcial as salvaParcialExame, ");
            buf.append("a.exa_idademax as idadeMaximaExame, ");
            buf.append("a.exa_idademin as idadeMinimaExame, ");
            buf.append("a.exa_idademaxtipo as tipoIdadeMaximaExame, ");
            buf.append("a.exa_idademintipo as tipoIdadeMinimaExame, ");
            buf.append("a.exa_proibidoweb as proibidoWebExame, ");
            buf.append("a.exa_qtdeamostras as quantidadeAmostrasExame, ");
            buf.append("b.emc_default as materialPadraoExame, ");
            buf.append("b.emc_preparo as preaparoExame, ");
            buf.append("b.emc_prepamostra as preparoAmostraExame, ");
            buf.append("b.emc_proibido as proibidoExameMaterial, ");
            buf.append("b.emc_inadequada as inadequadaExame, ");
            buf.append("b.prz_codigo as codigoPrazoEntrega, ");
            buf.append("b.met_codigo as codigoMetodologia, ");
            buf.append("b.emc_ordem as ordemExame, ");
            buf.append("b.emc_pagina as paginaExame, ");
            buf.append("b.emc_codigocbhpm as cbhpmExame, ");
            buf.append("b.emc_codigoamb as ambExame, ");
            buf.append("b.emc_conservacao as conservacaoExame, ");
            buf.append("b.emc_diasconserva as diasConservacaoExame, ");
            buf.append("b.emc_temperaturainicial as temperaturaInicialExame, ");
            buf.append("b.emc_temperaturafinal as temperaturaFinalExame, ");
            buf.append("b.emc_referencia as referenciaExame, ");
            buf.append("b.emc_procedimento as procedimentoExame, ");
            buf.append("b.emc_solicitarjejum as solicitarJejumExame, ");
            buf.append("b.emc_obrigamedicamento as solicitarMedicamentoExame, ");
            buf.append("b.emc_obrigadum as solicitarDUMExame, ");
            buf.append("b.emc_obrigapeso as solicitarPesoExame, ");
            buf.append("b.emc_obrigaaltura as solicitarAlturaExame, ");
            buf.append("b.emc_obrigavolume as solicitarVolumeExame, ");
            buf.append("b.emc_obrigatempodiurese as solicitarTempoDiureseExame, ");
            buf.append("b.emc_instrcoleta as instrucaoColetaExame, ");
            buf.append("b.emc_marcarexterno as marcarExternoExame, ");
            buf.append("c.prz_descricao as descricaoPrazoEntrega, ");
            buf.append("c.prz_prazo as rotinaPrazoEntrega, ");
            buf.append("c.prz_dias as diasPrazoEntrega, ");
            buf.append("c.prz_horaentrada as horaEntradaPrazoEntrega, ");
            buf.append("c.prz_horasaida as horaSaidaPrazoEntrega, ");
            buf.append("d.met_descricao as descricaoMetodologia, ");
            buf.append("e.mco_codigo as codigoMaterialColetado, ");
            buf.append("e.mco_descricao as descricaoMaterialColetado, ");
            buf.append("e.mco_solicitarmat as solicitarMaterialMaterialColetado, ");
            buf.append("e.mco_abreviatura as abreviaturaMaterialColetado, ");
            buf.append("f.set_codigo as codigoSetor, ");
            buf.append("g.set_descricao as descricaoSetor, ");
            buf.append("g.set_responsavel as responsavelSetor, ");
            buf.append("g.set_cor as corSetor, ");
            buf.append("g.set_sigla as siglaSetor, ");
            buf.append("h.usr_codigo as codigoUsuario, ");
            buf.append("h.usr_nome as nomeUsuario, ");
            buf.append("r.rec_codigo as codigoRecipiente, ");
            buf.append("r.rec_descricao as descricaoRecipiente, ");
            buf.append("r.rec_tipo as tipoRecipiente, ");
            buf.append("r.rec_capacidade as capacidadeRecipiente, ");
            buf.append("u.unm_codigo as codigoUnidadeMedida, ");
            buf.append("u.unm_descricao as descricaoUnidadeMedida, ");
            if (this.getFiltroCombo("filtroTipo").equals(this.tipo[0])) {
                buf.append(" rc.rco_volume as volumeUtilizadoExame, ");
            } else {
                buf.append(" rc.rtr_volume as volumeUtilizadoExame, ");
            }
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from exames a ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append(" left join examematcoleta b on a.fil_codigo = b.fil_codigo ");
            buf.append(" and a.exa_codigo = b.exa_codigo ");
            buf.append(" left join prazoentrega c on a.fil_codigo = c.fil_codigo ");
            buf.append(" and b.prz_codigo = c.prz_codigo ");
            buf.append(" left join metodologia d on a.fil_codigo = d.fil_codigo ");
            buf.append(" and b.met_codigo = d.met_codigo ");
            buf.append(" left join materialcoleta e on a.fil_codigo = e.fil_codigo ");
            buf.append(" and b.mco_codigo = e.mco_codigo ");
            buf.append(" left join examesetor f on a.fil_codigo = f.fil_codigo ");
            buf.append(" and a.exa_codigo = f.exa_codigo ");
            buf.append(" and f.ese_default = true");
            buf.append(" left join setores g on a.fil_codigo = g.fil_codigo ");
            buf.append(" and f.set_codigo = g.set_codigo ");
            buf.append(" left join usuario h on g.usr_codigo = h.usr_codigo ");
            if (this.getFiltroCombo("filtroTipo").equals(this.tipo[0])) {
                buf.append(" left join recipcoleta rc on b.fil_codigo = rc.fil_codigo and b.exa_codigo = rc.exa_codigo and b.mco_codigo = rc.mco_codigo ");
            } else {
                buf.append(" left join reciptriagem rc on b.fil_codigo = rc.fil_codigo and b.exa_codigo = rc.exa_codigo and b.mco_codigo = rc.mco_codigo ");
            }
            buf.append("left join recipientes r on rc.fil_codigo = r.fil_codigo and rc.rec_codigo = r.rec_codigo ");
            buf.append("left join unidademedida u on r.fil_codigo = u.fil_codigo and r.unm_codigo = u.unm_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            String[] materiais = this.getSelecionadosFiltro("filtroMaterial", 0);
            if (materiais != null) {
                buf.append(" and b.mco_codigo in (");
                for (int i = 0; i < materiais.length; ++i) {
                    buf.append(materiais[i]);
                    if (i >= materiais.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if ((prazos = this.getSelecionadosFiltro("filtroPrazo", 0)) != null) {
                buf.append(" and b.prz_codigo in (");
                for (int i = 0; i < prazos.length; ++i) {
                    buf.append(prazos[i]);
                    if (i >= prazos.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if ((metodologia = this.getSelecionadosFiltro("filtroMetodologia", 0)) != null) {
                buf.append(" and b.met_codigo in (");
                for (int i = 0; i < metodologia.length; ++i) {
                    buf.append(metodologia[i]);
                    if (i >= metodologia.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if ((setor = this.getSelecionadosFiltro("filtroSetor", 0)) != null) {
                buf.append(" and f.set_codigo in (");
                for (int i = 0; i < setor.length; ++i) {
                    buf.append(setor[i]);
                    if (i >= setor.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if ((recipiente = this.getSelecionadosFiltro("filtroRecipiente", 0)) != null) {
                buf.append(" and r.rec_codigo in (");
                for (int i = 0; i < recipiente.length; ++i) {
                    buf.append(recipiente[i]);
                    if (i >= recipiente.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if (this.getFiltroCombo("filtroSituacaoMaterial").equals(this.material[1])) {
                buf.append(" and (b.emc_proibido = false and not a.exa_proibido) ");
            } else if (this.getFiltroCombo("filtroSituacaoMaterial").equals(this.material[2])) {
                buf.append(" and (b.emc_proibido = true or a.exa_proibido) ");
            }
            buf.append(" order by a.exa_codigo, ");
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                buf.append("a.exa_descricao");
            } else {
                buf.append("a.exa_codigo");
            }
            buf.append(", b.mco_codigo");
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        Object object = o[i] = campos[i].indexOf("tipo") >= 0 ? Tipos.tipoIdade(rs.getString(campos[i])) : rs.getObject(campos[i]);
                        if (!campos[i].equals("proibidoExameMaterial")) continue;
                        o[i] = !rs.getBoolean(campos[i]) ? "Liberado" : "Proibido";
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioExamesRecipientes.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioExamesRecipientes.this.panelCentro.removeAll();
                            RelatorioExamesRecipientes.this.panelCentro.repaint();
                            RelatorioExamesRecipientes.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    var.put("filtroSituacaoMaterial", this.getFiltroCombo("filtroSituacaoMaterial"));
                    buf.delete(0, buf.length());
                    if (materiais != null) {
                        for (i = 0; i < materiais.length; ++i) {
                            buf.append(materiais[i]);
                            if (i >= materiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroMaterial", buf.toString());
                    buf.delete(0, buf.length());
                    if (prazos != null) {
                        for (i = 0; i < prazos.length; ++i) {
                            buf.append(prazos[i]);
                            if (i >= prazos.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroPrazo", buf.toString());
                    buf.delete(0, buf.length());
                    if (metodologia != null) {
                        for (i = 0; i < metodologia.length; ++i) {
                            buf.append(metodologia[i]);
                            if (i >= metodologia.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroMetodologia", buf.toString());
                    buf.delete(0, buf.length());
                    if (setor != null) {
                        for (i = 0; i < setor.length; ++i) {
                            buf.append(setor[i]);
                            if (i >= setor.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroSetor", buf.toString());
                    buf.delete(0, buf.length());
                    if (recipiente != null) {
                        for (i = 0; i < recipiente.length; ++i) {
                            buf.append(recipiente);
                            if (i >= recipiente.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroRecipiente", buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0811901120");
    }
}

