/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.cadastros;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.service.relatorio.RelatorioExamesOperadoraSaudeService;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableModel;

public class RelatorioExamesOperadoraSaude
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_OPERADORA = "filtroOperadora";
    private final String FILTRO_EXAME = "filtroExame";
    private final String FILTRO_MODELO = "filtroModelo";
    private final String FILTRO_METODO = "filtroMetodo";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_SOMENTE_NAO_CONFIGURADOS = "filtroSomenteNaoConfigurados";
    private final String MK_SAUDE = "MK Sa\u00fade";
    private final String DATA_HEALTH = "Data Health";
    private final String[] ordem = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Material", "Modelo"};
    private final long ACESSO_CONFIGURAR = Long.parseLong("0811901143");
    private Map<String, String> listaExamesOperadora = new LinkedHashMap<String, String>();
    private final String VTRP = "integracaovtrp";
    private final String IBITINGA = "integracaoibitinga";
    private final String UPY = "integracaoupy";
    boolean isCheckSomenteNaoConfigurados = false;
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoExame", "descricaoExame", "codigoMaterialColeta", "descricaoMaterialColeta", "abreviaturaMaterialColeta", "modeloCodigo", "modeloDescricao", "metodoC\u00f3digo", "materialColetaPadraoExame", "modeloPadraoExameMatColeta", "metodoPadraoExameMatColeta", "metodoDescricao", "descricaoAbreviadaOperadora", "descricaoOperadoraSaude", "codigoAgrupado"});
    private static HashMap<String, String> MAPA_TODOS_CAMPOS_DISPONIVEIS = new HashMap();
    private static String LIGACOES = "";
    private static HashMap<String, String> camposUtilizados = new HashMap();
    RelatorioExamesOperadoraSaudeService operadoraService = new RelatorioExamesOperadoraSaudeService();

    public RelatorioExamesOperadoraSaude() {
        this.setName("RelatorioExamesOperadoraSaude");
        this.montaBarraDescricao("Relat\u00f3rio de exames por Operadora de Sa\u00fade", "Listagem dos exames configurados para integra\u00e7\u00e3o com Operadora de Sa\u00fade", "rel_exames_operadora.jpg");
        this.adicionaRelatorioListener(this);
        ArrayList<String> operadorasSaude = this.getOperadorasSaude();
        String[] operadoras = operadorasSaude.toArray(new String[0]);
        this.adicionaItemFiltro("filtroOperadora", "Operadora", operadoras, new String[]{"Descri\u00e7\u00e3o"});
        this.adicionaItemFiltro("filtroExame", "Exame", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroModelo", "Modelo", "layout", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"lay_codigo", "lay_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroMetodo", "M\u00e9todo", "metodologia", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"met_codigo", "met_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        final JCheckBox checkSomenteNaoConfigurados = this.adicionaRetornaFiltroCheck("filtroSomenteNaoConfigurados", "Somente n\u00e3o configurados", false);
        checkSomenteNaoConfigurados.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RelatorioExamesOperadoraSaude.this.isCheckSomenteNaoConfigurados = checkSomenteNaoConfigurados.isSelected();
            }
        });
        this.setModuloConfigurar(this.ACESSO_CONFIGURAR);
        this.setModuloAcesso(RelatorioExamesOperadoraSaude.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    public ArrayList<String> getOperadorasSaude() {
        ArrayList<String> operadoras = new ArrayList<String>();
        for (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocolo : FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.values()) {
            if (protocolo.getDescricao().equalsIgnoreCase("MK Sa\u00fade") || protocolo.getDescricao().equalsIgnoreCase("Data Health")) continue;
            operadoras.add(protocolo.getDescricao());
        }
        return operadoras;
    }

    @Override
    public void imprimirPressionado() {
        try {
            if (this.validaFiltroOperadora()) {
                Funcoes.mensagem(this, "Uma Operadora de Sa\u00fade deve ser selecionada", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (Funcoes.textoVazio(this.operadoraService.retornaLayoutRelatorio(RelatorioExamesOperadoraSaude.getModuloAcesso()))) {
                Funcoes.mensagem(this, "Modelo n\u00e3o localizado ou n\u00e3o definido.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            camposUtilizados = new HashMap();
            String[] operadoras = this.getSelecionadosFiltroArray("filtroOperadora");
            String[] exames = this.getSelecionadosFiltro("filtroExame", 0);
            String[] modelos = this.getSelecionadosFiltro("filtroModelo", 0);
            String[] metodos = this.getSelecionadosFiltro("filtroMetodo", 0);
            String odemRel = (String)this.getFiltroCombo("ordemRelatorio");
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.imprimirRelatorio(this, this.panelCentro, operadoras, exames, metodos, modelos, this.isCheckSomenteNaoConfigurados, odemRel, new Runnable(){

                @Override
                public void run() {
                    RelatorioExamesOperadoraSaude.this.panelCentro.removeAll();
                    RelatorioExamesOperadoraSaude.this.panelCentro.repaint();
                    RelatorioExamesOperadoraSaude.this.habilitaBotaoImprimir(true);
                }
            }, new Runnable(){

                @Override
                public void run() {
                    RelatorioExamesOperadoraSaude.this.habilitaBotaoImprimir(true);
                }
            });
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void imprimirRelatorio(RelatorioExamesOperadoraSaude pai, JPanel panel, String[] operadoras, String[] exames, String[] metodos, String[] modelos, boolean isCheckSomenteNaoConfigurados, String odemRel, Runnable acaoFechar, Runnable acaoFimRelatorio) throws SQLException {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        ModeloGridTable modelo = this.operadoraService.retornaSqlRelatorio(operadoras, exames, metodos, modelos, isCheckSomenteNaoConfigurados, odemRel);
        if (modelo == null) {
            Funcoes.mensagem(pai, "N\u00e3o h\u00e1 dados para imprimir.", 2);
            if (acaoFimRelatorio != null) {
                acaoFimRelatorio.run();
            }
            Conexao.fecharStatement(st, st2);
            return;
        }
        String layout = this.operadoraService.retornaLayoutRelatorio(RelatorioExamesOperadoraSaude.getModuloAcesso());
        if (!Funcoes.textoVazio(layout)) {
            int i;
            Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
            gerador.setPai(panel);
            gerador.setPreVisualizar(true);
            gerador.setZoomPreVisualizar(0.5f);
            if (acaoFechar != null) {
                gerador.setAcaoFechar(acaoFechar);
            }
            HashMap<String, Object> var = new HashMap<String, Object>();
            buf.delete(0, buf.length());
            if (operadoras != null) {
                for (i = 0; i < operadoras.length; ++i) {
                    buf.append(operadoras[i]);
                    if (i >= operadoras.length - 1) continue;
                    buf.append(", ");
                }
            }
            var.put("filtroOperadora", buf.toString());
            buf.delete(0, buf.length());
            if (exames != null) {
                for (i = 0; i < exames.length; ++i) {
                    buf.append(exames[i]);
                    if (i >= exames.length - 1) continue;
                    buf.append(", ");
                }
            }
            var.put("filtroExame", buf.toString());
            gerador.executar(layout, (TableModel)modelo, var);
            panel.revalidate();
        } else {
            Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
            this.habilitaBotaoImprimir(true);
        }
        Conexao.fecharStatement(st, st2);
    }

    private boolean validaFiltroOperadora() {
        return this.getSelecionadosFiltroArray("filtroOperadora") == null || this.getSelecionadosFiltroArray("filtroOperadora").length == 0;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0811901142");
    }
}

