/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.cadastros;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioExamesInterfaces
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_MATERIAL = "filtroMaterial";
    private final String FILTRO_INTERFACE = "filtroInterface";
    private final String FILTRO_METODOLOGIA = "filtroMetodologia";
    private final String FILTRO_SETOR = "filtroSetor";
    private final String[] ordem = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"};
    private final long ACESSO_CONFIGURAR = Long.parseLong("0811901131");
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoExame", "descricaoExame", "sexoExame", "materialPadraoExame", "horaEntradaExame", "horaSaidaExame", "filtroExame", "proibidoExame", "diagnosticoExame", "interferenciaExame", "sinonimoExame", "salvaParcialExame", "idadeMaximaExame", "idadeMinimaExame", "tipoIdadeMaximaExame", "tipoIdadeMinimaExame", "proibidoWebExame", "quantidadeAmostrasExame", "materialPadraoExame", "preaparoExame", "preparoAmostraExame", "inadequadaExame", "codigoMetodologia", "ordemExame", "paginaExame", "cbhpmExame", "ambExame", "conservacaoExame", "diasConservacaoExame", "temperaturaInicialExame", "temperaturaFinalExame", "referenciaExame", "procedimentoExame", "solicitarJejumExame", "solicitarMedicamentoExame", "solicitarDUMExame", "codigoMaterialColetado", "solicitarTempoDiureseExame", "instrucaoColetaExame", "marcarExternoExame", "descricaoMetodologia", "descricaoMaterialColetado", "codigoInterface", "descricaoInterface", "fabricanteInterface", "solicitarMaterialMaterialColetado", "abreviaturaMaterialColetado", "codigoAlternativoInterface", "materialAlternativoInterface", "codigoMetodologiaInterface", "descricaoMetodologiaInterface", "codigoSetor", "descricaoSetor", "responsavelSetor", "corSetor"});

    public RelatorioExamesInterfaces() {
        this.setName("RelatorioExamesInterfaces");
        this.montaBarraDescricao("Relat\u00f3rio de exames por interface", "Listagem dos exames relacionados por interfaceamento", "relatorios/rel_exames_interface.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroInterface", "Interface", "interface", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"int_codigo", "int_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroMaterial", "Material", "materialcoleta", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"mco_codigo", "mco_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroMetodologia", "Metodologia", "metodologia", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"met_codigo", "met_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSetor", "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.setModuloConfigurar(this.ACESSO_CONFIGURAR);
        this.setModuloAcesso(RelatorioExamesInterfaces.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String[] setor;
            String[] metodologia;
            String[] interfaces;
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("select a.exa_codigo as codigoExame, ");
            buf.append("a.exa_descricao as descricaoExame, ");
            buf.append("a.exa_sexo as sexoExame, ");
            buf.append("a.exa_horaentrada as horaEntradaExame, ");
            buf.append("a.exa_horasaida as horaSaidaExame, ");
            buf.append("a.exa_filtro as filtroExame, ");
            buf.append("a.exa_proibido as proibidoExame, ");
            buf.append("a.exa_diagnostico as diagnosticoExame, ");
            buf.append("a.exa_interferencia as interferenciaExame, ");
            buf.append("a.exa_sinonimo as sinonimoExame, ");
            buf.append("a.exa_salvaparcial as salvaParcialExame, ");
            buf.append("a.exa_idademax as idadeMaximaExame, ");
            buf.append("a.exa_idademin as idadeMinimaExame, ");
            buf.append("a.exa_idademaxtipo as tipoIdadeMaximaExame, ");
            buf.append("a.exa_idademintipo as tipoIdadeMinimaExame, ");
            buf.append("a.exa_proibidoweb as proibidoWebExame, ");
            buf.append("a.exa_qtdeamostras as quantidadeAmostrasExame, ");
            buf.append("b.emc_default as materialPadraoExame, ");
            buf.append("b.emc_preparo as preaparoExame, ");
            buf.append("b.emc_prepamostra as preparoAmostraExame, ");
            buf.append("b.emc_inadequada as inadequadaExame, ");
            buf.append("b.met_codigo as codigoMetodologia, ");
            buf.append("b.emc_ordem as ordemExame, ");
            buf.append("b.emc_pagina as paginaExame, ");
            buf.append("b.emc_codigocbhpm as cbhpmExame, ");
            buf.append("b.emc_codigoamb as ambExame, ");
            buf.append("b.emc_conservacao as conservacaoExame, ");
            buf.append("b.emc_diasconserva as diasConservacaoExame, ");
            buf.append("b.emc_temperaturainicial as temperaturaInicialExame, ");
            buf.append("b.emc_temperaturafinal as temperaturaFinalExame, ");
            buf.append("b.emc_referencia as referenciaExame, ");
            buf.append("b.emc_procedimento as procedimentoExame, ");
            buf.append("b.emc_solicitarjejum as solicitarJejumExame, ");
            buf.append("b.emc_obrigamedicamento as solicitarMedicamentoExame, ");
            buf.append("b.emc_obrigadum as solicitarDUMExame, ");
            buf.append("b.emc_obrigapeso as solicitarPesoExame, ");
            buf.append("b.emc_obrigaaltura as solicitarAlturaExame, ");
            buf.append("b.emc_obrigavolume as solicitarVolumeExame, ");
            buf.append("b.emc_obrigatempodiurese as solicitarTempoDiureseExame, ");
            buf.append("b.emc_instrcoleta as instrucaoColetaExame, ");
            buf.append("b.emc_marcarexterno as marcarExternoExame, ");
            buf.append("d.met_descricao as descricaoMetodologia, ");
            buf.append("e.mco_codigo as codigoMaterialColetado, ");
            buf.append("e.mco_descricao as descricaoMaterialColetado, ");
            buf.append("e.mco_solicitarmat as solicitarMaterialMaterialColetado, ");
            buf.append("e.mco_abreviatura as abreviaturaMaterialColetado, ");
            buf.append("f.set_codigo as codigoSetor, ");
            buf.append("g.set_descricao as descricaoSetor, ");
            buf.append("g.set_responsavel as responsavelSetor, ");
            buf.append("g.set_cor as corSetor, ");
            buf.append("g.set_sigla as siglaSetor, ");
            buf.append("h.int_codigo as codigoInterface,");
            buf.append("h.int_descricao as descricaoInterface, ");
            buf.append("h.int_fabricante as fabricanteInterface, ");
            buf.append("i.emi_alternativo as codigoAlternativoInterface,");
            buf.append("i.emi_material as materialAlternativoInterface,");
            buf.append("i.met_codigo as codigoMetodologiaInterface,");
            buf.append("j.met_descricao as descricaoMetodologiaInterface,");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from exames a ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append(" left join examematcoleta b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
            buf.append(" join examematinterface i on b.fil_codigo = i.fil_codigo and b.exa_codigo = i.exa_codigo and b.mco_codigo = i.mco_codigo ");
            buf.append(" left join metodologia d on a.fil_codigo = d.fil_codigo and b.met_codigo = d.met_codigo ");
            buf.append(" left join materialcoleta e on a.fil_codigo = e.fil_codigo and b.mco_codigo = e.mco_codigo ");
            buf.append(" left join examesetor f on a.fil_codigo = f.fil_codigo and a.exa_codigo = f.exa_codigo and f.ese_default = true");
            buf.append(" left join setores g on a.fil_codigo = g.fil_codigo and f.set_codigo = g.set_codigo ");
            buf.append(" left join interface h on i.fil_codigo = h.fil_codigo and i.int_codigo = h.int_codigo ");
            buf.append(" left join metodologia j on i.fil_codigo = j.fil_codigo and i.met_codigo = j.met_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            String[] materiais = this.getSelecionadosFiltro("filtroMaterial", 0);
            if (materiais != null) {
                buf.append(" and b.mco_codigo in (");
                for (int i = 0; i < materiais.length; ++i) {
                    buf.append(materiais[i]);
                    if (i >= materiais.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if ((interfaces = this.getSelecionadosFiltro("filtroInterface", 0)) != null) {
                buf.append(" and i.int_codigo in (");
                for (int i = 0; i < interfaces.length; ++i) {
                    buf.append(interfaces[i]);
                    if (i >= interfaces.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if ((metodologia = this.getSelecionadosFiltro("filtroMetodologia", 0)) != null) {
                buf.append(" and b.met_codigo in (");
                for (int i = 0; i < metodologia.length; ++i) {
                    buf.append(metodologia[i]);
                    if (i >= metodologia.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if ((setor = this.getSelecionadosFiltro("filtroSetor", 0)) != null) {
                buf.append(" and f.set_codigo in (");
                for (int i = 0; i < setor.length; ++i) {
                    buf.append(setor[i]);
                    if (i >= setor.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            buf.append(" order by i.int_codigo, ");
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                buf.append("a.exa_descricao");
            } else {
                buf.append("a.exa_codigo");
            }
            buf.append(", b.mco_codigo");
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        o[i] = campos[i].indexOf("tipo") >= 0 ? Tipos.tipoIdade(rs.getString(campos[i])) : rs.getObject(campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioExamesInterfaces.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioExamesInterfaces.this.panelCentro.removeAll();
                            RelatorioExamesInterfaces.this.panelCentro.repaint();
                            RelatorioExamesInterfaces.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    buf.delete(0, buf.length());
                    if (materiais != null) {
                        for (i = 0; i < materiais.length; ++i) {
                            buf.append(materiais[i]);
                            if (i >= materiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroMaterial", buf.toString());
                    buf.delete(0, buf.length());
                    if (interfaces != null) {
                        for (i = 0; i < interfaces.length; ++i) {
                            buf.append(interfaces[i]);
                            if (i >= interfaces.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroInterface", buf.toString());
                    buf.delete(0, buf.length());
                    if (metodologia != null) {
                        for (i = 0; i < metodologia.length; ++i) {
                            buf.append(metodologia[i]);
                            if (i >= metodologia.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroMetodologia", buf.toString());
                    buf.delete(0, buf.length());
                    if (setor != null) {
                        for (i = 0; i < setor.length; ++i) {
                            buf.append(setor[i]);
                            if (i >= setor.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroSetor", buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0811901130");
    }
}

