/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.cadastros;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.util.parsers.FabricaConfigurador;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.relatorio.Gerador;
import jalis.relatorio.gerador.Relatorio;
import jalis.util.ArraysUtil;
import jalis.util.ConvenioUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;

public class RelatorioExamesApoiados
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_APOIO = "filtroApoio";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_MOSTRAR_VALORES = "filtroMostrarPreco";
    private final String FILTRO_APRESENTAR_SOMENTE_PADRAO = "filtroApresentarSomentePadrao";
    private final String[] ordem = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Valor conv\u00eanio"};
    private final long ACESSO_CONFIGURAR = Long.parseLong("0811901141");
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoExame", "descricaoExame", "sexoExame", "materialPadraoExame", "horaEntradaExame", "horaSaidaExame", "filtroExame", "proibidoExame", "diagnosticoExame", "interferenciaExame", "sinonimoExame", "salvaParcialExame", "idadeMaximaExame", "idadeMinimaExame", "tipoIdadeMaximaExame", "tipoIdadeMinimaExame", "proibidoWebExame", "quantidadeAmostrasExame", "materialPadraoExame", "preaparoExame", "preparoAmostraExame", "inadequadaExame", "codigoPrazoEntrega", "codigoMetodologia", "ordemExame", "paginaExame", "cbhpmExame", "ambExame", "conservacaoExame", "diasConservacaoExame", "temperaturaInicialExame", "temperaturaFinalExame", "referenciaExame", "procedimentoExame", "solicitarJejumExame", "solicitarMedicamentoExame", "solicitarDUMExame", "solicitarTempoDiureseExame", "instrucaoColetaExame", "marcarExternoExame", "descricaoPrazoEntrega", "rotinaPrazoEntrega", "diasPrazoEntrega", "horaEntradaPrazoEntrega", "horaSaidaPrazoEntrega", "descricaoMetodologia", "codigoMaterialColetado", "descricaoMaterialColetado", "solicitarMaterialMaterialColetado", "abreviaturaMaterialColetado", "codigoSetor", "descricaoSetor", "responsavelSetor", "corSetor", "siglaSetor", "codigoUsuario", "nomeUsuario", "codigoExameLaboratorioApoio", "descricaoExameLaboratorioApoio", "codigoApoio", "descricaoApoio", "protocoloApoio", "bloqueadoLaboratorioApoio", "diasPrazoLaboratorioApoio", "valorExameLaboratorioApoio", "valorFaturamentoConvenio"});
    private Integer codigoLabExterno = null;

    public RelatorioExamesApoiados() {
        this.setName("RelatorioExamesApoiados");
        this.montaBarraDescricao("Relat\u00f3rio de exames para apoio", "Listagem dos exames configurados para apoio", "relatorios/rel_exames_apoio.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroApoio", "Apoio", "labexterno", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"lae_codigo", "lae_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.adicionaFiltroCheck("filtroMostrarPreco", "Calcular pre\u00e7o cobrado", false);
        this.adicionaFiltroCheck("filtroApresentarSomentePadrao", "Apresentar somente padr\u00e3o", false);
        this.setModuloConfigurar(this.ACESSO_CONFIGURAR);
        this.setModuloAcesso(RelatorioExamesApoiados.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    public void imprimirPressionado(Integer codigoLabExterno) {
        this.codigoLabExterno = codigoLabExterno;
        this.panelCard.setVisible(false);
        this.buttonConfigurar.setVisible(false);
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelatorioExamesApoiados.this.setVisible(false);
                RelatorioExamesApoiados.this.getParent().getParent().getParent().setVisible(false);
            }
        });
        this.imprimirPressionado();
    }

    @Override
    public void imprimirPressionado() {
        if ((this.getSelecionadosFiltro("filtroApoio", 0) == null || this.getSelecionadosFiltro("filtroApoio", 0).length == 0) && this.codigoLabExterno == null) {
            Funcoes.mensagem(this, "Um laborat\u00f3rio de apoio deve ser selecionado", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        if ((this.getSelecionadosFiltro("filtroConvenio", 0) == null || this.getSelecionadosFiltro("filtroConvenio", 0).length == 0) && this.getFiltroCheck("filtroMostrarPreco")) {
            Funcoes.mensagem(this, "Um conv\u00eanio deve ser selecionado para calcular os valores de cobran\u00e7a", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        if (this.getSelecionadosFiltro("filtroConvenio", 0) != null && this.getSelecionadosFiltro("filtroConvenio", 0).length > 1 && this.getFiltroCheck("filtroMostrarPreco")) {
            Funcoes.mensagem(this, "Apenas um conv\u00eanio pode ser selecionado para calcular os valores de cobran\u00e7a", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Statement st = Conexao.getStatement();
            Statement st2 = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("select a.exa_codigo as codigoExame, ");
            buf.append("a.exa_descricao as descricaoExame, ");
            buf.append("a.exa_sexo as sexoExame, ");
            buf.append("a.exa_horaentrada as horaEntradaExame, ");
            buf.append("a.exa_horasaida as horaSaidaExame, ");
            buf.append("a.exa_filtro as filtroExame, ");
            buf.append("a.exa_proibido as proibidoExame, ");
            buf.append("a.exa_diagnostico as diagnosticoExame, ");
            buf.append("a.exa_interferencia as interferenciaExame, ");
            buf.append("a.exa_sinonimo as sinonimoExame, ");
            buf.append("a.exa_salvaparcial as salvaParcialExame, ");
            buf.append("a.exa_idademax as idadeMaximaExame, ");
            buf.append("a.exa_idademin as idadeMinimaExame, ");
            buf.append("a.exa_idademaxtipo as tipoIdadeMaximaExame, ");
            buf.append("a.exa_idademintipo as tipoIdadeMinimaExame, ");
            buf.append("a.exa_proibidoweb as proibidoWebExame, ");
            buf.append("a.exa_qtdeamostras as quantidadeAmostrasExame, ");
            buf.append("b.emc_default as materialPadraoExame, ");
            buf.append("b.emc_preparo as preaparoExame, ");
            buf.append("b.emc_prepamostra as preparoAmostraExame, ");
            buf.append("b.emc_inadequada as inadequadaExame, ");
            buf.append("b.prz_codigo as codigoPrazoEntrega, ");
            buf.append("b.met_codigo as codigoMetodologia, ");
            buf.append("b.emc_ordem as ordemExame, ");
            buf.append("b.emc_pagina as paginaExame, ");
            buf.append("b.emc_codigocbhpm as cbhpmExame, ");
            buf.append("b.emc_codigoamb as ambExame, ");
            buf.append("b.emc_conservacao as conservacaoExame, ");
            buf.append("b.emc_diasconserva as diasConservacaoExame, ");
            buf.append("b.emc_temperaturainicial as temperaturaInicialExame, ");
            buf.append("b.emc_temperaturafinal as temperaturaFinalExame, ");
            buf.append("b.emc_referencia as referenciaExame, ");
            buf.append("b.emc_procedimento as procedimentoExame, ");
            buf.append("b.emc_solicitarjejum as solicitarJejumExame, ");
            buf.append("b.emc_obrigamedicamento as solicitarMedicamentoExame, ");
            buf.append("b.emc_obrigadum as solicitarDUMExame, ");
            buf.append("b.emc_obrigapeso as solicitarPesoExame, ");
            buf.append("b.emc_obrigaaltura as solicitarAlturaExame, ");
            buf.append("b.emc_obrigavolume as solicitarVolumeExame, ");
            buf.append("b.emc_obrigatempodiurese as solicitarTempoDiureseExame, ");
            buf.append("b.emc_instrcoleta as instrucaoColetaExame, ");
            buf.append("b.emc_marcarexterno as marcarExternoExame, ");
            buf.append("c.prz_descricao as descricaoPrazoEntrega, ");
            buf.append("c.prz_prazo as rotinaPrazoEntrega, ");
            buf.append("c.prz_dias as diasPrazoEntrega, ");
            buf.append("c.prz_horaentrada as horaEntradaPrazoEntrega, ");
            buf.append("c.prz_horasaida as horaSaidaPrazoEntrega, ");
            buf.append("d.met_descricao as descricaoMetodologia, ");
            buf.append("e.mco_codigo as codigoMaterialColetado, ");
            buf.append("e.mco_descricao as descricaoMaterialColetado, ");
            buf.append("e.mco_solicitarmat as solicitarMaterialMaterialColetado, ");
            buf.append("e.mco_abreviatura as abreviaturaMaterialColetado, ");
            buf.append("f.set_codigo as codigoSetor, ");
            buf.append("g.set_descricao as descricaoSetor, ");
            buf.append("g.set_responsavel as responsavelSetor, ");
            buf.append("g.set_cor as corSetor, ");
            buf.append("g.set_sigla as siglaSetor, ");
            buf.append("h.usr_codigo as codigoUsuario, ");
            buf.append("h.usr_nome as nomeUsuario, ");
            buf.append("j.lae_codigo as codigoApoio, ");
            buf.append("j.lae_descricao as descricaoApoio, ");
            buf.append("j.lae_protocolo as protocoloApoio, ");
            buf.append("k.ele_xmllabexterno as codigoExameLaboratorioApoio, '' as descricaoExameLaboratorioApoio, ");
            buf.append("k.ele_diasprazo as diasPrazoLaboratorioApoio, k.ele_valorexame as valorExameLaboratorioApoio, ");
            buf.append("k.ele_bloqueado as bloqueadoLaboratorioApoio, ");
            buf.append("0 as valorFaturamentoConvenio, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from exames a ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append(" left join examematcoleta b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
            buf.append(" left join prazoentrega c on a.fil_codigo = c.fil_codigo and b.prz_codigo = c.prz_codigo ");
            buf.append(" left join metodologia d on a.fil_codigo = d.fil_codigo and b.met_codigo = d.met_codigo ");
            buf.append(" left join materialcoleta e on a.fil_codigo = e.fil_codigo  and b.mco_codigo = e.mco_codigo ");
            buf.append(" left join examesetor f on a.fil_codigo = f.fil_codigo and a.exa_codigo = f.exa_codigo and f.ese_default = true");
            buf.append(" left join setores g on a.fil_codigo = g.fil_codigo  and f.set_codigo = g.set_codigo ");
            buf.append(" left join usuario h on g.usr_codigo = h.usr_codigo ");
            buf.append(" left join examematcoletalabexterno k on b.fil_codigo = k.fil_codigo and b.exa_codigo = k.exa_codigo and b.mco_codigo = k.mco_codigo ");
            buf.append(" left join labexterno j on b.fil_codigo = j.fil_codigo and k.lae_codigo = j.lae_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            String[] apoios = this.getSelecionadosFiltro("filtroApoio", 0);
            if (apoios != null) {
                buf.append(" and k.lae_codigo in (");
                for (int i = 0; i < apoios.length; ++i) {
                    buf.append(apoios[i]);
                    if (i >= apoios.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            } else if (this.codigoLabExterno != null && this.codigoLabExterno > 0) {
                buf.append(" and k.lae_codigo = ").append(this.codigoLabExterno);
            }
            if (this.getFiltroCheck("filtroApresentarSomentePadrao")) {
                buf.append("and k.ele_padrao ");
            }
            buf.append(" order by k.lae_codigo, ");
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                buf.append("a.exa_descricao");
            } else {
                buf.append("a.exa_codigo");
            }
            buf.append(", b.mco_codigo");
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                Object[] campos2 = ArraysUtil.concatenar(campos, new String[]{"ordenacao"});
                ModeloGridTable modelo = new ModeloGridTable((String[])campos2);
                do {
                    Object[] o = new Object[campos2.length];
                    for (int i = 0; i < campos2.length; ++i) {
                        Protocolo p;
                        String xml;
                        if (campos2[i].equals("ordenacao")) continue;
                        if (campos2[i].equalsIgnoreCase("codigoExameLaboratorioApoio")) {
                            xml = rs.getString("codigoExameLaboratorioApoio");
                            o[i] = "";
                            p = Protocolo.getProtocolo(rs.getString("protocoloApoio"));
                            if (p == null) continue;
                            o[i] = FabricaConfigurador.getCodigoIdentExameLabExternoSelecionado(p, rs.getString("codigoApoio"), xml);
                            continue;
                        }
                        if (campos2[i].equalsIgnoreCase("descricaoExameLaboratorioApoio")) {
                            xml = rs.getString("codigoExameLaboratorioApoio");
                            o[i] = "";
                            p = Protocolo.getProtocolo(rs.getString("protocoloApoio"));
                            if (p == null) continue;
                            o[i] = FabricaConfigurador.getDescricaoExameSelecionado(p, rs.getString("codigoApoio"), xml);
                            continue;
                        }
                        if (campos2[i].equalsIgnoreCase("valorFaturamentoConvenio") && this.getFiltroCheck("filtroMostrarPreco")) {
                            DadosConvenios conv;
                            String convenio = this.getSelecionadosFiltro("filtroConvenio", 0)[0];
                            DadosMaterial material = ExameUtil.getDadosMaterial(Variaveis.filialPadrao, rs.getInt("codigoMaterialColetado"));
                            DadosExames exame = ExameUtil.getDadosExame(Variaveis.filialPadrao, rs.getString("codigoExame"), material, st2);
                            int preco = ExameUtil.calculaPrecoExame(Variaveis.filialPadrao, exame, material, conv = ConvenioUtil.getDadosConvenios(Variaveis.filialPadrao, Integer.parseInt(convenio)), true, false, true, null, null, (Integer)Integer.parseInt(exame.getCodMetodo()), 1);
                            if (preco == 1 || preco == 6 || preco == 7 || preco == 8) {
                                o[i] = 0;
                                continue;
                            }
                            o[i] = exame.getValor();
                            continue;
                        }
                        o[i] = ((String)campos2[i]).indexOf("tipo") >= 0 ? Tipos.tipoIdade(rs.getString((String)campos2[i])) : rs.getObject((String)campos2[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2]) && this.getFiltroCheck("filtroMostrarPreco")) {
                    int colunaOrdem = ArraysUtil.indice(campos2, "ordenacao");
                    int colunaLabExterno = ArraysUtil.indice(campos2, "codigoApoio");
                    int colunaValor = ArraysUtil.indice(campos2, "valorFaturamentoConvenio");
                    if (colunaOrdem > -1 && colunaLabExterno > -1 && colunaValor > -1) {
                        for (int i = 0; i < modelo.getRowCount(); ++i) {
                            String s = Funcoes.preencheZero(modelo.getValueAt(i, colunaLabExterno).toString(), 3) + Funcoes.preencheZero(modelo.getValueAt(i, colunaValor) == null ? "0" : modelo.getValueAt(i, colunaValor).toString().replaceAll(",", "").replaceAll("[.]", ""), 10);
                            modelo.setValueAt(s, i, colunaOrdem);
                        }
                    }
                    modelo.ordenarColuna(colunaOrdem);
                }
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioExamesApoiados.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioExamesApoiados.this.panelCentro.removeAll();
                            RelatorioExamesApoiados.this.panelCentro.repaint();
                            RelatorioExamesApoiados.this.habilitaBotaoImprimir(true);
                            if (RelatorioExamesApoiados.this.codigoLabExterno != null) {
                                RelatorioExamesApoiados.this.getParent().getParent().getParent().setVisible(false);
                            }
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    var.put("filtroApresentarSomentePadrao", this.getFiltroCheck("filtroApresentarSomentePadrao") ? "Sim" : "N\u00e3o");
                    buf.delete(0, buf.length());
                    if (apoios != null) {
                        for (int i = 0; i < apoios.length; ++i) {
                            buf.append(apoios[i]);
                            if (i >= apoios.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroApoio", buf.toString());
                    Relatorio rel = new Relatorio(modelo, var, ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                    rel.setConfiguracao(rs.getString("rel_xml"));
                    gerador.executar(rel);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st, st2);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0811901140");
    }
}

