/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.cadastros;

import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioEntidades
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    public static int TIPO_CADASTRO = 1;
    public static int TIPO_MALADIRETA = 2;
    public static int TIPO_ENTIDADE_FORNECEDOR = 1;
    public static int TIPO_ENTIDADE_FUNCIONARIO = 2;
    public static int TIPO_ENTIDADE_COLETADOR = 3;
    public static int TIPO_ENTIDADE_REPRESENTANTE = 4;
    public static int TIPO_ENTIDADE_FISCAL = 5;
    public static int TIPO_ENTIDADE_RESPONSAVEL = 6;
    public static int TIPO_ENTIDADE_EMPRESA = 7;
    private int tipoRelatorio = TIPO_CADASTRO;
    private int tipoEntidade = TIPO_ENTIDADE_FORNECEDOR;
    private final String[] ordem = new String[]{"C\u00f3digo", "Raz\u00e3o Social", "Fantasia"};
    private final String[] estados = ArraysUtil.concatenar(new String[]{"Todos"}, ConstantesGerais.ESTADOS);
    private final String[] tiposFornecedores = new String[]{"Todos", Tipos.getTipoFornecedor("P"), Tipos.getTipoFornecedor("S"), Tipos.getTipoFornecedor("A"), Tipos.getTipoFornecedor("E")};
    private final String[] tiposEmpresas = new String[]{"Todos", Tipos.getTipoEmpresa("F"), Tipos.getTipoEmpresa("J")};
    private final String FILTRO_EMPRESA = "filtroEmpresa";
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_CIDADE = "filtroCidade";
    private final String FILTRO_ESTADO = "filtroEstado";
    private final String FILTRO_BAIRRO = "filtroBairro";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_INATIVO = "filtroInativo";
    private final String FILTRO_TIPO_FORNECEDOR = "filtroTipoFornecedor";
    private final String FILTRO_TIPO_EMPRESA = "filtroTipoEmpresa";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoEntidade", "razaoSocialEntidade", "fantasiaEntidade", "dataNascimentoEntidade", "cpfCnpjEntidade", "rgIEEntidade", "enderecoEntidade", "complementoEntidade", "cepEntidade", "foneEntidade", "faxEntidade", "celularEntidade", "contatoEntidade", "foneContatoEntidade", "emailEntidade", "siteEntidade", "cargoEntidade", "senhaWebEntidade", "numeroEnderecoEntidade", "tipoLogradouroEntidade", "codigoCidade", "descricaoCidade", "estadoCidade", "codigoBairro", "descricaoBairro", "inativoEntidade", "tipoFornecedor", "tipoPessoa"});

    public RelatorioEntidades(int tipoRelatorio, int tipoEntidade) {
        this.setName("RelatorioEntidades");
        this.tipoRelatorio = tipoRelatorio;
        this.tipoEntidade = tipoEntidade;
        if (tipoRelatorio == TIPO_CADASTRO) {
            if (tipoEntidade == TIPO_ENTIDADE_FORNECEDOR) {
                this.montaBarraDescricao("Relat\u00f3rio de fornecedor", "Listagem dos fornecedores cadastrados", "relatorios/rel_cad_fornecedor.jpg");
            } else if (tipoEntidade == TIPO_ENTIDADE_EMPRESA) {
                this.montaBarraDescricao("Relat\u00f3rio da empresa", "Listagem das empresas cadastradas", "relatorios/rel_cad_fornecedor.jpg");
            } else if (tipoEntidade == TIPO_ENTIDADE_FUNCIONARIO) {
                this.montaBarraDescricao("Relat\u00f3rio de funcion\u00e1rios", "Listagem dos funcion\u00e1rios cadastrados", "relatorios/rel_cad_funcionario.jpg");
            } else if (tipoEntidade == TIPO_ENTIDADE_COLETADOR) {
                this.montaBarraDescricao("Relat\u00f3rio de coletadores", "Listagem dos coletadores cadastrados", "relatorios/rel_coletador.jpg");
            } else if (tipoEntidade == TIPO_ENTIDADE_REPRESENTANTE) {
                this.montaBarraDescricao("Relat\u00f3rio de representantes", "Listagem dos representantes cadastrados", "relatorios/rel_cad_representante.jpg");
            } else if (tipoEntidade == TIPO_ENTIDADE_FISCAL) {
                this.montaBarraDescricao("Relat\u00f3rio de fiscais", "Listagem dos fiscais cadastrados", "relatorios/rel_cad_fiscal.jpg");
            } else {
                this.montaBarraDescricao("Relat\u00f3rio de respons\u00e1veis", "Listagem dos respons\u00e1veis cadastrados", "relatorios/rel_cad_responsavel.jpg");
            }
        }
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        if (tipoEntidade == TIPO_ENTIDADE_EMPRESA) {
            this.adicionaItemFiltro("filtroEmpresa", "Empresa", "entidade", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"ent_codigo", "ent_razaosocial", "ent_cpfcnpj"}, new String[]{"C\u00f3digo", "Raz\u00e3o Social", "CNPJ"}, new int[]{70, 0, 150});
        } else {
            this.adicionaItemFiltro("filtroCidade", "Cidade", "cidades", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cid_codigo", "cid_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
            this.adicionaItemFiltro("filtroBairro", "Bairro", "bairro", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"bai_codigo", "bai_descricao"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
            this.adicionaFiltroCombo("filtroEstado", "Estado:", this.estados, 0);
        }
        if (tipoEntidade == TIPO_ENTIDADE_FORNECEDOR) {
            this.adicionaFiltroCombo("filtroTipoFornecedor", "Tipo:", this.tiposFornecedores, 0);
        } else if (tipoEntidade == TIPO_ENTIDADE_EMPRESA) {
            this.adicionaFiltroCombo("filtroTipoEmpresa", "Tipo:", this.tiposEmpresas, 0);
        }
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem", this.ordem, 0);
        if (tipoEntidade == TIPO_ENTIDADE_EMPRESA) {
            this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Dt.Cadastro inicial:");
            this.adicionaFiltroData(FILTRO_DATA_FINAL, "Dt.Cadastro final:");
        }
        this.adicionaFiltroCheck("filtroInativo", "Apresenta Inativos", false);
        this.setModuloConfigurar(RelatorioEntidades.pegaModuloConfiguracao(tipoRelatorio, tipoEntidade));
        this.setModuloAcesso(RelatorioEntidades.getModuloAcesso(tipoRelatorio, tipoEntidade));
        this.setCamposConfigurador(campos);
    }

    public static long pegaModuloConfiguracao(int tipoRelatorio, int tipoEntidade) {
        if (tipoRelatorio == TIPO_CADASTRO) {
            if (tipoEntidade == TIPO_ENTIDADE_FORNECEDOR) {
                return 812500101L;
            }
            if (tipoEntidade == TIPO_ENTIDADE_FUNCIONARIO) {
                return 812500201L;
            }
            if (tipoEntidade == TIPO_ENTIDADE_COLETADOR) {
                return 812500301L;
            }
            if (tipoEntidade == TIPO_ENTIDADE_REPRESENTANTE) {
                return 812500401L;
            }
            if (tipoEntidade == TIPO_ENTIDADE_FISCAL) {
                return 812500501L;
            }
            if (tipoEntidade == TIPO_ENTIDADE_EMPRESA) {
                return 812501101L;
            }
            return 812500601L;
        }
        return -1L;
    }

    @Override
    public void imprimirPressionado() {
        String[] cidade = null;
        String[] bairro = null;
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            int i;
            int i2;
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("select a.ent_codigo as codigoEntidade, ");
            buf.append("a.ent_razaosocial as razaoSocialEntidade, a.ent_fantasia as fantasiaEntidade, ");
            buf.append("a.ent_datanascimento as dataNascimentoEntidade, a.ent_cpfcnpj as cpfCnpjEntidade, ");
            buf.append("a.ent_rgie as rgIEEntidade, ");
            buf.append("a.ent_endereco as enderecoEntidade, a.ent_complemento as complementoEntidade, a.ent_cep as cepEntidade, ");
            buf.append("a.ent_numeroendereco as numeroEnderecoEntidade, a.ent_tipologradouroendereco as tipoLogradouroEntidade,  ");
            buf.append("a.ent_fone as foneEntidade, a.ent_fax as faxEntidade, a.ent_celular as celularEntidade, ");
            buf.append("a.ent_nomecontato as contatoEntidade, a.ent_fonecontato as foneContatoEntidade, ");
            buf.append("a.ent_email as emailEntidade, a.ent_site as siteEntidade, ");
            buf.append("a.ent_cargo as cargoEntidade, a.ent_senhaweb as senhaWebEntidade, a.ent_tipofornecedor as tipoFornecedor, ");
            buf.append("a.ent_inativo as inativoEntidade, ");
            buf.append("a.ent_tipopessoa as tipoPessoa, ");
            buf.append("a.ent_datahora as filtroDataInicial ,");
            buf.append("a.ent_datahora as filtroDataFinal ,");
            buf.append("b.cid_codigo as codigoCidade, ");
            buf.append("b.cid_nome as descricaoCidade, ");
            buf.append("b.cid_uf as estadoCidade, ");
            buf.append("c.bai_codigo as codigoBairro, ");
            buf.append("c.bai_descricao as descricaoBairro, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from entidade a ");
            buf.append("left join cidades b on a.fil_codigo = b.fil_codigo and a.cid_codigo = b.cid_codigo ");
            buf.append("left join bairro c on a.fil_codigo = c.fil_codigo and a.bai_codigo = c.bai_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            buf.append(" where a.fil_codigo in (");
            for (i2 = 0; i2 < filiais.length; ++i2) {
                buf.append(filiais[i2]);
                if (i2 >= filiais.length - 1) continue;
                buf.append(", ");
            }
            buf.append(" )");
            if (this.tipoEntidade != TIPO_ENTIDADE_EMPRESA) {
                cidade = this.getSelecionadosFiltro("filtroCidade", 0);
                if (cidade != null) {
                    buf.append(" and a.cid_codigo in (");
                    for (i2 = 0; i2 < cidade.length; ++i2) {
                        buf.append(cidade[i2]);
                        if (i2 >= cidade.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(") ");
                }
                if ((bairro = this.getSelecionadosFiltro("filtroBairro", 0)) != null) {
                    buf.append(" and a.bai_codigo in ('");
                    for (i2 = 0; i2 < bairro.length; ++i2) {
                        buf.append(bairro[i2]);
                        if (i2 >= bairro.length - 1) continue;
                        buf.append("', '");
                    }
                    buf.append(" ) ");
                }
                if (!this.getFiltroCombo("filtroEstado").equals(this.estados[0])) {
                    buf.append(" and b.cid_uf = '");
                    buf.append(this.getFiltroCombo("filtroEstado"));
                    buf.append("'");
                }
            } else {
                String[] empresa;
                String dataInicial = this.getFiltroData(FILTRO_DATA_INICIAL);
                String dataFinal = this.getFiltroData(FILTRO_DATA_FINAL);
                if (dataInicial != null && Funcoes.verificaData(dataInicial)) {
                    buf.append(" and cast(ent_datahora as date) >='");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", dataInicial));
                    buf.append("'");
                }
                if (dataFinal != null && Funcoes.verificaData(dataFinal)) {
                    buf.append(" and cast(ent_datahora as date) <='");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", dataFinal));
                    buf.append("'");
                }
                if ((empresa = this.getSelecionadosFiltro("filtroEmpresa", 0)) != null) {
                    buf.append(" and a.ent_codigo in (");
                    for (i = 0; i < empresa.length; ++i) {
                        buf.append(empresa[i]);
                        if (i >= empresa.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(") ");
                }
            }
            if (this.tipoEntidade == TIPO_ENTIDADE_EMPRESA && !this.getFiltroCombo("filtroTipoEmpresa").equals(this.tiposEmpresas[0])) {
                if (this.getFiltroCombo("filtroTipoEmpresa").equals(this.tiposEmpresas[1])) {
                    buf.append(" and a.ent_tipopessoa = '").append("F").append("' ");
                } else if (this.getFiltroCombo("filtroTipoEmpresa").equals(this.tiposEmpresas[2])) {
                    buf.append(" and a.ent_tipopessoa = '").append("J").append("' ");
                }
            }
            if (this.tipoEntidade == TIPO_ENTIDADE_FORNECEDOR && !this.getFiltroCombo("filtroTipoFornecedor").equals(this.tiposFornecedores[0])) {
                if (this.getFiltroCombo("filtroTipoFornecedor").equals(this.tiposFornecedores[1])) {
                    buf.append(" and a.ent_tipofornecedor = '").append("P").append("' ");
                } else if (this.getFiltroCombo("filtroTipoFornecedor").equals(this.tiposFornecedores[2])) {
                    buf.append(" and a.ent_tipofornecedor = '").append("S").append("' ");
                } else if (this.getFiltroCombo("filtroTipoFornecedor").equals(this.tiposFornecedores[3])) {
                    buf.append(" and a.ent_tipofornecedor = '").append("A").append("' ");
                } else {
                    buf.append(" and a.ent_tipofornecedor = '").append("E").append("' ");
                }
            }
            buf.append(" and a.ent_tipo = '").append(this.converterParaTipoEntidade(this.tipoEntidade)).append("' ");
            if (!this.getFiltroCheck("filtroInativo")) {
                buf.append(" and (a.ent_inativo = false or a.ent_inativo is null) ");
            }
            buf.append(" order by a.fil_codigo, ");
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                buf.append("upper(a.ent_razaosocial)");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                buf.append("upper(a.ent_fantasia)");
            } else {
                buf.append("a.ent_codigo");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (i = 0; i < campos.length; ++i) {
                        o[i] = campos[i].equalsIgnoreCase("tipoLogradouroEntidade") ? Tipos.tipoLogradouroDescricao(rs.getString(campos[i])) : (campos[i].equalsIgnoreCase("tipoFornecedor") ? Tipos.getTipoFornecedor(rs.getString(campos[i])) : rs.getObject(campos[i]));
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioEntidades.getModuloAcesso(this.tipoRelatorio, this.tipoEntidade));
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i3;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioEntidades.this.panelCentro.removeAll();
                            RelatorioEntidades.this.panelCentro.repaint();
                            RelatorioEntidades.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    var.put("filtroEstado", this.getFiltroCombo("filtroEstado"));
                    if (this.tipoRelatorio == TIPO_ENTIDADE_FORNECEDOR) {
                        var.put("filtroTipoFornecedor", this.getFiltroCombo("filtroTipoFornecedor"));
                    }
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        for (i3 = 0; i3 < filiais.length; ++i3) {
                            buf.append(filiais[i3]);
                            if (i3 >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroFilial", buf.toString());
                    buf.delete(0, buf.length());
                    if (cidade != null) {
                        for (i3 = 0; i3 < cidade.length; ++i3) {
                            buf.append(cidade[i3]);
                            if (i3 >= cidade.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroCidade", buf.toString());
                    buf.delete(0, buf.length());
                    if (bairro != null) {
                        for (i3 = 0; i3 < bairro.length; ++i3) {
                            buf.append(bairro[i3]);
                            if (i3 >= bairro.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroBairro", buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private String converterParaTipoEntidade(int tipoEntidade) {
        if (tipoEntidade == TIPO_ENTIDADE_FORNECEDOR) {
            return "F";
        }
        if (tipoEntidade == TIPO_ENTIDADE_FUNCIONARIO) {
            return "U";
        }
        if (tipoEntidade == TIPO_ENTIDADE_EMPRESA) {
            return "E";
        }
        if (tipoEntidade == TIPO_ENTIDADE_COLETADOR) {
            return "C";
        }
        if (tipoEntidade == TIPO_ENTIDADE_REPRESENTANTE) {
            return "R";
        }
        if (tipoEntidade == TIPO_ENTIDADE_FISCAL) {
            return "I";
        }
        return "P";
    }

    public static long getModuloAcesso(int tipoRelatorio, int tipoEntidade) {
        if (tipoRelatorio == TIPO_CADASTRO) {
            if (tipoEntidade == TIPO_ENTIDADE_FORNECEDOR) {
                return Long.parseLong("0812500100");
            }
            if (tipoEntidade == TIPO_ENTIDADE_FUNCIONARIO) {
                return Long.parseLong("0812500200");
            }
            if (tipoEntidade == TIPO_ENTIDADE_COLETADOR) {
                return Long.parseLong("0812500300");
            }
            if (tipoEntidade == TIPO_ENTIDADE_REPRESENTANTE) {
                return Long.parseLong("0812500400");
            }
            if (tipoEntidade == TIPO_ENTIDADE_FISCAL) {
                return Long.parseLong("0812500500");
            }
            if (tipoEntidade == TIPO_ENTIDADE_EMPRESA) {
                return Long.parseLong("0812501100");
            }
            return Long.parseLong("0812500600");
        }
        return -1L;
    }
}

