/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.cadastros;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioDestinos
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String[] ordem = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"};
    private final long ACESSO_CONFIGURAR = Long.parseLong("0810700001");
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_CIDADE = "filtroCidade";
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoDestino", "descricaoDestino", "cepDestino", "complementoDestino", "enderecoDestino", "foneDestino", "enviarWebDestino", "naoImprimirDestino", "impressoraDestino", "codigoCidadeDestino", "descricaoCidadeDestino", "estadoCidadeDestino", "codigoBairroDestino", "descricaoBairroDestino", "senhaWebDestino"});

    public RelatorioDestinos() {
        this.setName("RelatorioDestinos");
        this.configuraTitulo();
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroCidade", "Cidade", "cidades", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cid_codigo", "cid_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.setModuloConfigurar(this.ACESSO_CONFIGURAR);
        this.setModuloAcesso(RelatorioDestinos.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    private void configuraTitulo() {
        if (Variaveis.tipoFilialPadrao.equals("A")) {
            this.montaBarraDescricao("Relat\u00f3rio de modalidades", "Listagem de modalidades cadastradas", "relatorios/rel_modalidade.jpg");
        } else {
            this.montaBarraDescricao("Relat\u00f3rio de destinos", "Listagem de destinos cadastrados", "relatorios/rel_destino.jpg");
        }
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("select a.des_codigo as codigoDestino, a.des_descricao as descricaoDestino, a.des_cep as cepDestino, a.des_senhaweb as senhaWebDestino, ");
            buf.append("a.des_complemento as complementoDestino, a.des_endereco as enderecoDestino, a.des_fone as foneDestino, a.des_naoimprimir as naoImprimirDestino,");
            buf.append("a.des_impressora as impressoraDestino, a.des_enviarweb as enviarWebDestino, ");
            buf.append("e.bai_codigo as codigoBairroDestino, e.bai_descricao as descricaoBairroDestino, f.cid_codigo as codigoCidadeDestino, f.cid_nome as descricaoCidadeDestino, f.cid_uf as estadoCidadeDestino, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from destino a ");
            buf.append("left join cidades f on a.fil_codigo = f.fil_codigo and a.cid_codigo = f.cid_codigo ");
            buf.append("left join bairro e on a.fil_codigo = e.fil_codigo and a.bai_codigo = e.bai_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            String[] cidades = this.getSelecionadosFiltro("filtroCidade", 0);
            if (cidades != null) {
                buf.append(" and ");
                for (int i = 0; i < cidades.length; ++i) {
                    buf.append("(a.cid_codigo = ");
                    buf.append(cidades[i]);
                    buf.append(")");
                    if (i >= cidades.length - 1) continue;
                    buf.append(" or ");
                }
            }
            buf.append("order by ");
            if (this.getFiltroCombo("ordemRelatorio").equals("Descri\u00e7\u00e3o")) {
                buf.append("a.des_descricao");
            } else {
                buf.append("a.des_codigo");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        o[i] = rs.getObject(campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioDestinos.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioDestinos.this.panelCentro.removeAll();
                            RelatorioDestinos.this.panelCentro.repaint();
                            RelatorioDestinos.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    buf.delete(0, buf.length());
                    if (cidades != null) {
                        for (int i = 0; i < cidades.length; ++i) {
                            buf.append(cidades[i]);
                            if (i >= cidades.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroCidade", buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0810700000");
    }
}

