/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.cadastros;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioConveniosPorRota
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String[] ordem = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"};
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_ROTA = "filtroRota";
    private String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoRota", "descricaoRota", "responsavelRota", "codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "cnpjConvenio", "observacaoConvenio", "tipoPagamentoConvenio", "faturarFaltaMaterialConvenio", "habilitarDescontoConvenio", "normaConvenio", "multaConvenio", "moraConvenio", "faturarFiliaisConvenio", "quantidade1ViaConvenio", "numeroExamesConvenio", "viasFaturaConvenio", "imprimirBloquetoConvenio", "quantidade2ViaConvenio", "proibidoConvenio", "tipoCalculoFaturaConvenio", "percentualBalcaoConvenio", "cobrarExameBalcaoConvenio", "inscricaoEstadualConvenio", "titularDependenteConvenio", "mascaraCarteiraConvenio", "contatoConvenio", "obrigaMatriculaConvenio", "cepConvenio", "complementoConvenio", "enderecoConvenio", "cepCobrancaConvenio", "complementoCobrancaConvenio", "enderecoCobrancaConvenio", "faxConvenio", "foneConvenio", "valorFilmeConvenio", "valorCHConvenio", "siteConvenio", "email2Convenio", "email1Convenio", "tipoCalculoCHConvenio", "percentualAcrescimoConvenio", "inscricaoMunicipalConvenio", "percentualBonusConvenio", "senhaWebConvenio", "proibidoWebConvenio", "obrigaValidadeGuiaConvenio", "obrigaGuiaConvenio", "diasValidadeGuia", "ordemFaturaConvenio", "cobrarMateriaisConvenio", "dataCadastroConvenio", "codigoCidadeConvenio", "descricaoCidadeConvenio", "estadoCidadeConvenio", "numeroEnderecoConvenio", "numeroEnderecoCobrancaConvenio", "tipoLogradouroConvenio", "tipoLogradouroCobrancaConvenio", "ceiConvenio"});

    public RelatorioConveniosPorRota() {
        this.setName("RelatorioConveniosPorRota");
        this.montaBarraDescricao("Relat\u00f3rio de conv\u00eanios por rota", "Listagem dos conv\u00eanios por rota", "relatorios/rel_convenio_rota.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroRota", "Rota", "rota", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"rot_codigo", "rot_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.setModuloConfigurar(RelatorioConveniosPorRota.getModuloConfigurar());
        this.setModuloAcesso(RelatorioConveniosPorRota.getModuloAcesso());
        this.setCamposConfigurador(this.campos);
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("select con.con_codigo as codigoConvenio, ");
            buf.append("                                  con.con_razao as razaoSocialConvenio, ");
            buf.append("                                  con.con_fantasia as fantasiaConvenio, ");
            buf.append("                                  con.con_cnpjcpf as cnpjConvenio, ");
            buf.append("                                  con.con_observ as observacaoConvenio, ");
            buf.append("                                  con.con_tppgto as tipoPagamentoConvenio, ");
            buf.append("                                  con.con_fatfmaterial as faturarFaltaMaterialConvenio, ");
            buf.append("                                  con.con_descexame as habilitarDescontoConvenio, ");
            buf.append("                                  con.con_norma as normaConvenio, ");
            buf.append("                                  con.con_multa as multaConvenio, ");
            buf.append("                                  con.con_mora as moraConvenio, ");
            buf.append("                                  con.con_fatfiliais as faturarFiliaisConvenio, ");
            buf.append("                                  con.con_impbloqueto as imprimirBloquetoConvenio, ");
            buf.append("                                  con.con_nr2via as quantidade2ViaConvenio, ");
            buf.append("                                  con.con_nr1via as quantidade1ViaConvenio, ");
            buf.append("                                  con.con_nrexames as numeroExamesConvenio, ");
            buf.append("                                  con.con_viasfatura as viasFaturaConvenio, ");
            buf.append("                                  con.con_inscrest as inscricaoEstadualConvenio, ");
            buf.append("                                  con.con_titdep as titularDependenteConvenio, ");
            buf.append("                                  con.con_tpcalcfatu as tipoCalculoFaturaConvenio, ");
            buf.append("                                  con.con_percpgto as percentualBalcaoConvenio, ");
            buf.append("                                  con.con_cobrexame as cobrarExameBalcaoConvenio,");
            buf.append("                                  con.con_maskcart as mascaraCarteiraConvenio, ");
            buf.append("                                  con.con_contato as contatoConvenio, ");
            buf.append("                                  con.con_informarmat as obrigaMatriculaConvenio, ");
            buf.append("                                  con.con_complcobranca as complementoCobrancaConvenio, ");
            buf.append("                                  con.con_endcobranca as enderecoCobrancaConvenio, ");
            buf.append("                                  con.con_fax as faxConvenio, ");
            buf.append("                                  con.con_fone as foneConvenio, ");
            buf.append("                                  con.con_valorfilme as valorFilmeConvenio, ");
            buf.append("                                  con.con_valorch as valorCHConvenio, ");
            buf.append("                                  con.con_site as siteConvenio,");
            buf.append("                                  con.con_email2 as email2Convenio, ");
            buf.append("                                  con.con_email1 as email1Convenio, ");
            buf.append("                                  con.con_tpcalcch as tipoCalculoCHConvenio, ");
            buf.append("                                  con.con_inscmunic as inscricaoMunicipalConvenio, ");
            buf.append("                                  con.con_bonus as percentualBonusConvenio, ");
            buf.append("                                  con.con_senhaweb as senhaWebConvenio, ");
            buf.append("                                  con.con_cep as cepConvenio, ");
            buf.append("                                  con.con_complemento as complementoConvenio, ");
            buf.append("                                  con.con_endereco as enderecoConvenio, ");
            buf.append("                                  con.con_numeroendereco as numeroEnderecoConvenio, ");
            buf.append("                                  con.con_numeroendcobranca as numeroEnderecoCobrancaConvenio, ");
            buf.append("                                  con.con_tipologradouroendereco as tipoLogradouroConvenio, ");
            buf.append("                                  con.con_tipologradouroendcobranca as tipoLogradouroCobrancaConvenio, ");
            buf.append("                                  con.con_cepcobranca as cepCobrancaConvenio, ");
            buf.append("                                  con.con_proibidoweb as proibidoWebConvenio, ");
            buf.append("                                  con.con_validadeguia as obrigaValidadeGuiaConvenio, ");
            buf.append("                                  con.con_codigoguia as obrigaGuiaConvenio, ");
            buf.append("                                  con.con_diasvalidade as diasValidadeGuia, ");
            buf.append("                                  con.con_ordemfatura as ordemFaturaConvenio, ");
            buf.append("                                  con.con_cobrmaterial as cobrarMateriaisConvenio, ");
            buf.append("                                  con.con_acrescimo as percentualAcrescimoConvenio, ");
            buf.append("                                  con.con_proibido as proibidoConvenio, ");
            buf.append("                                  con.con_datacadastro as dataCadastroConvenio, ");
            buf.append("                                  con.usr_codigo as codigoUsuarioCadastro, ");
            buf.append("                                  a.rot_codigo as codigoRota, ");
            buf.append("                                  a.rot_descricao as descricaoRota, ");
            buf.append("                                  a.rot_responsavel as responsavelRota, ");
            buf.append("                                  cid.cid_codigo as codigoCidadeConvenio, ");
            buf.append("                                  cid.cid_nome as descricaoCidadeConvenio, ");
            buf.append("                                  cid.cid_uf as estadoCidadeConvenio, ");
            buf.append("                                  con.con_cei as ceiConvenio, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from rota a ");
            buf.append("join convenios con on a.rot_codigo is not null and a.fil_codigo = con.fil_codigo and a.rot_codigo = con.rot_codigo ");
            buf.append("left join cidades cid on con.fil_codigo = cid.fil_codigo and con.cid_codigo = cid.cid_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append(" where a.fil_codigo ");
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais == null || filiais.length == 0) {
                buf.append(" = ").append(Variaveis.filialPadrao);
            } else {
                buf.append(" in (");
                for (int i = 0; i < filiais.length; ++i) {
                    buf.append(filiais[i]);
                    if (i >= filiais.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            String[] rota = this.getSelecionadosFiltro("filtroRota", 0);
            if (rota != null) {
                buf.append(" and a.rot_codigo in (");
                for (int i = 0; i < rota.length; ++i) {
                    buf.append(rota[i]);
                    if (i >= rota.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            buf.append(" order by ");
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                buf.append(" descricaoRota, fantasiaConvenio ");
            } else {
                buf.append(" codigoRota, codigoConvenio ");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(this.campos);
                do {
                    Object[] o = new Object[this.campos.length];
                    for (int i = 0; i < this.campos.length; ++i) {
                        o[i] = this.campos[i].equalsIgnoreCase("tipoLogradouroConvenio") || this.campos[i].equalsIgnoreCase("tipoLogradouroCobrancaConvenio") ? Tipos.tipoLogradouroDescricao(rs.getString(this.campos[i])) : rs.getObject(this.campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioConveniosPorRota.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioConveniosPorRota.this.panelCentro.removeAll();
                            RelatorioConveniosPorRota.this.panelCentro.repaint();
                            RelatorioConveniosPorRota.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        for (i = 0; i < filiais.length; ++i) {
                            buf.append(filiais[i]);
                            if (i >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroFilial", buf.toString());
                    buf.delete(0, buf.length());
                    if (rota != null) {
                        for (i = 0; i < rota.length; ++i) {
                            buf.append(rota[i]);
                            if (i >= rota.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroRota", buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0811700400");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0811700401");
    }
}

