/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.cadastros;

import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioConvenios
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    public static int TIPO_CADASTRO = 1;
    public static int TIPO_MALADIRETA = 2;
    private int tipoRelatorio = TIPO_CADASTRO;
    private final String[] ordem = new String[]{"C\u00f3digo", "Raz\u00e3o social", "Fantasia", "Cidade"};
    private final long ACESSO_CONFIGURAR_CADASTRO = Long.parseLong("0811700301");
    private final long ACESSO_CONFIGURAR_MALADIRETA = Long.parseLong("0890400201");
    private final String FILTRO_ESTADO = "filtroEstado";
    private final String FILTRO_CIDADE = "filtroCidade";
    private final String FILTRO_ROTA = "filtroRota";
    private final String FILTRO_PRIORIDADE = "filtroPrioridade";
    private final String FILTRO_TABELA = "filtroTabela";
    private final String FILTRO_MODELO = "filtroModelo";
    private final String FILTRO_APOIO = "filtroApoio";
    private final String FILTRO_PROIBIDO = "filtroProibido";
    private final String FILTRO_NAO_PROIBIDO = "filtroNaoProibido";
    private final String FILTRO_PROIBIDO_WEB = "filtroProibidoWeb";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String[] estados = ArraysUtil.concatenar(new String[]{"Todos"}, ConstantesGerais.ESTADOS);
    private String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "cnpjConvenio", "observacaoConvenio", "tipoPagamentoConvenio", "faturarFaltaMaterialConvenio", "habilitarDescontoConvenio", "normaConvenio", "multaConvenio", "moraConvenio", "faturarFiliaisConvenio", "quantidade1ViaConvenio", "numeroExamesConvenio", "viasFaturaConvenio", "imprimirBloquetoConvenio", "quantidade2ViaConvenio", "proibidoConvenio", "tipoCalculoFaturaConvenio", "percentualBalcaoConvenio", "cobrarExameBalcaoConvenio", "inscricaoEstadualConvenio", "titularDependenteConvenio", "vencimentosConvenio", "mascaraCarteiraConvenio", "contatoConvenio", "obrigaMatriculaConvenio", "cepConvenio", "complementoConvenio", "enderecoConvenio", "cepCobrancaConvenio", "complementoCobrancaConvenio", "enderecoCobrancaConvenio", "faxConvenio", "foneConvenio", "valorFilmeConvenio", "valorCHConvenio", "siteConvenio", "email2Convenio", "email1Convenio", "tipoCalculoCHConvenio", "percentualAcrescimoConvenio", "inscricaoMunicipalConvenio", "percentualBonusConvenio", "senhaWebConvenio", "proibidoWebConvenio", "obrigaValidadeGuiaConvenio", "obrigaGuiaConvenio", "diasValidadeGuia", "ordemFaturaConvenio", "cobrarMateriaisConvenio", "dataCadastroConvenio", "codigoUsuarioCadastro", "nomeUsuarioCadastro", "codigoPrioridade", "descricaoPrioridade", "codigoTabela", "descricaoTabela", "valorCHTabela", "moedaTabela", "codigoCidadeCobrancaConvenio", "descricaoCidadeCobrancaConvenio", "estadoCidadeCobrancaConvenio", "codigoCidadeConvenio", "descricaoCidadeConvenio", "estadoCidadeConvenio", "codigoBairroCobrancaConvenio", "descricaoBairroCobrancaConvenio", "codigoBairroConvenio", "descricaoBairroConvenio", "codigoModelo", "descricaoModelo", "codigoDestino", "descricaoDestino", "cepDestino", "complementoDestino", "enderecoDestino", "foneDestino", "enviarWebDestino", "naoImprimirDestino", "impressoraDestino", "codigoCidadeDestino", "descricaoCidadeDestino", "estadoCidadeDestino", "codigoBairroDestino", "descricaoBairroDestino", "codigoColeta", "descricaoColeta", "cepColeta", "complementoColeta", "enderecoColeta", "foneColeta", "codigoCidadeColeta", "descricaoCidadeColeta", "estadoCidadeColeta", "codigoBairroColeta", "descricaoBairroColeta", "codigoRota", "descricaoRota", "responsavelRota", "codigoCelulaEstoque", "descricaoCelulaEstoque", "numeroEnderecoConvenio", "numeroEnderecoCobrancaConvenio", "tipoLogradouroConvenio", "tipoLogradouroCobrancaConvenio"});

    public RelatorioConvenios(int tipo) {
        this.setName("RelatorioConvenios");
        this.tipoRelatorio = tipo;
        if (tipo == TIPO_CADASTRO) {
            this.montaBarraDescricao("Relat\u00f3rio de conv\u00eanios", "Listagem dos conv\u00eanios cadastrados", "relatorios/rel_convenio.jpg");
            this.campos = ArraysUtil.concatenar(this.campos, new String[]{"ceiConvenio"});
        } else {
            this.montaBarraDescricao("Mala-direta de conv\u00eanios", "Listagem dos conv\u00eanios cadastrados para mala-direta", "relatorios/mala_direta_convenio.jpg");
        }
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroPrioridade", "Prioridade", "prioridade", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"pri_codigo", "pri_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroTabela", "Tabela", "tabelaprecoexames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"tpe_codigo", "tpe_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroModelo", "Modelo", "layout", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"lay_codigo", "lay_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroCidade", "Cidade", "cidades", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cid_codigo", "cid_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroRota", "Rota", "rota", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"rot_codigo", "rot_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Cad. inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Cad. final:");
        this.adicionaFiltroCombo("filtroEstado", "Estado:", this.estados, 0);
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.adicionaFiltroCheck("filtroApoio", "Somente apoio", false);
        this.adicionaFiltroCheck("filtroProibido", "Somente proibidos", false);
        this.adicionaFiltroCheck("filtroProibidoWeb", "Somente proibidos web", false);
        this.adicionaFiltroCheck("filtroNaoProibido", "Somente liberados", false);
        if (tipo == TIPO_CADASTRO) {
            this.setModuloConfigurar(this.ACESSO_CONFIGURAR_CADASTRO);
        } else {
            this.setModuloConfigurar(this.ACESSO_CONFIGURAR_MALADIRETA);
        }
        this.setModuloAcesso(RelatorioConvenios.getModuloAcesso(tipo));
        this.setCamposConfigurador(this.campos);
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        try {
            String[] rota;
            String[] cidade;
            String[] modelos;
            String[] tabelas;
            String[] prioridades;
            StringBuilder buf = new StringBuilder("select a.con_codigo as codigoConvenio, a.con_razao as razaoSocialConvenio, a.con_fantasia as fantasiaConvenio, ");
            buf.append("a.con_cnpjcpf as cnpjConvenio, a.con_observ as observacaoConvenio, a.con_tppgto as tipoPagamentoConvenio, ");
            buf.append("a.con_fatfmaterial as faturarFaltaMaterialConvenio, a.con_descexame as habilitarDescontoConvenio, a.con_norma as normaConvenio,");
            buf.append("a.con_multa as multaConvenio, a.con_mora as moraConvenio, a.con_fatfiliais as faturarFiliaisConvenio,");
            buf.append("a.con_nr1via as quantidade1ViaConvenio, a.con_nrexames as numeroExamesConvenio, a.con_viasfatura as viasFaturaConvenio,");
            buf.append("a.con_impbloqueto as imprimirBloquetoConvenio, a.con_nr2via as quantidade2ViaConvenio,");
            buf.append("a.con_tpcalcfatu as tipoCalculoFaturaConvenio, a.con_percpgto as percentualBalcaoConvenio, a.con_cobrexame as cobrarExameBalcaoConvenio,");
            buf.append("a.con_inscrest as inscricaoEstadualConvenio, a.con_titdep as titularDependenteConvenio,");
            buf.append("a.con_maskcart as mascaraCarteiraConvenio, a.con_contato as contatoConvenio, a.con_informarmat as obrigaMatriculaConvenio,");
            buf.append("a.con_cep as cepConvenio, a.con_complemento as complementoConvenio, a.con_endereco as enderecoConvenio, a.con_cepcobranca as cepCobrancaConvenio,");
            buf.append("a.con_numeroendereco as numeroEnderecoConvenio, a.con_tipologradouroendereco as tipoLogradouroConvenio, ");
            buf.append("a.con_numeroendcobranca as numeroEnderecoCobrancaConvenio, a.con_tipologradouroendcobranca as tipoLogradouroCobrancaConvenio, ");
            buf.append("a.con_complcobranca as complementoCobrancaConvenio, a.con_endcobranca as enderecoCobrancaConvenio, a.con_fax as faxConvenio,");
            buf.append("a.con_fone as foneConvenio, a.con_valorfilme as valorFilmeConvenio, a.con_valorch as valorCHConvenio, a.con_site as siteConvenio,");
            buf.append("a.con_email2 as email2Convenio, a.con_email1 as email1Convenio, a.con_tpcalcch as tipoCalculoCHConvenio,");
            buf.append("a.con_inscmunic as inscricaoMunicipalConvenio, a.con_bonus as percentualBonusConvenio, a.con_senhaweb as senhaWebConvenio,");
            buf.append("a.con_acrescimo as percentualAcrescimoConvenio, a.con_proibido as proibidoConvenio, ");
            buf.append("a.con_proibidoweb as proibidoWebConvenio, a.con_validadeguia as obrigaValidadeGuiaConvenio, a.con_codigoguia as obrigaGuiaConvenio,");
            buf.append("a.con_diasvalidade as diasValidadeGuia, a.con_ordemfatura as ordemFaturaConvenio, a.con_cobrmaterial as cobrarMateriaisConvenio, ");
            buf.append("p.pri_codigo as codigoPrioridade, p.pri_descricao as descricaoPrioridade,");
            buf.append("t.tpe_codigo as codigoTabela, t.tpe_descricao as descricaoTabela, t.tpe_valorch as valorCHTabela, t.tpe_moeda as moedaTabela,");
            buf.append("cidcob.cid_codigo as codigoCidadeCobrancaConvenio, cidcob.cid_nome as descricaoCidadeCobrancaConvenio,");
            buf.append("cidcob.cid_uf as estadoCidadeCobrancaConvenio,");
            buf.append("a.con_datacadastro as dataCadastroConvenio, ");
            buf.append("a.usr_codigo as codigoUsuarioCadastro, usuario.usr_nome as nomeUsuarioCadastro, ");
            buf.append("cid.cid_codigo as codigoCidadeConvenio, cid.cid_nome as descricaoCidadeConvenio, cid.cid_uf as estadoCidadeConvenio,");
            buf.append("baicob.bai_codigo as codigoBairroCobrancaConvenio, baicob.bai_descricao as descricaoBairroCobrancaConvenio,");
            buf.append("bai.bai_codigo as codigoBairroConvenio, bai.bai_descricao as descricaoBairroConvenio,");
            buf.append("l.lay_codigo as codigoModelo, l.lay_descricao as descricaoModelo,");
            buf.append("d.des_codigo as codigoDestino, d.des_descricao as descricaoDestino, d.des_cep as cepDestino,");
            buf.append("d.des_complemento as complementoDestino, d.des_endereco as enderecoDestino, d.des_fone as foneDestino,");
            buf.append("d.des_enviarweb as enviarWebDestino, d.des_naoimprimir as naoImprimirDestino, d.des_impressora as impressoraDestino,");
            buf.append("ciddes.cid_codigo as codigoCidadeDestino, ciddes.cid_nome as descricaoCidadeDestino, ciddes.cid_uf as estadoCidadeDestino,");
            buf.append("baides.bai_codigo as codigoBairroDestino, baides.bai_descricao as descricaoBairroDestino,");
            buf.append("c.col_codigo as codigoColeta, c.col_descricao as descricaoColeta, c.col_cep as cepColeta,");
            buf.append("c.col_complemento as complementoColeta, c.col_endereco as enderecoColeta, c.col_fone as foneColeta,");
            buf.append("cidcol.cid_codigo as codigoCidadeColeta, cidcol.cid_nome as descricaoCidadeColeta, cidcol.cid_uf as estadoCidadeColeta,");
            buf.append("baicol.bai_codigo as codigoBairroColeta, baicol.bai_descricao as descricaoBairroColeta,");
            buf.append("rot.rot_codigo as codigoRota, rot.rot_descricao as descricaoRota, rot.rot_responsavel as responsavelRota, ");
            buf.append("cel.cel_codigo as codigoCelulaEstoque, cel.cel_descricao as descricaoCelulaEstoque, ");
            buf.append("a.con_cei as ceiConvenio, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from convenios a ");
            buf.append("left join prioridade p on a.fil_codigo = p.fil_codigo and a.pri_codigo = p.pri_codigo ");
            buf.append("left join tabelaprecoexames t on a.fil_codigo = t.fil_codigo and a.tpe_codigo = t.tpe_codigo ");
            buf.append("left join layout l on a.fil_codigo = l.fil_codigo and a.lay_codigo = l.lay_codigo ");
            buf.append("left join cidades cidcob on a.fil_codigo = cidcob.fil_codigo and a.cid_codcobranca = cidcob.cid_codigo ");
            buf.append("left join bairro baicob on a.fil_codigo = baicob.fil_codigo and a.bai_codcobranca = baicob.bai_codigo ");
            buf.append("left join bairro bai on a.fil_codigo = bai.fil_codigo and a.bai_codigo = bai.bai_codigo ");
            buf.append("left join cidades cid on a.fil_codigo = cid.fil_codigo and a.cid_codigo = cid.cid_codigo ");
            buf.append("left join destino d on a.fil_codigo = d.fil_codigo and a.des_codigo = d.des_codigo ");
            buf.append("left join cidades ciddes on d.fil_codigo = ciddes.fil_codigo and d.cid_codigo = ciddes.cid_codigo ");
            buf.append("left join bairro baides on d.fil_codigo = baides.fil_codigo and d.bai_codigo = baides.bai_codigo ");
            buf.append("left join coletas c on a.fil_codigo = c.fil_codigo and a.col_codigo = c.col_codigo ");
            buf.append("left join cidades cidcol on d.fil_codigo = cidcol.fil_codigo and c.cid_codigo = cidcol.cid_codigo ");
            buf.append("left join bairro baicol on d.fil_codigo = baicol.fil_codigo and c.bai_codigo = baicol.bai_codigo ");
            buf.append("left join usuario on a.usr_codigo = usuario.usr_codigo ");
            buf.append("left join rota rot on a.fil_codigo = rot.fil_codigo and a.rot_codigo = rot.rot_codigo ");
            buf.append("left join celulaestoque cel on a.fil_codigo = cel.fil_codigo and a.cel_codigo = cel.cel_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            String dataInicial = this.getFiltroData(FILTRO_DATA_INICIAL);
            String dataFinal = this.getFiltroData(FILTRO_DATA_FINAL);
            if (dataInicial != null && Funcoes.verificaData(dataInicial)) {
                buf.append(" and cast(con_datacadastro as date) >= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", dataInicial));
                buf.append("'");
            }
            if (dataFinal != null && Funcoes.verificaData(dataFinal)) {
                buf.append(" and cast(con_datacadastro as date) <= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", dataFinal));
                buf.append("'");
            }
            if ((prioridades = this.getSelecionadosFiltro("filtroPrioridade", 0)) != null) {
                buf.append(" and a.pri_codigo in (");
                for (int i = 0; i < prioridades.length; ++i) {
                    buf.append(prioridades[i]);
                    if (i >= prioridades.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((tabelas = this.getSelecionadosFiltro("filtroTabela", 0)) != null) {
                buf.append(" and a.tpe_codigo in (");
                for (int i = 0; i < tabelas.length; ++i) {
                    buf.append(tabelas[i]);
                    if (i >= tabelas.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((modelos = this.getSelecionadosFiltro("filtroModelo", 0)) != null) {
                buf.append(" and a.lay_codigo in (");
                for (int i = 0; i < modelos.length; ++i) {
                    buf.append(modelos[i]);
                    if (i >= modelos.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((cidade = this.getSelecionadosFiltro("filtroCidade", 0)) != null) {
                buf.append(" and a.cid_codigo in (");
                for (int i = 0; i < cidade.length; ++i) {
                    buf.append(cidade[i]);
                    if (i >= cidade.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((rota = this.getSelecionadosFiltro("filtroRota", 0)) != null) {
                buf.append(" and a.rot_codigo in (");
                for (int i = 0; i < rota.length; ++i) {
                    buf.append(rota[i]);
                    if (i >= rota.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if (!this.getFiltroCombo("filtroEstado").equals(this.estados[0])) {
                buf.append(" and cid.cid_uf = '");
                buf.append(this.getFiltroCombo("filtroEstado"));
                buf.append("'");
            }
            if (!this.getFiltroCombo("filtroEstado").equals(this.estados[0])) {
                buf.append(" and cid.cid_uf = '");
                buf.append(this.getFiltroCombo("filtroEstado"));
                buf.append("'");
            }
            if (this.getFiltroCheck("filtroApoio")) {
                buf.append(" and a.con_apoiado  = true ");
            }
            if (this.getFiltroCheck("filtroProibido")) {
                buf.append(" and a.con_proibido  = true ");
            }
            if (this.getFiltroCheck("filtroNaoProibido")) {
                buf.append(" and a.con_proibido  = false ");
            }
            if (this.getFiltroCheck("filtroProibidoWeb")) {
                buf.append(" and a.con_proibidoweb  = true ");
            }
            buf.append(" order by ");
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                buf.append("a.con_razao");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                buf.append("a.con_fantasia");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[3])) {
                buf.append("cid.cid_nome, cid.cid_uf");
            } else {
                buf.append("a.con_codigo");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(this.campos);
                do {
                    Object[] o = new Object[this.campos.length];
                    for (int i = 0; i < this.campos.length; ++i) {
                        if (this.campos[i].equalsIgnoreCase("tipoLogradouroConvenio") || this.campos[i].equalsIgnoreCase("tipoLogradouroCobrancaConvenio")) {
                            o[i] = Tipos.tipoLogradouroDescricao(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("tipoPagamentoConvenio")) {
                            o[i] = Tipos.tipoPagamento(rs.getString("tipoPagamentoConvenio"));
                            continue;
                        }
                        if (this.campos[i].equals("tipoCalculoFaturaConvenio")) {
                            o[i] = Tipos.tipoCalculoFatura(rs.getString("tipoCalculoFaturaConvenio"));
                            continue;
                        }
                        if (this.campos[i].equals("tipoCalculoCHConvenio")) {
                            o[i] = Tipos.tipoCalculoCH(rs.getString("tipoCalculoCHConvenio"));
                            continue;
                        }
                        if (this.campos[i].equals("titularDependenteConvenio")) {
                            o[i] = Tipos.tipoTitularDependente(rs.getString("titularDependenteConvenio"));
                            continue;
                        }
                        if (this.campos[i].equals("ordemFaturaConvenio")) {
                            o[i] = Tipos.tipoOrdemFatura(rs.getString("ordemFaturaConvenio"));
                            continue;
                        }
                        if (this.campos[i].equals("vencimentosConvenio")) {
                            buf.delete(0, buf.length());
                            buf.append("select cpv_diavenc from conveniosvencimento where fil_codigo = ");
                            buf.append(Variaveis.filialPadrao);
                            buf.append(" and con_codigo = ");
                            buf.append(rs.getString("codigoConvenio"));
                            ResultSet query = Conexao.executeQuery(st2, buf.toString());
                            if (query != null) {
                                String dias = "";
                                while (query.next()) {
                                    if (dias.trim().length() > 0) {
                                        dias = dias + ",";
                                    }
                                    dias = dias + query.getString("cpv_diavenc");
                                }
                                o[i] = dias;
                            }
                            query.close();
                            continue;
                        }
                        o[i] = rs.getObject(this.campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioConvenios.getModuloAcesso(this.tipoRelatorio));
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioConvenios.this.panelCentro.removeAll();
                            RelatorioConvenios.this.panelCentro.repaint();
                            RelatorioConvenios.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    var.put("filtroApoio", this.getFiltroCheck("filtroApoio") ? "Sim" : "N\u00e3o");
                    var.put("filtroProibido", this.getFiltroCheck("filtroProibido") ? "Sim" : "N\u00e3o");
                    var.put("filtroNaoProibido", this.getFiltroCheck("filtroNaoProibido") ? "Sim" : "N\u00e3o");
                    var.put("filtroProibidoWeb", this.getFiltroCheck("filtroProibidoWeb") ? "Sim" : "N\u00e3o");
                    var.put("filtroEstado", this.getFiltroCombo("filtroEstado"));
                    var.put(FILTRO_DATA_INICIAL, dataInicial);
                    var.put(FILTRO_DATA_FINAL, dataFinal);
                    buf.delete(0, buf.length());
                    if (prioridades != null) {
                        for (int i = 0; i < prioridades.length; ++i) {
                            buf.append(prioridades[i]);
                            if (i >= prioridades.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroPrioridade", buf.toString());
                    buf.delete(0, buf.length());
                    if (tabelas != null) {
                        for (int i = 0; i < tabelas.length; ++i) {
                            buf.append(tabelas[i]);
                            if (i >= tabelas.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroTabela", buf.toString());
                    buf.delete(0, buf.length());
                    if (modelos != null) {
                        for (int i = 0; i < modelos.length; ++i) {
                            buf.append(modelos[i]);
                            if (i >= modelos.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroModelo", buf.toString());
                    buf.delete(0, buf.length());
                    if (cidade != null) {
                        for (int i = 0; i < cidade.length; ++i) {
                            buf.append(cidade[i]);
                            if (i >= cidade.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroCidade", buf.toString());
                    buf.delete(0, buf.length());
                    if (rota != null) {
                        for (int i = 0; i < rota.length; ++i) {
                            buf.append(rota[i]);
                            if (i >= rota.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroRota", buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso(int tipo) {
        if (tipo == TIPO_CADASTRO) {
            return Long.parseLong("0811700300");
        }
        return Long.parseLong("0890400200");
    }
}

