/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.cadastros;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioAgrupaSituacao
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_SITUACAO = "filtroSituacao";
    private final String[] ordem = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"};
    private final long ACESSO_CONFIGURAR = Long.parseLong("0811901231");
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoExame", "descricaoExame", "sexoExame", "materialPadraoExame", "horaEntradaExame", "horaSaidaExame", "filtroExame", "proibidoExame", "diagnosticoExame", "interferenciaExame", "sinonimoExame", "salvaParcialExame", "idadeMaximaExame", "idadeMinimaExame", "tipoIdadeMaximaExame", "tipoIdadeMinimaExame", "proibidoWebExame", "quantidadeAmostrasExame", "materialPadraoExame", "preparoExame", "inadequadaExame", "codigoPrazoEntrega", "codigoMetodologia", "ordemExame", "paginaExame", "cbhpmExame", "ambExame", "conservacaoExame", "diasConservacaoExame", "temperaturaInicialExame", "temperaturaFinalExame", "referenciaExame", "procedimentoExame", "solicitarJejumExame", "solicitarMedicamentoExame", "solicitarDUMExame", "solicitarTempoDiureseExame", "instrucaoColetaExame", "marcarExternoExame", "descricaoPrazoEntrega", "rotinaPrazoEntrega", "diasPrazoEntrega", "horaEntradaPrazoEntrega", "horaSaidaPrazoEntrega", "descricaoMetodologia", "descricaoMaterialColetado", "solicitarMaterialMaterialColetado", "abreviaturaMaterialColetado", "codigoSetor", "descricaoSetor", "responsavelSetor", "corSetor", "siglaSetor", "codigoUsuario", "nomeUsuario", "codigoSituacao", "descricaoSituacao", "codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "cnpjConvenio", "tipoPagamentoConvenio", "faturarFaltaMaterialConvenio", "habilitarDescontoConvenio", "multaConvenio", "moraConvenio", "faturarFiliaisConvenio", "quantidade1ViaConvenio", "numeroExamesConvenio", "viasFaturaConvenio", "imprimirBloquetoConvenio", "quantidade2ViaConvenio", "tipoCalculoFaturaConvenio", "percentualBalcaoConvenio", "cobrarExameBalcaoConvenio", "inscricaoEstadualConvenio", "titularDependenteConvenio", "mascaraCarteiraConvenio", "contatoConvenio", "obrigaMatriculaConvenio", "cepConvenio", "complementoConvenio", "enderecoConvenio", "cepCobrancaConvenio", "complementoCobrancaConvenio", "enderecoCobrancaConvenio", "faxConvenio", "foneConvenio", "valorFilmeConvenio", "valorCHConvenio", "siteConvenio", "email2Convenio", "email1Convenio", "tipoCalculoCHConvenio", "inscricaoMunicipalConvenio", "percentualBonusConvenio", "percentualAcrescimoConvenio", "senhaWebConvenio", "proibidoWebConvenio", "obrigaValidadeGuiaConvenio", "obrigaGuiaConvenio", "diasValidadeGuia", "ordemFaturaConvenio", "cobrarMateriaisConvenio", "codigoPrioridade", "descricaoPrioridade", "codigoTabela", "descricaoTabela", "valorCHTabela", "moedaTabela", "codigoCidadeConvenio", "descricaoCidadeConvenio", "estadoCidadeConvenio", "codigoBairroConvenio", "descricaoBairroConvenio", "codigoModelo", "descricaoModelo", "numeroEnderecoConvenio", "numeroEnderecoCobrancaConvenio", "tipoLogradouroConvenio", "tipoLogradouroCobrancaConvenio"});

    public RelatorioAgrupaSituacao() {
        this.setName("RelatorioAgrupaSituacao");
        this.montaBarraDescricao("Relat\u00f3rio de agrupamento de exames para situa\u00e7\u00e3o", "Listagem dos agrupamentos de exames para situa\u00e7\u00e3o cadastrados", "relatorios/rel_exm_situacao.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSituacao", "Situa\u00e7\u00e3o", "situacao", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"sit_codigo", "sit_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.setModuloConfigurar(this.ACESSO_CONFIGURAR);
        this.setModuloAcesso(RelatorioAgrupaSituacao.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String[] situacoes;
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("select i.exa_codigo as codigoExame, ");
            buf.append("a.exa_descricao as descricaoExame, ");
            buf.append("a.exa_sexo as sexoExame, ");
            buf.append("a.exa_horaentrada as horaEntradaExame, ");
            buf.append("a.exa_horasaida as horaSaidaExame, ");
            buf.append("a.exa_filtro as filtroExame, ");
            buf.append("a.exa_proibido as proibidoExame, ");
            buf.append("a.exa_diagnostico as diagnosticoExame, ");
            buf.append("a.exa_interferencia as interferenciaExame, ");
            buf.append("a.exa_sinonimo as sinonimoExame, ");
            buf.append("a.exa_salvaparcial as salvaParcialExame, ");
            buf.append("a.exa_idademax as idadeMaximaExame, ");
            buf.append("a.exa_idademin as idadeMinimaExame, ");
            buf.append("a.exa_idademaxtipo as tipoIdadeMaximaExame, ");
            buf.append("a.exa_idademintipo as tipoIdadeMinimaExame, ");
            buf.append("a.exa_proibidoweb as proibidoWebExame, ");
            buf.append("a.exa_qtdeamostras as quantidadeAmostrasExame, ");
            buf.append("b.emc_default as materialPadraoExame, ");
            buf.append("b.emc_preparo as preparoExame, ");
            buf.append("b.emc_inadequada as inadequadaExame, ");
            buf.append("b.prz_codigo as codigoPrazoEntrega, ");
            buf.append("b.met_codigo as codigoMetodologia, ");
            buf.append("b.emc_ordem as ordemExame, ");
            buf.append("b.emc_pagina as paginaExame, ");
            buf.append("b.emc_codigocbhpm as cbhpmExame, ");
            buf.append("b.emc_codigoamb as ambExame, ");
            buf.append("b.emc_conservacao as conservacaoExame, ");
            buf.append("b.emc_diasconserva as diasConservacaoExame, ");
            buf.append("b.emc_temperaturainicial as temperaturaInicialExame, ");
            buf.append("b.emc_temperaturafinal as temperaturaFinalExame, ");
            buf.append("b.emc_referencia as referenciaExame, ");
            buf.append("b.emc_procedimento as procedimentoExame, ");
            buf.append("b.emc_solicitarjejum as solicitarJejumExame, ");
            buf.append("b.emc_obrigamedicamento as solicitarMedicamentoExame, ");
            buf.append("b.emc_obrigadum as solicitarDUMExame, ");
            buf.append("b.emc_obrigapeso as solicitarPesoExame, ");
            buf.append("b.emc_obrigaaltura as solicitarAlturaExame, ");
            buf.append("b.emc_obrigavolume as solicitarVolumeExame, ");
            buf.append("b.emc_obrigatempodiurese as solicitarTempoDiureseExame, ");
            buf.append("b.emc_instrcoleta as instrucaoColetaExame, ");
            buf.append("b.emc_marcarexterno as marcarExternoExame, ");
            buf.append("c.prz_descricao as descricaoPrazoEntrega, ");
            buf.append("c.prz_prazo as rotinaPrazoEntrega, ");
            buf.append("c.prz_dias as diasPrazoEntrega, ");
            buf.append("c.prz_horaentrada as horaEntradaPrazoEntrega, ");
            buf.append("c.prz_horasaida as horaSaidaPrazoEntrega, ");
            buf.append("d.met_descricao as descricaoMetodologia, ");
            buf.append("e.mco_descricao as descricaoMaterialColetado, ");
            buf.append("e.mco_solicitarmat as solicitarMaterialMaterialColetado, ");
            buf.append("e.mco_abreviatura as abreviaturaMaterialColetado, ");
            buf.append("f.set_codigo as codigoSetor, ");
            buf.append("g.set_descricao as descricaoSetor, ");
            buf.append("g.set_responsavel as responsavelSetor, ");
            buf.append("g.set_cor as corSetor, ");
            buf.append("g.set_sigla as siglaSetor, ");
            buf.append("h.usr_codigo as codigoUsuario, ");
            buf.append("h.usr_nome as nomeUsuario, ");
            buf.append("j.sit_codigo as codigoSituacao, ");
            buf.append("j.sit_descricao as descricaoSituacao, ");
            buf.append("convenio.con_codigo as codigoConvenio, ");
            buf.append("convenio.con_razao as razaoSocialConvenio, ");
            buf.append("convenio.con_fantasia as fantasiaConvenio, ");
            buf.append("convenio.con_cnpjcpf as cnpjConvenio, ");
            buf.append("convenio.con_tppgto as tipoPagamentoConvenio, ");
            buf.append("convenio.con_fatfmaterial as faturarFaltaMaterialConvenio, ");
            buf.append("convenio.con_descexame as habilitarDescontoConvenio, ");
            buf.append("convenio.con_multa as multaConvenio, ");
            buf.append("convenio.con_mora as moraConvenio, ");
            buf.append("convenio.con_fatfiliais as faturarFiliaisConvenio, ");
            buf.append("convenio.con_nr1via as quantidade1ViaConvenio, ");
            buf.append("convenio.con_nrexames as numeroExamesConvenio, ");
            buf.append("convenio.con_viasfatura as viasFaturaConvenio, ");
            buf.append("convenio.con_impbloqueto as imprimirBloquetoConvenio, ");
            buf.append("convenio.con_nr2via as quantidade2ViaConvenio, ");
            buf.append("convenio.con_tpcalcfatu as tipoCalculoFaturaConvenio, ");
            buf.append("convenio.con_percpgto as percentualBalcaoConvenio, ");
            buf.append("convenio.con_cobrexame as cobrarExameBalcaoConvenio, ");
            buf.append("convenio.con_inscrest as inscricaoEstadualConvenio, ");
            buf.append("convenio.con_titdep as titularDependenteConvenio, ");
            buf.append("convenio.con_maskcart as mascaraCarteiraConvenio, ");
            buf.append("convenio.con_contato as contatoConvenio, ");
            buf.append("convenio.con_informarmat as obrigaMatriculaConvenio, ");
            buf.append("convenio.con_cep as cepConvenio, ");
            buf.append("convenio.con_complemento as complementoConvenio, ");
            buf.append("convenio.con_endereco as enderecoConvenio, ");
            buf.append("convenio.con_cepcobranca as cepCobrancaConvenio, ");
            buf.append("convenio.con_complcobranca as complementoCobrancaConvenio, ");
            buf.append("convenio.con_endcobranca as enderecoCobrancaConvenio, ");
            buf.append("convenio.con_numeroendereco as numeroEnderecoConvenio, ");
            buf.append("convenio.con_numeroendcobranca as numeroEnderecoCobrancaConvenio, ");
            buf.append("convenio.con_tipologradouroendereco as tipoLogradouroConvenio, ");
            buf.append("convenio.con_tipologradouroendcobranca as tipoLogradouroCobrancaConvenio, ");
            buf.append("convenio.con_fax as faxConvenio, ");
            buf.append("convenio.con_fone as foneConvenio, ");
            buf.append("convenio.con_valorfilme as valorFilmeConvenio, ");
            buf.append("convenio.con_valorch as valorCHConvenio, ");
            buf.append("convenio.con_site as siteConvenio, ");
            buf.append("convenio.con_email2 as email2Convenio, ");
            buf.append("convenio.con_email1 as email1Convenio, ");
            buf.append("convenio.con_tpcalcch as tipoCalculoCHConvenio, ");
            buf.append("convenio.con_inscmunic as inscricaoMunicipalConvenio, ");
            buf.append("convenio.con_bonus as percentualBonusConvenio, ");
            buf.append("convenio.con_acrescimo as percentualAcrescimoConvenio, ");
            buf.append("convenio.con_senhaweb as senhaWebConvenio, ");
            buf.append("convenio.con_proibidoweb as proibidoWebConvenio, ");
            buf.append("convenio.con_validadeguia as obrigaValidadeGuiaConvenio, ");
            buf.append("convenio.con_codigoguia as obrigaGuiaConvenio, ");
            buf.append("convenio.con_diasvalidade as diasValidadeGuia, ");
            buf.append("convenio.con_ordemfatura as ordemFaturaConvenio, ");
            buf.append("convenio.con_cobrmaterial as cobrarMateriaisConvenio, ");
            buf.append("prioridade.pri_codigo as codigoPrioridade, ");
            buf.append("prioridade.pri_descricao as descricaoPrioridade, ");
            buf.append("tabela.tpe_codigo as codigoTabela, ");
            buf.append("tabela.tpe_descricao as descricaoTabela, ");
            buf.append("tabela.tpe_valorch as valorCHTabela, ");
            buf.append("tabela.tpe_moeda as moedaTabela, ");
            buf.append("cidconvenio.cid_codigo as codigoCidadeConvenio, ");
            buf.append("cidconvenio.cid_nome as descricaoCidadeConvenio, ");
            buf.append("cidconvenio.cid_uf as estadoCidadeConvenio, ");
            buf.append("baiconvenio.bai_codigo as codigoBairroConvenio, ");
            buf.append("baiconvenio.bai_descricao as descricaoBairroConvenio, ");
            buf.append("layout.lay_codigo as codigoModelo, ");
            buf.append("layout.lay_descricao as descricaoModelo, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append(" from exameagrupasituacao i ");
            buf.append(" join exames a on i.fil_codigo = a.fil_codigo and i.exa_codigo = a.exa_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append(" left join examematcoleta b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo and i.mco_codigo = b.mco_codigo");
            buf.append(" left join prazoentrega c on a.fil_codigo = c.fil_codigo and b.prz_codigo = c.prz_codigo ");
            buf.append(" left join metodologia d on a.fil_codigo = d.fil_codigo and b.met_codigo = d.met_codigo ");
            buf.append(" left join materialcoleta e on a.fil_codigo = e.fil_codigo and b.mco_codigo = e.mco_codigo ");
            buf.append(" left join examesetor f on a.fil_codigo = f.fil_codigo and a.exa_codigo = f.exa_codigo and f.ese_default = true");
            buf.append(" left join setores g on a.fil_codigo = g.fil_codigo and f.set_codigo = g.set_codigo ");
            buf.append(" left join usuario h on g.usr_codigo = h.usr_codigo ");
            buf.append(" join situacao j on i.fil_codigo = j.fil_codigo and i.sit_codigo = j.sit_codigo ");
            buf.append(" left join convenios convenio on i.fil_codigo = convenio.fil_codigo and i.con_codigo = convenio.con_codigo ");
            buf.append(" left join cidades cidconvenio on convenio.fil_codigo = cidconvenio.fil_codigo and convenio.cid_codigo = cidconvenio.cid_codigo ");
            buf.append(" left join bairro baiconvenio on convenio.fil_codigo = baiconvenio.fil_codigo and convenio.bai_codigo = baiconvenio.bai_codigo ");
            buf.append(" left join layout on convenio.fil_codigo = layout.fil_codigo and convenio.lay_codigo = layout.lay_codigo ");
            buf.append(" left join prioridade on convenio.fil_codigo = prioridade.fil_codigo and convenio.pri_codigo = prioridade.pri_codigo ");
            buf.append(" left join tabelaprecoexames tabela on convenio.fil_codigo = tabela.fil_codigo and convenio.tpe_codigo = tabela.tpe_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            String[] convenios = this.getSelecionadosFiltro("filtroConvenio", 0);
            if (convenios != null) {
                buf.append(" and i.con_codigo in (");
                for (int i = 0; i < convenios.length; ++i) {
                    buf.append(convenios[i]);
                    if (i >= convenios.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((situacoes = this.getSelecionadosFiltro("filtroSituacao", 0)) != null) {
                buf.append(" and i.sit_codigo in (");
                for (int i = 0; i < situacoes.length; ++i) {
                    buf.append(situacoes[i]);
                    if (i >= situacoes.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            buf.append(" order by i.sit_codigo, ");
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                buf.append("a.exa_descricao");
            } else {
                buf.append("i.exa_codigo");
            }
            buf.append(", i.mco_codigo");
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                int i;
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    int pos = -1;
                    for (i = 0; i < campos.length; ++i) {
                        pos = modelo.findColumn(campos[i]);
                        o[pos] = campos[i].equalsIgnoreCase("tipoLogradouroConvenio") || campos[i].equalsIgnoreCase("tipoLogradouroCobrancaConvenio") ? Tipos.tipoLogradouroDescricao(rs.getString(campos[i])) : rs.getObject(campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioAgrupaSituacao.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioAgrupaSituacao.this.panelCentro.removeAll();
                            RelatorioAgrupaSituacao.this.panelCentro.repaint();
                            RelatorioAgrupaSituacao.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    buf.delete(0, buf.length());
                    if (convenios != null) {
                        for (i = 0; i < convenios.length; ++i) {
                            buf.append(convenios[i]);
                            if (i >= convenios.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroConvenio", buf.toString());
                    buf.delete(0, buf.length());
                    if (situacoes != null) {
                        for (i = 0; i < situacoes.length; ++i) {
                            buf.append(situacoes[i]);
                            if (i >= situacoes.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroSituacao", buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0811901230");
    }
}

