/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.apoio.relatoriocomparativoprecolabapoio;

import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.laboratorio.relatorios.apoio.relatoriocomparativoprecolabapoio.ComparativoPrecoPorLabApoioVO;
import jalis.laboratorio.relatorios.apoio.relatoriocomparativoprecolabapoio.ServiceRelatorioComparativoPrecoPorLabApoio;
import jalis.relatorio.Gerador;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.TableModel;

public class RelatorioComparativoPrecoPorLabApoio
extends FrmRelPadrao {
    public static final String TITULO = "Relat\u00f3rio de comparativo de pre\u00e7os por laborat\u00f3rios de apoio";
    public static final String DESCRICAO = "Listagem dos pre\u00e7os e prazos de exames por laborat\u00f3rio de apoio";
    public static final String IMAGEM = "relatorios/rel_tab_preco_comparativo_apoio.jpg";
    private final String FILTRO_LAB_EXTERNO = "filtroLabExterno";
    private final String FILTRO_EXAME = "filtroExame";
    private final String FILTRO_SETOR = "filtroSetor";
    private final String FILTRO_ORDEM = "filtroOrdem";
    private ServiceRelatorioComparativoPrecoPorLabApoio serviceRelatorio;

    public RelatorioComparativoPrecoPorLabApoio() {
        this.montaBarraDescricao(TITULO, DESCRICAO, IMAGEM);
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroLabExterno", "Lab. Externo", "labexterno", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"lae_codigo", "lae_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroExame", "Exame", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSetor", "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.setModuloAcesso(RelatorioComparativoPrecoPorLabApoio.getModuloAcesso());
        this.setModuloConfigurar(RelatorioComparativoPrecoPorLabApoio.getModuloConfigurar());
        this.serviceRelatorio = new ServiceRelatorioComparativoPrecoPorLabApoio();
        this.adicionaFiltroCombo("filtroOrdem", "Ordem:", this.serviceRelatorio.getOrdem(), 0);
        this.setCamposConfigurador(this.serviceRelatorio.getCampos());
    }

    @Override
    public void imprimirPressionado() {
        block15: {
            if (this.getSelecionadosFiltro("filtroLabExterno", 0) == null) {
                Funcoes.mensagem(this, "Nenhum laborat\u00f3rio de apoio foi selecionado. \u00c9 necess\u00e1rio selecionar no m\u00ednimo 2.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (this.getSelecionadosFiltro("filtroLabExterno", 0).length < 2 || this.getSelecionadosFiltro("filtroLabExterno", 0).length > 5) {
                Funcoes.mensagem(this, "\u00c9 necess\u00e1rio selecionar no m\u00ednimo 2 ou no m\u00e1ximo 5 laborat\u00f3rios de apoio.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            ModeloGridTable modelo = new ModeloGridTable(this.serviceRelatorio.getCampos());
            this.serviceRelatorio.setFiltroExames(this.getSelecionadosFiltro("filtroExame", 0));
            this.serviceRelatorio.setFiltroLabExterno(this.getSelecionadosFiltro("filtroLabExterno", 0));
            this.serviceRelatorio.setFiltroSetor(this.getSelecionadosFiltro("filtroLabExterno", 0));
            this.serviceRelatorio.setFiltroOrdem(this.getFiltroCombo("filtroOrdem"));
            this.serviceRelatorio.setFiltroSetor(this.getSelecionadosFiltro("filtroSetor", 0));
            this.serviceRelatorio.setFiltroFiliais(new String[]{Variaveis.filialPadrao});
            try {
                List<Object> listaPrecos = this.serviceRelatorio.gerarRelatorio();
                if (listaPrecos != null && !listaPrecos.isEmpty()) {
                    Iterator<Object> it = listaPrecos.iterator();
                    boolean contador = true;
                    while (it.hasNext()) {
                        ComparativoPrecoPorLabApoioVO comparativo = (ComparativoPrecoPorLabApoioVO)it.next();
                        Object[] o = new Object[this.serviceRelatorio.getCampos().length];
                        for (int i = 0; i < this.serviceRelatorio.getCampos().length && comparativo.getDadosPreco() != null; ++i) {
                            o[i] = comparativo.getDadosPreco().get(this.serviceRelatorio.getCampos()[i]);
                        }
                        modelo.addLine(o);
                    }
                    if (!Funcoes.textoVazio(this.serviceRelatorio.getModeloRelatorio())) {
                        int i;
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioComparativoPrecoPorLabApoio.this.panelCentro.removeAll();
                                RelatorioComparativoPrecoPorLabApoio.this.panelCentro.repaint();
                                RelatorioComparativoPrecoPorLabApoio.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        StringBuilder buf = new StringBuilder();
                        if (this.serviceRelatorio.getFiltroOrdem() != null) {
                            var.put("filtroOrdem", this.getFiltroCombo("filtroOrdem"));
                        }
                        buf.delete(0, buf.length());
                        if (this.serviceRelatorio.getFiltroExames() != null) {
                            for (i = 0; i < this.serviceRelatorio.getFiltroExames().length; ++i) {
                                buf.append(this.serviceRelatorio.getFiltroExames()[i]);
                                if (i >= this.serviceRelatorio.getFiltroExames().length - 1) continue;
                                buf.append(", ");
                            }
                            var.put("filtroExame", buf.toString());
                        }
                        buf.delete(0, buf.length());
                        if (this.serviceRelatorio.getFiltroLabExterno() != null) {
                            for (i = 0; i < this.serviceRelatorio.getFiltroLabExterno().length; ++i) {
                                buf.append(this.serviceRelatorio.getFiltroLabExterno()[i]);
                                if (i >= this.serviceRelatorio.getFiltroLabExterno().length - 1) continue;
                                buf.append(", ");
                            }
                            var.put("filtroLabExterno", buf.toString());
                        }
                        buf.delete(0, buf.length());
                        if (this.serviceRelatorio.getFiltroSetor() != null) {
                            for (i = 0; i < this.serviceRelatorio.getFiltroSetor().length; ++i) {
                                buf.append(this.serviceRelatorio.getFiltroSetor()[i]);
                                if (i >= this.serviceRelatorio.getFiltroSetor().length - 1) continue;
                                buf.append(", ");
                            }
                            var.put("filtroSetor", buf.toString());
                        }
                        gerador.executar(this.serviceRelatorio.getModeloRelatorio(), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block15;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0860100700");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0860100701");
    }
}

