/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.apoio;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableModel;

public class RelatorioTabelaPreco
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_TABELA = "filtroTabela";
    private final String FILTRO_FILTRO = "filtroFiltro";
    private final String FILTRO_SETOR = "filtroSetor";
    private final String FILTRO_LISTAR = "filtroLabApoio";
    private final String FILTRO_PROIBIDOS = "filtroProibidos";
    private final String FILTRO_APENAS_PROIBIDOS = "filtroApenasProibidos";
    private final String FILTRO_VALOR = "filtroValorZero";
    boolean isCheckIncluirProibido = false;
    boolean isCheckApenasProibido = false;
    private final String[] valor = new String[]{"Todos", "Exceto Zerados", "Somente Zerados"};
    private final String[] ordem = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "C\u00f3digo AMB", "Setor + Descri\u00e7\u00e3o"};
    private final long ACESSO_CONFIGURAR = Long.parseLong("0860100201");
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoExame", "descricaoExame", "sexoExame", "materialPadraoExame", "horaEntradaExame", "horaSaidaExame", "filtroExame", "proibidoExame", "diagnosticoExame", "interferenciaExame", "sinonimoExame", "salvaParcialExame", "idadeMaximaExame", "idadeMinimaExame", "tipoIdadeMaximaExame", "tipoIdadeMinimaExame", "proibidoWebExame", "quantidadeAmostrasExame", "materialPadraoExame", "preaparoExame", "preparoAmostraExame", "inadequadaExame", "codigoPrazoEntrega", "codigoMetodologia", "ordemExame", "paginaExame", "cbhpmExame", "ambExame", "conservacaoExame", "diasConservacaoExame", "temperaturaInicialExame", "temperaturaFinalExame", "referenciaExame", "procedimentoExame", "solicitarJejumExame", "solicitarMedicamentoExame", "solicitarDUMExame", "solicitarTempoDiureseExame", "instrucaoColetaExame", "marcarExternoExame", "descricaoPrazoEntrega", "rotinaPrazoEntrega", "diasPrazoEntrega", "horaEntradaPrazoEntrega", "horaSaidaPrazoEntrega", "descricaoMetodologia", "descricaoMaterialColetado", "solicitarMaterialMaterialColetado", "abreviaturaMaterialColetado", "codigoSetor", "descricaoSetor", "responsavelSetor", "corSetor", "siglaSetor", "codigoUsuario", "nomeUsuario", "codigoMaterialColetado", "codigoTabelaPreco", "descricaoTabelaPreco", "valorCHTabelaPreco", "moedaTabelaPreco", "percentualTabelaPrecoExame", "custoTabelaPrecoExame", "porteTabelaPrecoExame", "valorPorteTabelaPrecoExame", "valorUCOTabelaPrecoExame", "codigoAmbTabelaPrecoExame", "valorCHTabelaPrecoExame", "proibidoTabelaPrecoExame"});

    public RelatorioTabelaPreco() {
        this.setName("RelatorioTabelaPreco");
        this.montaBarraDescricao("Relat\u00f3rio de tabela de pre\u00e7os", "Listagem dos exames com os pre\u00e7os", "relatorios/rel_tab_preco.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroTabela", "Tabela", "tabelaprecoexames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"tpe_codigo", "tpe_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSetor", "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroTexto("filtroFiltro", "Filtro", 50);
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.adicionaFiltroCombo("filtroValorZero", "Valor:", this.valor, 0);
        this.adicionaFiltroCheck("filtroLabApoio", "Listar apenas lab. apoio", false);
        final JCheckBox checkIncluirProibidos = this.adicionaRetornaFiltroCheck("filtroProibidos", "Incluir proibidos", false);
        final JCheckBox checkApenasProibido = this.adicionaRetornaFiltroCheck("filtroApenasProibidos", "Listar apenas proibidos", false);
        checkIncluirProibidos.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (checkIncluirProibidos.isSelected()) {
                    checkApenasProibido.setSelected(false);
                    RelatorioTabelaPreco.this.isCheckIncluirProibido = true;
                    RelatorioTabelaPreco.this.isCheckApenasProibido = false;
                } else {
                    RelatorioTabelaPreco.this.isCheckIncluirProibido = false;
                }
            }
        });
        checkApenasProibido.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (checkApenasProibido.isSelected()) {
                    checkIncluirProibidos.setSelected(false);
                    RelatorioTabelaPreco.this.isCheckApenasProibido = true;
                    RelatorioTabelaPreco.this.isCheckIncluirProibido = false;
                } else {
                    RelatorioTabelaPreco.this.isCheckApenasProibido = false;
                }
            }
        });
        this.setModuloConfigurar(this.ACESSO_CONFIGURAR);
        this.setModuloAcesso(RelatorioTabelaPreco.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        if (this.getSelecionadosFiltro("filtroTabela", 0) == null || this.getSelecionadosFiltro("filtroTabela", 0).length == 0) {
            Funcoes.mensagem(this, "Tabela de pre\u00e7o n\u00e3o selecionada.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        if (this.getSelecionadosFiltro("filtroTabela", 0).length > 1) {
            Funcoes.mensagem(this, "Apenas uma tabela de pre\u00e7o pode ser selecionada.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            int i;
            String[] setor;
            Statement st = Conexao.getStatement();
            StringBuilder bufMetodologia = new StringBuilder();
            StringBuilder bufNormal = new StringBuilder();
            StringBuilder buf = new StringBuilder();
            buf.append(" select a.exa_codigo as codigoExame ");
            buf.append("       ,a.exa_descricao as descricaoExame ");
            buf.append("       ,a.exa_sexo as sexoExame ");
            buf.append("       ,a.exa_horaentrada as horaEntradaExame ");
            buf.append("       ,a.exa_horasaida as horaSaidaExame ");
            buf.append("       ,a.exa_filtro as filtroExame ");
            buf.append("       ,a.exa_proibido as proibidoExame ");
            buf.append("       ,a.exa_diagnostico as diagnosticoExame ");
            buf.append("       ,a.exa_interferencia as interferenciaExame ");
            buf.append("       ,a.exa_sinonimo as sinonimoExame ");
            buf.append("       ,a.exa_salvaparcial as salvaParcialExame ");
            buf.append("       ,a.exa_idademax as idadeMaximaExame ");
            buf.append("       ,a.exa_idademin as idadeMinimaExame ");
            buf.append("       ,a.exa_idademaxtipo as tipoIdadeMaximaExame ");
            buf.append("       ,a.exa_idademintipo as tipoIdadeMinimaExame ");
            buf.append("       ,a.exa_proibidoweb as proibidoWebExame ");
            buf.append("       ,a.exa_qtdeamostras as quantidadeAmostrasExame ");
            buf.append("       ,b.emc_default as materialPadraoExame ");
            buf.append("       ,b.emc_preparo as preaparoExame ");
            buf.append("       ,b.emc_prepamostra as preparoAmostraExame ");
            buf.append("       ,b.emc_inadequada as inadequadaExame ");
            buf.append("       ,b.prz_codigo as codigoPrazoEntrega ");
            buf.append("       ,d.met_codigo as codigoMetodologia ");
            buf.append("       ,b.emc_ordem as ordemExame ");
            buf.append("       ,b.emc_pagina as paginaExame ");
            buf.append("       ,b.emc_codigocbhpm as cbhpmExame ");
            buf.append("       ,coalesce(b.emc_codigoamb, '') as ambExame ");
            buf.append("       ,b.emc_conservacao as conservacaoExame ");
            buf.append("       ,b.emc_diasconserva as diasConservacaoExame ");
            buf.append("       ,b.emc_temperaturainicial as temperaturaInicialExame ");
            buf.append("       ,b.emc_temperaturafinal as temperaturaFinalExame ");
            buf.append("       ,b.emc_referencia as referenciaExame ");
            buf.append("       ,b.emc_procedimento as procedimentoExame ");
            buf.append("       ,b.emc_solicitarjejum as solicitarJejumExame ");
            buf.append("       ,b.emc_obrigamedicamento as solicitarMedicamentoExame ");
            buf.append("       ,b.emc_obrigadum as solicitarDUMExame ");
            buf.append("       ,b.emc_obrigapeso as solicitarPesoExame ");
            buf.append("       ,b.emc_obrigaaltura as solicitarAlturaExame ");
            buf.append("       ,b.emc_obrigavolume as solicitarVolumeExame ");
            buf.append("       ,b.emc_obrigatempodiurese as solicitarTempoDiureseExame ");
            buf.append("       ,b.emc_instrcoleta as instrucaoColetaExame ");
            buf.append("       ,b.emc_marcarexterno as marcarExternoExame ");
            buf.append("       ,c.prz_descricao as descricaoPrazoEntrega ");
            buf.append("       ,c.prz_prazo as rotinaPrazoEntrega ");
            buf.append("       ,c.prz_dias as diasPrazoEntrega ");
            buf.append("       ,c.prz_horaentrada as horaEntradaPrazoEntrega ");
            buf.append("       ,c.prz_horasaida as horaSaidaPrazoEntrega ");
            buf.append("       ,d.met_descricao as descricaoMetodologia ");
            buf.append("       ,e.mco_codigo as codigoMaterialColetado ");
            buf.append("       ,e.mco_descricao as descricaoMaterialColetado ");
            buf.append("       ,e.mco_solicitarmat as solicitarMaterialMaterialColetado ");
            buf.append("       ,e.mco_abreviatura as abreviaturaMaterialColetado ");
            buf.append("       ,f.set_codigo as codigoSetor ");
            buf.append("       ,g.set_descricao as descricaoSetor ");
            buf.append("       ,g.set_responsavel as responsavelSetor ");
            buf.append("       ,g.set_cor as corSetor ");
            buf.append("       ,g.set_sigla as siglaSetor ");
            buf.append("       ,h.usr_codigo as codigoUsuario ");
            buf.append("       ,h.usr_nome as nomeUsuario ");
            buf.append("       ,j.tpe_codigo as codigoTabelaPreco ");
            buf.append("       ,j.tpe_descricao as descricaoTabelaPreco ");
            buf.append("       ,j.tpe_valorch as valorCHTabelaPreco ");
            buf.append("       ,j.tpe_moeda as moedaTabelaPreco ");
            buf.append("       ,case when j.tpe_tipocbhpm = false then k.dtp_valor ");
            buf.append("             else ((k.dtp_percentual * p.tpp_valor) + (k.dtp_valor * j.tpe_uco)) ");
            buf.append("        end as valorCHTabelaPrecoExame ");
            buf.append("       ,k.dtp_valor as custoTabelaPrecoExame ");
            buf.append("       ,j.tpe_uco as valorUCOTabelaPrecoExame ");
            buf.append("       ,k.dtp_percentual as percentualTabelaPrecoExame ");
            buf.append("       ,k.tpp_porte as porteTabelaPrecoExame ");
            buf.append("       ,p.tpp_valor as valorPorteTabelaPrecoExame ");
            buf.append("       ,coalesce(k.dtp_codamb, '') as codigoAmbTabelaPrecoExame ");
            buf.append("       ,k.dtp_proibido as proibidoTabelaPrecoExame ");
            buf.append("       , ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            bufMetodologia.append(buf.toString().replaceAll("dtp", "dtm"));
            bufNormal.append(buf.toString());
            bufNormal.append(" from detalhetabelapreco k ");
            bufNormal.append(" left join examematcoleta b on k.fil_codigo = b.fil_codigo and k.exa_codigo = b.exa_codigo and k.mco_codigo = b.mco_codigo");
            bufNormal.append(" left join exames a on b.fil_codigo = a.fil_codigo and b.exa_codigo = a.exa_codigo ");
            bufNormal.append(" left join prazoentrega c on a.fil_codigo = c.fil_codigo and b.prz_codigo = c.prz_codigo ");
            bufNormal.append(" left join metodologia d on a.fil_codigo = d.fil_codigo and b.met_codigo = d.met_codigo ");
            bufNormal.append(" left join materialcoleta e on a.fil_codigo = e.fil_codigo and b.mco_codigo = e.mco_codigo ");
            bufNormal.append(" left join examesetor f on a.fil_codigo = f.fil_codigo and a.exa_codigo = f.exa_codigo and f.ese_default = true");
            bufNormal.append(" left join setores g on a.fil_codigo = g.fil_codigo and f.set_codigo = g.set_codigo ");
            bufNormal.append(" left join usuario h on g.usr_codigo = h.usr_codigo ");
            bufNormal.append(" left join tabelaprecoexames j on k.fil_codigo = j.fil_codigo and k.tpe_codigo = j.tpe_codigo ");
            bufNormal.append(" left join tabelaprecoexamesporte p on k.fil_codigo = p.fil_codigo and k.tpe_codigo = p.tpe_codigo and k.tpp_porte = p.tpp_porte ");
            bufNormal.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            bufMetodologia.append(" from detalhetabelaprecometodologia k ");
            bufMetodologia.append(" left join examematcoleta b on k.fil_codigo = b.fil_codigo and k.exa_codigo = b.exa_codigo and k.mco_codigo = b.mco_codigo");
            bufMetodologia.append(" left join exames a on b.fil_codigo = a.fil_codigo and b.exa_codigo = a.exa_codigo ");
            bufMetodologia.append(" left join prazoentrega c on a.fil_codigo = c.fil_codigo and b.prz_codigo = c.prz_codigo ");
            bufMetodologia.append(" left join metodologia d on k.fil_codigo = d.fil_codigo and k.met_codigo = d.met_codigo ");
            bufMetodologia.append(" left join materialcoleta e on a.fil_codigo = e.fil_codigo and b.mco_codigo = e.mco_codigo ");
            bufMetodologia.append(" left join examesetor f on a.fil_codigo = f.fil_codigo and a.exa_codigo = f.exa_codigo and f.ese_default = true");
            bufMetodologia.append(" left join setores g on a.fil_codigo = g.fil_codigo and f.set_codigo = g.set_codigo ");
            bufMetodologia.append(" left join usuario h on g.usr_codigo = h.usr_codigo ");
            bufMetodologia.append(" left join tabelaprecoexames j on k.fil_codigo = j.fil_codigo and k.tpe_codigo = j.tpe_codigo ");
            bufMetodologia.append(" left join tabelaprecoexamesporte p on k.fil_codigo = p.fil_codigo and k.tpe_codigo = p.tpe_codigo and k.tpp_porte = p.tpp_porte ");
            bufMetodologia.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.setLength(0);
            buf.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
            String[] tabelas = this.getSelecionadosFiltro("filtroTabela", 0);
            if (tabelas != null) {
                buf.append(" and k.tpe_codigo in (");
                for (int i2 = 0; i2 < tabelas.length; ++i2) {
                    buf.append(tabelas[i2]);
                    if (i2 >= tabelas.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if ((setor = this.getSelecionadosFiltro("filtroSetor", 0)) != null) {
                buf.append(" and f.set_codigo in (");
                for (int i3 = 0; i3 < setor.length; ++i3) {
                    buf.append(setor[i3]);
                    if (i3 >= setor.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if (!this.isCheckIncluirProibido && !this.isCheckApenasProibido) {
                buf.append(" and a.exa_proibido = false and k.dtp_proibido = false and b.emc_proibido = false ");
            }
            if (this.isCheckApenasProibido && this.getFiltroCheck("filtroLabApoio")) {
                buf.append(" and b.emc_proibidoapoio = true ");
            } else if (this.isCheckApenasProibido) {
                buf.append(" and (a.exa_proibido = true or k.dtp_proibido = true or b.emc_proibido = true or b.emc_proibidoapoio = true) ");
            } else if (this.getFiltroCheck("filtroLabApoio")) {
                buf.append(" and b.emc_proibidoapoio = false ");
            }
            if (this.getFiltroComboIndice("filtroValorZero") == 1) {
                buf.append(" and k.dtp_valor > 0 ");
            } else if (this.getFiltroComboIndice("filtroValorZero") == 2) {
                buf.append(" and k.dtp_valor = 0 ");
            }
            if (this.getFiltroTexto("filtroFiltro").length() > 0) {
                buf.append(" and a.exa_filtro ILIKE '%").append(this.getFiltroTexto("filtroFiltro")).append("%' ");
            }
            buf.append(" order by ");
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                buf.append("UPPER(TO_ASCII(a.exa_descricao))");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                buf.append("k.dtp_codamb");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[3])) {
                buf.append("f.set_codigo, a.exa_descricao");
            } else {
                buf.append("a.exa_codigo, b.mco_codigo");
            }
            bufNormal.append(buf.toString());
            bufMetodologia.append(buf.toString().replaceAll("dtp", "dtm"));
            ListaDados listaDados = new ListaDados();
            if (ParametrosGerais.getPrecoMetodologia()) {
                ResultSet rsMetodologia = Conexao.executeQuery(st, bufMetodologia.toString());
                while (rsMetodologia.next()) {
                    listaDados.addExame(rsMetodologia.getString("codigoExame"), rsMetodologia.getInt("codigoMaterialColetado"), rsMetodologia.getInt("codigoMetodologia"));
                    for (i = 0; i < campos.length; ++i) {
                        listaDados.addValor(rsMetodologia.getString("codigoExame"), rsMetodologia.getInt("codigoMaterialColetado"), rsMetodologia.getInt("codigoMetodologia"), campos[i], rsMetodologia.getObject(campos[i]));
                    }
                }
            }
            ResultSet rsNormal = Conexao.executeQuery(st, bufNormal.toString());
            while (rsNormal.next()) {
                if (!listaDados.addExame(rsNormal.getString("codigoExame"), rsNormal.getInt("codigoMaterialColetado"))) continue;
                for (i = 0; i < campos.length; ++i) {
                    listaDados.addValor(rsNormal.getString("codigoExame"), rsNormal.getInt("codigoMaterialColetado"), campos[i], rsNormal.getObject(campos[i]));
                }
            }
            ModeloGridTable modelo = new ModeloGridTable(campos);
            Iterator it = listaDados.getIterator();
            if (it.hasNext()) {
                while (it.hasNext()) {
                    Dados dados = (Dados)it.next();
                    Object[] o = new Object[campos.length];
                    for (int i4 = 0; i4 < campos.length; ++i4) {
                        o[i4] = campos[i4].indexOf("tipo") >= 0 ? Tipos.tipoIdade(dados.getValor(campos[i4]).toString()) : dados.getValor(campos[i4]);
                    }
                    modelo.addLine(o);
                }
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioTabelaPreco.getModuloAcesso());
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i5;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioTabelaPreco.this.panelCentro.removeAll();
                            RelatorioTabelaPreco.this.panelCentro.repaint();
                            RelatorioTabelaPreco.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    var.put("filtroFiltro", this.getFiltroTexto("filtroFiltro"));
                    var.put("filtroLabApoio", this.getFiltroCheck("filtroLabApoio"));
                    var.put("filtroProibidos", this.getFiltroCheck("filtroProibidos"));
                    var.put("filtroApenasProibidos", this.getFiltroCheck("filtroApenasProibidos"));
                    var.put("filtroValorZero", this.getFiltroCombo("filtroValorZero"));
                    buf.delete(0, buf.length());
                    if (tabelas != null) {
                        for (i5 = 0; i5 < tabelas.length; ++i5) {
                            buf.append(tabelas[i5]);
                            if (i5 >= tabelas.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroTabela", buf.toString());
                    buf.delete(0, buf.length());
                    if (setor != null) {
                        for (i5 = 0; i5 < setor.length; ++i5) {
                            buf.append(setor[i5]);
                            if (i5 >= setor.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroSetor", buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0860100200");
    }

    class Dados
    implements Comparable {
        String[] colunasOrdenacao = null;
        String codigoExame = null;
        Integer codigoMaterial = null;
        Integer codigoMetodologia = null;
        HashMap<String, Object> dados = null;

        public Dados(String codigoExame, Integer codigoMaterial, Integer codigoMetodologia) {
            this.codigoExame = codigoExame;
            this.codigoMaterial = codigoMaterial;
            this.codigoMetodologia = codigoMetodologia == null ? -1 : codigoMetodologia;
            this.dados = new HashMap();
        }

        public void put(String coluna, Object valor) {
            this.dados.put(coluna, valor);
        }

        public boolean equals(String codigoExame, Integer codigoMaterial) {
            if (this.codigoExame != null && this.codigoMaterial != null && codigoExame != null && codigoMaterial != null) {
                return this.codigoExame.equalsIgnoreCase(codigoExame) && this.codigoMaterial.equals(codigoMaterial);
            }
            return false;
        }

        public boolean equals(String codigoExame, Integer codigoMaterial, Integer codigoMetodologia) {
            if (this.codigoExame != null && this.codigoMaterial != null && codigoExame != null && codigoMaterial != null && this.codigoMetodologia != null && codigoMetodologia != null) {
                return this.codigoExame.equalsIgnoreCase(codigoExame) && this.codigoMaterial.equals(codigoMaterial) && this.codigoMetodologia.equals(codigoMetodologia);
            }
            return false;
        }

        public Object getValor(String coluna) {
            return this.dados.get(coluna);
        }

        public int compareTo(Object o) {
            if (o instanceof Dados) {
                Dados aux = (Dados)o;
                int resultado = 0;
                for (int i = 0; i < this.colunasOrdenacao.length; ++i) {
                    Object valor2;
                    Object valor1;
                    if (this.dados.get(this.colunasOrdenacao[i]) instanceof String) {
                        valor1 = this.dados.get(this.colunasOrdenacao[i]) == null ? "" : (String)this.dados.get(this.colunasOrdenacao[i]);
                        valor2 = aux.dados.get(this.colunasOrdenacao[i]) == null ? "" : (String)aux.dados.get(this.colunasOrdenacao[i]);
                        resultado = ((String)valor1).compareTo((String)valor2);
                    } else if (this.dados.get(this.colunasOrdenacao[i]) instanceof Integer) {
                        valor1 = (Integer)this.dados.get(this.colunasOrdenacao[i]);
                        valor2 = (Integer)aux.dados.get(this.colunasOrdenacao[i]);
                        resultado = ((Integer)valor1).compareTo((Integer)valor2);
                    } else if (this.dados.get(this.colunasOrdenacao[i]) instanceof BigDecimal) {
                        valor1 = (BigDecimal)this.dados.get(this.colunasOrdenacao[i]);
                        valor2 = (BigDecimal)aux.dados.get(this.colunasOrdenacao[i]);
                        resultado = ((BigDecimal)valor1).compareTo((BigDecimal)valor2);
                    }
                    if (resultado == 0 && i != this.colunasOrdenacao.length - 1) continue;
                    return resultado;
                }
            }
            return 0;
        }
    }

    class ListaDados {
        ArrayList<Dados> exames = new ArrayList();
        Dados auxExame = null;

        public Iterator getIterator() {
            return this.exames.iterator();
        }

        public boolean addExame(String codigoExame, Integer codigoMaterial) {
            for (Dados aux : this.exames) {
                if (!aux.equals(codigoExame, codigoMaterial)) continue;
                this.auxExame = aux;
                return false;
            }
            this.auxExame = new Dados(codigoExame, codigoMaterial, null);
            this.exames.add(this.auxExame);
            return true;
        }

        public void addExame(String codigoExame, Integer codigoMaterial, Integer codigoMetodologia) {
            for (Dados aux : this.exames) {
                if (!aux.equals(codigoExame, codigoMaterial, codigoMetodologia)) continue;
                this.auxExame = aux;
                return;
            }
            this.auxExame = new Dados(codigoExame, codigoMaterial, codigoMetodologia);
            this.exames.add(this.auxExame);
        }

        public void addValor(String codigoExame, Integer codigoMaterial, Integer codigoMetodologia, String coluna, Object valor) {
            if (this.auxExame != null && this.auxExame.codigoExame.equalsIgnoreCase(codigoExame) && this.auxExame.codigoMaterial.equals(codigoMaterial) && this.auxExame.codigoMetodologia.equals(codigoMetodologia)) {
                this.auxExame.put(coluna, valor);
            } else {
                for (Dados aux : this.exames) {
                    if (!aux.equals(codigoExame, codigoMaterial, codigoMetodologia)) continue;
                    this.auxExame = aux;
                    this.auxExame.put(coluna, valor);
                }
            }
        }

        public void addValor(String codigoExame, Integer codigoMaterial, String coluna, Object valor) {
            if (this.auxExame != null && this.auxExame.codigoExame.equalsIgnoreCase(codigoExame) && this.auxExame.codigoMaterial.equals(codigoMaterial)) {
                this.auxExame.put(coluna, valor);
            } else {
                for (Dados aux : this.exames) {
                    if (!aux.equals(codigoExame, codigoMaterial)) continue;
                    this.auxExame = aux;
                    this.auxExame.put(coluna, valor);
                }
            }
        }

        public void ordenarDados(String[] colunasOrdenacao) {
            for (int i = 0; i < this.exames.size(); ++i) {
                this.exames.get((int)i).colunasOrdenacao = colunasOrdenacao;
            }
            Collections.sort(this.exames);
        }
    }
}

