/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.apoio;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.util.parsers.FabricaConfigurador;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.relatorio.Gerador;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import javax.swing.table.TableModel;

public class RelatorioSituacaoLote
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_LOTE = "filtroLote";
    private final long ACESSO_CONFIGURAR = Long.parseLong("0860200301");
    public static final String[] campos = new String[]{"codigoRequisicao", "nomePaciente", "dataNascimentoPaciente", "sexoPaciente", "idadePaciente", "anoMesPaciente", "horaRequisicao", "conselhoMedico", "crmMedico", "ufMedico", "nomeMedico", "observacaoRequisicao", "codigoRequisicaoApoio", "codigoExame", "descricaoExame", "dataRequisicao", "codigoLote", "dataLote", "codigoLoteLabApoio", "codigoMaterialColetado", "descricaoMaterialColetado", "abreviaturaMaterialColetado", "situacaoExame", "codigoLabExterno", "descricaoLabExterno", "protocoloLabExterno", "codigoExameLaboratorioApoio", "descricaoExameLaboratorioApoio", "codigoFilial", "descricaoFilial", "codigoCip", "codigoFilialCodigoRequisicao", "posicaoOrdenacao", "etiquetaExternaExame", "nomeSocialPaciente", "descricaoColeta", "generoPaciente"};

    public RelatorioSituacaoLote() {
        this.montaBarraDescricao("Relat\u00f3rio de situa\u00e7\u00e3o de lote enviado", "Listagem com a situa\u00e7\u00e3o dos exames enviados para o laborat\u00f3rio de apoio", "relatorios/sit_lote_enviado.jpg");
        this.adicionaRelatorioListener(this);
        String sql = " select a.lex_codigo, a.lex_datahora, b.lae_codigo, b.lae_descricao from  loteexterno a left join labexterno b on a.fil_codigo = b.fil_codigo and a.lae_codigo = b.lae_codigo ";
        this.adicionaItemFiltro("filtroLote", "Lote", sql, "a.fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"lex_codigo", "lex_datahora", "lae_codigo", "lae_descricao"}, new String[]{"C\u00f3digo", "Data", "Lab. Externo", "Lab. Descri\u00e7\u00e3o"}, new int[]{70, 0, 70, 0}, new int[]{0, 2}, true);
        this.setModuloConfigurar(this.ACESSO_CONFIGURAR);
        this.setModuloAcesso(RelatorioSituacaoLote.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st;
        block10: {
            if (this.getSelecionadosFiltro("filtroLote", 0) == null || this.getSelecionadosFiltro("filtroLote", 0).length == 0) {
                Funcoes.mensagem(this, "Lote n\u00e3o selecionado", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (this.getSelecionadosFiltro("filtroLote", 0).length > 1) {
                Funcoes.mensagem(this, "Apenas um lote pode ser selecionado", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            StringBuilder buf = new StringBuilder();
            st = Conexao.getStatement();
            try {
                String[] lotes = this.getSelecionadosFiltro("filtroLote", 0);
                String[] labs = this.getSelecionadosFiltro("filtroLote", 2);
                ModeloGridTable modelo = this.getModeloDados(st, lotes, labs, -1, null, Integer.parseInt(Variaveis.filialPadrao), ParametrosGerais.getDigitosTuboRequisicao(), ParametrosGerais.getDigitosTuboFilial());
                if (modelo.getRowCount() > 0) {
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioSituacaoLote.getModuloAcesso());
                    ResultSet rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioSituacaoLote.this.panelCentro.removeAll();
                                RelatorioSituacaoLote.this.panelCentro.repaint();
                                RelatorioSituacaoLote.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        buf.delete(0, buf.length());
                        if (lotes != null) {
                            for (int i = 0; i < lotes.length; ++i) {
                                buf.append(lotes[i]);
                                if (i >= lotes.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroLote", buf.toString());
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block10;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public ModeloGridTable getModeloDados(Statement st, String[] lotes, String[] labs, int colunaOrdenacao, List<Registro> requisicoes, int filialPadrao, int digitosTuboRequisicao, int digitosTuboFilial) throws Exception {
        int i;
        ModeloGridTable modelo = new ModeloGridTable(campos);
        StringBuilder buf = new StringBuilder();
        buf.append("select rle.rle_codigo as codigoRequisicaoApoio,  a.req_codigo as codigoRequisicao, '' as codigoFilialCodigoRequisicao, ");
        buf.append("paciente.pac_nome as nomePaciente, a.req_idade as idadePaciente, a.req_anomes as anoMesPaciente, ");
        buf.append("c.exa_codigo as codigoExame, c.exa_descricao as descricaoExame,  ");
        buf.append("paciente.pac_datanasc as dataNascimentoPaciente, paciente.pac_sexo as sexoPaciente, paciente.pac_nomeSocial as nomeSocialPaciente, ");
        buf.append("a.med_conselho as conselhoMedico, a.med_crm as crmMedico, a.med_uf as ufMedico, medico.med_nome as nomeMedico, ");
        buf.append("a.req_obs as observacaoRequisicao, a.req_hora as horaRequisicao, ");
        buf.append("coletado.mco_codigo as codigoMaterialColetado, coletado.mco_descricao as descricaoMaterialColetado, ");
        buf.append("coletado.mco_abreviatura as abreviaturaMaterialColetado, exr.exr_situacao as situacaoExame, ");
        buf.append("l.lex_codigo as codigoLote, l.lex_datahora as dataLote,  ");
        buf.append("labexterno.lae_codigo as codigoLabExterno, labexterno.lae_descricao as descricaoLabExterno, labexterno.lae_protocolo as protocoloLabExterno, ");
        buf.append("ele.ele_xmllabexterno as codigoExameLaboratorioApoio, '' as descricaoExameLaboratorioApoio, ");
        buf.append("a.req_data as dataRequisicao, lote.fil_kodigo as codigoFilial, fil.fil_descricao as descricaoFilial, ");
        buf.append("rle.rle_codigo as codigoCip, ");
        buf.append("'' as posicaoOrdenacao, ");
        buf.append("errecip.ere_codigoapoiado as etiquetaExternaExame ");
        buf.append(",col.col_descricao as descricaoColeta ");
        buf.append(",idg.ige_descricao as generoPaciente ");
        buf.append("from loteexternorequisicao lote ");
        buf.append("left join loteexterno l on lote.fil_codigo = l.fil_codigo and lote.lex_codigo = l.lex_codigo and lote.lae_codigo = l.lae_codigo ");
        buf.append("left join requisicao a on lote.fil_kodigo = a.fil_codigo and lote.req_codigo = a.req_codigo ");
        buf.append("join loteexternoexamerequisicao b on lote.fil_codigo = b.fil_codigo and lote.req_codigo = b.req_codigo and lote.lex_codigo = b.lex_codigo and lote.lae_codigo = b.lae_codigo and lote.fil_kodigo = b.fil_kodigo ");
        buf.append("join examerequisicao exr on b.fil_kodigo = exr.fil_codigo and b.req_codigo = exr.req_codigo and b.exa_codigo = exr.exa_codigo and b.mco_codigo = exr.mco_codigo ");
        buf.append("left join  loteexternoexamerequisicaorecip  lerrecip ON b.fil_codigo = lerrecip.fil_codigo AND b.fil_kodigo = lerrecip.fil_kodigo AND b.req_codigo = lerrecip.req_codigo AND b.lex_codigo = lerrecip.lex_codigo AND b.lae_codigo = lerrecip.lae_codigo AND b.exa_codigo = lerrecip.exa_codigo AND b.mco_codigo = lerrecip.mco_codigo ");
        buf.append("left join  examerequisicaorecipiente errecip on lerrecip.fil_codigo = errecip.fil_codigo and lerrecip.req_codigo = errecip.req_codigo and lerrecip.exa_codigo = errecip.exa_codigo and lerrecip.mco_codigo = errecip.mco_codigo and lerrecip.rec_codigo = errecip.rec_kodigo ");
        buf.append("join paciente on a.fil_codigo = paciente.fil_codigo and a.pac_codigo = paciente.pac_codigo ");
        buf.append("left join exames c on b.fil_kodigo = c.fil_codigo and b.exa_codigo = c.exa_codigo ");
        buf.append("left join examematcoleta d on b.fil_kodigo = d.fil_codigo and b.exa_codigo = d.exa_codigo and b.mco_codigo = d.mco_codigo ");
        buf.append("left join materialcoleta coletado on d.fil_codigo = coletado.fil_codigo and d.mco_codigo = coletado.mco_codigo ");
        buf.append("left join medico on a.fil_codigo = medico.fil_codigo and a.med_conselho = medico.med_conselho and a.med_crm = medico.med_crm and a.med_uf = medico.med_uf ");
        buf.append("left join labexterno on lote.fil_codigo = labexterno.fil_codigo and lote.lae_codigo = labexterno.lae_codigo ");
        buf.append("left join filiais_postocoleta fil on lote.fil_kodigo = fil.fil_codigo ");
        buf.append("left join requisicaolabexterno rle on lote.fil_kodigo = rle.fil_codigo and lote.req_codigo = rle.req_codigo and lote.lae_codigo = rle.lae_codigo ");
        buf.append("left join examematcoletalabexterno ele on b.fil_codigo = ele.fil_codigo and b.exa_codigo = ele.exa_codigo and b.mco_codigo = ele.mco_codigo and b.lae_codigo = ele.lae_codigo ");
        buf.append("left join coletas as col on a.fil_codigo = col.fil_codigo and a.col_codigo = col.col_codigo ");
        buf.append("left join identidadegenero idg on coalesce(paciente.pac_genero, 0) = idg.ige_codigo ");
        buf.append("where lote.fil_codigo = ");
        buf.append(filialPadrao);
        buf.append(" and l.lex_dataestorno is null and l.usr_codestorno is null ");
        buf.append(" and lote.leq_dataestorno is null and lote.usr_codestorno is null ");
        if (lotes != null) {
            buf.append(" and lote.lex_codigo in (");
            for (i = 0; i < lotes.length; ++i) {
                buf.append(lotes[i]);
                if (i >= lotes.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        if (labs != null) {
            buf.append(" and lote.lae_codigo in (");
            for (i = 0; i < labs.length; ++i) {
                buf.append(labs[i]);
                if (i >= labs.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        buf.append(" and a.req_excluida = false and exr.exr_excluido = false ");
        buf.append(" and b.usr_codestorno is null and b.ler_datahoraestorno is null");
        if (requisicoes == null || requisicoes.isEmpty()) {
            buf.append(" order by lote.fil_kodigo, a.req_codigo ");
        } else if (colunaOrdenacao == -10) {
            buf.append(" order by exr.exr_ordem asc ");
        }
        ResultSet rs = st.executeQuery(buf.toString());
        if (rs.next()) {
            do {
                Object[] o = new Object[campos.length];
                for (int i2 = 0; i2 < campos.length; ++i2) {
                    Protocolo p;
                    String xml;
                    if (campos[i2].equals("codigoFilialCodigoRequisicao")) {
                        o[i2] = Funcoes.preencheZero(rs.getInt("codigoFilial"), digitosTuboFilial) + Funcoes.preencheZero(rs.getInt("codigoRequisicao"), digitosTuboRequisicao);
                        continue;
                    }
                    if (campos[i2].equalsIgnoreCase("codigoLoteLabApoio")) {
                        o[i2] = Funcoes.preencheZero(rs.getString("codigoLote"), 6);
                        continue;
                    }
                    if (campos[i2].equalsIgnoreCase("anoMesPaciente")) {
                        o[i2] = Tipos.tipoIdade(rs.getString(campos[i2]));
                        continue;
                    }
                    if (campos[i2].equalsIgnoreCase("sexoPaciente")) {
                        o[i2] = Tipos.tipoSexo(rs.getString(campos[i2]));
                        continue;
                    }
                    if (campos[i2].equalsIgnoreCase("situacaoExame")) {
                        o[i2] = Tipos.tipoSituacaoExame(rs.getString(campos[i2]));
                        continue;
                    }
                    if (campos[i2].equalsIgnoreCase("codigoExameLaboratorioApoio")) {
                        xml = rs.getString("codigoExameLaboratorioApoio");
                        o[i2] = "";
                        p = Protocolo.getProtocolo(rs.getString("protocoloLabExterno"));
                        if (p == null) continue;
                        o[i2] = FabricaConfigurador.getCodigoIdentExameLabExternoSelecionado(p, rs.getString("codigoLabExterno"), xml);
                        continue;
                    }
                    if (campos[i2].equalsIgnoreCase("descricaoExameLaboratorioApoio")) {
                        xml = rs.getString("codigoExameLaboratorioApoio");
                        o[i2] = "";
                        p = Protocolo.getProtocolo(rs.getString("protocoloLabExterno"));
                        if (p == null) continue;
                        o[i2] = FabricaConfigurador.getDescricaoExameSelecionado(p, rs.getString("codigoLabExterno"), xml);
                        continue;
                    }
                    o[i2] = campos[i2].equalsIgnoreCase("posicaoOrdenacao") ? Integer.valueOf(this.getPosicaoOrdenacao(requisicoes, rs.getInt("codigoRequisicao"), rs.getInt("codigoFilial"))) : rs.getObject(campos[i2]);
                }
                modelo.addLine(o);
            } while (rs.next());
        }
        if (requisicoes != null && !requisicoes.isEmpty()) {
            modelo.ordenarColunaSemTrocarSentido(modelo.findColumn("posicaoOrdenacao"));
        }
        return modelo;
    }

    private int getPosicaoOrdenacao(List<Registro> requisicoeList, int codigoRequisicao, int filialRequisicao) {
        if (requisicoeList != null) {
            for (Registro registro : requisicoeList) {
                if (registro.getInt("fil_codigo") != filialRequisicao || registro.getInt("req_codigo") != codigoRequisicao) continue;
                return requisicoeList.indexOf(registro);
            }
        }
        return 0;
    }

    public String getXMLRelatorio(Statement st) throws Exception {
        StringBuilder buf = new StringBuilder("select rel_xml from relatoriosistema where rel_codigo = ");
        buf.append(RelatorioSituacaoLote.getModuloAcesso());
        ResultSet rs = st.executeQuery(buf.toString());
        if (rs.next()) {
            return rs.getString("rel_xml");
        }
        return "";
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0860200300");
    }
}

