/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.apoio;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioLotesEstornados
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_LAB_APOIO = "filtroLabApoio";
    private final String FILTRO_DATA_COLETA = "filtroDataColeta";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String[] tipoDatas = new String[]{"Lote", "Requisi\u00e7\u00e3o"};
    private final String[] ordem = new String[]{"C\u00f3digo", "Data+Hora Lote", "Data+Hora Estorno", "Laborat\u00f3rio"};
    private static String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoLoteLabApoio", "dataLoteLabApoio", "dataHoraEstornoLote", "usuarioEstornoLote", "codigoFilialLote", "codigoLabExterno", "descricaoLabExterno", "protocoloLabExterno", "codigoRequisicao", "dataRequisicao", "horaRequisicao", "dataHoraEstornoRequisicaoLote", "usuarioEstornoRequisicaoLote"});

    public RelatorioLotesEstornados() {
        this.montaBarraDescricao("Relat\u00f3rio de Lotes estornados", "Listagem dos lotes enviados para laborat\u00f3rio de apoio que posteriormente foram estornados", "relatorios/rel_lote_estornado.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroLabApoio", "Lab. Apoio", "labexterno", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"lae_codigo", "lae_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroCombo("filtroDataColeta", "Campo Data:", this.tipoDatas, 0);
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.setModuloConfigurar(this.getModuloConfigurar());
        this.setModuloAcesso(RelatorioLotesEstornados.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        if (!this.validarCampos()) {
            this.habilitaBotaoImprimir(true);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        Object[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
        Object[] labapoio = this.getSelecionadosFiltro("filtroLabApoio", 0);
        if (Funcoes.objectIsNull(filiais)) {
            filiais = new String[]{Variaveis.filialPadrao};
        }
        StringBuilder buf = new StringBuilder();
        buf.append("select ");
        buf.append("  lotext.lex_codigo as codigoLoteLabApoio,");
        buf.append("  lotext.lex_datahora as dataLoteLabApoio,");
        buf.append("  lotext.lex_dataestorno as dataHoraEstornoLote,");
        buf.append("  lotext.usr_codestorno as usuarioEstornoLote,");
        buf.append("  lotext.fil_codigo as codigoFilialLote,");
        buf.append("  lae.lae_codigo as codigoLabExterno,");
        buf.append("  lae.lae_descricao as descricaoLabExterno,");
        buf.append("  lae.lae_protocolo as protocoloLabExterno,");
        buf.append("  lotextreq.req_codigo as codigoRequisicao,");
        buf.append("  a.req_data as dataRequisicao,");
        buf.append("  a.req_hora as horaRequisicao,");
        buf.append("  lotextreq.leq_dataestorno as dataHoraEstornoRequisicaoLote,");
        buf.append("  lotextreq.usr_codestorno as usuarioEstornoRequisicaoLote, ");
        buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        buf.append(" from requisicao a");
        buf.append("  left join loteexternorequisicao lotextreq on a.fil_codigo = lotextreq.fil_codigo and a.req_codigo = lotextreq.req_codigo");
        buf.append("  left join loteexterno lotext on a.fil_codigo = lotext.fil_codigo and lotextreq.lae_codigo = lotext.lae_codigo and lotextreq.lex_codigo = lotext.lex_codigo");
        buf.append("  left join labexterno lae on a.fil_codigo = lae.fil_codigo and lotextreq.lae_codigo = lae.lae_codigo ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        buf.append(this.getWhere((String[])filiais, (String[])labapoio));
        buf.append(this.getOrderBy());
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            ModeloGridTable modelo = new ModeloGridTable(campos);
            while (rs.next()) {
                Object[] o = new Object[campos.length];
                for (int i = 0; i < campos.length; ++i) {
                    if (RelatorioUtil.possuiColuna(rs, campos[i]) == -1) continue;
                    o[i] = rs.getObject(campos[i]);
                }
                modelo.addLine(o);
            }
            buf.delete(0, buf.length());
            buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
            buf.append(RelatorioLotesEstornados.getModuloAcesso());
            rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next() && modelo.getRowCount() > 0) {
                Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                gerador.setPai(this.panelCentro);
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(new Runnable(){

                    @Override
                    public void run() {
                        RelatorioLotesEstornados.this.panelCentro.removeAll();
                        RelatorioLotesEstornados.this.panelCentro.repaint();
                        RelatorioLotesEstornados.this.habilitaBotaoImprimir(true);
                    }
                });
                HashMap<String, Object> var = new HashMap<String, Object>();
                var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                var.put("filtroDataColeta", this.getFiltroCombo("filtroDataColeta"));
                var.put("filtroFilial", this.arrayToString(filiais, false));
                var.put("filtroLabApoio", this.arrayToString(labapoio, false));
                gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                this.panelCentro.revalidate();
            } else if (modelo.getRowCount() == 0) {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioLotesEstornados: 152");
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private String getWhere(String[] filiais, String[] labapoio) {
        String dataFormatada;
        StringBuilder buf = new StringBuilder();
        buf.append(" where a.fil_codigo in ( ");
        buf.append(this.arrayToString(filiais, false)).append(" )");
        if (!Funcoes.objectIsNull(labapoio)) {
            buf.append(" and lotextreq.lae_codigo in ( ").append(this.arrayToString(labapoio, false)).append(" )");
        }
        if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
            dataFormatada = Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial"));
            if (this.getFiltroCombo("filtroDataColeta").equals(this.tipoDatas[0])) {
                buf.append(" and cast (lotext.lex_datahora as date) >= '").append(dataFormatada).append("'");
            } else {
                buf.append(" and a.req_data >= '").append(dataFormatada).append("'");
            }
        }
        if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
            dataFormatada = Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal"));
            if (this.getFiltroCombo("filtroDataColeta").equals(this.tipoDatas[0])) {
                buf.append(" and cast(lotext.lex_datahora as date) <= '").append(dataFormatada).append("'");
            } else {
                buf.append(" and a.req_data <= '").append(dataFormatada).append("'");
            }
        }
        buf.append(" AND (lotext.lex_dataestorno is not null or lotextreq.leq_dataestorno is not null)");
        return buf.toString();
    }

    private String getOrderBy() {
        int indexComboOrdem = ArraysUtil.indice((Object[])this.ordem, this.getFiltroCombo("ordemRelatorio"));
        StringBuilder buf = new StringBuilder(" order by");
        switch (indexComboOrdem) {
            case 0: {
                buf.append(" lae.lae_codigo asc, lotextreq.lex_codigo asc");
                break;
            }
            case 1: {
                buf.append(" lae.lae_codigo asc, lotext.lex_datahora asc");
                break;
            }
            case 2: {
                buf.append(" lae.lae_codigo asc, lotext.lex_dataestorno asc");
                break;
            }
            case 3: {
                buf.append(" lae.lae_descricao asc, lotextreq.lex_codigo asc");
            }
        }
        return buf.toString();
    }

    private boolean validarCampos() {
        if (Funcoes.textoVazio(this.arrayToString(this.getSelecionadosFiltro("filtroLabApoio", 0), false))) {
            Funcoes.mensagem(this, "O Lab. Apoio deve ser preenchido", 2);
            ScreenUtil.requisitarFoco(this.getComponentes().get("filtroLabApoio"));
            return false;
        }
        if (Funcoes.textoVazio(this.getFiltroData("filtroDataInicial"))) {
            Funcoes.mensagem(this, "O campo Data inicial deve ser preenchido", 2);
            ScreenUtil.requisitarFoco(this.getComponentes().get("filtroDataInicial"));
            return false;
        }
        if (Funcoes.textoVazio(this.getFiltroData("filtroDataFinal"))) {
            Funcoes.mensagem(this, "O campo Data final deve ser preenchido", 2);
            ScreenUtil.requisitarFoco(this.getComponentes().get("filtroDataFinal"));
            return false;
        }
        return true;
    }

    private String arrayToString(Object[] a, boolean isTexto) {
        if (a == null) {
            return "";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (true) {
            String valor = String.valueOf(a[i]);
            if (isTexto) {
                valor = "'" + valor + "'";
            }
            b.append(valor);
            if (i == iMax) {
                return b.toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0860200600");
    }

    private long getModuloConfigurar() {
        return Long.parseLong("0860200601");
    }
}

