/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.apoio;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.util.parsers.FabricaConfigurador;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.relatorio.Gerador;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioConferenciaEnviados
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_LOTE = "filtroLote";
    private final long ACESSO_CONFIGURAR = Long.parseLong("0860200101");
    protected static final String[] campos = new String[]{"codigoRequisicao", "nomePaciente", "nomeSocialPaciente", "proprietarioPaciente", "dataNascimentoPaciente", "sexoPaciente", "idadePaciente", "anoMesPaciente", "horaRequisicao", "conselhoMedico", "crmMedico", "ufMedico", "nomeMedico", "codigoLaboratorio", "razaoLaboratorio", "observacaoRequisicao", "codigoRequisicaoApoio", "codigoExame", "descricaoExame", "dataRequisicao", "codigoLote", "dataLote", "codigoLoteLabApoio", "codigoMaterialColetado", "descricaoMaterialColetado", "abreviaturaMaterialColetado", "codigoFilialRequisicao", "codigoLabExterno", "protocoloLabExterno", "codigoExameLaboratorioApoio", "descricaoExameLaboratorioApoio", "codigoMatLaboratorioApoio", "descricaoMatLaboratorioApoio", "dataEntregaExameRequisicao", "dataEntregaRequisicao", "requisicaoExcluida", "generoPaciente"};

    public RelatorioConferenciaEnviados() {
        this.montaBarraDescricao("Relat\u00f3rio de confer\u00eancia de requisi\u00e7\u00f5es enviadas", "Listagem com os c\u00f3digos das requisi\u00e7\u00f5es enviadas pelo laborat\u00f3rio de apoio", "relatorios/conf_req_enviadas.jpg");
        this.adicionaRelatorioListener(this);
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
            String sql = "select a.lot_codigo, a.lot_datahora, a.pac_codigo, b.pac_nome from loteapoio a left join paciente b on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo";
            this.adicionaItemFiltro("filtroLote", "Lote", sql, "a.fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"lot_codigo", "lot_datahora", "pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Data", "Cliente", "Nome"}, new int[]{70, 0, 70, 0}, new int[]{0, 2}, true);
        } else {
            String sql = "select a.lot_codigo, a.lot_datahora, a.con_codigo, b.con_fantasia from loteapoio a left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo";
            this.adicionaItemFiltro("filtroLote", "Lote", sql, "a.fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"lot_codigo", "lot_datahora", "con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Data", "Conv\u00eanio", "Fantasia"}, new int[]{70, 0, 70, 0}, new int[]{0, 2}, true);
        }
        this.setModuloConfigurar(this.ACESSO_CONFIGURAR);
        this.setModuloAcesso(RelatorioConferenciaEnviados.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        if (this.getSelecionadosFiltro("filtroLote", 0) == null || this.getSelecionadosFiltro("filtroLote", 0).length == 0) {
            Funcoes.mensagem(this, "Lote n\u00e3o selecionado", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        if (this.getSelecionadosFiltro("filtroLote", 0).length > 1) {
            Funcoes.mensagem(this, "Apenas um lote pode ser selecionado", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Statement st = Conexao.getStatement();
            String[] lotes = this.getSelecionadosFiltro("filtroLote", 0);
            ModeloGridTable modelo = null;
            if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
                String[] clientes = this.getSelecionadosFiltro("filtroLote", 2);
                modelo = this.getModeloDados(st, lotes, null, clientes);
            } else {
                String[] convenios = this.getSelecionadosFiltro("filtroLote", 2);
                modelo = this.getModeloDados(st, lotes, convenios, null);
            }
            if (modelo.getRowCount() > 0) {
                StringBuilder buf = new StringBuilder();
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioConferenciaEnviados.getModuloAcesso());
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioConferenciaEnviados.this.panelCentro.removeAll();
                            RelatorioConferenciaEnviados.this.panelCentro.repaint();
                            RelatorioConferenciaEnviados.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    buf.delete(0, buf.length());
                    if (lotes != null) {
                        for (int i = 0; i < lotes.length; ++i) {
                            buf.append(lotes[i]);
                            if (i >= lotes.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroLote", buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
                rs.close();
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public ModeloGridTable getModeloDados(Statement st, String[] lotes, String[] convenios, String[] clientes) throws Exception {
        int i;
        ModeloGridTable modelo = new ModeloGridTable(campos);
        StringBuilder buf = new StringBuilder();
        buf.append("select a.fil_codigo as codigoFilialRequisicao, a.req_codigoapoiado as codigoRequisicao,  a.req_codigo as codigoRequisicaoApoio, ");
        buf.append("paciente.pac_nome as nomePaciente, paciente.pac_proprietario as proprietarioPaciente, a.req_idade as idadePaciente, a.req_anomes as anoMesPaciente, ");
        buf.append("c.exa_codigo as codigoExame, c.exa_descricao as descricaoExame,  b.exr_dataentregaprev as dataEntregaExameRequisicao, ");
        buf.append("paciente.pac_datanasc as dataNascimentoPaciente, paciente.pac_sexo as sexoPaciente, ");
        buf.append("a.med_conselho as conselhoMedico, a.med_crm as crmMedico, a.med_uf as ufMedico, medico.med_nome as nomeMedico, ");
        buf.append("a.req_obs as observacaoRequisicao, a.req_hora as horaRequisicao, ");
        buf.append("coletado.mco_codigo as codigoMaterialColetado, coletado.mco_descricao as descricaoMaterialColetado, ");
        buf.append("coletado.mco_abreviatura as abreviaturaMaterialColetado, ");
        buf.append("l.lot_codigo as codigoLote, l.lot_datahora as dataLote, a.req_data as dataRequisicao, a.req_dataentregaprev as dataEntregaRequisicao, paciente.pac_nomesocial as nomeSocialPaciente, ");
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
            buf.append("l.pac_codigo as codigoLaboratorio, p.pac_nome as razaoLaboratorio, ");
        } else {
            buf.append("l.con_codigo as codigoLaboratorio, convenios.con_razao as razaoLaboratorio, ");
        }
        buf.append(" a.req_excluida as requisicaoExcluida, ");
        buf.append("q.ele_xmllabexterno as codigoExameLaboratorioApoio, '' as descricaoExameLaboratorioApoio, ");
        buf.append("d.lae_codigo as codigoLabExterno, labexterno.lae_protocolo as protocoloLabExterno, ");
        buf.append("idg.ige_descricao as generoPaciente ");
        buf.append("from loteapoiorequisicao lote ");
        buf.append("left join loteapoio l on lote.fil_codigo = l.fil_codigo and lote.lot_id = l.lot_id ");
        buf.append("left join requisicao a on lote.fil_codigo = a.fil_codigo and lote.req_codigo = a.req_codigo ");
        buf.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        buf.append("join paciente on a.fil_codigo = paciente.fil_codigo and a.pac_codigo = paciente.pac_codigo ");
        buf.append("left join exames c on b.fil_codigo = c.fil_codigo and b.exa_codigo = c.exa_codigo ");
        buf.append("left join examematcoleta d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo and b.mco_codigo = d.mco_codigo ");
        buf.append("left join materialcoleta coletado on d.fil_codigo = coletado.fil_codigo and d.mco_codigo = coletado.mco_codigo ");
        buf.append("left join medico on a.fil_codigo = medico.fil_codigo and a.med_conselho = medico.med_conselho and a.med_crm = medico.med_crm and a.med_uf = medico.med_uf ");
        buf.append("left join convenios on a.fil_codigo = convenios.fil_codigo and l.con_codigo = convenios.con_codigo ");
        buf.append("left join labexterno on d.fil_codigo = labexterno.fil_codigo and d.lae_codigo = labexterno.lae_codigo ");
        buf.append("left join paciente p on a.fil_codigo = p.fil_codigo and l.pac_codigo = p.pac_codigo ");
        buf.append("left join examematcoletalabexterno q on d.fil_codigo = q.fil_codigo and d.exa_codigo = q.exa_codigo and d.mco_codigo = q.mco_codigo and labexterno.lae_codigo = q.lae_codigo ");
        buf.append("left join identidadegenero idg on coalesce(paciente.pac_genero, 0) = idg.ige_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and (a.req_excluida or not b.exr_excluido) ");
        if (lotes != null) {
            buf.append(" and l.lot_codigo in (");
            for (i = 0; i < lotes.length; ++i) {
                buf.append(lotes[i]);
                if (i >= lotes.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        if (convenios != null) {
            buf.append(" and l.con_codigo in (");
            for (i = 0; i < convenios.length; ++i) {
                buf.append(convenios[i]);
                if (i >= convenios.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        if (clientes != null && clientes.length > 0 && !clientes[0].trim().isEmpty()) {
            buf.append(" and l.pac_codigo in (");
            for (i = 0; i < clientes.length; ++i) {
                buf.append(clientes[i]);
                if (i >= clientes.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        buf.append(" order by ");
        buf.append("a.req_codigo");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            do {
                Object[] o = new Object[campos.length];
                for (int i2 = 0; i2 < campos.length; ++i2) {
                    Protocolo p;
                    String xml;
                    if (campos[i2].equalsIgnoreCase("codigoLoteLabApoio")) {
                        if (rs.getString("codigoLaboratorio") == null || rs.getString("codigoLaboratorio").trim().isEmpty()) continue;
                        o[i2] = Funcoes.preencheZero(Variaveis.filialPadrao, 2) + Funcoes.preencheZero(rs.getString("codigoLaboratorio"), 4) + Funcoes.preencheZero(rs.getString("codigoLote"), 6);
                        continue;
                    }
                    if (campos[i2].equalsIgnoreCase("anoMesPaciente")) {
                        o[i2] = Tipos.tipoIdade(rs.getString(campos[i2]));
                        continue;
                    }
                    if (campos[i2].equalsIgnoreCase("sexoPaciente")) {
                        o[i2] = Tipos.tipoSexo(rs.getString(campos[i2]));
                        continue;
                    }
                    if (campos[i2].equalsIgnoreCase("codigoExameLaboratorioApoio")) {
                        xml = rs.getString("codigoExameLaboratorioApoio");
                        o[i2] = "";
                        p = Protocolo.getProtocolo(rs.getString("protocoloLabExterno"));
                        if (p == null) continue;
                        o[i2] = FabricaConfigurador.getCodigoIdentExameLabExternoSelecionado(p, rs.getString("codigoLabExterno"), xml);
                        continue;
                    }
                    if (campos[i2].equalsIgnoreCase("descricaoExameLaboratorioApoio")) {
                        xml = rs.getString("codigoExameLaboratorioApoio");
                        o[i2] = "";
                        p = Protocolo.getProtocolo(rs.getString("protocoloLabExterno"));
                        if (p == null) continue;
                        o[i2] = FabricaConfigurador.getDescricaoExameSelecionado(p, rs.getString("codigoLabExterno"), xml);
                        continue;
                    }
                    o[i2] = campos[i2].equalsIgnoreCase("codigoMatLaboratorioApoio") || campos[i2].equalsIgnoreCase("descricaoMatLaboratorioApoio") ? "" : (campos[i2].equalsIgnoreCase("requisicaoExcluida") ? (rs.getBoolean("requisicaoExcluida") ? "Sim" : "N\u00e3o") : rs.getObject(campos[i2]));
                }
                modelo.addLine(o);
            } while (rs.next());
        }
        return modelo;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0860200100");
    }
}

