/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.apoio;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.table.TableModel;

public class RelatorioComparativoPrecoTabela
extends FrmRelPadrao {
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_TABELA_PRECO = "filtroTabelaPreco";
    private final String FILTRO_LAB_EXTERNO = "filtroLabExterno";
    private final String FILTRO_VALOR_MENOR = "filtroValorMenor";
    private final String FILTRO_ORDEM = "filtroOrdem";
    private final String[] ordem = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "C\u00f3digo AMB"};
    private final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoExame", "descricaoExame", "sexoExame", "materialPadraoExame", "horaEntradaExame", "horaSaidaExame", "filtroExame", "proibidoExame", "diagnosticoExame", "interferenciaExame", "sinonimoExame", "salvaParcialExame", "idadeMaximaExame", "idadeMinimaExame", "tipoIdadeMaximaExame", "tipoIdadeMinimaExame", "proibidoWebExame", "quantidadeAmostrasExame", "materialPadraoExame", "preaparoExame", "preparoAmostraExame", "inadequadaExame", "codigoPrazoEntrega", "codigoMetodologia", "ordemExame", "paginaExame", "cbhpmExame", "ambExame", "conservacaoExame", "diasConservacaoExame", "temperaturaInicialExame", "temperaturaFinalExame", "referenciaExame", "procedimentoExame", "solicitarJejumExame", "solicitarMedicamentoExame", "solicitarDUMExame", "solicitarTempoDiureseExame", "instrucaoColetaExame", "marcarExternoExame", "descricaoPrazoEntrega", "rotinaPrazoEntrega", "diasPrazoEntrega", "horaEntradaPrazoEntrega", "horaSaidaPrazoEntrega", "descricaoMetodologia", "descricaoMaterialColetado", "solicitarMaterialMaterialColetado", "abreviaturaMaterialColetado", "codigoSetor", "descricaoSetor", "responsavelSetor", "corSetor", "siglaSetor", "codigoUsuario", "nomeUsuario", "codigoTabelaPreco", "descricaoTabelaPreco", "valorCHTabelaPreco", "moedaTabelaPreco", "percentualTabelaPrecoExame", "custoTabelaPrecoExame", "porteTabelaPrecoExame", "valorPorteTabelaPrecoExame", "valorUCOTabelaPrecoExame", "codigoAmbTabelaPrecoExame", "valorCHTabelaPrecoExame", "proibidoTabelaPrecoExame", "valorExameLabExterno", "prazoExameLabExterno", "codigoLabExterno", "descricaoLabExterno", "codigoMetodologia", "codigoMaterialColetado"});

    public RelatorioComparativoPrecoTabela() {
        this.montaBarraDescricao("Relat\u00f3rio comparativo de pre\u00e7os por tabela", "Listagem das diferen\u00e7as de pre\u00e7os dos exames entre o labor\u00e1torio e o lab. apoio", "relatorios/rel_tab_preco_comparativo.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroTabelaPreco", "Tabela de pre\u00e7o", "tabelaprecoexames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"tpe_codigo", "tpe_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroLabExterno", "Lab. Externo", "labexterno", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"lae_codigo", "lae_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroCombo("filtroOrdem", "Ordem:", this.ordem, 0);
        this.adicionaFiltroCheck("filtroValorMenor", "Exames acima da tabela", false);
        this.setCamposConfigurador(this.campos);
        this.setModuloAcesso(RelatorioComparativoPrecoTabela.getModuloAcesso());
        this.setModuloConfigurar(RelatorioComparativoPrecoTabela.getModuloConfigurar());
    }

    @Override
    public void imprimirPressionado() {
        if (this.getSelecionadosFiltro("filtroTabelaPreco", 0) == null || this.getSelecionadosFiltro("filtroTabelaPreco", 0).length == 0) {
            Funcoes.mensagem(this, "Selecione uma tabela de pre\u00e7o.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        if (this.getSelecionadosFiltro("filtroTabelaPreco", 0).length > 1) {
            Funcoes.mensagem(this, "Selecione apenas uma tabela de pre\u00e7o.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        if (this.getSelecionadosFiltro("filtroLabExterno", 0) == null || this.getSelecionadosFiltro("filtroLabExterno", 0).length == 0) {
            Funcoes.mensagem(this, "Selecione pelo menos um laborat\u00f3rio externo.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            int i;
            String[] labexterno;
            Statement st = Conexao.getStatement();
            StringBuilder bufNormal = new StringBuilder();
            StringBuilder bufMetodologia = new StringBuilder();
            StringBuilder buf = new StringBuilder();
            buf.append(" SELECT ele.ele_valorexame AS valorExameLabExterno ");
            buf.append("       ,ele.ele_diasprazo AS prazoexamelabexterno ");
            buf.append("       ,lae.lae_codigo AS codigolabexterno ");
            buf.append("       ,lae.lae_descricao AS descricaolabexterno ");
            buf.append("       ,met.met_codigo AS codigoMetodologia ");
            buf.append("       ,met.met_descricao AS descricaoMetodologia ");
            buf.append("       ,a.exa_codigo as codigoExame ");
            buf.append("       ,a.exa_descricao as descricaoExame ");
            buf.append("       ,a.exa_sexo as sexoExame ");
            buf.append("       ,a.exa_horaentrada as horaEntradaExame ");
            buf.append("       ,a.exa_horasaida as horaSaidaExame ");
            buf.append("       ,a.exa_filtro as filtroExame ");
            buf.append("       ,a.exa_proibido as proibidoExame ");
            buf.append("       ,a.exa_diagnostico as diagnosticoExame ");
            buf.append("       ,a.exa_interferencia as interferenciaExame ");
            buf.append("       ,a.exa_sinonimo as sinonimoExame ");
            buf.append("       ,a.exa_salvaparcial as salvaParcialExame ");
            buf.append("       ,a.exa_idademax as idadeMaximaExame ");
            buf.append("       ,a.exa_idademin as idadeMinimaExame ");
            buf.append("       ,a.exa_idademaxtipo as tipoIdadeMaximaExame ");
            buf.append("       ,a.exa_idademintipo as tipoIdadeMinimaExame ");
            buf.append("       ,a.exa_proibidoweb as proibidoWebExame ");
            buf.append("       ,a.exa_qtdeamostras as quantidadeAmostrasExame ");
            buf.append("       ,emc.emc_default as materialPadraoExame ");
            buf.append("       ,emc.emc_preparo as preaparoExame ");
            buf.append("       ,emc.emc_prepamostra as preparoAmostraExame ");
            buf.append("       ,emc.emc_inadequada as inadequadaExame ");
            buf.append("       ,emc.prz_codigo as codigoPrazoEntrega ");
            buf.append("       ,emc.met_codigo as codigoMetodologia ");
            buf.append("       ,emc.emc_ordem as ordemExame ");
            buf.append("       ,emc.emc_pagina as paginaExame ");
            buf.append("       ,emc.emc_codigocbhpm as cbhpmExame ");
            buf.append("       ,emc.emc_codigoamb as ambExame ");
            buf.append("       ,emc.emc_conservacao as conservacaoExame ");
            buf.append("       ,emc.emc_diasconserva as diasConservacaoExame ");
            buf.append("       ,emc.emc_temperaturainicial as temperaturaInicialExame ");
            buf.append("       ,emc.emc_temperaturafinal as temperaturaFinalExame ");
            buf.append("       ,emc.emc_referencia as referenciaExame ");
            buf.append("       ,emc.emc_procedimento as procedimentoExame ");
            buf.append("       ,emc.emc_solicitarjejum as solicitarJejumExame ");
            buf.append("       ,emc.emc_obrigamedicamento as solicitarMedicamentoExame ");
            buf.append("       ,emc.emc_obrigadum as solicitarDUMExame ");
            buf.append("       ,emc.emc_obrigapeso as solicitarPesoExame ");
            buf.append("       ,emc.emc_obrigaaltura as solicitarAlturaExame ");
            buf.append("       ,emc.emc_obrigavolume as solicitarVolumeExame ");
            buf.append("       ,emc.emc_obrigatempodiurese as solicitarTempoDiureseExame ");
            buf.append("       ,emc.emc_instrcoleta as instrucaoColetaExame ");
            buf.append("       ,emc.emc_marcarexterno as marcarExternoExame ");
            buf.append("       ,prz.prz_descricao as descricaoPrazoEntrega ");
            buf.append("       ,prz.prz_prazo as rotinaPrazoEntrega ");
            buf.append("       ,prz.prz_dias as diasPrazoEntrega ");
            buf.append("       ,prz.prz_horaentrada as horaEntradaPrazoEntrega ");
            buf.append("       ,prz.prz_horasaida as horaSaidaPrazoEntrega ");
            buf.append("       ,mco.mco_codigo as codigoMaterialColetado ");
            buf.append("       ,mco.mco_descricao as descricaoMaterialColetado ");
            buf.append("       ,mco.mco_solicitarmat as solicitarMaterialMaterialColetado ");
            buf.append("       ,mco.mco_abreviatura as abreviaturaMaterialColetado ");
            buf.append("       ,ese.set_codigo as codigoSetor ");
            buf.append("       ,setor.set_descricao as descricaoSetor ");
            buf.append("       ,setor.set_responsavel as responsavelSetor ");
            buf.append("       ,setor.set_cor as corSetor ");
            buf.append("       ,setor.set_sigla as siglaSetor ");
            buf.append("       ,usr.usr_codigo as codigoUsuario ");
            buf.append("       ,usr.usr_nome as nomeUsuario ");
            buf.append("       ,tpe.tpe_codigo as codigoTabelaPreco ");
            buf.append("       ,tpe.tpe_descricao as descricaoTabelaPreco ");
            buf.append("       ,tpe.tpe_valorch as valorCHTabelaPreco ");
            buf.append("       ,tpe.tpe_moeda as moedaTabelaPreco ");
            buf.append("       ,case when tpe.tpe_tipocbhpm = false then dtp.dtp_valor ");
            buf.append("             else ((dtp.dtp_percentual * tpp.tpp_valor) + (dtp.dtp_valor * tpe.tpe_uco)) ");
            buf.append("        end as valorCHTabelaPrecoExame ");
            buf.append("       ,dtp.dtp_valor as custoTabelaPrecoExame ");
            buf.append("       ,tpe.tpe_uco as valorUCOTabelaPrecoExame");
            buf.append("       ,dtp.dtp_percentual as percentualTabelaPrecoExame ");
            buf.append("       ,dtp.tpp_porte as porteTabelaPrecoExame ");
            buf.append("       ,tpp.tpp_valor as valorPorteTabelaPrecoExame ");
            buf.append("       ,dtp.dtp_codamb as codigoAmbTabelaPrecoExame ");
            buf.append("       ,dtp.dtp_proibido as proibidoTabelaPrecoExame ");
            buf.append("       , ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            bufMetodologia.append(buf.toString().replaceAll("dtp", "dtm"));
            bufNormal.append(buf.toString());
            bufNormal.append(" FROM detalhetabelapreco dtp ");
            bufNormal.append(" LEFT JOIN examematcoletalabexterno ele ON dtp.fil_codigo = ele.fil_codigo AND dtp.exa_codigo = ele.exa_codigo AND dtp.mco_codigo = ele.mco_codigo ");
            bufNormal.append(" LEFT JOIN labexterno lae ON dtp.fil_codigo = lae.fil_codigo AND ele.lae_codigo = lae.lae_codigo ");
            bufNormal.append(" LEFT JOIN examematcoleta emc ON dtp.fil_codigo = emc.fil_codigo AND dtp.exa_codigo = emc.exa_codigo AND dtp.mco_codigo = emc.mco_codigo ");
            bufNormal.append(" LEFT JOIN exames a ON emc.fil_codigo = a.fil_codigo AND emc.exa_codigo = a.exa_codigo ");
            bufNormal.append(" LEFT JOIN prazoentrega prz ON a.fil_codigo = prz.fil_codigo AND emc.prz_codigo = prz.prz_codigo ");
            bufNormal.append(" LEFT JOIN metodologia met ON a.fil_codigo = met.fil_codigo AND ele.met_codigo = met.met_codigo ");
            bufNormal.append(" LEFT JOIN materialcoleta mco ON a.fil_codigo = mco.fil_codigo AND emc.mco_codigo = mco.mco_codigo ");
            bufNormal.append(" LEFT JOIN examesetor ese ON a.fil_codigo = ese.fil_codigo AND a.exa_codigo = ese.exa_codigo AND ese.ese_default = true ");
            bufNormal.append(" LEFT JOIN setores setor ON a.fil_codigo = setor.fil_codigo AND ese.set_codigo = setor.set_codigo ");
            bufNormal.append(" LEFT JOIN usuario usr ON setor.usr_codigo = usr.usr_codigo ");
            bufNormal.append(" LEFT JOIN tabelaprecoexames tpe ON dtp.fil_codigo = tpe.fil_codigo AND dtp.tpe_codigo = tpe.tpe_codigo ");
            bufNormal.append(" LEFT JOIN tabelaprecoexamesporte tpp ON dtp.fil_codigo = tpp.fil_codigo AND dtp.tpe_codigo = tpp.tpe_codigo AND dtp.tpp_porte = tpp.tpp_porte ");
            bufNormal.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            bufMetodologia.append(" FROM detalhetabelaprecometodologia dtm ");
            bufMetodologia.append(" LEFT JOIN examematcoletalabexterno ele ON dtm.fil_codigo = ele.fil_codigo AND dtm.exa_codigo = ele.exa_codigo AND dtm.mco_codigo = ele.mco_codigo and dtm.met_codigo = ele.met_codigo ");
            bufMetodologia.append(" LEFT JOIN labexterno lae ON ele.fil_codigo = lae.fil_codigo AND ele.lae_codigo = lae.lae_codigo ");
            bufMetodologia.append(" LEFT JOIN examematcoleta emc ON dtm.fil_codigo = emc.fil_codigo AND dtm.exa_codigo = emc.exa_codigo AND dtm.mco_codigo = emc.mco_codigo ");
            bufMetodologia.append(" LEFT JOIN exames a ON emc.fil_codigo = a.fil_codigo AND emc.exa_codigo = a.exa_codigo ");
            bufMetodologia.append(" LEFT JOIN prazoentrega prz ON a.fil_codigo = prz.fil_codigo AND emc.prz_codigo = prz.prz_codigo ");
            bufMetodologia.append(" LEFT JOIN metodologia met ON dtm.fil_codigo = met.fil_codigo AND dtm.met_codigo = met.met_codigo ");
            bufMetodologia.append(" LEFT JOIN materialcoleta mco ON a.fil_codigo = mco.fil_codigo AND emc.mco_codigo = mco.mco_codigo ");
            bufMetodologia.append(" LEFT JOIN examesetor ese ON a.fil_codigo = ese.fil_codigo AND a.exa_codigo = ese.exa_codigo AND ese.ese_default = true ");
            bufMetodologia.append(" LEFT JOIN setores setor ON a.fil_codigo = setor.fil_codigo AND ese.set_codigo = setor.set_codigo ");
            bufMetodologia.append(" LEFT JOIN usuario usr ON setor.usr_codigo = usr.usr_codigo ");
            bufMetodologia.append(" LEFT JOIN tabelaprecoexames tpe ON dtm.fil_codigo = tpe.fil_codigo AND dtm.tpe_codigo = tpe.tpe_codigo ");
            bufMetodologia.append(" LEFT JOIN tabelaprecoexamesporte tpp ON dtm.fil_codigo = tpp.fil_codigo AND dtm.tpe_codigo = tpp.tpe_codigo AND dtm.tpp_porte = tpp.tpp_porte ");
            bufMetodologia.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.setLength(0);
            buf.append("where ");
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais != null) {
                buf.append(" a.fil_codigo in (");
                for (int i2 = 0; i2 < filiais.length; ++i2) {
                    buf.append(filiais[i2]);
                    if (i2 >= filiais.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            } else {
                buf.append("a.fil_codigo = ").append(Variaveis.filialPadrao);
            }
            String[] tabelas = this.getSelecionadosFiltro("filtroTabelaPreco", 0);
            if (tabelas != null) {
                buf.append(" and tpe.tpe_codigo in (");
                for (int i3 = 0; i3 < tabelas.length; ++i3) {
                    buf.append(tabelas[i3]);
                    if (i3 >= tabelas.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if ((labexterno = this.getSelecionadosFiltro("filtroLabExterno", 0)) != null) {
                buf.append(" and lae.lae_codigo in (");
                for (int i4 = 0; i4 < labexterno.length; ++i4) {
                    buf.append(labexterno[i4]);
                    if (i4 >= labexterno.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if (this.getFiltroCheck("filtroValorMenor")) {
                buf.append("and dtp.dtp_valor < ele.ele_valorexame ");
            }
            buf.append("and a.exa_proibido = false ");
            buf.append("and dtp.dtp_proibido = false ");
            buf.append("and emc.emc_proibido = false ");
            bufNormal.append(buf.toString());
            bufMetodologia.append(buf.toString().replaceAll("dtp", "dtm"));
            ListaDados listaDados = new ListaDados();
            if (ParametrosGerais.getPrecoMetodologia()) {
                ResultSet rsMetodologia = Conexao.executeQuery(st, bufMetodologia.toString());
                while (rsMetodologia.next()) {
                    listaDados.addExame(rsMetodologia.getString("codigoExame"), rsMetodologia.getInt("codigoMaterialColetado"), rsMetodologia.getInt("codigoMetodologia"));
                    for (i = 0; i < this.campos.length; ++i) {
                        listaDados.addValor(rsMetodologia.getString("codigoExame"), rsMetodologia.getInt("codigoMaterialColetado"), rsMetodologia.getInt("codigoMetodologia"), this.campos[i], rsMetodologia.getObject(this.campos[i]));
                    }
                }
            }
            ResultSet rsNormal = Conexao.executeQuery(st, bufNormal.toString());
            while (rsNormal.next()) {
                if (!listaDados.addExame(rsNormal.getString("codigoExame"), rsNormal.getInt("codigoMaterialColetado"))) continue;
                for (i = 0; i < this.campos.length; ++i) {
                    listaDados.addValor(rsNormal.getString("codigoExame"), rsNormal.getInt("codigoMaterialColetado"), this.campos[i], rsNormal.getObject(this.campos[i]));
                }
            }
            if (this.getFiltroCombo("filtroOrdem").equals(this.ordem[0])) {
                listaDados.ordenarDados(new String[]{"codigoExame", "codigoMaterialColetado"});
            }
            if (this.getFiltroCombo("filtroOrdem").equals(this.ordem[1])) {
                listaDados.ordenarDados(new String[]{"descricaoExame"});
            } else if (this.getFiltroCombo("filtroOrdem").equals(this.ordem[2])) {
                listaDados.ordenarDados(new String[]{"codigoAmbTabelaPrecoExame"});
            }
            ModeloGridTable modelo = new ModeloGridTable(this.campos);
            Iterator it = listaDados.getIterator();
            if (it.hasNext()) {
                while (it.hasNext()) {
                    Dados dados = (Dados)it.next();
                    Object[] o = new Object[this.campos.length];
                    for (int i5 = 0; i5 < this.campos.length; ++i5) {
                        o[i5] = this.campos[i5].indexOf("tipo") >= 0 ? Tipos.tipoIdade(dados.getValor(this.campos[i5]).toString()) : dados.getValor(this.campos[i5]);
                    }
                    modelo.addLine(o);
                }
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioComparativoPrecoTabela.getModuloAcesso());
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i6;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioComparativoPrecoTabela.this.panelCentro.removeAll();
                            RelatorioComparativoPrecoTabela.this.panelCentro.repaint();
                            RelatorioComparativoPrecoTabela.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("filtroOrdem", this.getFiltroCombo("filtroOrdem"));
                    buf.delete(0, buf.length());
                    if (tabelas != null) {
                        for (i6 = 0; i6 < tabelas.length; ++i6) {
                            buf.append(tabelas[i6]);
                            if (i6 >= tabelas.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroTabelaPreco", buf.toString());
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        for (i6 = 0; i6 < filiais.length; ++i6) {
                            buf.append(filiais[i6]);
                            if (i6 >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroFilial", buf.toString());
                    buf.delete(0, buf.length());
                    if (labexterno != null) {
                        for (i6 = 0; i6 < labexterno.length; ++i6) {
                            buf.append(labexterno[i6]);
                            if (i6 >= labexterno.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroLabExterno", buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0860100500");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0860100501");
    }

    class Dados
    implements Comparable {
        String[] colunasOrdenacao = null;
        String codigoExame = null;
        Integer codigoMaterial = null;
        Integer codigoMetodologia = null;
        HashMap<String, Object> dados = null;

        public Dados(String codigoExame, Integer codigoMaterial, Integer codigoMetodologia) {
            this.codigoExame = codigoExame;
            this.codigoMaterial = codigoMaterial;
            this.codigoMetodologia = codigoMetodologia == null ? -1 : codigoMetodologia;
            this.dados = new HashMap();
        }

        public void put(String coluna, Object valor) {
            this.dados.put(coluna, valor);
        }

        public boolean equals(String codigoExame, Integer codigoMaterial) {
            if (this.codigoExame != null && this.codigoMaterial != null && codigoExame != null && codigoMaterial != null) {
                return this.codigoExame.equalsIgnoreCase(codigoExame) && this.codigoMaterial.equals(codigoMaterial);
            }
            return false;
        }

        public boolean equals(String codigoExame, Integer codigoMaterial, Integer codigoMetodologia) {
            if (this.codigoExame != null && this.codigoMaterial != null && codigoExame != null && codigoMaterial != null && this.codigoMetodologia != null && codigoMetodologia != null) {
                return this.codigoExame.equalsIgnoreCase(codigoExame) && this.codigoMaterial.equals(codigoMaterial) && this.codigoMetodologia.equals(codigoMetodologia);
            }
            return false;
        }

        public Object getValor(String coluna) {
            return this.dados.get(coluna);
        }

        public int compareTo(Object o) {
            if (o instanceof Dados) {
                Dados aux = (Dados)o;
                int resultado = 0;
                for (int i = 0; i < this.colunasOrdenacao.length; ++i) {
                    Object valor2;
                    Object valor1;
                    if (this.dados.get(this.colunasOrdenacao[i]) instanceof String) {
                        valor1 = (String)this.dados.get(this.colunasOrdenacao[i]);
                        valor2 = (String)aux.dados.get(this.colunasOrdenacao[i]);
                        resultado = ((String)valor1).compareTo((String)valor2);
                    } else if (this.dados.get(this.colunasOrdenacao[i]) instanceof Integer) {
                        valor1 = (Integer)this.dados.get(this.colunasOrdenacao[i]);
                        valor2 = (Integer)aux.dados.get(this.colunasOrdenacao[i]);
                        resultado = ((Integer)valor1).compareTo((Integer)valor2);
                    } else if (this.dados.get(this.colunasOrdenacao[i]) instanceof BigDecimal) {
                        valor1 = (BigDecimal)this.dados.get(this.colunasOrdenacao[i]);
                        valor2 = (BigDecimal)aux.dados.get(this.colunasOrdenacao[i]);
                        resultado = ((BigDecimal)valor1).compareTo((BigDecimal)valor2);
                    }
                    if (resultado == 0 && i != this.colunasOrdenacao.length - 1) continue;
                    return resultado;
                }
            }
            return 0;
        }
    }

    class ListaDados {
        ArrayList<Dados> exames = new ArrayList();
        Dados auxExame = null;

        public Iterator getIterator() {
            return this.exames.iterator();
        }

        public boolean addExame(String codigoExame, Integer codigoMaterial) {
            for (Dados aux : this.exames) {
                if (!aux.equals(codigoExame, codigoMaterial)) continue;
                this.auxExame = aux;
                return false;
            }
            this.auxExame = new Dados(codigoExame, codigoMaterial, null);
            this.exames.add(this.auxExame);
            return true;
        }

        public void addExame(String codigoExame, Integer codigoMaterial, Integer codigoMetodologia) {
            for (Dados aux : this.exames) {
                if (!aux.equals(codigoExame, codigoMaterial, codigoMetodologia)) continue;
                this.auxExame = aux;
                return;
            }
            this.auxExame = new Dados(codigoExame, codigoMaterial, codigoMetodologia);
            this.exames.add(this.auxExame);
        }

        public void addValor(String codigoExame, Integer codigoMaterial, Integer codigoMetodologia, String coluna, Object valor) {
            if (this.auxExame != null && this.auxExame.codigoExame.equalsIgnoreCase(codigoExame) && this.auxExame.codigoMaterial.equals(codigoMaterial) && this.auxExame.codigoMetodologia.equals(codigoMetodologia)) {
                this.auxExame.put(coluna, valor);
            } else {
                for (Dados aux : this.exames) {
                    if (!aux.equals(codigoExame, codigoMaterial, codigoMetodologia)) continue;
                    this.auxExame = aux;
                    this.auxExame.put(coluna, valor);
                }
            }
        }

        public void addValor(String codigoExame, Integer codigoMaterial, String coluna, Object valor) {
            if (this.auxExame != null && this.auxExame.codigoExame.equalsIgnoreCase(codigoExame) && this.auxExame.codigoMaterial.equals(codigoMaterial)) {
                this.auxExame.put(coluna, valor);
            } else {
                for (Dados aux : this.exames) {
                    if (!aux.equals(codigoExame, codigoMaterial)) continue;
                    this.auxExame = aux;
                    this.auxExame.put(coluna, valor);
                }
            }
        }

        public void ordenarDados(String[] colunasOrdenacao) {
            for (int i = 0; i < this.exames.size(); ++i) {
                this.exames.get((int)i).colunasOrdenacao = colunasOrdenacao;
            }
            Collections.sort(this.exames);
        }
    }
}

