/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SolicitarVolume
extends JDialog {
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelTopo = new JPanel(null);
    private JButton buttonSalvar = new JButton("Salvar");
    private TTextField txtVolume = new TTextField(8, 2, 3);
    private JLabel label = new JLabel("Volume de diurese (ml):");

    public static SolicitarVolume novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new SolicitarVolume((Frame)pai);
        }
        if (pai instanceof Dialog) {
            return new SolicitarVolume((Dialog)pai);
        }
        return null;
    }

    public SolicitarVolume(Frame owner) {
        super(owner, "Volume");
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    public SolicitarVolume(Dialog owner) {
        super(owner, "Volume");
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.setSize(165, 130);
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelTopo, "Center");
        this.panelBotoes.add(this.buttonSalvar);
        this.panelTopo.add(this.label);
        this.panelTopo.add(this.txtVolume);
        this.label.setBounds(5, 5, 145, 14);
        this.txtVolume.setBounds(5, 20, 130, 20);
        this.buttonSalvar.setMnemonic('S');
        Funcoes.montaEnter((JComponent)this.panelTopo);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SolicitarVolume.this.txtVolume.selectAll();
                SolicitarVolume.this.txtVolume.grabFocus();
            }
        });
        this.buttonSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Funcoes.isNumeric(SolicitarVolume.this.txtVolume.getText())) {
                    Funcoes.mensagem(SolicitarVolume.this, "Volume inv\u00e1lido", 1);
                    SolicitarVolume.this.txtVolume.grabFocus();
                } else {
                    SolicitarVolume.this.setVisible(false);
                }
            }
        });
    }

    public double getVolume() {
        return Double.parseDouble(Funcoes.limpaDecimal(this.txtVolume.getText()));
    }

    public void setVolume(double volume) {
        this.txtVolume.setText(Funcoes.formataDecimal(this.txtVolume.getMaskDecimal(), volume));
    }
}

