/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SolicitarValidadeMatricula
extends AbstractDialogoOKCancelar {
    private TTextField textData = new TTextField(10, 4);
    private JLabel label = new JLabel("Data de validade da matr\u00edcula:");
    private JButton buttonBuscaData = new JButton();

    public static SolicitarValidadeMatricula novaInstancia(Component owner) {
        if (owner instanceof Frame) {
            return new SolicitarValidadeMatricula((Frame)owner);
        }
        if (owner instanceof Dialog) {
            return new SolicitarValidadeMatricula((Dialog)owner);
        }
        return null;
    }

    public SolicitarValidadeMatricula(Frame owner) {
        super(owner, "Validade");
        try {
            this.jbInit(owner);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    public SolicitarValidadeMatricula(Dialog owner) {
        super(owner, "Validade");
        try {
            this.jbInit(owner);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit(Component owner) throws Exception {
        this.setSize(220, 120);
        this.setLocationRelativeTo(owner);
        this.setModal(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.getBotaoCancelar().setVisible(false);
        final JPanel panel = this.getPanelCentral();
        panel.setLayout(null);
        panel.add(this.label);
        panel.add(this.textData);
        panel.add(this.buttonBuscaData);
        this.label.setBounds(5, 5, 205, 14);
        this.textData.setBounds(5, 20, 100, 20);
        this.buttonBuscaData.setBounds(106, 20, 20, 20);
        this.buttonBuscaData.setFocusable(false);
        Funcoes.montaEnter((JComponent)panel);
        Funcoes.imagemPesquisa(this.buttonBuscaData);
        this.buttonBuscaData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(SolicitarValidadeMatricula.this.textData, SolicitarValidadeMatricula.this.buttonBuscaData, panel, true);
            }
        });
        this.textData.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Funcoes.mostraData(SolicitarValidadeMatricula.this.textData, SolicitarValidadeMatricula.this.buttonBuscaData, panel, true);
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SolicitarValidadeMatricula.this.textData.selectAll();
                ScreenUtil.requisitarFoco(SolicitarValidadeMatricula.this.textData);
            }
        });
    }

    public Date getData() {
        return !Funcoes.textoVazio(this.textData) ? Funcoes.stringToDate(this.textData.getText()) : null;
    }

    public void setData(Date data) {
        if (data != null) {
            this.textData.setText(Funcoes.formataData(data));
        }
    }

    @Override
    protected boolean acaoOk() {
        if (!Funcoes.textoVazio(this.textData.getText()) && !Funcoes.verificaData(this.textData.getText())) {
            Funcoes.mensagem(this, "Data inv\u00e1lida.", 2);
            ScreenUtil.requisitarFoco(this.textData);
            return false;
        }
        if (!Funcoes.textoVazio(this.textData.getText()) && Funcoes.verificaData(this.textData.getText()) && Funcoes.stringToDate(this.textData.getText()).compareTo(Funcoes.stringToDate(Funcoes.formataData(new Date()))) < 0) {
            Funcoes.mensagem(this, "A data informada \u00e9 menor que a data atual, a validade expirou.", 2);
            ScreenUtil.requisitarFoco(this.textData);
            return false;
        }
        return true;
    }
}

