/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.comum.Acesso;
import jalis.laboratorio.recepcao.Requisicao;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SolicitarValidadeGuia
extends JDialog {
    private final JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private final JPanel panelTopo = new JPanel(null);
    private final JButton buttonSalvar = new JButton("OK");
    private final JButton buttonCancelar = new JButton("Cancelar");
    private final TTextField txtValidade = new TTextField(10, 4);
    private final TTextField txtData = new TTextField(10, 4);
    private final JLabel labelValidade = new JLabel("Validade:");
    private final JLabel labelData = new JLabel("Data:");
    private final JButton buttonBuscaValidade = new JButton();
    private final JButton buttonBuscaData = new JButton();
    private final JCheckBox checkDeveGuia = ComponenteFactory.novoJCheckBox("Sem pedido/guia", 'd');
    private int diasValidade = 0;
    private Date validadeGuia = null;
    private Date dataGuia = null;
    private Date dataRequisicao = null;
    private boolean isExigeValidade = false;
    public static final int DEVE_GUIA = 0;
    public static final int DATA_INVALIDA = 1;
    public static final int DATA_OK = 2;
    public static final int DATA_ANTERIOR = 3;
    public static final int GUIA_EXPIROU = 4;
    private boolean ok = false;

    public SolicitarValidadeGuia(Frame owner, boolean isExigeValidade, int diasValidade, Date dataRequisicao) {
        super(owner, "Dados da guia");
        this.diasValidade = diasValidade;
        this.dataRequisicao = dataRequisicao;
        this.isExigeValidade = isExigeValidade;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    public SolicitarValidadeGuia(Dialog owner, boolean isExigeValidade, int diasValidade, Date dataRequisicao) {
        super(owner, "Dados da guia");
        this.diasValidade = diasValidade;
        this.dataRequisicao = dataRequisicao;
        this.isExigeValidade = isExigeValidade;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.setSize(175, 130 + (this.isExigeValidade && this.diasValidade == 0 ? 55 : 20));
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelTopo, "Center");
        this.panelBotoes.add(this.buttonSalvar);
        this.panelBotoes.add(this.buttonCancelar);
        this.panelTopo.add(this.labelData);
        this.panelTopo.add(this.txtData);
        this.panelTopo.add(this.buttonBuscaData);
        this.panelTopo.add(this.labelValidade);
        this.panelTopo.add(this.txtValidade);
        this.panelTopo.add(this.buttonBuscaValidade);
        this.panelTopo.add(this.checkDeveGuia);
        this.labelData.setBounds(5, 5, 130, 14);
        this.txtData.setBounds(5, 20, 110, 21);
        this.buttonBuscaData.setBounds(116, 20, 20, 20);
        this.buttonBuscaData.setFocusable(false);
        if (this.isExigeValidade && this.diasValidade == 0) {
            this.labelValidade.setBounds(5, 40, 130, 14);
            this.txtValidade.setBounds(5, 55, 110, 21);
            this.buttonBuscaValidade.setBounds(116, 55, 20, 20);
            this.buttonBuscaValidade.setFocusable(false);
        }
        this.checkDeveGuia.setBounds(5, 45 + (this.isExigeValidade && this.diasValidade == 0 ? 40 : 0), 160, 18);
        this.checkDeveGuia.setVisible(Acesso.getAcesso(Requisicao.ACESSO_DEVE_GUIA));
        this.txtData.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Funcoes.verificaData(SolicitarValidadeGuia.this.txtData.getText()) && !Funcoes.verificaData(SolicitarValidadeGuia.this.txtValidade.getText()) && e.getOppositeComponent() != SolicitarValidadeGuia.this.buttonCancelar) {
                    SolicitarValidadeGuia.this.txtValidade.setText(SolicitarValidadeGuia.this.txtData.getText());
                }
            }
        });
        this.checkDeveGuia.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SolicitarValidadeGuia.this.txtValidade.setText("");
                    SolicitarValidadeGuia.this.txtValidade.setEnabled(false);
                    SolicitarValidadeGuia.this.txtData.setText("");
                    SolicitarValidadeGuia.this.txtData.setEnabled(false);
                    SolicitarValidadeGuia.this.buttonBuscaValidade.setEnabled(false);
                    SolicitarValidadeGuia.this.buttonBuscaData.setEnabled(false);
                } else {
                    SolicitarValidadeGuia.this.txtValidade.setEnabled(true);
                    SolicitarValidadeGuia.this.buttonBuscaValidade.setEnabled(true);
                    SolicitarValidadeGuia.this.txtData.setEnabled(true);
                    SolicitarValidadeGuia.this.buttonBuscaData.setEnabled(true);
                    ScreenUtil.requisitarFoco(SolicitarValidadeGuia.this.txtData);
                }
            }
        });
        Funcoes.montaEnter((JComponent)this.panelTopo);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        Funcoes.imagemPesquisa(this.buttonBuscaValidade);
        Funcoes.imagemPesquisa(this.buttonBuscaData);
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SolicitarValidadeGuia.this.ok = false;
                SolicitarValidadeGuia.this.setVisible(false);
            }
        });
        this.buttonSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Funcoes.textoVazio(SolicitarValidadeGuia.this.txtData) && !Funcoes.verificaData(SolicitarValidadeGuia.this.txtData.getText())) {
                    Funcoes.mensagem(SolicitarValidadeGuia.this, "Data incorreta.", 2);
                    ScreenUtil.requisitarFoco(SolicitarValidadeGuia.this.txtData);
                    return;
                }
                if (!Funcoes.textoVazio(SolicitarValidadeGuia.this.txtValidade) && !Funcoes.verificaData(SolicitarValidadeGuia.this.txtValidade.getText())) {
                    Funcoes.mensagem(SolicitarValidadeGuia.this, "Validade incorreta.", 2);
                    ScreenUtil.requisitarFoco(SolicitarValidadeGuia.this.txtValidade);
                    return;
                }
                SolicitarValidadeGuia.this.setVisible(false);
            }
        });
        this.buttonBuscaValidade.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(SolicitarValidadeGuia.this.txtValidade, SolicitarValidadeGuia.this.buttonBuscaValidade, SolicitarValidadeGuia.this.panelTopo, true);
            }
        });
        this.buttonBuscaData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(SolicitarValidadeGuia.this.txtData, SolicitarValidadeGuia.this.buttonBuscaData, SolicitarValidadeGuia.this.panelTopo, true);
            }
        });
        this.txtValidade.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Funcoes.mostraData(SolicitarValidadeGuia.this.txtValidade, SolicitarValidadeGuia.this.buttonBuscaValidade, SolicitarValidadeGuia.this.panelTopo, true);
                }
            }
        });
        this.txtData.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Funcoes.mostraData(SolicitarValidadeGuia.this.txtData, SolicitarValidadeGuia.this.buttonBuscaData, SolicitarValidadeGuia.this.panelTopo, true);
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SolicitarValidadeGuia.this.txtData.selectAll();
                ScreenUtil.requisitarFoco(SolicitarValidadeGuia.this.txtData);
            }
        });
    }

    public Date getValidade() {
        return this.validadeGuia;
    }

    public Date getData() {
        return this.dataGuia;
    }

    public void setData(Date data) {
        if (data != null) {
            this.txtData.setText(Funcoes.formataData(data));
            this.dataGuia = data;
        }
    }

    public void setValidade(Date validade) {
        if (validade != null) {
            this.txtValidade.setText(Funcoes.formataData(validade));
            this.validadeGuia = validade;
        }
    }

    public int getOK() {
        if (this.checkDeveGuia.isSelected()) {
            return 0;
        }
        if (Funcoes.textoVazio(this.txtData) || !Funcoes.verificaData(this.txtData.getText())) {
            return 1;
        }
        this.dataGuia = Funcoes.stringToDate(this.txtData.getText());
        if (!this.isExigeValidade || this.diasValidade > 0) {
            if (!this.isExigeValidade) {
                this.validadeGuia = null;
                return 2;
            }
            this.validadeGuia = Funcoes.somaDias(this.dataGuia, this.diasValidade);
            if (Funcoes.comparaData(this.dataGuia, this.validadeGuia) > 0) {
                return 3;
            }
            if (Funcoes.comparaData(this.dataRequisicao, this.validadeGuia) > 0) {
                return 4;
            }
            return 2;
        }
        Date date = this.validadeGuia = Funcoes.textoVazio(this.txtValidade) ? null : Funcoes.stringToDate(this.txtValidade.getText());
        if (!Funcoes.verificaData(this.txtData.getText())) {
            return 1;
        }
        if (this.isExigeValidade && (this.validadeGuia == null || !Funcoes.verificaData(this.txtValidade.getText()))) {
            return 1;
        }
        if (this.validadeGuia != null && Funcoes.comparaData(this.dataGuia, this.validadeGuia) > 0) {
            return 3;
        }
        if (Funcoes.comparaData(this.dataRequisicao, this.validadeGuia) > 0) {
            return 4;
        }
        return 2;
    }

    public void setDias(int dias) {
        this.diasValidade = dias;
    }

    public boolean getDeveGuia() {
        return this.checkDeveGuia.isSelected();
    }

    public void setDeveGuia(boolean b) {
        this.checkDeveGuia.setSelected(b);
    }

    private void setExigirValidadeGuia(boolean exigirValidadeGuia) {
        this.isExigeValidade = exigirValidadeGuia;
        this.buttonCancelar.setVisible(!exigirValidadeGuia);
    }
}

