/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SolicitarTempoDiurese
extends JDialog {
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelTopo = new JPanel(null);
    private JButton buttonSalvar = new JButton("Salvar");
    private TTextField txtTempo = new TTextField(5, 13);
    private JLabel label = new JLabel("Tempo de diurese:");

    public static SolicitarTempoDiurese novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new SolicitarTempoDiurese((Frame)pai);
        }
        if (pai instanceof Dialog) {
            return new SolicitarTempoDiurese((Dialog)pai);
        }
        return null;
    }

    public SolicitarTempoDiurese(Frame owner) {
        super(owner, "Tempo de diurese");
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    public SolicitarTempoDiurese(Dialog owner) {
        super(owner, "Tempo de diurese");
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.setSize(130, 115);
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelTopo, "Center");
        this.panelBotoes.add(this.buttonSalvar);
        this.panelTopo.add(this.label);
        this.panelTopo.add(this.txtTempo);
        this.label.setBounds(5, 5, 130, 14);
        this.txtTempo.setBounds(5, 20, 100, 20);
        this.buttonSalvar.setMnemonic('S');
        Funcoes.montaEnter((JComponent)this.panelTopo);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SolicitarTempoDiurese.this.txtTempo.selectAll();
                SolicitarTempoDiurese.this.txtTempo.grabFocus();
            }
        });
        this.buttonSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SolicitarTempoDiurese.this.testarHora(SolicitarTempoDiurese.this.txtTempo.getText())) {
                    Funcoes.mensagem(SolicitarTempoDiurese.this, "Tempo inv\u00e1lido para a diurese", 1);
                    SolicitarTempoDiurese.this.txtTempo.grabFocus();
                } else {
                    SolicitarTempoDiurese.this.setVisible(false);
                }
            }
        });
        this.txtTempo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String temp = SolicitarTempoDiurese.this.txtTempo.getText();
                if (Funcoes.isNumeric(temp)) {
                    if (temp.length() == 1) {
                        temp = "0" + temp + ":00";
                    } else if (temp.length() == 2) {
                        temp = temp + ":00";
                    }
                } else if (Funcoes.verificaHora(temp)) {
                    if (temp.length() == 3) {
                        temp = temp + "00";
                    } else if (temp.length() == 4) {
                        temp = temp + "0";
                    }
                }
                SolicitarTempoDiurese.this.txtTempo.setText(temp);
            }
        });
    }

    private boolean testarHora(String hora) {
        return hora.matches("([0-9]\\d|2[0-9]):[0-5]\\d");
    }

    public String getTempoDiurese() {
        return this.txtTempo.getText();
    }

    public void setTempoDiurese(String tempo) {
        this.txtTempo.setText(tempo);
    }
}

