/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SolicitarQtdeMaterial
extends JDialog {
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelTopo = new JPanel(new GridBagLayout());
    private JButton buttonSalvar = new JButton("Salvar");
    private TTextField textQuantidade = new TTextField(8, 2, 4);
    private JLabel label = new JLabel("Quantidade");

    public static SolicitarQtdeMaterial novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new SolicitarQtdeMaterial((Frame)pai);
        }
        if (pai instanceof Dialog) {
            return new SolicitarQtdeMaterial((Dialog)pai);
        }
        return null;
    }

    public SolicitarQtdeMaterial(Frame owner) {
        super(owner, "Quantidade");
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    public SolicitarQtdeMaterial(Dialog owner) {
        super(owner, "Quantidade");
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.setSize(150, 115);
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelTopo, "Center");
        this.panelBotoes.add(this.buttonSalvar);
        this.panelTopo.add(this.label);
        this.panelTopo.add(this.textQuantidade);
        this.buttonSalvar.setMnemonic('S');
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.panelTopo.add((Component)this.label, c);
        ++c.gridy;
        this.textQuantidade.setPreferredSize(new Dimension(100, 20));
        this.textQuantidade.setMinimumSize(new Dimension(100, 20));
        this.panelTopo.add((Component)this.textQuantidade, c);
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 1;
        Funcoes.montaEnter((JComponent)this.panelTopo);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SolicitarQtdeMaterial.this.textQuantidade.selectAll();
                SolicitarQtdeMaterial.this.textQuantidade.grabFocus();
            }
        });
        this.buttonSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Funcoes.isNumeric(SolicitarQtdeMaterial.this.textQuantidade.getText())) {
                    Funcoes.mensagem(SolicitarQtdeMaterial.this, "Quantidade inv\u00e1lida", 1);
                    SolicitarQtdeMaterial.this.textQuantidade.grabFocus();
                } else {
                    SolicitarQtdeMaterial.this.setVisible(false);
                }
            }
        });
    }

    public double getQuantidade() {
        return Double.parseDouble(Funcoes.limpaDecimal(this.textQuantidade.getText()));
    }

    public void setQuantidade(double quantidade) {
        this.textQuantidade.setText(Funcoes.formataDecimal(this.textQuantidade.getMaskDecimal(), quantidade));
    }

    public void setDescricaoMaterial(String descricao) {
        this.label.setText("Quantidade para " + descricao);
    }
}

