/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SolicitarPesoAltura
extends JDialog {
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelTopo = new JPanel(null);
    private JButton buttonSalvar = new JButton("Salvar");
    private TTextField txtPeso = new TTextField(5, 2);
    private TTextField txtAltura = new TTextField(3, 2);
    private JLabel labelPeso = new JLabel("Peso:");
    private JLabel labelPesoUm = new JLabel("Kg");
    private JLabel labelAltura = new JLabel("Altura:");
    private JLabel labelAlturaUm = new JLabel("m");
    private static boolean obrigaPeso = false;
    private static boolean obrigaAltura = false;

    public static SolicitarPesoAltura novaInstancia(Object pai, boolean peso, boolean altura) {
        obrigaPeso = peso;
        obrigaAltura = altura;
        if (pai instanceof Frame) {
            return new SolicitarPesoAltura((Frame)pai);
        }
        if (pai instanceof Dialog) {
            return new SolicitarPesoAltura((Dialog)pai);
        }
        return null;
    }

    public SolicitarPesoAltura(Frame owner) {
        super(owner, "Informa\u00e7\u00f5es do paciente");
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    public SolicitarPesoAltura(Dialog owner) {
        super(owner, "Informa\u00e7\u00f5es do paciente");
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.setSize(180, 130);
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.setResizable(false);
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelTopo, "Center");
        this.setDefaultCloseOperation(0);
        this.panelBotoes.add(this.buttonSalvar);
        this.panelTopo.add(this.labelPeso);
        this.panelTopo.add(this.txtPeso);
        this.panelTopo.add(this.labelPesoUm);
        this.panelTopo.add(this.labelAltura);
        this.panelTopo.add(this.txtAltura);
        this.panelTopo.add(this.labelAlturaUm);
        this.labelPeso.setBounds(10, 15, 60, 14);
        this.txtPeso.setBounds(45, 15, 100, 20);
        this.labelPesoUm.setBounds(145, 15, 15, 14);
        this.labelAltura.setBounds(5, 40, 60, 14);
        this.txtAltura.setBounds(45, 40, 100, 20);
        this.labelAlturaUm.setBounds(145, 40, 15, 14);
        this.buttonSalvar.setMnemonic('S');
        Funcoes.montaEnter((JComponent)this.panelTopo);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SolicitarPesoAltura.this.txtPeso.selectAll();
                SolicitarPesoAltura.this.txtPeso.grabFocus();
            }
        });
        this.buttonSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Funcoes.textoVazio(SolicitarPesoAltura.this.txtPeso) && obrigaPeso && Funcoes.textoVazio(SolicitarPesoAltura.this.txtAltura) && obrigaAltura) {
                    Funcoes.mensagem(SolicitarPesoAltura.this, "Peso e altura do paciente devem ser informados", 1);
                    SolicitarPesoAltura.this.txtPeso.grabFocus();
                } else if (Funcoes.textoVazio(SolicitarPesoAltura.this.txtPeso) && obrigaPeso) {
                    Funcoes.mensagem(SolicitarPesoAltura.this, "O peso do paciente deve ser informado", 1);
                    SolicitarPesoAltura.this.txtPeso.grabFocus();
                } else if (Funcoes.textoVazio(SolicitarPesoAltura.this.txtAltura) && obrigaAltura) {
                    Funcoes.mensagem(SolicitarPesoAltura.this, "A altura do paciente deve ser informada", 1);
                    SolicitarPesoAltura.this.txtAltura.grabFocus();
                } else {
                    SolicitarPesoAltura.this.setVisible(false);
                }
            }
        });
    }

    public String getPeso() {
        return this.txtPeso.getText();
    }

    public void setPeso(String peso) {
        this.txtPeso.setText(Funcoes.textoVazio(peso) ? "" : Funcoes.formataDecimal(this.txtPeso.getMaskDecimal(), Double.valueOf(peso)));
    }

    public String getAltura() {
        return this.txtAltura.getText();
    }

    public void setAltura(String altura) {
        this.txtAltura.setText(altura);
    }
}

