/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SolicitarNumeroGuiaPrincipal
extends AbstractDialogoOKCancelar {
    private TTextField textGuia = new TTextField(20, "[a-zA-Z0-9./-]+");
    private TTextField textGuiaPrincipal = new TTextField(20, "[a-zA-Z0-9./-]+");
    private JLabel labelGuia = new JLabel("Guia");
    private JLabel labelGuiaPrincipal = new JLabel("Guia principal (operadora)");
    private boolean ocultarGuiaPrincipal = false;
    private boolean exigirGuia = false;

    public static SolicitarNumeroGuiaPrincipal novaInstancia(Component owner, boolean ocultarGuiaPrincipal) {
        if (owner instanceof Frame) {
            return new SolicitarNumeroGuiaPrincipal((Frame)owner, ocultarGuiaPrincipal);
        }
        if (owner instanceof Dialog) {
            return new SolicitarNumeroGuiaPrincipal((Dialog)owner, ocultarGuiaPrincipal);
        }
        return null;
    }

    public SolicitarNumeroGuiaPrincipal(Frame owner, boolean ocultarGuiaPrincipal) {
        super(owner, "N\u00famero guia");
        this.ocultarGuiaPrincipal = ocultarGuiaPrincipal;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    public SolicitarNumeroGuiaPrincipal(Dialog owner, boolean ocultarGuiaPrincipal) {
        super(owner, "N\u00famero guia");
        this.ocultarGuiaPrincipal = ocultarGuiaPrincipal;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit() throws Exception {
        this.setSize(260, !this.ocultarGuiaPrincipal ? 170 : 130);
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        panel.add((Component)this.labelGuia, c);
        ++c.gridy;
        panel.add((Component)this.textGuia, c);
        if (!this.ocultarGuiaPrincipal) {
            ++c.gridy;
            panel.add((Component)this.labelGuiaPrincipal, c);
            ++c.gridy;
            panel.add((Component)this.textGuiaPrincipal, c);
        }
        Funcoes.montaEnter((JComponent)panel);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SolicitarNumeroGuiaPrincipal.this.textGuia.grabFocus();
            }
        });
    }

    public String getGuiaConvenio() {
        return this.textGuia.getText();
    }

    public String getGuiaPrincipal() {
        return this.textGuiaPrincipal.getText();
    }

    public void setGuiaConvenio(String guia) {
        this.textGuia.setText(guia);
    }

    public void setGuiaPrincipal(String guia) {
        this.textGuiaPrincipal.setText(guia);
    }

    @Override
    protected boolean acaoOk() {
        if (Funcoes.textoVazio(this.textGuia.getText()) && this.exigirGuia) {
            Funcoes.mensagem(this, "Guia n\u00e3o informada", 1);
            ScreenUtil.requisitarFoco(this.textGuia);
            return false;
        }
        return true;
    }

    public void setExigirGuia(boolean exigirGuia) {
        this.exigirGuia = exigirGuia;
    }
}

