/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.comum.Conexao;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class SolicitarMultiguia
extends AbstractDialogoOKCancelar {
    private TTextField textCodigoRequisicao = new TTextField(8, 1);
    private JButton buttonBuscaRequisicao = ComponenteFactory.novoJButton(this, true);
    private JLabel labelNomePaciente = new JLabel();
    private JLabel labelFantasiaConvenio = new JLabel();
    private JLabel labelNomeMedico = new JLabel();
    private String filial = Variaveis.filialPadrao;
    private int requisicaoParaLigar = -1;
    private String codigoPaciente = null;
    private String codigoRequisicaoEdicao = null;

    public static SolicitarMultiguia novaInstancia(Object owner, String codigoPaciente, String codigoRequisicaoEdicao) {
        if (owner instanceof Frame) {
            return new SolicitarMultiguia((Frame)owner, codigoPaciente, codigoRequisicaoEdicao);
        }
        if (owner instanceof Dialog) {
            return new SolicitarMultiguia((Dialog)owner, codigoPaciente, codigoRequisicaoEdicao);
        }
        return null;
    }

    public SolicitarMultiguia(Frame owner, String codigoPaciente, String codigoRequisicaoEdicao) {
        super(owner, "Multiguia");
        this.codigoPaciente = codigoPaciente;
        this.codigoRequisicaoEdicao = codigoRequisicaoEdicao;
        this.montaTela(owner);
    }

    public SolicitarMultiguia(Dialog owner, String codigoPaciente, String codigoRequisicaoEdicao) {
        super(owner, "Multiguia");
        this.codigoPaciente = codigoPaciente;
        this.codigoRequisicaoEdicao = codigoRequisicaoEdicao;
        this.montaTela(owner);
    }

    private void montaTela(Component comp) {
        this.setSize(new Dimension(450, 145));
        this.setLocationRelativeTo(comp);
        ScreenUtil.setBorda(new Component[]{this.labelNomePaciente, this.labelFantasiaConvenio, this.labelNomeMedico}, new TitledBorder(""));
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        panel.add((Component)new JLabel("C\u00f3digo:"), c);
        c.gridx = 1;
        this.textCodigoRequisicao.setPreferredSize(new Dimension(80, 20));
        panel.add((Component)this.textCodigoRequisicao, c);
        c.gridx = 2;
        this.buttonBuscaRequisicao.setPreferredSize(new Dimension(20, 20));
        panel.add((Component)this.buttonBuscaRequisicao, c);
        c.gridx = 3;
        c.fill = 2;
        c.weightx = 1.0;
        this.labelNomePaciente.setPreferredSize(new Dimension(100, 20));
        this.labelNomePaciente.setMinimumSize(new Dimension(100, 20));
        panel.add((Component)this.labelNomePaciente, c);
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 1;
        panel.add((Component)new JLabel("Conv\u00eanio:"), c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.gridwidth = 3;
        this.labelFantasiaConvenio.setPreferredSize(new Dimension(100, 20));
        this.labelFantasiaConvenio.setMinimumSize(new Dimension(100, 20));
        panel.add((Component)this.labelFantasiaConvenio, c);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 2;
        panel.add((Component)new JLabel("M\u00e9dico:"), c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.gridwidth = 3;
        this.labelNomeMedico.setPreferredSize(new Dimension(100, 20));
        this.labelNomeMedico.setMinimumSize(new Dimension(100, 20));
        panel.add((Component)this.labelNomeMedico, c);
        ScreenUtil.requisitarFoco(this.textCodigoRequisicao);
        this.textCodigoRequisicao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    SolicitarMultiguia.this.pesquisaRequisicao();
                }
            }
        });
        this.textCodigoRequisicao.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(SolicitarMultiguia.this.textCodigoRequisicao.getText())) {
                    Statement st = Conexao.getStatement();
                    try {
                        StringBuilder buf = new StringBuilder();
                        buf.append("select a.pac_codigo, a.pac_nome, b.con_fantasia, c.med_nome, req.req_codigo from requisicao req ");
                        buf.append("left join paciente a on req.fil_codigo = a.fil_codigo and req.pac_codigo = a.pac_codigo ");
                        buf.append("left join convenios b on req.fil_codigo = b.fil_codigo and req.con_codigo = b.con_codigo ");
                        buf.append("left join medico c on req.fil_codigo = c.fil_codigo and req.med_conselho = c.med_conselho and req.med_crm = c.med_crm and req.med_uf = c.med_uf ");
                        buf.append("where req.fil_codigo = ").append(SolicitarMultiguia.this.filial);
                        buf.append(" and req.req_codigo = ").append(SolicitarMultiguia.this.textCodigoRequisicao.getText());
                        ResultSet rs = Conexao.executeQuery(st, buf);
                        if (rs.next()) {
                            if (SolicitarMultiguia.this.verificaRequisicaoMultiguia(SolicitarMultiguia.this.codigoRequisicaoEdicao)) {
                                Funcoes.mensagem(SolicitarMultiguia.this, "A requisi\u00e7\u00e3o informada j\u00e1 faz parte da multiguia.", 2);
                                SolicitarMultiguia.this.textCodigoRequisicao.clear();
                                ScreenUtil.requisitarFoco(SolicitarMultiguia.this.textCodigoRequisicao);
                                return;
                            }
                            if (SolicitarMultiguia.this.codigoRequisicaoEdicao != null && SolicitarMultiguia.this.codigoRequisicaoEdicao.equalsIgnoreCase(rs.getString("req_codigo"))) {
                                Funcoes.mensagem(SolicitarMultiguia.this, "A requisi\u00e7\u00e3o n\u00e3o pode pertencer a uma multiguia pois a requisi\u00e7\u00e3o informada \u00e9 a mesma requisi\u00e7\u00e3o em edi\u00e7\u00e3o.", 2);
                                SolicitarMultiguia.this.textCodigoRequisicao.clear();
                                ScreenUtil.requisitarFoco(SolicitarMultiguia.this.textCodigoRequisicao);
                                return;
                            }
                            if (SolicitarMultiguia.this.codigoPaciente != null && !SolicitarMultiguia.this.codigoPaciente.equalsIgnoreCase(rs.getString("pac_codigo"))) {
                                Funcoes.mensagem(SolicitarMultiguia.this, "O paciente da requisi\u00e7\u00e3o selecionada \u00e9 diferente do paciente da requisi\u00e7\u00e3o em edi\u00e7\u00e3o.\nN\u00e3o \u00e9 poss\u00edvel associ\u00e1-las.", 2);
                                SolicitarMultiguia.this.textCodigoRequisicao.clear();
                                ScreenUtil.requisitarFoco(SolicitarMultiguia.this.textCodigoRequisicao);
                                return;
                            }
                            SolicitarMultiguia.this.labelNomePaciente.setText(rs.getString("pac_nome"));
                            SolicitarMultiguia.this.labelFantasiaConvenio.setText(rs.getString("con_fantasia"));
                            SolicitarMultiguia.this.labelNomeMedico.setText(rs.getString("med_nome"));
                        } else {
                            SolicitarMultiguia.this.labelNomePaciente.setText("N\u00e3o cadastrado");
                            Funcoes.mensagem(SolicitarMultiguia.this, "Requisi\u00e7\u00e3o n\u00e3o localizada", 1);
                        }
                    }
                    catch (Exception e1) {
                        ErrorLogger.mostraMensagem(SolicitarMultiguia.this, e1.getMessage(), e1.getStackTrace(), "SolicitarMultiguia: 140");
                    }
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonBuscaRequisicao) {
            this.pesquisaRequisicao();
        } else {
            super.actionPerformed(e);
        }
    }

    private void pesquisaRequisicao() {
        boolean retorno;
        Hashtable resultado = Pesquisas.requisicao(this, this.filial, false, false, this.codigoPaciente, this.codigoRequisicaoEdicao, false, false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.textCodigoRequisicao.setText(resultado.get("req_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textCodigoRequisicao);
    }

    public void setFilial(String filial) {
        this.filial = filial;
    }

    @Override
    public boolean acaoOk() {
        if (Funcoes.textoVazio(this.textCodigoRequisicao.getText()) || !Funcoes.isNumeric(this.textCodigoRequisicao.getText()) || this.labelNomePaciente.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Requisi\u00e7\u00e3o n\u00e3o informada", 1);
            return false;
        }
        return true;
    }

    private boolean validarMultiguia(String requisicao) {
        if (Funcoes.isNumeric(requisicao)) {
            try {
                Integer[] reqs = RecepcaoUtil.verificaMultiGuias(this.filial, requisicao, true);
                if (reqs != null && reqs.length > 0) {
                    return false;
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "SolicitarMultiguia (196)");
            }
        }
        return true;
    }

    private boolean verificaRequisicaoMultiguia(String requisicao) throws SQLException {
        Integer[] reqs = RecepcaoUtil.verificaMultiGuias(this.filial, requisicao, true);
        if (reqs != null && reqs.length > 0) {
            if (reqs.length == 1 && reqs[0].equals(Integer.valueOf(this.textCodigoRequisicao.getText()))) {
                return false;
            }
            for (Integer req : reqs) {
                if (!req.equals(Integer.valueOf(this.textCodigoRequisicao.getText()))) continue;
                return true;
            }
        }
        return false;
    }

    public String getCodigoRequisicao() {
        if (!Funcoes.textoVazio(this.textCodigoRequisicao.getText()) && !this.labelNomePaciente.getText().equals("N\u00e3o cadastrado")) {
            String requisicaoParaRetorno = this.textCodigoRequisicao.getText();
            try {
                Integer[] reqs = RecepcaoUtil.verificaMultiGuias(this.filial, this.textCodigoRequisicao.getText(), true);
                if (reqs != null && reqs.length > 0) {
                    requisicaoParaRetorno = String.valueOf(reqs[0]);
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "SolicitarMultiguia (222)");
            }
            return requisicaoParaRetorno;
        }
        return null;
    }

    public void setRequisicaoParaLigar(String requisicao) {
        if (Funcoes.isNumeric(requisicao)) {
            this.requisicaoParaLigar = Integer.parseInt(requisicao);
        }
    }
}

