/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.model.bean.cadastro.exame.MotivoRecoletaBean;
import jalis.service.cadastro.exame.MotivoRecoletaService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextAreaDocument;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SolicitarMotivoRecoleta
extends AbstractDialogoOKCancelar {
    private JTextArea textMotivo = new JTextArea(new TTextAreaDocument(500));
    private JScrollPane scrollMotivoRecoleta = new JScrollPane(this.textMotivo);
    private JCheckBox checkUsarparaTodos = new JCheckBox("Usar mesmo motivo para todas");
    private JComboBox<MotivoRecoletaBean> comboMotivos = new JComboBox();
    private transient MotivoRecoletaBean motivo = null;
    boolean variasRecoletas = false;
    private boolean marcarRecoleta = false;

    public static SolicitarMotivoRecoleta novaInstancia(Object owner, String descricaoExame, boolean variasRecoletas, String filial) {
        return owner instanceof Dialog ? new SolicitarMotivoRecoleta((Dialog)owner, "Motivo de recoleta - " + descricaoExame, variasRecoletas, filial) : new SolicitarMotivoRecoleta((Frame)owner, "Motivo de recoleta - " + descricaoExame, variasRecoletas, filial);
    }

    public static SolicitarMotivoRecoleta novaInstancia(Object owner, boolean variasRecoletas, String filial) {
        return owner instanceof Dialog ? new SolicitarMotivoRecoleta((Dialog)owner, "Motivo de recoleta", variasRecoletas, filial) : new SolicitarMotivoRecoleta((Frame)owner, "Motivo de recoleta", variasRecoletas, filial);
    }

    public SolicitarMotivoRecoleta(Dialog owner, String titulo, boolean variasRecoletas, String filial) {
        super(owner, titulo);
        this.setLocationRelativeTo(owner);
        this.variasRecoletas = variasRecoletas;
        this.iniciar(filial);
    }

    public SolicitarMotivoRecoleta(Frame owner, String titulo, boolean variasRecoletas, String filial) {
        super(owner, titulo);
        this.setLocationRelativeTo(owner);
        this.variasRecoletas = variasRecoletas;
        this.iniciar(filial);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOK || o == this.buttonCancelar) {
            boolean bl = this.ok = o == this.buttonOK;
            if (!this.ok) {
                this.acaoCancelar();
                this.dispose();
            }
            if (this.ok && this.acaoOk()) {
                this.dispose();
            }
        }
    }

    private void iniciar(String filial) {
        this.getBotaoCancelar().setVisible(true);
        this.setUsuarioPodeCancelar(false);
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        panel.add((Component)new JLabel("Motivo:"), c);
        c.weightx = 1.0;
        c.fill = 2;
        c.gridy = 1;
        this.comboMotivos.setPreferredSize(new Dimension(20, 22));
        panel.add(this.comboMotivos, c);
        c.gridx = 0;
        c.gridy = 2;
        panel.add((Component)ComponenteFactory.novoJLabel("Justificativa", 'J', null, this.scrollMotivoRecoleta), c);
        c.gridy = 3;
        c.fill = 1;
        c.weighty = 1.0;
        panel.add((Component)this.scrollMotivoRecoleta, c);
        if (this.variasRecoletas) {
            c.fill = 0;
            c.gridy = 5;
            c.weighty = 0.0;
            c.weightx = 0.0;
            panel.add((Component)this.checkUsarparaTodos, c);
        }
        try {
            MotivoRecoletaService service = new MotivoRecoletaService();
            Set motivos = service.load(" where fil_codigo = " + filial);
            ArrayList listaMotivoRecoleta = new ArrayList(motivos);
            Collections.sort(listaMotivoRecoleta, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 instanceof MotivoRecoletaBean && o2 instanceof MotivoRecoletaBean) {
                        return o1.toString().compareTo(o2.toString());
                    }
                    return 0;
                }
            });
            for (MotivoRecoletaBean motivoBean : listaMotivoRecoleta) {
                this.comboMotivos.addItem(motivoBean);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "SolicitarMotivoRecoleta");
        }
        this.setSize(new Dimension(350, 200 + (this.variasRecoletas ? 20 : 0)));
        ScreenUtil.centralizar(this);
        this.setModal(true);
        this.comboMotivos.setEnabled(this.comboMotivos.getItemCount() > 0);
        if (this.comboMotivos.isEnabled()) {
            ScreenUtil.requisitarFoco(this.comboMotivos);
        } else {
            ScreenUtil.requisitarFoco(this.textMotivo);
        }
    }

    @Override
    public boolean acaoOk() {
        if (this.comboMotivos.getSelectedItem() != null) {
            this.motivo = (MotivoRecoletaBean)this.comboMotivos.getSelectedItem();
            if (Boolean.TRUE.equals(this.motivo.getExigirJustificativa()) && Funcoes.textoVazio(this.textMotivo.getText())) {
                Funcoes.mensagem(this, "O motivo de recoleta exige uma justificativa.", 1);
                ScreenUtil.requisitarFoco(this.textMotivo);
                return false;
            }
        }
        return true;
    }

    public int getCodigoMotivo() {
        if (this.comboMotivos.getSelectedItem() != null) {
            return ((MotivoRecoletaBean)this.comboMotivos.getSelectedItem()).getCodigo();
        }
        return -1;
    }

    public String getMotivoRecoleta() {
        if (this.comboMotivos.getSelectedItem() != null) {
            return ((MotivoRecoletaBean)this.comboMotivos.getSelectedItem()).getDescricao();
        }
        return null;
    }

    public boolean getExigirJustificativa() {
        return this.motivo.getExigirJustificativa();
    }

    public String getDescricaoMotivo() {
        return this.textMotivo.getText();
    }

    public void setDescricaoMotivo(String motivo) {
        this.textMotivo.setText(motivo);
    }

    public boolean isUsarMesmoMotivo() {
        return this.checkUsarparaTodos.isSelected();
    }

    public boolean isMarcarRecoleta() {
        return this.marcarRecoleta;
    }

    public void setMarcarRecoleta(boolean marcarRecoleta) {
        this.marcarRecoleta = marcarRecoleta;
    }
}

