/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.model.vo.recepcao.MotivoPrepIncorretoVO;
import jalis.service.recepcao.MotivoPrepIncorretoService;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextAreaDocument;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class SolicitarMotivoPrepIncorreto
extends AbstractDialogoOKCancelar
implements ActionListener {
    private final JButton btnSelecionaTodos = ComponenteFactory.novoJButton("Selecionar todos", 'S', this);
    private final JButton btnDesmarcaTodos = ComponenteFactory.novoJButton("Desmarcar Todos", 'D', this);
    private final JPanel panelCentral = new JPanel(new GridBagLayout());
    private final int COLUNA_CODIGO_EXAME = 0;
    private final int COLUNA_MATERIAL = 1;
    private final int COLUNA_MOTIVO = 2;
    private final int COLUNA_USUARIO = 3;
    private final int COLUNA_CHECK_MOTIVO = 4;
    private final int COLUNA_EXAME_SELECIONADO = 5;
    private CheckBoxRender render = new CheckBoxRender();
    private String[] codigoExame = new String[0];
    private String codigoFilial;
    private String codigoRequisicao;
    private int codigoMaterial;
    private boolean permitirMarcarTodos = false;
    private boolean validaPanelMotivo = false;
    private boolean usuarioPodeCancelar = true;
    private boolean cancelado = false;
    private static String titulo = "Exames com registro de Preparo incorreto";
    private static String descricao = "Selecione os exames com o mesmo material que ter\u00e3o o registro de preparo incorreto removido:";
    private static int[] tamanhoColunasModeloMotivos = new int[]{80, 80, 0, 90, 20};
    private int[] linhas = new int[0];
    private ModeloGridTable modeloMotivos = new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Motivo preparo incorreto", "Usu\u00e1rio", "#"}){

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 4) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int row, int columnIndex) {
            return columnIndex == 4;
        }
    };
    JTable tableMotivos = ComponenteFactory.novoJTable((TableModel)this.modeloMotivos, tamanhoColunasModeloMotivos);
    JScrollPane scrollMotivos = new JScrollPane(this.tableMotivos);
    JLabel labelDescricao = new JLabel(descricao);
    JTextArea textMotivo = new JTextArea(new TTextAreaDocument(100));
    JCheckBox checkUsarparaTodos = new JCheckBox("Aplicar motivo para exames com mesmo material");

    public static SolicitarMotivoPrepIncorreto novaInstancia(Object owner, boolean variasRecoletas) {
        if (owner instanceof Dialog) {
            return new SolicitarMotivoPrepIncorreto((Dialog)owner, "Motivo de preparo incorreto", variasRecoletas);
        }
        if (owner instanceof Frame) {
            return new SolicitarMotivoPrepIncorreto((Frame)owner, "Motivo de preparo incorreto", variasRecoletas);
        }
        return null;
    }

    public static SolicitarMotivoPrepIncorreto novaInstancia(Object owner) {
        if (owner instanceof Dialog) {
            return new SolicitarMotivoPrepIncorreto((Dialog)owner, titulo);
        }
        if (owner instanceof Frame) {
            return new SolicitarMotivoPrepIncorreto((Frame)owner, titulo);
        }
        return null;
    }

    public SolicitarMotivoPrepIncorreto(Dialog owner, String titulo, boolean permitirMarcarTodos) {
        super(owner, titulo);
        this.setLocationRelativeTo(owner);
        this.permitirMarcarTodos = permitirMarcarTodos;
        this.iniciar();
    }

    public SolicitarMotivoPrepIncorreto(Frame owner, String titulo, boolean permitirMarcarTodos) {
        super(owner, titulo);
        this.setLocationRelativeTo(owner);
        this.permitirMarcarTodos = permitirMarcarTodos;
        this.iniciar();
    }

    public SolicitarMotivoPrepIncorreto(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public SolicitarMotivoPrepIncorreto(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    private void montaTela() {
        this.getPanelCentral().setLayout(new BorderLayout());
        this.setSize(new Dimension(700, 250));
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone16x16.png").getImage());
        this.validaPanelMotivo = true;
        this.tableMotivos.setDefaultRenderer(Boolean.class, this.render);
        this.modeloMotivos.setColumnSize(tamanhoColunasModeloMotivos, this.tableMotivos);
        this.modeloMotivos.addTableModelListener(e -> this.validarBotaoOK());
        this.tableMotivos.repaint();
        this.panelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 5;
        c.fill = 1;
        c.anchor = 17;
        ++c.gridy;
        this.scrollMotivos.setPreferredSize(new Dimension(150, 20));
        this.scrollMotivos.setMinimumSize(new Dimension(150, 20));
        this.panelCentral.add((Component)this.scrollMotivos, c);
        this.getPanelBotoesEsquerda().add(this.btnSelecionaTodos);
        this.getPanelBotoesEsquerda().add(this.btnDesmarcaTodos);
        this.getPanelCentral().add((Component)this.panelCentral, "Center");
        this.getPanelCentral().add((Component)this.labelDescricao, "North");
        ScreenUtil.centralizar(this);
        this.tableMotivos.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 0) {
                    Boolean isMarcado = (Boolean)SolicitarMotivoPrepIncorreto.this.modeloMotivos.getValueAt(SolicitarMotivoPrepIncorreto.this.tableMotivos.getSelectedRow(), 4);
                    if (isMarcado.booleanValue()) {
                        SolicitarMotivoPrepIncorreto.this.modeloMotivos.setValueAt(false, SolicitarMotivoPrepIncorreto.this.tableMotivos.getSelectedRow(), 4);
                    } else {
                        SolicitarMotivoPrepIncorreto.this.modeloMotivos.setValueAt(true, SolicitarMotivoPrepIncorreto.this.tableMotivos.getSelectedRow(), 4);
                    }
                    SolicitarMotivoPrepIncorreto.this.modeloMotivos.fireTableCellUpdated(SolicitarMotivoPrepIncorreto.this.tableMotivos.getSelectedRow(), 4);
                }
                SolicitarMotivoPrepIncorreto.this.validarBotaoOK();
            }
        });
    }

    private void validarBotaoOK() {
        boolean botaoOkAtivo = false;
        for (int i = 0; i < this.modeloMotivos.getRowCount(); ++i) {
            if (!((Boolean)this.modeloMotivos.getValueAt(i, 4)).booleanValue()) continue;
            botaoOkAtivo = true;
        }
        this.buttonOK.setEnabled(botaoOkAtivo);
    }

    private void iniciar() {
        this.getBotaoCancelar().setVisible(true);
        this.setDefaultCloseOperation(0);
        this.setUsuarioPodeCancelar(true);
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        panel.add((Component)ComponenteFactory.novoJLabel("Motivo", 'M', null, this.textMotivo), c);
        c.fill = 1;
        c.gridy = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        panel.add((Component)new JScrollPane(this.textMotivo), c);
        if (this.permitirMarcarTodos) {
            c.fill = 0;
            c.gridy = 2;
            c.weighty = 0.0;
            c.weightx = 0.0;
            panel.add((Component)this.checkUsarparaTodos, c);
        }
        this.setSize(new Dimension(350, 200 + (this.permitirMarcarTodos ? 20 : 0)));
        ScreenUtil.centralizar(this);
        this.setModal(true);
        ScreenUtil.requisitarFoco(this.textMotivo);
    }

    private void carregaRegistros(String codExameSelecionado) {
        if (!Funcoes.textoVazio(this.codigoFilial) && !Funcoes.textoVazio(this.codigoRequisicao)) {
            this.modeloMotivos.clear();
            MotivoPrepIncorretoVO[] motivoPrepIncorretoVO = new MotivoPrepIncorretoVO[]{};
            try {
                motivoPrepIncorretoVO = new MotivoPrepIncorretoService().buscarMotivoPrepIncorreto(this.codigoFilial, this.codigoRequisicao, this.codigoMaterial, codExameSelecionado);
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, "Erro ao carregar os dados dos motivos de preparo incorreto.\n" + e.getMessage(), e.getStackTrace());
            }
            this.addItemMotivoPrepIncorreto(motivoPrepIncorretoVO);
        }
    }

    public void addItemMotivoPrepIncorreto(MotivoPrepIncorretoVO[] motivoPrepIncorretoVO) {
        for (MotivoPrepIncorretoVO motivoPrepVO : motivoPrepIncorretoVO) {
            this.modeloMotivos.addLine(new Object[]{motivoPrepVO.getCodigoExame(), motivoPrepVO.getMaterialExame(), motivoPrepVO.getMotivo(), motivoPrepVO.getCodigoUsuario(), motivoPrepVO.isExameSelecionado()});
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.btnSelecionaTodos) {
            this.marcarDesmarcarTodos(true);
        } else if (o == this.btnDesmarcaTodos) {
            this.marcarDesmarcarTodos(false);
        } else if (o == this.buttonOK || o == this.buttonCancelar) {
            boolean bl = this.ok = o == this.buttonOK;
            if (!this.ok && this.usuarioPodeCancelar) {
                this.cancelado = true;
                this.acaoCancelar();
                this.dispose();
            } else if (this.ok && this.acaoOk()) {
                this.dispose();
            }
        }
    }

    @Override
    public boolean acaoOk() {
        if (!this.validaPanelMotivo && this.textMotivo.isEditable()) {
            if (Funcoes.textoVazio(this.textMotivo.getText())) {
                this.ok = false;
                Funcoes.mensagem(this, "O motivo deve ser informado", 2);
                return this.ok;
            }
            return !Funcoes.textoVazio(this.textMotivo.getText());
        }
        if (this.validaPanelMotivo) {
            for (int i = 0; i < this.tableMotivos.getRowCount(); ++i) {
                if (!Boolean.TRUE.equals(Boolean.valueOf(this.modeloMotivos.getValueAt(i, 4).toString()))) continue;
                this.linhas = ArraysUtil.concatenar(this.linhas, new int[]{i});
            }
            this.textMotivo.setEditable(false);
            this.validaExamesPrepIncorreto(this.linhas);
            this.validaPanelMotivo = false;
        }
        return true;
    }

    public void validaExamesPrepIncorreto(int[] linhas) {
        ArrayList<String> i = new ArrayList<String>(Arrays.asList(this.codigoExame));
        for (int linha : linhas) {
            String exame = String.valueOf(this.modeloMotivos.getValueAt(linha, 0));
            i.add(exame);
        }
        this.codigoExame = i.toArray(this.codigoExame);
        this.setCodExame(this.codigoExame);
    }

    public void marcarDesmarcarTodos(boolean valor) {
        TableModel model = this.tableMotivos.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            model.setValueAt(new Boolean(valor), i, 4);
        }
        this.modeloMotivos.fireTableDataChanged();
        this.validarBotaoOK();
    }

    public String getDescricaoMotivo() {
        return this.textMotivo.getText();
    }

    public void setDescricaoMotivo(String motivo) {
        this.textMotivo.setText(motivo);
    }

    public boolean isReplicarParaTodos() {
        return this.checkUsarparaTodos.isSelected();
    }

    public void setBloquearEdicao(boolean b) {
        if (b) {
            this.textMotivo.setEditable(false);
            this.checkUsarparaTodos.setVisible(false);
        }
    }

    public String getCodigoFilial() {
        return this.codigoFilial;
    }

    public void setCodigoFilial(String codigoFilial) {
        this.codigoFilial = codigoFilial;
    }

    public String getCodigoRequisicao() {
        return this.codigoRequisicao;
    }

    public void setCodigoRequisicao(String codigoRequisicao) {
        this.codigoRequisicao = codigoRequisicao;
    }

    public int getCodigoMaterial() {
        return this.codigoMaterial;
    }

    public void setCodigoMaterial(int codigoMaterial, boolean carregaExames, String codExameSelecionado) {
        this.codigoMaterial = codigoMaterial;
        if (carregaExames) {
            this.carregaRegistros(codExameSelecionado);
        }
    }

    public String[] getCodExame() {
        return this.codigoExame;
    }

    public void setCodExame(String[] string) {
        this.codigoExame = string;
    }

    public class CheckBoxRender
    extends JCheckBox
    implements TableCellRenderer {
        CheckBoxRender() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color cor = UIManager.getColor("Table.selectionBackground");
            this.setSelected(value != null && (Boolean)value != false);
            if (column == 4) {
                this.setEnabled(true);
                this.setBackground(table.getBackground());
            } else {
                if (isSelected) {
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setBackground(table.getBackground());
                    this.setEnabled(true);
                }
                this.setSelected(value != null && (Boolean)value != false);
            }
            return this;
        }
    }
}

