/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.model.bean.cadastro.financeiro.MotivoCancelamentoBean;
import jalis.service.cadastro.financeiro.MotivoCancelamentoService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextAreaDocument;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SolicitarMotivoCancelamento
extends AbstractDialogoOKCancelar {
    private JComboBox comboMotivos = new JComboBox();
    private JTextArea textMotivo = new JTextArea(new TTextAreaDocument(100));
    private boolean ocultarCancelar = false;

    public static SolicitarMotivoCancelamento novaInstancia(Object owner, boolean ocultarCancelar) {
        if (owner instanceof Dialog) {
            return new SolicitarMotivoCancelamento((Dialog)owner, "Motivo de cancelamento", ocultarCancelar);
        }
        if (owner instanceof Frame) {
            return new SolicitarMotivoCancelamento((Frame)owner, "Motivo de cancelamento", ocultarCancelar);
        }
        return null;
    }

    public SolicitarMotivoCancelamento(Dialog owner, String titulo, boolean ocultarCancelar) {
        super(owner, titulo);
        this.iniciar();
        this.setLocationRelativeTo(owner);
        this.ocultarCancelar = ocultarCancelar;
    }

    public SolicitarMotivoCancelamento(Frame owner, String titulo, boolean ocultarCancelar) {
        super(owner, titulo);
        this.iniciar();
        this.setLocationRelativeTo(owner);
        this.ocultarCancelar = ocultarCancelar;
    }

    private void iniciar() {
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        if (this.ocultarCancelar) {
            this.getBotaoCancelar().setVisible(false);
            this.setUsuarioPodeCancelar(false);
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    Funcoes.mensagem(SolicitarMotivoCancelamento.this, "O motivo deve ser informado", 2);
                }
            });
        }
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        panel.add((Component)ComponenteFactory.novoJLabel("Motivo", 'M', null, this.comboMotivos), c);
        c.gridy = 2;
        panel.add((Component)ComponenteFactory.novoJLabel("Descri\u00e7\u00e3o", 'D', null, this.textMotivo), c);
        c.weightx = 1.0;
        c.fill = 2;
        c.gridy = 1;
        this.comboMotivos.setPreferredSize(new Dimension(20, 22));
        panel.add((Component)this.comboMotivos, c);
        c.gridy = 3;
        c.fill = 1;
        c.weighty = 1.0;
        panel.add((Component)new JScrollPane(this.textMotivo), c);
        this.setSize(new Dimension(300, 200));
        try {
            MotivoCancelamentoService service = new MotivoCancelamentoService();
            Set motivos = service.load(" where fil_codigo = " + Variaveis.filialPadrao);
            for (MotivoCancelamentoBean motivo : motivos) {
                this.comboMotivos.addItem(motivo);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "SolicitarMotivoCancelamento (87)");
        }
        this.comboMotivos.setEnabled(this.temMotivosCancelamento());
        if (this.comboMotivos.isEnabled()) {
            ScreenUtil.requisitarFoco(this.comboMotivos);
        } else {
            ScreenUtil.requisitarFoco(this.textMotivo);
        }
    }

    public boolean temMotivosCancelamento() {
        return this.comboMotivos.getItemCount() > 0;
    }

    @Override
    public boolean acaoOk() {
        MotivoCancelamentoBean motivo = null;
        if (this.comboMotivos.getSelectedItem() != null) {
            motivo = (MotivoCancelamentoBean)this.comboMotivos.getSelectedItem();
            if (motivo.getExigeJustificativa().booleanValue() && Funcoes.textoVazio(this.textMotivo.getText())) {
                Funcoes.mensagem(this, "O motivo informado exige uma descri\u00e7\u00e3o do cancelamento.", 1);
                ScreenUtil.requisitarFoco(this.textMotivo);
                this.ok = false;
                return false;
            }
            return true;
        }
        this.ok = false;
        return false;
    }

    public int getCodigoMotivo() {
        if (this.comboMotivos.getSelectedItem() != null) {
            return ((MotivoCancelamentoBean)this.comboMotivos.getSelectedItem()).getCodigo();
        }
        return -1;
    }

    public MotivoCancelamentoBean getMotivoCancelamento() {
        if (this.comboMotivos.getSelectedItem() != null) {
            return (MotivoCancelamentoBean)this.comboMotivos.getSelectedItem();
        }
        return null;
    }

    public String getDescricaoMotivo() {
        return this.textMotivo.getText();
    }

    public void setDescricaoMotivo(String motivo) {
        this.textMotivo.setText(motivo);
    }
}

