/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SolicitarJejum
extends JDialog {
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelTopo = new JPanel(null);
    private JButton buttonSalvar = new JButton("Salvar");
    private TTextField txtTempo = new TTextField(5, 13);
    private JLabel label = new JLabel("Tempo de jejum:");
    private JCheckBox checkNaoInformado = new JCheckBox("N\u00e3o informado");

    public static SolicitarJejum novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new SolicitarJejum((Frame)pai);
        }
        if (pai instanceof Dialog) {
            return new SolicitarJejum((Dialog)pai);
        }
        return null;
    }

    public SolicitarJejum(Frame owner) {
        super(owner, "Jejum");
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    public SolicitarJejum(Dialog owner) {
        super(owner, "Jejum");
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.setSize(140, 135);
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelTopo, "Center");
        this.panelBotoes.add(this.buttonSalvar);
        this.panelTopo.add(this.label);
        this.panelTopo.add(this.txtTempo);
        this.panelTopo.add(this.checkNaoInformado);
        this.label.setBounds(5, 5, 130, 14);
        this.txtTempo.setBounds(5, 20, 100, 20);
        this.checkNaoInformado.setBounds(5, 40, 120, 20);
        this.buttonSalvar.setMnemonic('S');
        Funcoes.montaEnter((JComponent)this.panelTopo);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SolicitarJejum.this.txtTempo.selectAll();
                SolicitarJejum.this.txtTempo.grabFocus();
            }
        });
        this.buttonSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Funcoes.verificaIntervaloHora(SolicitarJejum.this.txtTempo.getText()) && !SolicitarJejum.this.checkNaoInformado.isSelected()) {
                    Funcoes.mensagem(SolicitarJejum.this, "Tempo inv\u00e1lido para o jejum", 1);
                    ScreenUtil.requisitarFoco(SolicitarJejum.this.txtTempo);
                } else {
                    SolicitarJejum.this.setVisible(false);
                }
            }
        });
        this.txtTempo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String temp = SolicitarJejum.this.txtTempo.getText();
                if (Funcoes.isNumeric(temp)) {
                    if (temp.length() == 1) {
                        temp = "0" + temp + ":00";
                    } else if (temp.length() == 2) {
                        temp = temp + ":00";
                    }
                } else if (Funcoes.verificaHora(temp)) {
                    if (temp.length() == 3) {
                        temp = temp + "00";
                    } else if (temp.length() == 4) {
                        temp = temp + "0";
                    }
                }
                SolicitarJejum.this.txtTempo.setText(temp);
            }
        });
    }

    public String getTempoJejum() {
        return this.txtTempo.getText();
    }

    public void setTempoJejum(String tempo) {
        this.txtTempo.setText(tempo);
    }

    public boolean isJejumNaoInformado() {
        return this.checkNaoInformado.isSelected();
    }
}

