/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.comum.Acesso;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.recepcao.Requisicao;
import jalis.laboratorio.recepcao.util.DadosGuiaPorExame;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class SolicitarGuiasAgrupamento
extends AbstractDialogoOKCancelar {
    private static int COLUNA_CODIGO = 0;
    private static int COLUNA_DESCRICAO = 1;
    private static int COLUNA_MATERIAL = 2;
    private static int COLUNA_GUIA = 3;
    private static int COLUNA_DATA_GUIA = 4;
    private static int COLUNA_VALIDADE_GUIA = 5;
    private static int COLUNA_DEVEGUIA = 6;
    private final JLabel label1 = new JLabel("Os exames a seguir formam um agrupamento para faturamento.");
    private final JLabel label2 = new JLabel("A quantidade de exames n\u00e3o pode exceder as guias informadas.");
    private final ModeloGridTable modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "Exame", "Mat.", "Guia", "Data", "Validade", "Deve"}){

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c) != null ? this.getValueAt(0, c).getClass() : (c == COLUNA_DEVEGUIA ? Boolean.class : String.class);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == COLUNA_DEVEGUIA && Acesso.getAcesso(Requisicao.ACESSO_DEVE_GUIA);
        }
    };
    private final JTable tabela = new JTable(this.modelo);
    private final JLabel labelCodigo = ComponenteFactory.novoJLabel("", new Dimension(80, 20), new TitledBorder(""));
    private final JLabel labelExame = ComponenteFactory.novoJLabel("", new Dimension(100, 20), new TitledBorder(""));
    private final JLabel labelMaterial = ComponenteFactory.novoJLabel("", new Dimension(80, 20), new TitledBorder(""));
    private final JButton buttonOKGuia = ComponenteFactory.novoJButton("OK", this);
    private final TTextField textGuia = new TTextField(20);
    private final TTextField textDataGuia = new TTextField(10, 4);
    private final TTextField textValidadeGuia = new TTextField(10, 4);
    private final JButton buttonBuscaDataGuia = ComponenteFactory.novoJButton(this, true);
    private final JButton buttonBuscaValidadeGuia = ComponenteFactory.novoJButton(this, true);
    private int linhaSendoAlterada = -1;
    private final HashMap<String, Integer> contagemGuias = new HashMap();
    private int numeroMaximoExamesPorGuia = 0;
    private DadosConvenios dadosConvenio = null;
    private boolean isExigeValidade = false;
    private int diasValidade = 0;
    private Date dataRequisicao = null;

    public static SolicitarGuiasAgrupamento novaInstancia(Object pai, boolean isExigeValidade, int diasValidade, Date dataRequisicao) {
        if (pai instanceof Frame) {
            return new SolicitarGuiasAgrupamento((Frame)pai, isExigeValidade, diasValidade, dataRequisicao);
        }
        if (pai instanceof Dialog) {
            return new SolicitarGuiasAgrupamento((Dialog)pai, isExigeValidade, diasValidade, dataRequisicao);
        }
        return null;
    }

    public SolicitarGuiasAgrupamento(Frame pai, boolean isExigeValidade, int diasValidade, Date dataRequisicao) {
        super(pai, "Guias para agrupamento");
        this.isExigeValidade = isExigeValidade;
        this.diasValidade = diasValidade;
        this.dataRequisicao = dataRequisicao;
        this.montaTela();
    }

    public SolicitarGuiasAgrupamento(Dialog pai, boolean isExigeValidade, int diasValidade, Date dataRequisicao) {
        super(pai, "Guias para agrupamento");
        this.isExigeValidade = isExigeValidade;
        this.diasValidade = diasValidade;
        this.dataRequisicao = dataRequisicao;
        this.montaTela();
    }

    public void setNumeroMaximoExamesPorGuia(int numeroMaximoExamesPorGuia) {
        this.numeroMaximoExamesPorGuia = numeroMaximoExamesPorGuia;
    }

    public void setDadosConvenio(DadosConvenios dados) {
        this.dadosConvenio = dados;
    }

    private void montaTela() {
        this.setSize(new Dimension(650, 400));
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.modelo.setColumnSize(new int[]{60, 0, 50, 100, 80, 80, 40}, this.tabela);
        this.tabela.setDefaultRenderer(Object.class, new DefaultTableCellRenderer());
        JPanel panelCentro = this.getPanelCentral();
        panelCentro.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.anchor = 17;
        c.fill = 2;
        panelCentro.add((Component)this.label1, c);
        ++c.gridy;
        panelCentro.add((Component)this.label2, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 0;
        c.gridwidth = 1;
        this.labelCodigo.setMinimumSize(this.labelCodigo.getPreferredSize());
        panelCentro.add((Component)this.labelCodigo, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.labelExame.setMinimumSize(this.labelExame.getPreferredSize());
        panelCentro.add((Component)this.labelExame, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.labelMaterial.setMinimumSize(this.labelMaterial.getPreferredSize());
        panelCentro.add((Component)this.labelMaterial, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = this.isExigeValidade && this.diasValidade == 0 ? 4 : 3;
        c.weightx = 1.0;
        c.fill = 2;
        JPanel p = new JPanel(new GridBagLayout());
        p.setPreferredSize(new Dimension(100, 20));
        panelCentro.add((Component)p, c);
        JScrollPane scroll = new JScrollPane(this.tabela);
        c.weighty = 1.0;
        ++c.gridy;
        c.fill = 1;
        panelCentro.add((Component)scroll, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.weighty = 0.0;
        p.add((Component)new JLabel("Guia"), c);
        ++c.gridx;
        p.add((Component)new JLabel("Data"), c);
        if (this.isExigeValidade && this.diasValidade == 0) {
            c.gridx += 2;
            p.add((Component)new JLabel("Validade"), c);
        }
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.fill = 2;
        this.textGuia.setPreferredSize(new Dimension(100, 20));
        this.textGuia.setMinimumSize(new Dimension(100, 20));
        p.add((Component)this.textGuia, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        c.gridwidth = 1;
        this.textDataGuia.setPreferredSize(new Dimension(80, 20));
        this.textDataGuia.setMinimumSize(new Dimension(80, 20));
        p.add((Component)this.textDataGuia, c);
        ++c.gridx;
        this.buttonBuscaDataGuia.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaDataGuia.setMinimumSize(new Dimension(20, 20));
        p.add((Component)this.buttonBuscaDataGuia, c);
        if (this.isExigeValidade && this.diasValidade == 0) {
            ++c.gridx;
            this.textValidadeGuia.setPreferredSize(new Dimension(80, 20));
            this.textValidadeGuia.setMinimumSize(new Dimension(80, 20));
            p.add((Component)this.textValidadeGuia, c);
            ++c.gridx;
            this.buttonBuscaValidadeGuia.setPreferredSize(new Dimension(20, 20));
            this.buttonBuscaValidadeGuia.setMinimumSize(new Dimension(20, 20));
            p.add((Component)this.buttonBuscaValidadeGuia, c);
        }
        ++c.gridx;
        this.buttonOKGuia.setPreferredSize(new Dimension(40, 20));
        this.buttonOKGuia.setMinimumSize(new Dimension(40, 20));
        p.add((Component)this.buttonOKGuia, c);
        this.textDataGuia.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Funcoes.mostraData(SolicitarGuiasAgrupamento.this.textDataGuia, SolicitarGuiasAgrupamento.this.buttonBuscaDataGuia, (JPanel)SolicitarGuiasAgrupamento.this.buttonBuscaDataGuia.getParent(), true);
                }
            }
        });
        this.textValidadeGuia.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Funcoes.mostraData(SolicitarGuiasAgrupamento.this.textValidadeGuia, SolicitarGuiasAgrupamento.this.buttonBuscaValidadeGuia, (JPanel)SolicitarGuiasAgrupamento.this.buttonBuscaValidadeGuia.getParent(), true);
                }
            }
        });
        this.tabela.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32 && SolicitarGuiasAgrupamento.this.tabela.getSelectedRow() > -1) {
                    SolicitarGuiasAgrupamento.this.editarLinha(SolicitarGuiasAgrupamento.this.tabela.getSelectedRow());
                }
            }
        });
        this.tabela.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SolicitarGuiasAgrupamento.this.tabela.getSelectedRow() > -1 && e.getClickCount() == 2) {
                    SolicitarGuiasAgrupamento.this.editarLinha(SolicitarGuiasAgrupamento.this.tabela.getSelectedRow());
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (SolicitarGuiasAgrupamento.this.modelo.getRowCount() > 0) {
                    SolicitarGuiasAgrupamento.this.tabela.setRowSelectionInterval(0, 0);
                }
                SolicitarGuiasAgrupamento.this.tabela.grabFocus();
            }
        });
    }

    @Override
    public boolean acaoOk() {
        boolean guiaVazia = false;
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            if (this.modelo.getValueAt(i, COLUNA_GUIA) != null && !Funcoes.textoVazio(this.modelo.getValueAt(i, COLUNA_GUIA).toString()) || ((Boolean)this.modelo.getValueAt(i, COLUNA_DEVEGUIA)).booleanValue()) continue;
            guiaVazia = true;
            break;
        }
        if (guiaVazia) {
            Funcoes.mensagem(this, "Algumas guias n\u00e3o foram informadas", 1);
        }
        return !guiaVazia;
    }

    private void editarLinha(int linha) {
        if (linha > -1 && this.modelo.getRowCount() >= linha) {
            if (linha > 0 && this.modelo.getValueAt(linha - 1, COLUNA_GUIA) != null && !Funcoes.textoVazio(this.modelo.getValueAt(linha - 1, COLUNA_GUIA).toString()) && (this.modelo.getValueAt(linha, COLUNA_GUIA) == null || Funcoes.textoVazio(this.modelo.getValueAt(linha, COLUNA_GUIA).toString()))) {
                this.textGuia.setText(this.modelo.getValueAt(linha - 1, COLUNA_GUIA).toString());
                if (this.modelo.getValueAt(linha - 1, COLUNA_DATA_GUIA) != null && Funcoes.verificaData(this.modelo.getValueAt(linha - 1, COLUNA_DATA_GUIA).toString())) {
                    this.textDataGuia.setText(this.modelo.getValueAt(linha - 1, COLUNA_DATA_GUIA).toString());
                }
                if (this.modelo.getValueAt(linha - 1, COLUNA_VALIDADE_GUIA) != null && Funcoes.verificaData(this.modelo.getValueAt(linha - 1, COLUNA_VALIDADE_GUIA).toString())) {
                    this.textValidadeGuia.setText(this.modelo.getValueAt(linha - 1, COLUNA_VALIDADE_GUIA).toString());
                }
            } else {
                this.textGuia.setText(this.modelo.getValueAt(linha, COLUNA_GUIA) != null ? this.modelo.getValueAt(linha, COLUNA_GUIA).toString() : "");
                this.textDataGuia.setText(this.modelo.getValueAt(linha, COLUNA_DATA_GUIA) != null ? this.modelo.getValueAt(linha, COLUNA_DATA_GUIA).toString() : "");
                this.textValidadeGuia.setText(this.modelo.getValueAt(linha, COLUNA_VALIDADE_GUIA) != null ? this.modelo.getValueAt(linha, COLUNA_VALIDADE_GUIA).toString() : "");
            }
            this.linhaSendoAlterada = linha;
            this.labelCodigo.setText(this.modelo.getValueAt(linha, COLUNA_CODIGO).toString());
            this.labelExame.setText(this.modelo.getValueAt(linha, COLUNA_DESCRICAO).toString());
            this.labelMaterial.setText(((DadosMaterial)this.modelo.getValueAt(linha, COLUNA_MATERIAL)).getAbreviatura());
            this.textGuia.grabFocus();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonBuscaDataGuia) {
            Funcoes.mostraData(this.textDataGuia, this.buttonBuscaDataGuia, (JPanel)this.buttonBuscaDataGuia.getParent(), true);
        } else if (e.getSource() == this.buttonBuscaValidadeGuia) {
            Funcoes.mostraData(this.textValidadeGuia, this.buttonBuscaValidadeGuia, (JPanel)this.buttonBuscaValidadeGuia.getParent(), true);
        } else if (e.getSource() == this.buttonOKGuia) {
            this.adicionarGuia();
        } else {
            super.actionPerformed(e);
        }
    }

    private void adicionarGuia() {
        if (this.isExigeValidade && Funcoes.textoVazio(this.textDataGuia)) {
            Funcoes.mensagem(this, "Informe a data da guia.", 2);
            ScreenUtil.requisitarFoco(this.textDataGuia);
            return;
        }
        int qtdeGuias = 0;
        if (this.linhaSendoAlterada > -1 && (qtdeGuias = this.validaNovaGuia(this.textGuia.getText().trim())) >= 0 && this.testaValidadeGuia(this.textDataGuia.getText(), this.textValidadeGuia.getText())) {
            this.modelo.setValueAt(this.textGuia.getText().trim(), this.linhaSendoAlterada, COLUNA_GUIA);
            this.modelo.setValueAt(this.textDataGuia.getText(), this.linhaSendoAlterada, COLUNA_DATA_GUIA);
            String validade = null;
            if (this.isExigeValidade && this.diasValidade == 0) {
                validade = this.textValidadeGuia.getText();
            } else if (this.isExigeValidade && this.diasValidade > 0) {
                Date guia = Funcoes.getData("dd/MM/yyyy", this.textDataGuia.getText());
                Date aux = Funcoes.somaDias(guia, this.diasValidade);
                validade = Funcoes.formataData("dd/MM/yyyy", aux);
            } else {
                validade = null;
            }
            this.modelo.setValueAt(validade, this.linhaSendoAlterada, COLUNA_VALIDADE_GUIA);
            for (int i = 1; i < qtdeGuias; ++i) {
                if (this.modelo.getRowCount() <= this.linhaSendoAlterada + i || this.modelo.getValueAt(this.linhaSendoAlterada + i, COLUNA_GUIA) != null && !Funcoes.textoVazio(this.modelo.getValueAt(this.linhaSendoAlterada + i, COLUNA_GUIA).toString())) continue;
                this.modelo.setValueAt(this.textGuia.getText().trim(), this.linhaSendoAlterada + i, COLUNA_GUIA);
                this.modelo.setValueAt(this.textDataGuia.getText(), this.linhaSendoAlterada + i, COLUNA_DATA_GUIA);
                this.modelo.setValueAt(validade, this.linhaSendoAlterada + i, COLUNA_VALIDADE_GUIA);
            }
        } else {
            Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel utilizar a guia \"" + this.textGuia.getText().trim() + "\".\nA guia ultrapassou o limite de exames.", 2);
            return;
        }
        this.linhaSendoAlterada = -1;
        if (qtdeGuias >= 0) {
            this.labelCodigo.setText("");
            this.labelExame.setText("");
            this.labelMaterial.setText("");
            this.textGuia.clear();
            this.textDataGuia.clear();
            this.textValidadeGuia.clear();
            ScreenUtil.requisitarFoco(this.tabela);
        } else {
            Funcoes.mensagem(this, "A guia informada excede no n\u00famero de exames por guia", 1);
            ScreenUtil.requisitarFoco(this.textGuia);
        }
    }

    public void adicionarExame(String codigo, String descricao, DadosMaterial material, String guia, Date dataGuia, Date validadeGuia, boolean deveGuia) {
        if (codigo == null || material == null) {
            return;
        }
        if (!this.achaExame(codigo, material)) {
            this.modelo.addLine(new Object[]{codigo, descricao, material, guia, dataGuia == null ? "" : Funcoes.formataData(dataGuia), validadeGuia == null ? "" : Funcoes.formataData(validadeGuia), new Boolean(deveGuia)});
        }
    }

    private boolean achaExame(String codigo, DadosMaterial material) {
        if (codigo != null && material != null) {
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                if (!this.modelo.getValueAt(i, COLUNA_CODIGO).toString().equalsIgnoreCase(codigo) || ((DadosMaterial)this.modelo.getValueAt(i, COLUNA_MATERIAL)).getCodigo() != material.getCodigo()) continue;
                return true;
            }
        }
        return false;
    }

    public void adicionaContagemGuia(String guia, Integer contagem) {
        if (guia != null) {
            this.contagemGuias.put(guia.toUpperCase(), contagem);
        }
    }

    private int validaNovaGuia(String guia) {
        int contagem = this.contagemGuias.get(guia.toUpperCase()) != null ? this.contagemGuias.get(guia.toUpperCase()) : 0;
        if (this.numeroMaximoExamesPorGuia > 0 && (contagem += this.contaNumeroGuiasInformadas(guia)) < this.numeroMaximoExamesPorGuia) {
            return this.numeroMaximoExamesPorGuia - contagem;
        }
        return this.numeroMaximoExamesPorGuia > 0 && contagem >= this.numeroMaximoExamesPorGuia ? -1 : 0;
    }

    private boolean testaValidadeGuia(String data, String validade) {
        if (this.dadosConvenio != null && Funcoes.verificaData(data) && Funcoes.verificaData(validade)) {
            Date d = Funcoes.stringToDate(data);
            if (d.compareTo(Funcoes.stringToDate(validade)) > 0) {
                Funcoes.mensagem(this, "A validade \u00e9 anterior \u00e0 data da guia.", 2);
                ScreenUtil.requisitarFoco(this.textValidadeGuia);
                return false;
            }
            if (this.dadosConvenio.getDiasValidadeGuia() > 0 && Funcoes.daysBetween(Funcoes.stringToDate(validade), Funcoes.stringToDate(data)) >= this.dadosConvenio.getDiasValidadeGuia()) {
                Funcoes.mensagem(this, "A validade da guia expirou.", 2);
                ScreenUtil.requisitarFoco(this.textDataGuia);
                return false;
            }
        }
        return true;
    }

    private int contaNumeroGuiasInformadas(String guia) {
        int contador = 0;
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            String g;
            if (this.modelo.getValueAt(i, COLUNA_GUIA) == null) continue;
            String string = g = this.modelo.getValueAt(i, COLUNA_GUIA) != null ? this.modelo.getValueAt(i, COLUNA_GUIA).toString() : "";
            if (Funcoes.textoVazio(g) || !g.equalsIgnoreCase(guia)) continue;
            ++contador;
        }
        return contador;
    }

    public ArrayList<DadosGuiaPorExame> getGuiasConfiguradas() {
        ArrayList<DadosGuiaPorExame> guias = new ArrayList<DadosGuiaPorExame>();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            DadosGuiaPorExame guia = new DadosGuiaPorExame();
            guia.setCodigoExame(this.modelo.getValueAt(i, COLUNA_CODIGO).toString());
            guia.setDescricaoExame(this.modelo.getValueAt(i, COLUNA_DESCRICAO).toString());
            guia.setGuia(this.modelo.getValueAt(i, COLUNA_GUIA) != null ? this.modelo.getValueAt(i, COLUNA_GUIA).toString() : null);
            guia.setDeveGuia(this.modelo.getValueAt(i, COLUNA_DEVEGUIA) instanceof Boolean ? (Boolean)this.modelo.getValueAt(i, COLUNA_DEVEGUIA) : false);
            guia.setCodigoMaterial(((DadosMaterial)this.modelo.getValueAt(i, COLUNA_MATERIAL)).getCodigo());
            guia.setDataGuia(this.modelo.getValueAt(i, COLUNA_DATA_GUIA) != null && Funcoes.verificaData(this.modelo.getValueAt(i, COLUNA_DATA_GUIA).toString()) ? Funcoes.stringToDate(this.modelo.getValueAt(i, COLUNA_DATA_GUIA).toString()) : null);
            guia.setValidadeGuia(this.modelo.getValueAt(i, COLUNA_VALIDADE_GUIA) != null && Funcoes.verificaData(this.modelo.getValueAt(i, COLUNA_VALIDADE_GUIA).toString()) ? Funcoes.stringToDate(this.modelo.getValueAt(i, COLUNA_VALIDADE_GUIA).toString()) : null);
            guias.add(guia);
        }
        return guias;
    }
}

