/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.comum.Acesso;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.recepcao.Requisicao;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SolicitarGuiaExame
extends AbstractDialogoOKCancelar {
    private final TTextField textGuia = new TTextField(20, "[a-zA-Z0-9./-]+");
    private final TTextField textDataGuia = new TTextField(10, 4);
    private final TTextField textValidadeGuia = new TTextField(10, 4);
    private final JButton buttonBuscaDataGuia = ComponenteFactory.novoJButton(this, true);
    private final JButton buttonBuscaValidadeGuia = ComponenteFactory.novoJButton(this, true);
    private final JCheckBox checkDeveGuia = new JCheckBox("Deve guia");
    private boolean exigirDataGuia = false;
    private int diasValidade = 0;
    private Date dataGuia = null;
    private Date validadeGuia = null;
    private Date dataRequisicao = null;
    private boolean isExigeValidade = false;

    public static SolicitarGuiaExame novaInstancia(Object owner, boolean isExigeValidade, int diasValidade, Date dataRequisicao) {
        if (owner instanceof Frame) {
            return new SolicitarGuiaExame((Frame)owner, isExigeValidade, diasValidade, dataRequisicao);
        }
        if (owner instanceof Dialog) {
            return new SolicitarGuiaExame((Dialog)owner, isExigeValidade, diasValidade, dataRequisicao);
        }
        return null;
    }

    public SolicitarGuiaExame(Dialog owner, boolean isExigeValidade, int diasValidade, Date dataRequisicao) {
        super(owner, "Guia do exame");
        this.diasValidade = diasValidade;
        this.dataRequisicao = dataRequisicao;
        this.isExigeValidade = isExigeValidade;
        this.montaTela();
        ScreenUtil.requisitarFoco(this.textGuia);
    }

    public SolicitarGuiaExame(Frame owner, boolean isExigeValidade, int diasValidade, Date dataRequisicao) {
        super(owner, "Guia do exame");
        this.diasValidade = diasValidade;
        this.dataRequisicao = dataRequisicao;
        this.isExigeValidade = isExigeValidade;
        this.montaTela();
        ScreenUtil.requisitarFoco(this.textGuia);
    }

    private void montaTela() {
        this.setSize(new Dimension(260, 150 + (this.isExigeValidade && this.diasValidade == 0 ? 40 : 25)));
        this.setLocationRelativeTo(this.getParent());
        this.setResizable(false);
        this.textDataGuia.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (SolicitarGuiaExame.this.isExigeValidade && SolicitarGuiaExame.this.diasValidade == 0 && !Funcoes.textoVazio(SolicitarGuiaExame.this.textDataGuia)) {
                    SolicitarGuiaExame.this.textValidadeGuia.setText(SolicitarGuiaExame.this.textDataGuia.getText());
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                ScreenUtil.requisitarFoco(SolicitarGuiaExame.this.textGuia);
            }
        });
        this.checkDeveGuia.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SolicitarGuiaExame.this.textGuia.setText("");
                    SolicitarGuiaExame.this.textDataGuia.setText("");
                    SolicitarGuiaExame.this.textValidadeGuia.setText("");
                    SolicitarGuiaExame.this.buttonBuscaDataGuia.setEnabled(false);
                    SolicitarGuiaExame.this.buttonBuscaValidadeGuia.setEnabled(false);
                    SolicitarGuiaExame.this.textGuia.setEnabled(false);
                    SolicitarGuiaExame.this.textDataGuia.setEnabled(false);
                    SolicitarGuiaExame.this.textValidadeGuia.setEnabled(false);
                } else {
                    SolicitarGuiaExame.this.buttonBuscaDataGuia.setEnabled(true);
                    SolicitarGuiaExame.this.buttonBuscaValidadeGuia.setEnabled(true);
                    SolicitarGuiaExame.this.textGuia.setEnabled(true);
                    SolicitarGuiaExame.this.textDataGuia.setEnabled(true);
                    SolicitarGuiaExame.this.textValidadeGuia.setEnabled(true);
                    SolicitarGuiaExame.this.textGuia.grabFocus();
                }
            }
        });
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        panel.add((Component)new JLabel("Guia:"), c);
        ++c.gridy;
        panel.add((Component)new JLabel("Data:"), c);
        if (this.isExigeValidade && this.diasValidade == 0) {
            ++c.gridy;
            panel.add((Component)new JLabel("Validade:"), c);
        }
        c.gridy = 0;
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 2;
        this.textGuia.setPreferredSize(new Dimension(100, 20));
        this.textGuia.setMinimumSize(new Dimension(100, 20));
        panel.add((Component)this.textGuia, c);
        ++c.gridy;
        c.gridwidth = 1;
        this.textDataGuia.setPreferredSize(new Dimension(100, 20));
        this.textDataGuia.setMinimumSize(new Dimension(100, 20));
        panel.add((Component)this.textDataGuia, c);
        if (this.isExigeValidade && this.diasValidade == 0) {
            ++c.gridy;
            c.gridwidth = 1;
            this.textValidadeGuia.setPreferredSize(new Dimension(100, 20));
            this.textValidadeGuia.setMinimumSize(new Dimension(100, 20));
            panel.add((Component)this.textValidadeGuia, c);
        }
        c.fill = 0;
        c.weightx = 0.0;
        this.buttonBuscaDataGuia.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaDataGuia.setMinimumSize(new Dimension(20, 20));
        ++c.gridx;
        c.gridy = 1;
        panel.add((Component)this.buttonBuscaDataGuia, c);
        if (this.isExigeValidade && this.diasValidade == 0) {
            c.fill = 0;
            c.weightx = 0.0;
            this.buttonBuscaValidadeGuia.setPreferredSize(new Dimension(20, 20));
            this.buttonBuscaValidadeGuia.setMinimumSize(new Dimension(20, 20));
            ++c.gridy;
            panel.add((Component)this.buttonBuscaValidadeGuia, c);
        }
        ++c.gridy;
        c.gridx = 1;
        c.gridwidth = 2;
        c.fill = 2;
        c.weightx = 1.0;
        this.checkDeveGuia.setPreferredSize(new Dimension(50, 15));
        this.checkDeveGuia.setMinimumSize(new Dimension(50, 15));
        panel.add((Component)this.checkDeveGuia, c);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        c.fill = 1;
        c.weighty = 1.0;
        panel.add((Component)new JPanel(), c);
        this.buttonBuscaDataGuia.setFocusable(false);
        this.buttonBuscaValidadeGuia.setFocusable(false);
        this.checkDeveGuia.setVisible(Acesso.getAcesso(Requisicao.ACESSO_DEVE_GUIA));
        this.textDataGuia.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    SolicitarGuiaExame.this.buscaDataGuia();
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SolicitarGuiaExame.this.textGuia.grabFocus();
            }
        });
    }

    @Override
    public boolean acaoOk() {
        if (!Funcoes.textoVazio(this.textDataGuia.getText()) && !Funcoes.verificaData(this.textDataGuia.getText())) {
            Funcoes.mensagem(this, "Data da guia incorreta.", 2);
            this.textDataGuia.selectAll();
            ScreenUtil.requisitarFoco(this.textDataGuia);
            return false;
        }
        if (this.checkDeveGuia.isSelected()) {
            this.dataGuia = null;
            this.validadeGuia = null;
            this.textGuia.clear();
            return true;
        }
        if (Funcoes.textoVazio(this.textGuia)) {
            Funcoes.mensagem(this, "A guia n\u00e3o foi informada.", 2);
            this.textGuia.selectAll();
            ScreenUtil.requisitarFoco(this.textGuia);
            return false;
        }
        this.dataGuia = Funcoes.textoVazio(this.textDataGuia.getText()) ? null : Funcoes.getData("dd/MM/yyyy", this.textDataGuia.getText());
        Date date = this.validadeGuia = Funcoes.textoVazio(this.textValidadeGuia.getText()) ? null : Funcoes.getData("dd/MM/yyyy", this.textValidadeGuia.getText());
        if (this.exigirDataGuia && this.dataGuia == null) {
            Funcoes.mensagem(this, "Data da guia n\u00e3o informada.", 2);
            this.textDataGuia.selectAll();
            ScreenUtil.requisitarFoco(this.textDataGuia);
            return false;
        }
        if (!this.isExigeValidade || this.diasValidade > 0) {
            if (!this.isExigeValidade) {
                this.validadeGuia = null;
                return true;
            }
            this.validadeGuia = Funcoes.somaDias(this.dataGuia, this.diasValidade);
            if (Funcoes.comparaData(this.dataGuia, this.validadeGuia) > 0) {
                Funcoes.mensagem(this, "A validade informada \u00e9 anterior \u00e0 data da guia.", 2);
                ScreenUtil.requisitarFoco(this.textValidadeGuia);
                return false;
            }
            if (Funcoes.comparaData(this.dataRequisicao, this.validadeGuia) > 0) {
                Funcoes.mensagem(this, "A validade da guia expirou.", 2);
                ScreenUtil.requisitarFoco(this.textValidadeGuia);
                return false;
            }
            return true;
        }
        if (this.validadeGuia != null || this.exigirDataGuia) {
            if (this.validadeGuia == null && this.exigirDataGuia) {
                Funcoes.mensagem(this, "A validade da guia deve ser informada.", 2);
                ScreenUtil.requisitarFoco(this.textValidadeGuia);
                return false;
            }
            if (this.validadeGuia != null && Funcoes.comparaData(this.dataGuia, this.validadeGuia) > 0) {
                Funcoes.mensagem(this, "A validade informada \u00e9 anterior \u00e0 data da guia.", 2);
                ScreenUtil.requisitarFoco(this.textValidadeGuia);
                return false;
            }
            if (Funcoes.comparaData(this.dataRequisicao, this.validadeGuia) > 0) {
                Funcoes.mensagem(this, "A validade da guia expirou.", 2);
                ScreenUtil.requisitarFoco(this.textValidadeGuia);
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonBuscaDataGuia) {
            this.buscaDataGuia();
        } else if (e.getSource() == this.buttonBuscaValidadeGuia) {
            this.buscaValidadeGuia();
        } else {
            super.actionPerformed(e);
        }
    }

    private void buscaDataGuia() {
        Funcoes.mostraData(this.textDataGuia, this.buttonBuscaDataGuia, this.getPanelCentral(), true);
    }

    private void buscaValidadeGuia() {
        Funcoes.mostraData(this.textValidadeGuia, this.buttonBuscaValidadeGuia, this.getPanelCentral(), true);
    }

    public void setGuia(String guia) {
        this.textGuia.setText(guia);
    }

    public void setDataGuia(Date data) {
        if (data != null) {
            this.textDataGuia.setText(Funcoes.formataData(data));
        }
    }

    public void setValidadeGuia(Date data) {
        if (data != null) {
            this.textValidadeGuia.setText(Funcoes.formataData(data));
        }
    }

    public void setDeveGuia(boolean deveGuia) {
        this.checkDeveGuia.setSelected(deveGuia);
    }

    public String getGuia() {
        return this.textGuia.getText().trim();
    }

    public Date getDataGuia() {
        return this.dataGuia;
    }

    public Date getValidadeGuia() {
        return this.validadeGuia;
    }

    public boolean isDeveGuia() {
        return this.checkDeveGuia.isSelected();
    }

    public void setDescricaoExame(String descricao) {
        this.getPanelCentral().setBorder(BorderFactory.createTitledBorder(descricao));
    }

    public boolean isExigirValidadeGuia() {
        return this.exigirDataGuia;
    }

    public void setExigirValidadeGuia(boolean exigirValidadeGuia) {
        this.exigirDataGuia = exigirValidadeGuia;
    }
}

