/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SolicitarDesconto
extends JDialog {
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelTopo = new JPanel(null);
    private JButton buttonSalvar = new JButton("OK");
    private JButton buttonCancelar = new JButton("Cancelar");
    private TTextField textDesconto = new TTextField(10);
    private JLabel label = new JLabel("Desconto:");
    private boolean ok = false;
    private boolean considerarPercentual = false;

    public static SolicitarDesconto novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new SolicitarDesconto((Frame)pai);
        }
        if (pai instanceof Dialog) {
            return new SolicitarDesconto((Dialog)pai);
        }
        return null;
    }

    public SolicitarDesconto(Frame owner) {
        super(owner, "Desconto");
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    public SolicitarDesconto(Dialog owner) {
        super(owner, "Desconto");
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.setSize(180, 110);
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelTopo, "Center");
        this.panelBotoes.add(this.buttonSalvar);
        this.panelBotoes.add(this.buttonCancelar);
        this.panelTopo.add(this.label);
        this.panelTopo.add(this.textDesconto);
        this.label.setBounds(5, 5, 130, 14);
        this.textDesconto.setBounds(5, 20, 130, 20);
        this.buttonSalvar.setMnemonic('S');
        Funcoes.montaEnter((JComponent)this.panelTopo);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SolicitarDesconto.this.textDesconto.selectAll();
                SolicitarDesconto.this.textDesconto.grabFocus();
            }
        });
        this.buttonSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean valida = Funcoes.isNumeric(SolicitarDesconto.this.textDesconto.getText());
                if (!valida && SolicitarDesconto.this.textDesconto.getText().indexOf("%") > 0) {
                    SolicitarDesconto.this.considerarPercentual = true;
                    String tmp = SolicitarDesconto.this.textDesconto.getText().substring(0, SolicitarDesconto.this.textDesconto.getText().indexOf("%")).trim();
                    valida = Funcoes.isNumeric(tmp);
                    if (valida && (Double.parseDouble(Funcoes.limpaDecimal(tmp)) > 100.0 || Double.parseDouble(Funcoes.limpaDecimal(tmp)) < 0.0)) {
                        valida = false;
                    }
                }
                if (!valida) {
                    Funcoes.mensagem(SolicitarDesconto.this, "Desconto inv\u00e1lido", 1);
                    SolicitarDesconto.this.textDesconto.grabFocus();
                } else {
                    SolicitarDesconto.this.setVisible(false);
                    SolicitarDesconto.this.ok = true;
                }
            }
        });
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SolicitarDesconto.this.setVisible(false);
                SolicitarDesconto.this.ok = false;
            }
        });
    }

    public boolean isOK() {
        return this.ok;
    }

    public String getDesconto() {
        String tmp = this.textDesconto.getText();
        if (this.textDesconto.getText().indexOf("%") > 0) {
            tmp = this.textDesconto.getText().substring(0, this.textDesconto.getText().indexOf("%")).trim();
        }
        return Funcoes.limpaDecimal(tmp);
    }

    public void setDesconto(String desconto) {
        this.textDesconto.setText(desconto);
    }

    public boolean isPercentual() {
        return this.considerarPercentual;
    }
}

