/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.ValidaDoc;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SolicitarDadosResponsavelPaciente
extends AbstractDialogoOKCancelar {
    public static String TITULO = "Respons\u00e1vel do paciente";
    private TTextField textResponsavel = new TTextField(99);
    private TTextField textCpfResponsavel = new TTextField(14, 8);
    private JLabel labelResponsavel = new JLabel("Respons\u00e1vel:");
    private JLabel labelCpfResponsavel = new JLabel("CPF:");

    public SolicitarDadosResponsavelPaciente(Dialog pai) {
        super(pai, TITULO);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(pai, e.getMessage(), e.getStackTrace());
        }
    }

    public SolicitarDadosResponsavelPaciente(Frame pai) {
        super(pai, TITULO);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(pai, e.getMessage(), e.getStackTrace());
        }
    }

    public static SolicitarDadosResponsavelPaciente novaInstancia(Component owner, boolean ocultarGuiaPrincipal) {
        if (owner instanceof Frame) {
            return new SolicitarDadosResponsavelPaciente((Frame)owner);
        }
        if (owner instanceof Dialog) {
            return new SolicitarDadosResponsavelPaciente((Dialog)owner);
        }
        return null;
    }

    private void jbInit() throws Exception {
        this.setSize(370, 140);
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        panel.add((Component)this.labelResponsavel, c);
        ++c.gridx;
        this.labelResponsavel.setLabelFor(this.textResponsavel);
        this.textResponsavel.setPreferredSize(new Dimension(250, 20));
        panel.add((Component)this.textResponsavel, c);
        ++c.gridy;
        c.gridx = 0;
        panel.add((Component)this.labelCpfResponsavel, c);
        ++c.gridx;
        this.labelCpfResponsavel.setLabelFor(this.textCpfResponsavel);
        this.textCpfResponsavel.setPreferredSize(new Dimension(250, 20));
        panel.add((Component)this.textCpfResponsavel, c);
        Funcoes.montaEnter((JComponent)panel);
        this.buttonCancelar.setVisible(true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SolicitarDadosResponsavelPaciente.this.textResponsavel.grabFocus();
            }
        });
        ScreenUtil.requisitarFoco(this.textResponsavel);
    }

    @Override
    protected boolean acaoOk() {
        if (Funcoes.textoVazio(this.textResponsavel.getText())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Respons\u00e1vel n\u00e3o informado", 1);
            ScreenUtil.requisitarFoco(this.textResponsavel);
            this.ok = false;
            return false;
        }
        if (!ValidaDoc.checkDoc(this.textCpfResponsavel.getText(), 8)) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "CPF Inv\u00e1lido", 1);
            ScreenUtil.requisitarFoco(this.textCpfResponsavel);
            this.ok = false;
            return false;
        }
        return true;
    }

    public TTextField getTextResponsavel() {
        return this.textResponsavel;
    }

    public void setTextResponsavel(String responsavel) {
        this.textResponsavel.setText(responsavel);
    }

    public TTextField getTextCpfResponsavel() {
        return this.textCpfResponsavel;
    }

    public void setTextCpfResponsavel(String cpfResponsavel) {
        this.textCpfResponsavel.setText(cpfResponsavel);
    }
}

