/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.util.FinanceiroUtil;
import jalis.model.bean.financeiro.LancamentoBean;
import jalis.model.vo.cadastro.financeiro.ContaCorrenteVO;
import jalis.service.cadastro.financeiro.ContaCorrenteService;
import jalis.util.Funcoes;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class SolicitarContaEstorno
extends AbstractDialogoOKCancelar {
    private JLabel labelTipoPagamento = new JLabel();
    private JLabel labelValor = new JLabel();
    private ButtonGroup bg = new ButtonGroup();
    private JRadioButton radioContaPadrao = ComponenteFactory.novoJRadioButton("Padr\u00e3o", 'P', this, null, null);
    private JRadioButton radioContaPagamento = ComponenteFactory.novoJRadioButton("Pagamento", 'm', this, null, null);
    private JPanel panelConta = new JPanel(new GridBagLayout());
    private ContaCorrenteVO contaPadrao = null;
    private LancamentoBean lancamentoAux = null;

    public SolicitarContaEstorno(Dialog pai, String titulo, ContaCorrenteVO contaPadrao, LancamentoBean lancamento) {
        super(pai, titulo);
        if (contaPadrao != null) {
            this.contaPadrao = contaPadrao;
        } else {
            try {
                this.contaPadrao = (ContaCorrenteVO)new ContaCorrenteService().get(Variaveis.filialPadrao, String.valueOf(ParametrosGerais.getContaCaixa()));
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel identficiar a conta padr\u00e3o.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        this.lancamentoAux = lancamento;
        this.iniciar();
    }

    public SolicitarContaEstorno(Frame pai, String titulo, ContaCorrenteVO contaPadrao, LancamentoBean lancamento) {
        super(pai, titulo);
        if (contaPadrao != null) {
            this.contaPadrao = contaPadrao;
        } else {
            try {
                this.contaPadrao = (ContaCorrenteVO)FinanceiroUtil.getContaCaixaPadrao(lancamento.getFilial().getCodigo().toString()).toVO();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel identificar a conta padr\u00e3o.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        this.lancamentoAux = lancamento;
        this.iniciar();
    }

    public static SolicitarContaEstorno novaInstancia(Object pai, ContaCorrenteVO contaPadrao, LancamentoBean lancamento) {
        SolicitarContaEstorno tela = null;
        if (pai instanceof Frame) {
            tela = new SolicitarContaEstorno((Frame)pai, "Selecionar conta", contaPadrao, lancamento);
        } else if (pai instanceof Dialog) {
            tela = new SolicitarContaEstorno((Dialog)pai, "Selecionar conta", contaPadrao, lancamento);
        } else {
            return null;
        }
        if (contaPadrao != null && contaPadrao.getReduzido().intValue() == lancamento.getContaCorrente().getReduzido().intValue()) {
            return null;
        }
        return tela;
    }

    private void iniciar() {
        this.buttonCancelar.setVisible(false);
        this.setSize(new Dimension(230, 180));
        this.setResizable(false);
        this.bg.add(this.radioContaPadrao);
        this.bg.add(this.radioContaPagamento);
        this.panelConta.setBorder(new TitledBorder("Conta"));
        this.labelTipoPagamento.setText("Pagamento: " + Tipos.tipoPagamento(this.lancamentoAux.getTipoPagamento()));
        this.labelValor.setText("Valor: " + Funcoes.formataDecimal(this.lancamentoAux.getValorTotal()));
        this.radioContaPadrao.setText(this.radioContaPadrao.getText() + " (" + this.contaPadrao.getConta() + ")");
        this.radioContaPagamento.setText(this.radioContaPagamento.getText() + " (" + this.lancamentoAux.getContaCorrente().getConta() + ")");
        JPanel panelCentral = this.getPanelCentral();
        panelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 5, 1, 1);
        panelCentral.add((Component)this.labelTipoPagamento, c);
        ++c.gridy;
        panelCentral.add((Component)this.labelValor, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        panelCentral.add((Component)this.panelConta, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        this.panelConta.add((Component)this.radioContaPadrao, c);
        ++c.gridy;
        this.panelConta.add((Component)this.radioContaPagamento, c);
        this.radioContaPadrao.setSelected(true);
    }

    public ContaCorrenteVO getContaSelecionada() {
        if (this.radioContaPadrao.isSelected()) {
            return this.contaPadrao;
        }
        return this.lancamentoAux.getContaCorrente();
    }
}

