/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SolicitarAcrescimoDesconto
extends JDialog {
    public static final String TIPO_ACRESCIMO = "Acr\u00e9scimo";
    public static final String TIPO_DESCONTO = "Desconto";
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelTopo = new JPanel(null);
    private JButton buttonSalvar = new JButton("OK");
    private JButton buttonCancelar = new JButton("Cancelar");
    private TTextField textAcrescimoDesconto = new TTextField(10);
    private JLabel labelAcresDesc = new JLabel();
    private boolean ok = false;
    private boolean considerarPercentual = false;
    private String tipo;

    public static SolicitarAcrescimoDesconto novaInstancia(Object pai, String tipo) {
        if (pai instanceof Frame) {
            return new SolicitarAcrescimoDesconto((Frame)pai, tipo);
        }
        if (pai instanceof Dialog) {
            return new SolicitarAcrescimoDesconto((Dialog)pai, tipo);
        }
        return null;
    }

    public SolicitarAcrescimoDesconto(Frame owner, String tipo) {
        super(owner, tipo);
        this.tipo = tipo;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    public SolicitarAcrescimoDesconto(Dialog owner, String tipo) {
        super(owner, tipo);
        this.tipo = tipo;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.setSize(180, 110);
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.labelAcresDesc.setText(this.tipo.concat(":"));
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelTopo, "Center");
        this.panelBotoes.add(this.buttonSalvar);
        this.panelBotoes.add(this.buttonCancelar);
        this.panelTopo.add(this.labelAcresDesc);
        this.panelTopo.add(this.textAcrescimoDesconto);
        this.labelAcresDesc.setBounds(5, 5, 130, 14);
        this.textAcrescimoDesconto.setBounds(5, 20, 130, 20);
        this.buttonSalvar.setMnemonic('S');
        Funcoes.montaEnter((JComponent)this.panelTopo);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SolicitarAcrescimoDesconto.this.textAcrescimoDesconto.selectAll();
                SolicitarAcrescimoDesconto.this.textAcrescimoDesconto.grabFocus();
            }
        });
        this.buttonSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean valida = Funcoes.isNumeric(SolicitarAcrescimoDesconto.this.textAcrescimoDesconto.getText());
                if (!valida && SolicitarAcrescimoDesconto.this.textAcrescimoDesconto.getText().indexOf("%") > 0) {
                    SolicitarAcrescimoDesconto.this.considerarPercentual = true;
                    String tmp = SolicitarAcrescimoDesconto.this.textAcrescimoDesconto.getText().substring(0, SolicitarAcrescimoDesconto.this.textAcrescimoDesconto.getText().indexOf("%")).trim();
                    valida = Funcoes.isNumeric(tmp);
                    if (valida && (Double.parseDouble(Funcoes.limpaDecimal(tmp)) > 100.0 || Double.parseDouble(Funcoes.limpaDecimal(tmp)) < 0.0)) {
                        valida = false;
                    }
                }
                if (!valida) {
                    Funcoes.mensagem(SolicitarAcrescimoDesconto.this, SolicitarAcrescimoDesconto.this.tipo.concat(" inv\u00e1lido"), 1);
                    SolicitarAcrescimoDesconto.this.textAcrescimoDesconto.grabFocus();
                } else {
                    SolicitarAcrescimoDesconto.this.setVisible(false);
                    SolicitarAcrescimoDesconto.this.ok = true;
                }
            }
        });
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SolicitarAcrescimoDesconto.this.setVisible(false);
                SolicitarAcrescimoDesconto.this.ok = false;
            }
        });
    }

    public boolean isOK() {
        return this.ok;
    }

    public String getAcrescimoDesconto() {
        String tmp = this.textAcrescimoDesconto.getText();
        if (this.textAcrescimoDesconto.getText().indexOf("%") > 0) {
            tmp = this.textAcrescimoDesconto.getText().substring(0, this.textAcrescimoDesconto.getText().indexOf("%")).trim();
        }
        return Funcoes.limpaDecimal(tmp);
    }

    public void setDesconto(String desconto) {
        this.textAcrescimoDesconto.setText(desconto);
    }

    public boolean isPercentual() {
        return this.considerarPercentual;
    }
}

