/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.comum.Pesquisas;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class RequisicaoCid10
extends AbstractDialogoOKCancelar {
    TTextField textCodigo = new TTextField(5);
    JLabel labelCodigo = new JLabel("C\u00f3digo");
    JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o");
    JButton buttonBuscaCid = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    JLabel labelVDescricao = ComponenteFactory.novoJLabel("", new Dimension(20, 20), new TitledBorder(""));
    JButton buttonOKCid = ComponenteFactory.novoJButton("OK", '\u0000', this, null, new Dimension(40, 20));
    ModeloGridTable modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"});
    JTable tabela = new JTable(this.modelo);
    private final int COLUNA_CODIGO = 0;
    private final int COLUNA_DESCRICAO = 1;

    public static RequisicaoCid10 getNovaInstancia(Object owner) {
        if (owner instanceof Frame) {
            return new RequisicaoCid10((Frame)owner);
        }
        if (owner instanceof Dialog) {
            return new RequisicaoCid10((Dialog)owner);
        }
        return null;
    }

    public RequisicaoCid10(Frame owner) {
        super(owner, "CID-10");
        this.montaTela();
    }

    public RequisicaoCid10(Dialog owner) {
        super(owner, "CID-10");
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(new Dimension(400, 350));
        this.setResizable(false);
        this.modelo.setColumnSize(new int[]{70, 0}, this.tabela);
        this.buttonBuscaCid.setFocusable(false);
        this.textCodigo.setUpperCase(true);
        JPanel painel = this.getPanelCentral();
        painel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        painel.add((Component)this.labelCodigo, c);
        c.gridy = 1;
        this.textCodigo.setPreferredSize(new Dimension(69, 20));
        this.textCodigo.setMinimumSize(this.textCodigo.getPreferredSize());
        painel.add((Component)this.textCodigo, c);
        c.gridx = 1;
        this.buttonBuscaCid.setMinimumSize(this.buttonBuscaCid.getPreferredSize());
        painel.add((Component)this.buttonBuscaCid, c);
        c.gridx = 3;
        this.buttonOKCid.setMinimumSize(this.buttonOKCid.getPreferredSize());
        painel.add((Component)this.buttonOKCid, c);
        c.gridx = 2;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        painel.add((Component)this.labelDescricao, c);
        c.gridy = 1;
        this.labelVDescricao.setMinimumSize(this.labelVDescricao.getPreferredSize());
        painel.add((Component)this.labelVDescricao, c);
        c.weighty = 1.0;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 4;
        painel.add((Component)new JScrollPane(this.tabela), c);
        this.textCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(RequisicaoCid10.this.textCodigo.getText())) {
                    try {
                        RequisicaoCid10.this.labelVDescricao.setText(DBUtil.getDescricao("select c10_descricao from cid10", "c10_codigo = '" + RequisicaoCid10.this.textCodigo.getTextDB() + "'", "c10_descricao"));
                    }
                    catch (SQLException ex) {
                        ErrorLogger.mostraMensagem(RequisicaoCid10.this, ex.getMessage(), ex.getStackTrace(), "RequisicaoCid10 (108)");
                    }
                }
            }
        });
        this.textCodigo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    RequisicaoCid10.this.pesquisaCid();
                }
            }
        });
        this.tabela.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && RequisicaoCid10.this.tabela.getSelectedRow() > -1 && Funcoes.mensagem(RequisicaoCid10.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    RequisicaoCid10.this.modelo.removeLine(RequisicaoCid10.this.tabela.getSelectedRow());
                    RequisicaoCid10.this.textCodigo.grabFocus();
                }
            }
        });
        ScreenUtil.requisitarFoco(this.textCodigo);
    }

    private void pesquisaCid() {
        Hashtable resultado = Pesquisas.cid10(this, true);
        if (resultado != null) {
            this.textCodigo.setText(resultado.get("c10_codigo").toString());
        }
        this.textCodigo.grabFocus();
    }

    public void adicionarCid() {
        if (!Funcoes.textoVazio(this.textCodigo.getText()) && !this.labelVDescricao.getText().equalsIgnoreCase("N\u00e3o cadastrado") && this.modelo.localizar(0, this.textCodigo.getText()) < 0) {
            this.modelo.addLine(new String[]{this.textCodigo.getText(), this.labelVDescricao.getText()});
        }
        this.textCodigo.clear();
        this.labelVDescricao.setText("");
        this.textCodigo.grabFocus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonBuscaCid) {
            this.pesquisaCid();
        } else if (e.getSource() == this.buttonOKCid) {
            this.adicionarCid();
        } else {
            super.actionPerformed(e);
        }
    }

    public void setSelecionados(String[] selecionados) {
        this.modelo.clear();
        if (selecionados != null) {
            try {
                for (String s : selecionados) {
                    if (Funcoes.textoVazio(s)) continue;
                    String descricao = DBUtil.getDescricao("select c10_descricao from cid10", "c10_codigo = '" + s + "'", "c10_descricao");
                    this.modelo.addLine(new String[]{s, descricao});
                }
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RequisicaoCid10 (108)");
            }
        }
    }

    public String[] getSelecionados() {
        String[] retorno = new String[this.modelo.getRowCount()];
        int indice = 0;
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            retorno[indice++] = this.modelo.getValueAt(i, 0).toString();
        }
        return retorno;
    }
}

